/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acctcf;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.bcmbussiness.CashFlowFormulaInfo;
import kd.fi.gl.bcmbussiness.FormulaInfo;
import kd.fi.gl.cashflow.CashFlowQueryExecutor;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLServiceUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;

public class AcctCFParseAction {
    private static final Log LOG = LogFactory.getLog(AcctCFParseAction.class);
    private static final String CFITEM = "cfitem";
    private static final String ASSGRP = "assgrp";
    public static final String AMOUNT = "amount";
    public static final String YEARAMOUNT = "yearamount";
    private static final String LJ = "LJ";
    private static final String FS = "FS";
    private static final String BASE_DATA_TYPE = "1";
    private static final String ASSISTANT_DATA_TYPE = "2";
    private Map<String, Long> numberGroupDetailMap = new HashMap<String, Long>();
    Table<String, String, Map<String, Set<Long>>> comAssistDispersedValIdTable = HashBasedTable.create();
    Table<String, String, Map<String, Set<Long>>> comAssistRangeValIdTable = HashBasedTable.create();

    public String parseParam(String param) {
        try {
            long onlyFlag = DB.genGlobalLongId();
            Map acctMap = (Map)JSONUtils.cast((String)param, Map.class);
            Map comParam = (Map)acctMap.get("commParam");
            int fy = (Integer)comParam.get("fy");
            String orgNumber = (String)comParam.get("org");
            String adjustPeriod = "";
            int period = 0;
            if (comParam.get("period") instanceof String) {
                adjustPeriod = AcctUtil.getPeriodParam((String)comParam.get("period"));
            } else {
                period = (Integer)comParam.get("period");
            }
            String comDimensionStrFormBCM = AcctUtil.getComAssistFromBCM(acctMap);
            AccountBookInfo defbook = this.getMainBook(orgNumber);
            String mainBookNumber = defbook == null ? this.getMainBookType() : defbook.getBookTypeNum();
            Map acctFormulas = (Map)acctMap.get("param");
            HashMap<String, Map<String, Long>> assistNumValNumMap = new HashMap<String, Map<String, Long>>();
            HashMap<String, Set<FormulaInfo>> keyFormulaInfosMap = new HashMap<String, Set<FormulaInfo>>();
            HashMap<String, Map<String, Set<Long>>> orgCashNumIdsMap = new HashMap<String, Map<String, Set<Long>>>();
            HashMap<String, Map<String, Map<String, Set<Long>>>> orgAssistMap = new HashMap<String, Map<String, Map<String, Set<Long>>>>();
            HashMap<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMap = new HashMap<String, Map<String, Map<String, Map<String, Set<String>>>>>();
            HashBasedTable orgComAssistNumTable = HashBasedTable.create();
            HashMap<String, Long> comAssistStandardMap = new HashMap<String, Long>(8);
            HashMap<String, DataSet> comAssistGroupMap = new HashMap<String, DataSet>(8);
            LOG.info("\u552f\u4e00\u6807\u8bc6\uff1a" + onlyFlag + " \u603b\u8d26acctcf\u53d6\u6570\u53c2\u6570\uff1a\u7ec4\u7ec7" + orgNumber + "\u5e74" + fy + "\u6708" + (StringUtils.isNotBlank((CharSequence)adjustPeriod) ? adjustPeriod : Integer.valueOf(period)) + "\u516c\u5f0f\u53c2\u6570" + param);
            HashMap<String, Map<String, Object>> errorInfoMap = new HashMap<String, Map<String, Object>>();
            HashSet<String> orgNumberSet = new HashSet<String>(8);
            for (Map.Entry formulaEntry : acctFormulas.entrySet()) {
                List formula = (List)formulaEntry.getValue();
                orgNumberSet.add(StringUtils.isEmpty((CharSequence)((CharSequence)formula.get(0))) ? orgNumber : (String)formula.get(0));
            }
            Map<String, Long> orgNumIdMap = AcctUtil.getOrgNumIdMap(orgNumberSet);
            HashBasedTable accountBookCache = HashBasedTable.create();
            if (Objects.nonNull(defbook)) {
                accountBookCache.put((Object)orgNumber, (Object)defbook.getBookTypeNum(), (Object)defbook);
            }
            Map<Long, Set<Integer>> periodTypeToYearNumMap = this.getPeriodTypeToYearNum(orgNumber, fy, defbook, (Table<String, String, AccountBookInfo>)accountBookCache, acctFormulas);
            Table<Long, String, List<String>> periodTypeToYearNumTable = AcctUtil.queryPeriodFromYear(periodTypeToYearNumMap);
            HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCTCF);
            String permName = InterfacePermissionService.getPermName(PermissionType.ACCTCF);
            for (Map.Entry entry : acctFormulas.entrySet()) {
                String orgNum;
                StringBuilder keySb = new StringBuilder();
                String formulaId = (String)entry.getKey();
                List formula = (List)entry.getValue();
                String string = orgNum = StringUtils.isEmpty((CharSequence)((CharSequence)formula.get(0))) ? orgNumber : (String)formula.get(0);
                if (!orgNumIdMap.containsKey(orgNum)) {
                    AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CashflowServiceImpl_10", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                    continue;
                }
                String errorMsg = AcctUtil.checkPermByOrgId(orgNum, permName, orgNumIdMap.get(orgNum), permOrgResult);
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    AcctUtil.setErrorMessage(errorInfoMap, formulaId, errorMsg, -1);
                    continue;
                }
                String booktypeNum = StringUtils.isEmpty((CharSequence)((CharSequence)formula.get(1))) ? mainBookNumber : (String)formula.get(1);
                String acctStr = (String)formula.get(2);
                String calType = (String)formula.get(3);
                if (StringUtils.isEmpty((CharSequence)calType) || !LJ.equals(calType) && !FS.equals(calType)) {
                    AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef\u3002\u8bf7\u8bbe\u7f6e\u4e3a'LJ'\u6216\u8005'FS'\u3002", (String)"CashflowServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                    continue;
                }
                String startPeriod = "0";
                String endPeriod = "0";
                int startYear = 0;
                String periodParam = AcctUtil.getPeriodParam((String)formula.get(5));
                List scopePeriod = (List)comParam.get("scopePeriod");
                if (StringUtils.isNotBlank((CharSequence)periodParam) && !"0".equals(periodParam) || scopePeriod == null || scopePeriod.isEmpty()) {
                    AccountBookInfo book;
                    if (Objects.nonNull(accountBookCache.get((Object)orgNum, (Object)booktypeNum))) {
                        book = (AccountBookInfo)accountBookCache.get((Object)orgNum, (Object)booktypeNum);
                    } else {
                        book = new AccountBookInfo(orgNum, booktypeNum);
                        accountBookCache.put((Object)orgNum, (Object)booktypeNum, (Object)book);
                    }
                    HashMap<String, List<String>> periodNumberFromYearMap = new HashMap();
                    if (Objects.nonNull(book)) {
                        periodNumberFromYearMap = periodTypeToYearNumTable.row((Object)book.getPeriodTypeId());
                    }
                    if (!AcctUtil.checkPeriodFormat(periodParam)) {
                        AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashflowServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                        continue;
                    }
                    if (scopePeriod != null && scopePeriod.size() > 1 && periodParam.startsWith("-")) {
                        AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u53d6\u6570\u65f6\u4e0d\u652f\u6301\u8bbe\u7f6e\u504f\u79fb\u91cf\uff0c\u8bf7\u66f4\u6539\u516c\u5f0f\u914d\u7f6e\u6216\u671f\u95f4\u6210\u5458\u6620\u5c04\u3002", (String)"ReClassNumberIDParam_3", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                        continue;
                    }
                    String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(periodParam, period, adjustPeriod, (String)formula.get(4), fy, periodNumberFromYearMap);
                    String[] yearAndPeriod = yearAndPeriodKey.split("-");
                    if (yearAndPeriod.length == 2) {
                        startYear = Integer.parseInt(yearAndPeriod[0]);
                        startPeriod = yearAndPeriod[1];
                    }
                    if (!AcctUtil.checkPeriodFormat(startPeriod)) {
                        AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashflowServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                        continue;
                    }
                    endPeriod = startPeriod;
                    keySb.append(orgNum).append("@");
                    keySb.append(booktypeNum).append("@");
                    keySb.append(startYear).append("@").append(startPeriod).append("@");
                } else if (CollectionUtils.isNotEmpty((Collection)scopePeriod) && periodParam.startsWith("-")) {
                    AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u53d6\u6570\u65f6\u4e0d\u652f\u6301\u8bbe\u7f6e\u504f\u79fb\u91cf\uff0c\u8bf7\u66f4\u6539\u516c\u5f0f\u914d\u7f6e\u6216\u671f\u95f4\u6210\u5458\u6620\u5c04\u3002", (String)"ReClassNumberIDParam_3", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                } else {
                    startPeriod = String.valueOf(scopePeriod.get(0));
                    endPeriod = String.valueOf(scopePeriod.get(1));
                    int formulaYear = StringUtils.isNotBlank((CharSequence)((CharSequence)formula.get(4))) && !"0".equals(formula.get(4)) ? Integer.parseInt((String)formula.get(4)) : 0;
                    int endYear = startYear = formulaYear > 1000 ? formulaYear : fy + formulaYear;
                    if (LJ.equals(formula.get(3))) {
                        startPeriod = endPeriod;
                    }
                    keySb.append(orgNum).append("@");
                    keySb.append(booktypeNum).append("@");
                    keySb.append(startYear).append("@").append(startPeriod).append("@");
                    keySb.append(endYear).append("@").append(endPeriod);
                }
                if (!(startPeriod.endsWith("T") || endPeriod.endsWith("T") || Integer.parseInt(startPeriod) > 0 && Integer.parseInt(endPeriod) > 0)) {
                    AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74\u3002", (String)"CashflowServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                }
                String comAssistStr = comDimensionStrFormBCM;
                if (formula.size() > 7 && StringUtils.isNotBlank((CharSequence)((CharSequence)formula.get(7)))) {
                    comAssistStr = (String)formula.get(7);
                }
                HashMap<String, Set<String>> comAssistKeyToNumMap = new HashMap(8);
                if (StringUtils.isNotBlank((CharSequence)comAssistStr)) {
                    if (AcctUtil.checkComAssistFormat(comAssistStr, Boolean.FALSE)) {
                        comAssistKeyToNumMap = AcctUtil.parseComAssistStr(comAssistStr);
                        HashMap<String, Set> allComAssistKeyToNumMap = (HashMap<String, Set>)orgComAssistNumTable.get((Object)orgNum, (Object)booktypeNum);
                        if (Objects.isNull(allComAssistKeyToNumMap)) {
                            allComAssistKeyToNumMap = new HashMap<String, Set>();
                            orgComAssistNumTable.put((Object)orgNum, (Object)booktypeNum, allComAssistKeyToNumMap);
                        }
                        for (Map.Entry entry2 : comAssistKeyToNumMap.entrySet()) {
                            Set allComAssistNumSet = allComAssistKeyToNumMap.computeIfAbsent((String)entry2.getKey(), k -> new HashSet(8));
                            allComAssistNumSet.addAll((Collection)entry2.getValue());
                        }
                    } else {
                        AcctUtil.setErrorMessage(errorInfoMap, formulaId, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CashflowServiceImpl_8", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                    }
                }
                String key = keySb.toString();
                FormulaInfo info = new FormulaInfo(formula, key, formulaId, comAssistKeyToNumMap);
                Set set = keyFormulaInfosMap.computeIfAbsent(key, e -> new HashSet());
                set.add(info);
                String[] acctStrs = acctStr.split("\\|");
                Map assistNumAndValNumIdMap = orgAssistMap.computeIfAbsent(orgNum, e -> new HashMap());
                Map valNumIdMap = null;
                Map groupNumAndGroupIdMap = orgAssistGroupMap.computeIfAbsent(orgNum, e -> new HashMap());
                Map groupIdMap = null;
                for (int i = 0; i < acctStrs.length; ++i) {
                    String[] groups;
                    if (i == 0) {
                        String itemNum = acctStrs[0];
                        if (StringUtils.isEmpty((CharSequence)itemNum)) continue;
                        Map cashNumIdsMap = orgCashNumIdsMap.computeIfAbsent(orgNum, e -> new HashMap());
                        cashNumIdsMap.computeIfAbsent(itemNum, e -> new HashSet());
                        continue;
                    }
                    if (i % 2 != 0) {
                        if (StringUtils.isEmpty((CharSequence)acctStrs[i])) continue;
                        assistNumValNumMap.put(acctStrs[i], new HashMap());
                        valNumIdMap = assistNumAndValNumIdMap.computeIfAbsent(acctStrs[i], e -> new HashMap());
                        groupIdMap = groupNumAndGroupIdMap.computeIfAbsent(acctStrs[i], e -> new HashMap());
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)acctStrs[i])) continue;
                    boolean isNoCategory = ReClassUtils.isCollectionNumber(acctStrs[i]);
                    if (!isNoCategory) {
                        String[] assgrps = acctStrs[i].split(",");
                        if (valNumIdMap == null) continue;
                        HashSet<Long> valIds = new HashSet<Long>(8);
                        valIds.add(0L);
                        for (String string2 : assgrps) {
                            valNumIdMap.put(string2, valIds);
                        }
                        continue;
                    }
                    String[] valueStrings = acctStrs[i].split("#");
                    String groupStandard = valueStrings[0];
                    String groupString = valueStrings[1];
                    if (groupIdMap == null) continue;
                    Map groupMap = groupIdMap.computeIfAbsent(groupStandard, e -> new HashMap());
                    for (String group : groups = groupString.split(",")) {
                        groupMap.put(group, new HashSet());
                    }
                }
            }
            this.printKeyToFormulaLog(keyFormulaInfosMap);
            Map<String, String[]> assistNumMap = this.getAssistNumMap(assistNumValNumMap);
            HashBasedTable cashFlowDirectionTable = HashBasedTable.create();
            Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap = this.getCashFlowIdToInfo(orgNumIdMap, orgCashNumIdsMap, (Table<String, String, String>)cashFlowDirectionTable);
            this.setOrgAssistMapByGroup(orgAssistGroupMap, orgAssistMap, assistNumMap);
            Map<String, Map<String, DataSet>> orgAssistNumDtMap = this.getOrgAssistNumDtMap(orgAssistMap, orgNumIdMap, assistNumMap);
            Map<String, Long> bookTypeNumToIdMap = this.queryBookTypeNumToId(orgComAssistNumTable.columnKeySet());
            Table<String, String, Set<Long>> orgAndBookTypeToIdTable = this.getOrgAndBookTypeToAccountTableId(orgNumIdMap, bookTypeNumToIdMap, (Table<String, String, Map<String, Set<String>>>)orgComAssistNumTable);
            HashSet<Long> allAccountTableIdSet = new HashSet<Long>(8);
            orgAndBookTypeToIdTable.values().forEach(allAccountTableIdSet::addAll);
            Table<Long, String, String> accountTableToValSourceTable = this.getAccountTableToValSourceTable(allAccountTableIdSet);
            this.setComAssistId((Table<String, String, Map<String, Set<String>>>)orgComAssistNumTable, orgNumIdMap, comAssistStandardMap, comAssistGroupMap, orgAndBookTypeToIdTable, accountTableToValSourceTable);
            boolean isQueryAdjustPeriod = comParam.get("isAdjustPeriod") == null ? true : (Boolean)comParam.get("isAdjustPeriod") == false;
            CashFlowQueryExecutor cashFlowQueryExecutor = CashFlowQueryExecutor.getInstance();
            StringBuilder selectedFiles = new StringBuilder();
            selectedFiles.append(CFITEM).append(',').append(ASSGRP).append(',').append(YEARAMOUNT).append(',').append(AMOUNT);
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(acctFormulas.size());
            for (Map.Entry entry : keyFormulaInfosMap.entrySet()) {
                long l;
                String key = (String)entry.getKey();
                String[] keysplits = key.split("@");
                String orgNum = keysplits[0];
                String booktypeNum = keysplits[1];
                AccountBookInfo book = orgNum.equals(orgNumber) && defbook != null && defbook.getBookTypeNum().equals(booktypeNum) ? defbook : new AccountBookInfo(orgNum, booktypeNum);
                if (book == null) continue;
                Map assistNumAndValNumIdMap = (Map)orgAssistMap.get(orgNum);
                long endPeriodId = l = this.getPeriodId(Integer.parseInt(keysplits[2]), keysplits[3], book.getPeriodTypeId()).longValue();
                if (keysplits.length > 4) {
                    endPeriodId = this.getPeriodIdWithAdjustPeriod(Integer.parseInt(keysplits[4]), keysplits[5], book.getPeriodTypeId(), isQueryAdjustPeriod);
                }
                if (!this.isExistPeriodId(l, endPeriodId, errorInfoMap, (Set)entry.getValue())) continue;
                long orgId = orgNumIdMap.get(orgNum);
                long bookTypeId = bookTypeNumToIdMap.get(booktypeNum) == null ? 0L : bookTypeNumToIdMap.get(booktypeNum);
                long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)endPeriodId);
                Map comAssistKeyToValSourceMap = accountTableToValSourceTable.row((Object)accountTableId);
                Set comAssistKeySet = comAssistKeyToValSourceMap.keySet();
                StringBuilder curSelectFields = new StringBuilder();
                curSelectFields.append((CharSequence)selectedFiles);
                for (String comAssistKey : comAssistKeySet) {
                    curSelectFields.append(",").append(comAssistKey);
                }
                DataSet dataSet = this.getCashJoinAssistSet(cashFlowQueryExecutor, curSelectFields.toString(), book, l, endPeriodId, orgCashNumIdsMap, orgAssistNumDtMap, orgAssistMap, orgNum);
                this.dumpDataSet(onlyFlag, dataSet.copy(), key);
                ArrayList<String> filterListLog = new ArrayList<String>();
                for (FormulaInfo info : (Set)entry.getValue()) {
                    String calType = info.getCalType();
                    String sumField = null;
                    if (LJ.equals(calType)) {
                        sumField = YEARAMOUNT;
                    } else {
                        if (!FS.equals(calType)) continue;
                        sumField = AMOUNT;
                    }
                    Tuple2<Boolean, List<String>> tuple = this.getFormulaListFilters(info, (Map)orgCashNumIdsMap.get(orgNum), assistNumMap, assistNumAndValNumIdMap, errorInfoMap, (Map)orgAssistGroupMap.get(orgNum), comAssistKeyToValSourceMap, cashFlowIdToInfoMap);
                    if (((Boolean)tuple.t1).booleanValue() || ((List)tuple.t2).isEmpty()) continue;
                    String itemFilterStr = (String)((List)tuple.t2).get(0);
                    Set<Long> sumCFIdSet = this.getSumCFIdByFilter(itemFilterStr);
                    Set<Long> needReduceCashFlowItemIdSet = this.getNeedReduceCFItemId(sumCFIdSet, (Set)((Map)orgCashNumIdsMap.get(orgNum)).get(info.getCashItemNum()), info.getAssistNumValsMap().keySet(), assistNumMap, cashFlowIdToInfoMap);
                    String direction = (String)cashFlowDirectionTable.get((Object)orgNum, (Object)info.getCashItemNum());
                    String filterStr = this.getDataSetFilterstr((List)tuple.t2);
                    DataSet bcmBalSet = this.sumBalance(dataSet, sumField, filterStr, info.getFormulaId(), direction);
                    DataSet reduceBalSet = null;
                    filterListLog.add(filterStr);
                    if (CollectionUtils.isNotEmpty(needReduceCashFlowItemIdSet)) {
                        ((List)tuple.t2).remove(0);
                        String cfItemFilter = "cfitem in (" + needReduceCashFlowItemIdSet.toString().substring(1, needReduceCashFlowItemIdSet.toString().length() - 1) + ")";
                        ((List)tuple.t2).add(cfItemFilter);
                        filterStr = this.getDataSetFilterstr((List)tuple.t2);
                        reduceBalSet = this.sumBalance(dataSet, sumField, filterStr, info.getFormulaId(), direction);
                    }
                    this.getResultMap(bcmBalSet, resultMap, reduceBalSet);
                }
                this.dumpFilterLog(onlyFlag, key, ((Object)filterListLog).toString());
            }
            for (Map.Entry errorEntry : errorInfoMap.entrySet()) {
                String acctKeyId = (String)errorEntry.getKey();
                Map acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap());
                if (!acctValMap.isEmpty()) continue;
                acctValMap.putAll((Map)errorEntry.getValue());
            }
            String resultStr = JSONUtils.toString(resultMap);
            LOG.info("\u603b\u8d26acctcf\u53d6\u6570\u7ed3\u679c\uff1a" + resultStr);
            return resultStr;
        }
        catch (Exception e2) {
            LOG.info(ResManager.loadKDString((String)"\u603b\u8d26acctcf\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"AcctCFParseAction_0", (String)"fi-gl-mservice", (Object[])new Object[0]) + GLUtil.printError((Throwable)e2));
            throw new BOSException((Throwable)e2);
        }
    }

    public int dealPeriod(String periodStr, int comPeriod) {
        String string = periodStr = StringUtils.isBlank((CharSequence)periodStr) ? "0" : periodStr;
        if (periodStr == null) {
            return 0;
        }
        int period = Integer.parseInt(periodStr);
        if (period <= 0) {
            period += comPeriod;
        }
        return period;
    }

    public int dealYear(String yearStr, int comFy, int period) {
        int year = Integer.parseInt(yearStr = StringUtils.isBlank((CharSequence)yearStr) ? "0" : yearStr);
        if (year <= 1000) {
            year += comFy;
        }
        if (period > -12 && period <= 0) {
            --year;
        }
        return year;
    }

    private void dumpDataSet(long onlyFlag, DataSet ds, String key) {
        int cols = ds.getRowMeta().getFieldCount();
        StringBuilder cashFlowLog = new StringBuilder();
        cashFlowLog.append(ResManager.loadKDString((String)"\u552f\u4e00\u6807\u8bc6\uff1a%1$sacctcf\u73b0\u91d1\u6d41\u91cf\u6570\u636e\uff1akey\u503c%2$s;%3$s\u5217;", (String)"AcctCFParseAction_1", (String)"fi-gl-mservice", (Object[])new Object[]{onlyFlag, key, cols}));
        for (int i = 0; i < cols; ++i) {
            cashFlowLog.append(ds.getRowMeta().getFieldAlias(i));
            cashFlowLog.append(",");
        }
        cashFlowLog.deleteCharAt(cashFlowLog.length() - 1);
        cashFlowLog.append(";");
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                cashFlowLog.append(obj);
                cashFlowLog.append(',');
            }
            cashFlowLog.deleteCharAt(cashFlowLog.length() - 1);
            cashFlowLog.append("/t");
        }
        LOG.info(cashFlowLog.toString());
    }

    private void dumpFilterLog(long onlyFlag, String key, String filterStr) {
        LOG.info("\u552f\u4e00\u6807\u8bc6\uff1a" + onlyFlag + " acctcf\u73b0\u91d1\u6d41\u91cf\u6570\u636e\uff1akey\u503c" + key + ";\u5404\u4e2a\u516c\u5f0f\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filterStr);
    }

    private void getResultMap(DataSet dataSet, Map<String, Map<String, Object>> resultMap, DataSet reduceBalSet) {
        BigDecimal resultVal;
        Object cur;
        Map acctValMap;
        BigDecimal value;
        String acctKeyId;
        for (Row row : dataSet) {
            acctKeyId = row.getString("formulaid");
            value = row.getBigDecimal("value");
            if (value == null) continue;
            acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap());
            if (acctValMap.isEmpty()) {
                acctValMap.put("v", value);
                acctValMap.put("type", 1);
                continue;
            }
            cur = acctValMap.get("v");
            if (!(cur instanceof BigDecimal)) continue;
            resultVal = value.add((BigDecimal)cur);
            acctValMap.put("v", resultVal);
        }
        if (Objects.nonNull(reduceBalSet)) {
            for (Row row : reduceBalSet) {
                acctKeyId = row.getString("formulaid");
                value = row.getBigDecimal("value");
                if (value == null || !Objects.nonNull(acctValMap = (Map)resultMap.getOrDefault(acctKeyId, null)) || !((cur = acctValMap.get("v")) instanceof BigDecimal)) continue;
                resultVal = value.subtract((BigDecimal)cur);
                acctValMap.put("v", resultVal);
            }
        }
        dataSet.close();
    }

    private Map<String, String[]> getAssistNumMap(Map<String, Map<String, Long>> assistNumValNumMap) {
        HashMap<String, String[]> assistNumMap = new HashMap<String, String[]>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"number,valuetype,assistanttype,valuesource,flexfield", (QFilter[])new QFilter("number", "in", assistNumValNumMap.keySet()).toArray(), null, (int)-1);){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                String number = row.getString("number");
                String valType = row.getString("valuetype");
                if (ASSISTANT_DATA_TYPE.equals(valType)) {
                    this.numberGroupDetailMap.put(number, row.getLong("assistanttype"));
                }
                assistNumMap.put(number, new String[]{row.getString("flexfield"), row.getString("valuesource")});
            }
        }
        return assistNumMap;
    }

    private Map<String, Map<String, DataSet>> getOrgAssistNumDtMap(Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, Map<String, Long> orgNumIdMap, Map<String, String[]> assistNumMap) {
        HashMap<String, Map<String, DataSet>> orgAssistNumDtMap = new HashMap<String, Map<String, DataSet>>();
        for (Map.Entry<String, Map<String, Map<String, Set<Long>>>> entry : orgAssistMap.entrySet()) {
            String orgNum = entry.getKey();
            Map assistNumDtMap = orgAssistNumDtMap.computeIfAbsent(orgNum, e -> new HashMap());
            Map<String, Map<String, Set<Long>>> assistNumAndValNumIdMap = entry.getValue();
            long orgId = orgNumIdMap.get(orgNum);
            for (Map.Entry<String, Map<String, Set<Long>>> assistNumAndValNumIdMapEntry : assistNumAndValNumIdMap.entrySet()) {
                String assistNum = assistNumAndValNumIdMapEntry.getKey();
                Map<String, Set<Long>> valNumIdMap = assistNumAndValNumIdMapEntry.getValue();
                String[] assistInfo = assistNumMap.get(assistNum);
                if (assistInfo == null) continue;
                String valuesource = assistInfo[1];
                QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)valuesource, (Long)orgId);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
                if (qids != null) {
                    qFilters.add(qids);
                }
                if (this.numberGroupDetailMap.get(assistNum) != null) {
                    long assistantTypeId = this.numberGroupDetailMap.get(assistNum);
                    QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)orgId);
                    if (assistantOrgFilter != null) {
                        qFilters.add(assistantOrgFilter);
                    }
                    qFilters.add(new QFilter("group", "=", (Object)assistantTypeId));
                }
                ArrayList<QFilter> assistNumDtFilterList = new ArrayList<QFilter>(8);
                assistNumDtFilterList.add(new QFilter("asstype", "=", (Object)assistInfo[0]));
                Map<String, Set<Long>> valNumberDetailMap = this.queryDetailAssist(valuesource, valNumIdMap.keySet(), qFilters);
                valNumIdMap.putAll(valNumberDetailMap);
                if (!valNumIdMap.containsKey("None")) {
                    HashSet valIds = new HashSet(8);
                    valNumIdMap.values().forEach(valIds::addAll);
                    assistNumDtFilterList.add(new QFilter("assval", "in", valIds));
                }
                assistNumDtMap.put(assistNum, QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)("hg,assval " + assistInfo[0]), (QFilter[])assistNumDtFilterList.toArray(new QFilter[0]), null));
            }
        }
        return orgAssistNumDtMap;
    }

    private Map<String, Set<Long>> queryDetailAssist(String entityId, Set<String> numbers, List<QFilter> filter) {
        MakeBaseDateDetailHelper helper = new MakeBaseDateDetailHelper();
        Map<String, Set<Long>> numberToIdsMap = helper.getDetailAssists(entityId, numbers, filter);
        return numberToIdsMap;
    }

    private DataSet getCashJoinAssistSet(CashFlowQueryExecutor cashFlowQueryExecutor, String select, AccountBookInfo book, long startPeriodId, long endPeriodId, Map<String, Map<String, Set<Long>>> orgCashNumIdsMap, Map<String, Map<String, DataSet>> orgAssistNumDtMap, Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, String orgNum) {
        Map<String, Set<Long>> cashNumIdsMap = orgCashNumIdsMap.get(orgNum);
        HashSet itemIds = new HashSet();
        for (Map.Entry<String, Set<Long>> cashNumIdsMapentry : cashNumIdsMap.entrySet()) {
            itemIds.addAll(cashNumIdsMapentry.getValue());
        }
        DataSet cashSet = cashFlowQueryExecutor.getCashFlow(this.getClass().getName(), select, new long[]{book.getOrgId()}, book.getBookTypeId(), startPeriodId, endPeriodId, new QFilter(CFITEM, "in", itemIds).toArray());
        Map<String, DataSet> assistNumDtMap = orgAssistNumDtMap.get(orgNum);
        for (Map.Entry<String, DataSet> dtEntry : assistNumDtMap.entrySet()) {
            DataSet dt = dtEntry.getValue();
            List<String> dtFields = GLServiceUtils.getFieldsByDs(dt);
            dtFields.remove(0);
            cashSet = cashSet.leftJoin(dt.copy()).on(ASSGRP, "hg").select(GLServiceUtils.getFieldsByDs(cashSet).toArray(new String[0]), dtFields.toArray(new String[0])).finish();
        }
        return cashSet;
    }

    private Tuple2<Boolean, List<String>> getFormulaListFilters(FormulaInfo info, Map<String, Set<Long>> cashNumIdsMap, Map<String, String[]> assistNumMap, Map<String, Map<String, Set<Long>>> assistNumAndValNumIdMap, Map<String, Map<String, Object>> errorInfoMap, Map<String, Map<String, Map<String, Set<String>>>> assistGroupIdMap, Map<String, String> comAssistKeyToValSourceMap, Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap) {
        String assistNum;
        ArrayList<String> filters = new ArrayList<String>();
        StringBuilder filtersb = new StringBuilder();
        boolean continueFlag = false;
        Set<Long> curCashItemIds = cashNumIdsMap.get(info.getCashItemNum());
        if (null == curCashItemIds || curCashItemIds.isEmpty()) {
            continueFlag = true;
            AcctUtil.setErrorMessage(errorInfoMap, info.getFormulaId(), ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashflowServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0]), -2);
        } else {
            Set<Long> includeAssistCashFlowIdSet = this.getIncludeAssistCashFlowIds(curCashItemIds, cashFlowIdToInfoMap, info.getAssistNumValsMap().keySet(), assistNumMap);
            Set<Object> sumCFItemIdSet = new HashSet<Long>(8);
            if (CollectionUtils.isNotEmpty(includeAssistCashFlowIdSet)) {
                sumCFItemIdSet = this.getSumCFItemIds(includeAssistCashFlowIdSet, cashFlowIdToInfoMap);
            }
            sumCFItemIdSet.add(0L);
            filtersb.append(CFITEM).append(" in (").append(sumCFItemIdSet.toString(), 1, sumCFItemIdSet.toString().length() - 1).append(")");
        }
        filters.add(filtersb.toString());
        HashSet<String> groupEmptyMemberToAssistSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : info.getGroupValsMap().entrySet()) {
            assistNum = entry.getKey();
            Map<String, Set<String>> groupStandardToGroupMap = entry.getValue();
            for (Map.Entry<String, Set<String>> groupStandardToGroupMapEntry : groupStandardToGroupMap.entrySet()) {
                String groupStandardNum = groupStandardToGroupMapEntry.getKey();
                Set<String> groupNumMap = groupStandardToGroupMapEntry.getValue();
                for (String groupNum : groupNumMap) {
                    Set<String> assistNumSet = assistGroupIdMap.get(assistNum).get(groupStandardNum).get(groupNum);
                    if (assistNumSet.isEmpty()) {
                        groupEmptyMemberToAssistSet.add(assistNum);
                        AcctUtil.setErrorMessage(errorInfoMap, info.getFormulaId(), ResManager.loadKDString((String)"\u516c\u5f0f\u7684%s\u5206\u7c7b\uff0c\u4e0d\u5b58\u5728\u6838\u7b97\u7ef4\u5ea6\u6210\u5458", (String)"CashflowServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[]{groupNum}), -1);
                        continue;
                    }
                    info.getAssistNumValsMap().get(assistNum).addAll(assistNumSet);
                }
            }
        }
        for (Map.Entry<String, Object> entry : info.getAssistNumValsMap().entrySet()) {
            assistNum = entry.getKey();
            String[] assistInfo = assistNumMap.get(assistNum);
            if (Objects.isNull(assistInfo)) {
                continueFlag = true;
                AcctUtil.setErrorMessage(errorInfoMap, info.getFormulaId(), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u8bbe\u7f6e\u3002", (String)"CashflowServiceImpl_5", (String)"fi-gl-mservice", (Object[])new Object[]{assistNum}), -1);
                break;
            }
            Map<String, Set<Long>> valNumIdMap = assistNumAndValNumIdMap.get(assistNum);
            Set valNums = (Set)entry.getValue();
            int i = 0;
            StringBuilder filterStr = new StringBuilder();
            for (String valNum : valNums) {
                Set<Long> valId = valNumIdMap.get(valNum);
                if (valId == null) {
                    continueFlag = true;
                    AcctUtil.setErrorMessage(errorInfoMap, info.getFormulaId(), ResManager.loadKDString((String)"\u516c\u5f0f\u7684%1$s\u7684%2$s\u4e0d\u5b58\u5728", (String)"CashflowServiceImpl_4", (String)"fi-gl-mservice", (Object[])new Object[]{assistNum, valNum}), -1);
                    continue;
                }
                if (i++ != 0) {
                    filterStr.append(',');
                }
                filterStr.append(valId.toString().substring(1, valId.toString().length() - 1));
            }
            if (groupEmptyMemberToAssistSet.contains(assistNum)) {
                if (i != 0) {
                    filterStr.append(',');
                }
                filterStr.append(0);
            }
            if (filterStr.length() != 0) {
                StringBuilder valueIdFilter = new StringBuilder(assistInfo[0]).append(" in (").append((CharSequence)filterStr).append(")");
                if (valNums.contains("None")) {
                    valueIdFilter.append(" or ").append(assistInfo[0]).append(" is null");
                }
                filters.add("(" + valueIdFilter + ")");
                continue;
            }
            filters.add(assistInfo[0] + " <> 0");
        }
        this.setCommonAssistFilter(info, filters, comAssistKeyToValSourceMap);
        return new Tuple2((Object)continueFlag, filters);
    }

    private Set<Long> getIncludeAssistCashFlowIds(Set<Long> curCashItemIds, Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap, Set<String> assistTypeNumSet, Map<String, String[]> assistNumMap) {
        HashSet<String> existAssistTypeNumSet = new HashSet<String>(8);
        for (String assistTypeNum : assistTypeNumSet) {
            if (!Objects.nonNull(assistNumMap.get(assistTypeNum))) continue;
            existAssistTypeNumSet.add(assistTypeNum);
        }
        HashSet<Long> cashFlowIdSet = new HashSet<Long>(8);
        if (CollectionUtils.isEmpty(existAssistTypeNumSet)) {
            return curCashItemIds;
        }
        for (Long cashFlowItemId : curCashItemIds) {
            Set<String> cashFlowItemAllAssistSet;
            CashFlowFormulaInfo cashFlowFormulaInfo = cashFlowIdToInfoMap.get(cashFlowItemId);
            if (!Objects.nonNull(cashFlowFormulaInfo) || CollectionUtils.isEmpty(cashFlowItemAllAssistSet = cashFlowFormulaInfo.getAssistNumSet()) || !cashFlowItemAllAssistSet.containsAll(existAssistTypeNumSet)) continue;
            cashFlowIdSet.add(cashFlowItemId);
        }
        return cashFlowIdSet;
    }

    private void setCommonAssistFilter(FormulaInfo info, List<String> filters, Map<String, String> comAssistKeyToValSourceMap) {
        Map<String, Set<String>> comAssistKeyToNumMap = info.getComAssistKeyToNumMap();
        String[] keySplits = info.getKey().split("@");
        String orgNum = keySplits[0];
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            Set<String> comAssistValNumSet;
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            String valueSource = comAssistKeyToValSourceMap.get(comAssistKey);
            if (!StringUtils.isNotBlank((CharSequence)valueSource) || !CollectionUtils.isNotEmpty(comAssistValNumSet = comAssistKeyToNumEntry.getValue())) continue;
            StringBuilder comAssistFilter = new StringBuilder();
            comAssistFilter.append(comAssistKey).append(" in (");
            for (String comAssistValNum : comAssistValNumSet) {
                Set comAssistIdSet;
                Map comAssistIdMap;
                if (AcctUtil.isRangeValueNumber(comAssistValNum)) {
                    comAssistIdMap = (Map)this.comAssistRangeValIdTable.get((Object)orgNum, (Object)valueSource);
                    if (comAssistIdMap != null && !comAssistIdMap.isEmpty()) {
                        comAssistIdSet = (Set)comAssistIdMap.get(comAssistValNum);
                        if (CollectionUtils.isNotEmpty((Collection)comAssistIdSet)) {
                            for (Long comAssistId : comAssistIdSet) {
                                comAssistFilter.append(comAssistId).append(",");
                            }
                            continue;
                        }
                        comAssistFilter.append(0).append(",");
                        continue;
                    }
                    comAssistFilter.append(0).append(",");
                    continue;
                }
                comAssistIdMap = (Map)this.comAssistDispersedValIdTable.get((Object)orgNum, (Object)valueSource);
                if (comAssistIdMap != null && !comAssistIdMap.isEmpty()) {
                    comAssistIdSet = (Set)comAssistIdMap.get(comAssistValNum);
                    if (CollectionUtils.isNotEmpty((Collection)comAssistIdSet)) {
                        for (Long comAssistId : comAssistIdSet) {
                            comAssistFilter.append(comAssistId).append(",");
                        }
                        continue;
                    }
                    comAssistFilter.append(0).append(",");
                    continue;
                }
                comAssistFilter.append(0).append(",");
            }
            comAssistFilter.delete(comAssistFilter.length() - 1, comAssistFilter.length()).append(")");
            filters.add(comAssistFilter.toString());
        }
        if (DebugTrace.enable()) {
            LOG.info("CashflowServiceImpl_getFormulaListFilters filters:" + filters);
        }
    }

    private String getDataSetFilterstr(List<String> filters) {
        StringBuilder sb = new StringBuilder();
        for (String filter : filters) {
            if (sb.length() != 0) {
                sb.append(" and ");
            }
            sb.append(filter);
        }
        return sb.toString();
    }

    private Long getPeriodId(int year, String periodNum, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "=", (Object)year);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        if (StringUtils.isNotBlank((CharSequence)periodNum)) {
            QFilter fperiod;
            if (periodNum.endsWith("T")) {
                fperiod = new QFilter("periodnumber", "=", (Object)Integer.parseInt(periodNum.substring(0, periodNum.length() - 1)));
                filters.add(fperiod);
            } else {
                fperiod = new QFilter("periodnumber", "=", (Object)Integer.parseInt(periodNum));
                filters.add(fperiod);
            }
        }
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"periodyear, periodnumber, id, isadjustperiod", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashMap<String, Long> periodIdsMap = new HashMap<String, Long>(8);
        for (Row row : periodSet) {
            int periodNumber = row.getInteger("periodnumber");
            if (periodNumber >= 13) {
                periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
                periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
                continue;
            }
            if (row.getBoolean("isadjustperiod").booleanValue()) {
                periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
                continue;
            }
            periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
        }
        if (periodIdsMap.isEmpty()) {
            return 0L;
        }
        long periodId = periodIdsMap.get(year + "," + periodNum) == null ? 0L : (Long)periodIdsMap.get(year + "," + periodNum);
        return periodId;
    }

    private long getPeriodIdWithAdjustPeriod(int year, String periodNum, long periodTypeId, boolean isQueryAdjustPeriod) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "=", (Object)year);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"periodyear, periodnumber, id, isadjustperiod", (QFilter[])filters.toArray(new QFilter[0]), null);
        String maxNoAdjustPeriodKey = "";
        String maxAdjustPeriodKey = "";
        Long maxAdjustPeriodId = 0L;
        HashMap<String, Long> periodIdsMap = new HashMap<String, Long>(8);
        for (Row row : periodSet) {
            int periodNumber = row.getInteger("periodnumber");
            Boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
            if (!periodIdsMap.containsKey(year + "," + periodNumber) || isQueryAdjustPeriod && isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
            }
            if (isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
                if (!StringUtils.isBlank((CharSequence)maxAdjustPeriodKey) && Integer.parseInt(maxAdjustPeriodKey.split(",")[1]) >= periodNumber) continue;
                maxAdjustPeriodKey = year + "," + periodNumber;
                maxAdjustPeriodId = row.getLong("id");
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)maxNoAdjustPeriodKey) && Integer.parseInt(maxNoAdjustPeriodKey.split(",")[1]) >= periodNumber) continue;
            maxNoAdjustPeriodKey = year + "," + periodNumber;
        }
        if (StringUtils.isNotBlank((CharSequence)maxAdjustPeriodKey) && StringUtils.isNotBlank((CharSequence)maxNoAdjustPeriodKey) && Integer.parseInt(maxAdjustPeriodKey.split(",")[1]) > Integer.parseInt(maxNoAdjustPeriodKey.split(",")[1])) {
            periodIdsMap.put(maxNoAdjustPeriodKey, maxAdjustPeriodId);
        }
        return periodIdsMap.get(year + "," + periodNum) == null ? 0L : (Long)periodIdsMap.get(year + "," + periodNum);
    }

    private AccountBookInfo getMainBook(String comOrgNumber) {
        AccountBookInfo book = null;
        long orgId = 0L;
        if (!StringUtils.isBlank((CharSequence)comOrgNumber)) {
            QFilter filter = new QFilter("number", "=", (Object)comOrgNumber);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(filter);
            try (DataSet querySet = this.queryDataSet("bos_org", "number, id", qFilters);){
                while (querySet.hasNext()) {
                    orgId = querySet.next().getLong("id");
                }
            }
        }
        if (orgId != 0L) {
            QFilter qorg = new QFilter("org", "=", (Object)orgId);
            QFilter qbooktype = new QFilter("bookstype.accounttype", "=", (Object)BASE_DATA_TYPE);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])new QFilter[]{qorg, qbooktype}, null, (int)-1);
            if (!ids.isEmpty()) {
                book = new AccountBookInfo(((Long)ids.get(0)).longValue());
            }
        }
        return book;
    }

    private DataSet queryDataSet(String entityName, String selFields, List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BCMBalanceParamParseUtils.queryDataSet", (String)entityName, (String)selFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return dataSet;
    }

    private void setOrgAssistMapByGroup(Map<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMap, Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, Map<String, String[]> assistNumMap) {
        HashMap<String, Long> groupStandardIdMap = new HashMap<String, Long>();
        HashMap groupStandardToGroupIdMap = new HashMap();
        HashMap<Long, Set> groupToAssistMemberNumMap = new HashMap<Long, Set>();
        for (Map.Entry<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMapEntry : orgAssistGroupMap.entrySet()) {
            String orgId = orgAssistGroupMapEntry.getKey();
            Map<String, Map<String, Map<String, Set<String>>>> assistGroupMap = orgAssistGroupMapEntry.getValue();
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> assistGroupMapEntry : assistGroupMap.entrySet()) {
                String assistNum = assistGroupMapEntry.getKey();
                String[] assistNumAndSource = assistNumMap.get(assistNum);
                if (assistNumAndSource == null) continue;
                String entityId = assistNumAndSource[1];
                Map<String, Map<String, Set<String>>> groupStandardToGroupMap = assistGroupMapEntry.getValue();
                for (Map.Entry<String, Map<String, Set<String>>> groupStandardToGroupMapEntry : groupStandardToGroupMap.entrySet()) {
                    String groupStandardNum = groupStandardToGroupMapEntry.getKey();
                    if (groupStandardIdMap.get(entityId + "_" + groupStandardNum) == null) {
                        DataSet groupStandardDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(entityId + "groupstandard"), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupStandardNum)}, null);
                        for (Row row : groupStandardDataSet) {
                            groupStandardIdMap.put(entityId + "_" + groupStandardNum, row.getLong("id"));
                        }
                    }
                    if (groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum) == null) {
                        Long groupStandardId = (Long)groupStandardIdMap.get(entityId + "_" + groupStandardNum);
                        QFilter groupStandardQF = new QFilter("standard", "in", (Object)groupStandardId);
                        QFilter groupNumsQF = new QFilter("number", "in", groupStandardToGroupMapEntry.getValue().keySet());
                        DataSet assistDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(entityId + "group"), (String)"id,number", (QFilter[])new QFilter[]{groupStandardQF, groupNumsQF}, null);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (Row row : assistDataSet) {
                            hashMap.put(row.getString("number"), row.getLong("id"));
                        }
                        groupStandardToGroupIdMap.put(entityId + "_" + groupStandardNum, hashMap);
                    }
                    HashSet groupIdSet = new HashSet(((Map)groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum)).values());
                    String selectProperties = entityId.substring(3) + ".number,group.id";
                    DynamicObject[] assistMembers = BusinessDataServiceHelper.load((String)(entityId + "groupdetail"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("group.id", "in", groupIdSet)});
                    for (DynamicObject assistMember : assistMembers) {
                        long groupId = assistMember.getLong("group.id");
                        String assistMemberNum = assistMember.getString(entityId.substring(3) + ".number");
                        HashSet<Long> valIds = new HashSet<Long>(8);
                        valIds.add(0L);
                        orgAssistMap.get(orgId).get(assistNum).put(assistMemberNum, valIds);
                        Set assistMemberNumSet = groupToAssistMemberNumMap.computeIfAbsent(groupId, e -> new HashSet());
                        assistMemberNumSet.add(assistMemberNum);
                    }
                    for (Map.Entry entry : groupStandardToGroupMapEntry.getValue().entrySet()) {
                        String groupNum = (String)entry.getKey();
                        Long groupId = (Long)((Map)groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum)).get(groupNum);
                        ((Set)entry.getValue()).addAll(groupToAssistMemberNumMap.get(groupId) == null ? new HashSet() : (Collection)groupToAssistMemberNumMap.get(groupId));
                    }
                }
            }
        }
    }

    private void printKeyToFormulaLog(Map<String, Set<FormulaInfo>> keyFormulaInfosMap) {
        StringBuilder logSb = new StringBuilder();
        logSb.append("keyFormulaInfosMap = ");
        for (Map.Entry<String, Set<FormulaInfo>> keyFormulaInfosEntry : keyFormulaInfosMap.entrySet()) {
            logSb.append(keyFormulaInfosEntry.getKey()).append(":{");
            for (FormulaInfo formulaInfo : keyFormulaInfosEntry.getValue()) {
                logSb.append(formulaInfo.getFormulaId()).append(",");
            }
            logSb.delete(logSb.length() - 1, logSb.length()).append("};");
        }
        LOG.info(logSb.toString());
    }

    private Map<String, Long> queryBookTypeNumToId(Collection<String> bookTypeNums) {
        HashMap<String, Long> bookTypeNumToIdMap = new HashMap<String, Long>(8);
        DynamicObjectCollection bookTypeDyns = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", bookTypeNums)});
        for (DynamicObject bookTypeDyn : bookTypeDyns) {
            bookTypeNumToIdMap.put(bookTypeDyn.getString("number"), bookTypeDyn.getLong("id"));
        }
        return bookTypeNumToIdMap;
    }

    private Table<String, String, Set<Long>> getOrgAndBookTypeToAccountTableId(Map<String, Long> orgNumIdMap, Map<String, Long> bookTypeNumToIdMap, Table<String, String, Map<String, Set<String>>> orgComAssistNumTable) {
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashMap<Long, String> orgIdToNumMap = new HashMap<Long, String>(8);
        for (String orgNum : orgComAssistNumTable.rowKeySet()) {
            long orgId = orgNumIdMap.get(orgNum);
            orgIdSet.add(orgId);
            orgIdToNumMap.put(orgId, orgNum);
        }
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(bookTypeNumToIdMap.values());
        HashMap<Long, String> bookTypeIdToNumMap = new HashMap<Long, String>(8);
        for (Map.Entry<String, Long> bookTypeNumToIdEntry : bookTypeNumToIdMap.entrySet()) {
            bookTypeIdToNumMap.put(bookTypeNumToIdEntry.getValue(), bookTypeNumToIdEntry.getKey());
        }
        HashBasedTable orgAndBookTypeToIdTable = HashBasedTable.create();
        ArrayList<QFilter> accountBookFilterList = new ArrayList<QFilter>(8);
        accountBookFilterList.add(new QFilter("org", "in", orgIdSet));
        accountBookFilterList.add(new QFilter("bookstype", "in", bookTypeIdSet));
        DynamicObjectCollection accountBookDyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, bookstype, accounttable", (QFilter[])accountBookFilterList.toArray(new QFilter[0]));
        for (DynamicObject accountBookDyn : accountBookDyns) {
            String bookTypeNum;
            String orgNum = (String)orgIdToNumMap.get(accountBookDyn.getLong("org"));
            HashSet<Long> accountTableIdSet = (HashSet<Long>)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)bookTypeIdToNumMap.get(accountBookDyn.getLong("bookstype"))));
            if (accountTableIdSet != null) {
                accountTableIdSet.add(accountBookDyn.getLong("accounttable"));
                continue;
            }
            accountTableIdSet = new HashSet<Long>(8);
            accountTableIdSet.add(accountBookDyn.getLong("accounttable"));
            orgAndBookTypeToIdTable.put((Object)orgNum, (Object)bookTypeNum, accountTableIdSet);
        }
        ArrayList<QFilter> bookVersionFilterList = new ArrayList<QFilter>(8);
        bookVersionFilterList.add(new QFilter("org", "in", orgIdSet));
        bookVersionFilterList.add(new QFilter("booktype", "in", bookTypeIdSet));
        DynamicObjectCollection bookVersionDyns = QueryServiceHelper.query((String)"gl_book_version", (String)"org, booktype, accounttable", (QFilter[])bookVersionFilterList.toArray(new QFilter[0]));
        for (DynamicObject bookVersionDyn : bookVersionDyns) {
            String bookTypeNum;
            String orgNum = (String)orgIdToNumMap.get(bookVersionDyn.getLong("org"));
            HashSet<Long> accountTableIdSet = (HashSet<Long>)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)bookTypeIdToNumMap.get(bookVersionDyn.getLong("booktype"))));
            if (accountTableIdSet != null) {
                accountTableIdSet.add(bookVersionDyn.getLong("accounttable"));
                continue;
            }
            accountTableIdSet = new HashSet<Long>(8);
            accountTableIdSet.add(bookVersionDyn.getLong("accounttable"));
            orgAndBookTypeToIdTable.put((Object)orgNum, (Object)bookTypeNum, accountTableIdSet);
        }
        return orgAndBookTypeToIdTable;
    }

    private Table<Long, String, String> getAccountTableToValSourceTable(Collection<Long> accountTableIdSet) {
        DynamicObjectCollection accountTableDyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"id, comassistentry.seq seq, comassistentry.valuesourcetype valuesourcetype, comassistentry.valuesource valuesource, comassistentry.assistantvaluesource.id assistantvaluesource.id", (QFilter[])new QFilter[]{new QFilter("id", "in", accountTableIdSet)});
        HashBasedTable comAssistValSourceTable = HashBasedTable.create();
        for (DynamicObject accountTableDyn : accountTableDyns) {
            if (accountTableDyn == null) continue;
            String comAssistKey = CommonAssistUtil.getComassistField((int)accountTableDyn.getInt("seq"));
            String valueSourceType = accountTableDyn.getString("valuesourcetype");
            long accountTableId = accountTableDyn.getLong("id");
            String entityId = "";
            if (BASE_DATA_TYPE.equals(valueSourceType)) {
                entityId = accountTableDyn.getString("valuesource");
            } else if (ASSISTANT_DATA_TYPE.equals(valueSourceType)) {
                entityId = "bos_assistantdata_detail_" + accountTableDyn.getLong("assistantvaluesource.id");
            }
            if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
            comAssistValSourceTable.put((Object)accountTableId, (Object)comAssistKey, (Object)entityId);
        }
        return comAssistValSourceTable;
    }

    private void setComAssistId(Table<String, String, Map<String, Set<String>>> orgComAssistNumTable, Map<String, Long> orgNumIdMap, Map<String, Long> standardMap, Map<String, DataSet> groupMap, Table<String, String, Set<Long>> orgAndBookTypeToIdTable, Table<Long, String, String> comAssistValSourceTable) {
        HashBasedTable allComAssistToValueNumTable = HashBasedTable.create();
        HashBasedTable allComAssistToRangeNumTable = HashBasedTable.create();
        for (Table.Cell orgComAssistNumCell : orgComAssistNumTable.cellSet()) {
            String bookTypeNum;
            String orgNum = (String)orgComAssistNumCell.getRowKey();
            Set accountTableIdSet = (Set)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)orgComAssistNumCell.getColumnKey()));
            if (!CollectionUtils.isNotEmpty((Collection)accountTableIdSet)) continue;
            for (Long accountTableId : accountTableIdSet) {
                if (accountTableId == 0L) continue;
                Map comAssistKeyToNumMap = (Map)orgComAssistNumCell.getValue();
                for (Map.Entry comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
                    String comAssistKey = (String)comAssistKeyToNumEntry.getKey();
                    String valueSource = (String)comAssistValSourceTable.get((Object)accountTableId, (Object)comAssistKey);
                    if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
                    for (String comAssistValueNum : (Set)comAssistKeyToNumEntry.getValue()) {
                        HashSet<String> allComAssistValueSet;
                        if (AcctUtil.isRangeValueNumber(comAssistValueNum)) {
                            if (allComAssistToRangeNumTable.contains((Object)orgNum, (Object)valueSource) && allComAssistToRangeNumTable.get((Object)orgNum, (Object)valueSource) != null) {
                                ((Set)allComAssistToRangeNumTable.get((Object)orgNum, (Object)valueSource)).add(comAssistValueNum);
                                continue;
                            }
                            allComAssistValueSet = new HashSet<String>(8);
                            allComAssistValueSet.add(comAssistValueNum);
                            allComAssistToRangeNumTable.put((Object)orgNum, (Object)valueSource, allComAssistValueSet);
                            continue;
                        }
                        if (allComAssistToValueNumTable.contains((Object)orgNum, (Object)valueSource) && allComAssistToValueNumTable.get((Object)orgNum, (Object)valueSource) != null) {
                            ((Set)allComAssistToValueNumTable.get((Object)orgNum, (Object)valueSource)).add(comAssistValueNum);
                            continue;
                        }
                        allComAssistValueSet = new HashSet(8);
                        allComAssistValueSet.add(comAssistValueNum);
                        allComAssistToValueNumTable.put((Object)orgNum, (Object)valueSource, allComAssistValueSet);
                    }
                }
            }
        }
        this.comAssistDispersedValIdTable = AcctUtil.queryComAssistDispersedValueId((Table<String, String, Set<String>>)allComAssistToValueNumTable, orgNumIdMap);
        this.comAssistRangeValIdTable = AcctUtil.queryComAssistRangeValueId((Table<String, String, Set<String>>)allComAssistToRangeNumTable, orgNumIdMap, standardMap, groupMap);
    }

    private String getMainBookType() {
        QFilter ftype = new QFilter("accounttype", "=", (Object)BASE_DATA_TYPE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "number", filters);
        String bookTypeNumber = null;
        if (bookTypeSet.hasNext()) {
            bookTypeNumber = bookTypeSet.next().getString("number");
        }
        return bookTypeNumber;
    }

    private Map<Long, Set<Integer>> getPeriodTypeToYearNum(String comOrgNumber, int comYear, AccountBookInfo defbook, Table<String, String, AccountBookInfo> accountBookCache, Map<String, Object> acctFormulas) {
        HashMap<Long, Set<Integer>> periodTypeToYearNumMap = new HashMap<Long, Set<Integer>>(8);
        for (Map.Entry<String, Object> acctFormulaEntry : acctFormulas.entrySet()) {
            List formulaParamList = (List)acctFormulaEntry.getValue();
            String orgNum = StringUtils.isEmpty((CharSequence)((CharSequence)formulaParamList.get(0))) ? comOrgNumber : (String)formulaParamList.get(0);
            String bookTypeNum = (String)formulaParamList.get(1);
            if (Objects.nonNull(defbook) && StringUtils.isEmpty((CharSequence)bookTypeNum)) {
                bookTypeNum = defbook.getBookTypeNum();
            }
            AccountBookInfo book = null;
            if (Objects.nonNull(accountBookCache.get((Object)orgNum, (Object)bookTypeNum))) {
                book = (AccountBookInfo)accountBookCache.get((Object)orgNum, (Object)bookTypeNum);
            } else {
                book = new AccountBookInfo(orgNum, bookTypeNum);
                accountBookCache.put((Object)orgNum, (Object)bookTypeNum, (Object)book);
            }
            if (!Objects.nonNull(book)) continue;
            Set yearNumSet = periodTypeToYearNumMap.computeIfAbsent(book.getPeriodTypeId(), k -> new HashSet(8));
            yearNumSet.add(Integer.parseInt(AcctUtil.getCurYear((String)formulaParamList.get(4), String.valueOf(comYear))));
        }
        return periodTypeToYearNumMap;
    }

    private boolean isExistPeriodId(long startPeriodId, long endPeriodId, Map<String, Map<String, Object>> errorInfoMap, Set<FormulaInfo> formulaInfoSet) {
        if (startPeriodId == 0L || endPeriodId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashflowServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]);
            for (FormulaInfo formulaInfo : formulaInfoSet) {
                AcctUtil.setErrorMessage(errorInfoMap, formulaInfo.getFormulaId(), errorMsg, -1);
            }
            return false;
        }
        return true;
    }

    private Map<Long, CashFlowFormulaInfo> getCashFlowIdToInfo(Map<String, Long> orgNumIdMap, Map<String, Map<String, Set<Long>>> orgCashNumIdsMap, Table<String, String, String> cashFlowDirectionTable) {
        HashMap<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap = new HashMap<Long, CashFlowFormulaInfo>(8);
        for (Map.Entry<String, Long> entry : orgNumIdMap.entrySet()) {
            Row row;
            String orgNumber = entry.getKey();
            long orgId = entry.getValue();
            Map<String, Set<Long>> cashNumIdsMap = orgCashNumIdsMap.get(orgNumber);
            if (cashNumIdsMap == null) continue;
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter[] qfs = new QFilter[]{qids, new QFilter("number", "in", cashNumIdsMap.keySet())};
            HashMap<String, String> numToLongNumMap = new HashMap<String, String>(8);
            HashMap<String, Integer> numToLevelMap = new HashMap<String, Integer>(8);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)"longnumber, number, level, direction", (QFilter[])qfs, null);){
                while (dt.hasNext()) {
                    row = dt.next();
                    numToLongNumMap.put(row.getString("number"), row.getString("longnumber"));
                    numToLevelMap.put(row.getString("number"), row.getInteger("level"));
                    cashFlowDirectionTable.put((Object)orgNumber, (Object)row.getString("number"), (Object)row.getString("direction"));
                }
            }
            dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)"longnumber, id, assistentry.asstypeid.number assistnumber, level", (QFilter[])new QFilter[]{qids}, null);
            var16_15 = null;
            try {
                while (dt.hasNext()) {
                    row = dt.next();
                    long itemId = row.getLong("id");
                    CashFlowFormulaInfo cashFlowFormulaInfo = cashFlowIdToInfoMap.computeIfAbsent(itemId, k -> new CashFlowFormulaInfo(row));
                    cashFlowFormulaInfo.getAssistNumSet().add(row.getString("assistnumber"));
                    String rowLongNumber = row.getString("longnumber");
                    for (Map.Entry<String, Set<Long>> cashNumIdsEntry : cashNumIdsMap.entrySet()) {
                        String assistNum = cashNumIdsEntry.getKey();
                        String longNumber = (String)numToLongNumMap.get(assistNum);
                        int level = numToLevelMap.getOrDefault(assistNum, 0);
                        int rowLevel = row.getInteger("level");
                        if (longNumber == null || !rowLongNumber.equals(longNumber) && (!rowLongNumber.startsWith(longNumber) || rowLevel <= level)) continue;
                        Set valueIdSet = cashNumIdsMap.computeIfAbsent(assistNum, k -> new HashSet());
                        valueIdSet.add(itemId);
                    }
                }
            }
            catch (Throwable throwable) {
                var16_15 = throwable;
                throw throwable;
            }
            finally {
                if (dt == null) continue;
                if (var16_15 != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable) {
                        var16_15.addSuppressed(throwable);
                    }
                    continue;
                }
                dt.close();
            }
        }
        return cashFlowIdToInfoMap;
    }

    private Set<Long> getSumCFItemIds(Set<Long> includeAssistCashFlowIdSet, Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap) {
        HashSet<Long> sumCFItemIdSet = new HashSet<Long>(8);
        HashSet<String> sumCFItemLongNumSet = new HashSet<String>(8);
        ArrayList<CashFlowFormulaInfo> cashFlowFormulaInfoList = new ArrayList<CashFlowFormulaInfo>(8);
        for (long cfItemId : includeAssistCashFlowIdSet) {
            CashFlowFormulaInfo cashFlowFormulaInfo = cashFlowIdToInfoMap.get(cfItemId);
            if (!Objects.nonNull(cashFlowFormulaInfo)) continue;
            cashFlowFormulaInfoList.add(cashFlowFormulaInfo);
        }
        cashFlowFormulaInfoList.sort(Comparator.comparingInt(CashFlowFormulaInfo::getLevel));
        for (CashFlowFormulaInfo cashFlowFormulaInfo : cashFlowFormulaInfoList) {
            String curLongNum = cashFlowFormulaInfo.getLongNumber();
            if (!Objects.nonNull(curLongNum) || !sumCFItemLongNumSet.stream().noneMatch(longNum -> !curLongNum.equals(longNum) && curLongNum.startsWith((String)longNum))) continue;
            sumCFItemIdSet.add(cashFlowFormulaInfo.getId());
            sumCFItemLongNumSet.add(curLongNum);
        }
        return sumCFItemIdSet;
    }

    private DataSet sumBalance(DataSet cashSet, String sumField, String filterStr, String formulaId, String direction) {
        if (direction.equals("b")) {
            String sumStr = "case when direction='o' then " + sumField + " * (-1) else " + sumField + " end";
            return cashSet.copy().filter(filterStr).groupBy().sum(sumStr, sumField).finish().select(sumField + " value").addField("'" + formulaId + "'", "formulaid");
        }
        return cashSet.copy().filter(filterStr).groupBy().sum(sumField).finish().select(sumField + " value").addField("'" + formulaId + "'", "formulaid");
    }

    private Set<Long> getSumCFIdByFilter(String filter) {
        String idStr = filter.substring(filter.indexOf(40) + 1, filter.indexOf(41));
        String[] ids = idStr.split(",");
        HashSet<Long> sumCFIdSet = new HashSet<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            sumCFIdSet.add(Long.parseLong(ids[i].trim()));
        }
        return sumCFIdSet;
    }

    private Set<Long> getNeedReduceCFItemId(Set<Long> sumCFIdSet, Set<Long> cashFlowItemIdSet, Set<String> assistTypeNumSet, Map<String, String[]> assistNumMap, Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap) {
        Set<Long> allSubItemIdSet = this.getAllSubItemId(sumCFIdSet, cashFlowItemIdSet, cashFlowIdToInfoMap);
        Set<Long> includeAssistCashFlowIdSet = this.getIncludeAssistCashFlowIds(allSubItemIdSet, cashFlowIdToInfoMap, assistTypeNumSet, assistNumMap);
        allSubItemIdSet.removeAll(includeAssistCashFlowIdSet);
        return allSubItemIdSet;
    }

    private Set<Long> getAllSubItemId(Set<Long> sumCFIdSet, Set<Long> cashFlowItemIdSet, Map<Long, CashFlowFormulaInfo> cashFlowIdToInfoMap) {
        HashSet<String> longNumSet = new HashSet<String>(8);
        for (Long curCashFlowId : sumCFIdSet) {
            CashFlowFormulaInfo curCashFlowItemInfo = cashFlowIdToInfoMap.get(curCashFlowId);
            if (!Objects.nonNull(curCashFlowItemInfo)) continue;
            longNumSet.add(curCashFlowItemInfo.getLongNumber());
        }
        HashSet<Long> subCFIdSet = new HashSet<Long>(8);
        for (Long cashFlowId : cashFlowItemIdSet) {
            CashFlowFormulaInfo cashFlowItemInfo = cashFlowIdToInfoMap.get(cashFlowId);
            if (!Objects.nonNull(cashFlowItemInfo) || !longNumSet.stream().anyMatch(curLongNum -> cashFlowItemInfo.getLongNumber().startsWith((String)curLongNum))) continue;
            subCFIdSet.add(cashFlowId);
        }
        return subCFIdSet;
    }
}

