/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acctfloat;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.param.AcctReClassAmountKey;
import kd.fi.gl.acctfloat.AcctFloatQueryParam;
import kd.fi.gl.util.ReClassUtils;

public class AcctFloatQueryFormula {
    private static final String FLOAT_KEY = "@";
    private static final String CONTRA_KEY = "Y";
    Map<Map<String, Object>, Table<String, String, BigDecimal>> combinationToAmountByAccountTable;
    Map<Map<String, Object>, Map<AcctReClassAmountKey, BigDecimal>> combinationToAmountByAssgrpMap;
    private String formulaKey;
    private String orgNumber;
    private String bookTypeNumber;
    private Map<String, DynamicObject> accountNumberToDynMap;
    private Set<String> accountContinueNumberSet;
    private Map<String, List<String>> assistToValueNumberMap;
    private Map<String, List<String>> assistToRangeValueMap;
    private Set<String> allValueAssistNumberSet;
    private List<String> floatAssistNumberList;
    private String fetchType;
    private int year;
    private String period;
    private String currency;
    private int reClassType;
    private boolean contraAccount;
    private String errorMsg;
    private Map<Map<String, Object>, BigDecimal> resultMap;
    private String comAssistStr;
    private Map<String, Set<String>> comAssistToValNumMap;
    private Set<String> includeNoneAssistSet = new HashSet<String>(8);

    public AcctFloatQueryFormula(AcctFloatQueryParam acctParam, String formulaKey, List<String> formulaParam) {
        this.formulaKey = formulaKey;
        this.initFormula(acctParam, formulaParam);
    }

    private void initFormula(AcctFloatQueryParam acctParam, List<String> formulaParam) {
        this.orgNumber = StringUtils.isNotBlank((CharSequence)formulaParam.get(0)) ? formulaParam.get(0) : acctParam.getComOrgNumber();
        this.bookTypeNumber = StringUtils.isNotBlank((CharSequence)formulaParam.get(1)) ? formulaParam.get(1) : acctParam.getMainBookTypeNumber();
        this.parseAccountAndAssist(formulaParam.get(2), acctParam.getRefParamMap());
        this.fetchType = formulaParam.get(3).toUpperCase();
        this.year = StringUtils.isNotBlank((CharSequence)formulaParam.get(4)) ? Integer.parseInt(formulaParam.get(4)) : 0;
        this.period = StringUtils.isNotBlank((CharSequence)formulaParam.get(5)) ? formulaParam.get(5) : "0";
        this.currency = formulaParam.get(6);
        this.reClassType = formulaParam.size() > 7 && StringUtils.isNotBlank((CharSequence)formulaParam.get(7)) ? Integer.parseInt(formulaParam.get(7)) : acctParam.getComAcctReClass();
        this.contraAccount = formulaParam.size() > 8 && CONTRA_KEY.equals(formulaParam.get(8));
        this.resultMap = new HashMap<Map<String, Object>, BigDecimal>(8);
        this.combinationToAmountByAccountTable = new HashMap<Map<String, Object>, Table<String, String, BigDecimal>>(8);
        this.combinationToAmountByAssgrpMap = new HashMap<Map<String, Object>, Map<AcctReClassAmountKey, BigDecimal>>(8);
        this.comAssistStr = formulaParam.size() > 9 && StringUtils.isNotBlank((CharSequence)formulaParam.get(9)) ? formulaParam.get(9) : acctParam.getComAssistStr();
        this.comAssistToValNumMap = new HashMap<String, Set<String>>(8);
        if (AcctUtil.checkComAssistFormat(this.comAssistStr, Boolean.TRUE)) {
            this.comAssistToValNumMap = AcctUtil.parseComAssistStr(this.comAssistStr);
        }
    }

    private void parseAccountAndAssist(String accountAndAssistStr, Map<String, Object> floatParam) {
        accountAndAssistStr = accountAndAssistStr.replaceAll("\\|", "\\| ");
        String[] accountAndAssistSplit = accountAndAssistStr.split("\\|");
        String accountStr = accountAndAssistSplit[0];
        this.accountContinueNumberSet = new HashSet<String>(8);
        this.accountNumberToDynMap = new HashMap<String, DynamicObject>(8);
        if (ReClassUtils.isContinueNumber(accountStr)) {
            this.accountContinueNumberSet.add(accountStr);
        } else {
            String[] accountNumbers;
            for (String accountNumber : accountNumbers = accountStr.split(",")) {
                this.accountNumberToDynMap.put(accountNumber, null);
            }
        }
        this.assistToValueNumberMap = new HashMap<String, List<String>>(8);
        this.assistToRangeValueMap = new HashMap<String, List<String>>(8);
        this.allValueAssistNumberSet = new HashSet<String>(8);
        this.floatAssistNumberList = new ArrayList<String>(8);
        for (int index = 1; index < accountAndAssistSplit.length; index += 2) {
            String assistNumber = accountAndAssistSplit[index].trim();
            String valueNumber = accountAndAssistSplit[index + 1].trim();
            if (FLOAT_KEY.equals(valueNumber)) {
                this.assistToValueNumberMap.put(assistNumber, (List)floatParam.get(assistNumber));
                this.floatAssistNumberList.add(assistNumber);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)valueNumber)) {
                this.allValueAssistNumberSet.add(assistNumber);
                continue;
            }
            if (ReClassUtils.isContinueNumber(valueNumber)) {
                List rangeValueList = this.assistToRangeValueMap.computeIfAbsent(assistNumber, key -> new ArrayList(8));
                rangeValueList.add(valueNumber);
                continue;
            }
            this.assistToValueNumberMap.put(assistNumber, new ArrayList<String>(Arrays.asList(valueNumber.split(","))));
        }
    }

    public Long getPeriodTypeId(Map<String, DynamicObject> accountBookMap) {
        DynamicObject accountBook = accountBookMap.get(this.orgNumber + "*" + this.bookTypeNumber);
        if (accountBook != null) {
            return accountBook.getLong("periodtype_id");
        }
        return 0L;
    }

    public String getFormulaKey() {
        return this.formulaKey;
    }

    public void setFormulaKey(String formulaKey) {
        this.formulaKey = formulaKey;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public Map<String, DynamicObject> getAccountNumberToDynMap() {
        return this.accountNumberToDynMap;
    }

    public void setAccountNumberToDynMap(Map<String, DynamicObject> accountNumberToDynMap) {
        this.accountNumberToDynMap = accountNumberToDynMap;
    }

    public Set<String> getAccountContinueNumberSet() {
        return this.accountContinueNumberSet;
    }

    public void setAccountContinueNumberSet(Set<String> accountContinueNumberSet) {
        this.accountContinueNumberSet = accountContinueNumberSet;
    }

    public Map<String, List<String>> getAssistToValueNumberMap() {
        return this.assistToValueNumberMap;
    }

    public void setAssistToValueNumberMap(Map<String, List<String>> assistToValueNumberMap) {
        this.assistToValueNumberMap = assistToValueNumberMap;
    }

    public Map<String, List<String>> getAssistToRangeValueMap() {
        return this.assistToRangeValueMap;
    }

    public void setAssistToRangeValueMap(Map<String, List<String>> assistToRangeValueMap) {
        this.assistToRangeValueMap = assistToRangeValueMap;
    }

    public Set<String> getAllValueAssistNumberSet() {
        return this.allValueAssistNumberSet;
    }

    public void setAllValueAssistNumberSet(Set<String> allValueAssistNumberSet) {
        this.allValueAssistNumberSet = allValueAssistNumberSet;
    }

    public List<String> getFloatAssistNumberList() {
        return this.floatAssistNumberList;
    }

    public void setFloatAssistNumberList(List<String> floatAssistNumberList) {
        this.floatAssistNumberList = floatAssistNumberList;
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public int getReClassType() {
        return this.reClassType;
    }

    public void setReClassType(int reClassType) {
        this.reClassType = reClassType;
    }

    public boolean isContraAccount() {
        return this.contraAccount;
    }

    public void setContraAccount(boolean contraAccount) {
        this.contraAccount = contraAccount;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Map<Map<String, Object>, BigDecimal> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<Map<String, Object>, BigDecimal> resultMap) {
        this.resultMap = resultMap;
    }

    public Map<Map<String, Object>, Table<String, String, BigDecimal>> getCombinationToAmountByAccountTable() {
        return this.combinationToAmountByAccountTable;
    }

    public void setCombinationToAmountByAccountMap(Map<Map<String, Object>, Table<String, String, BigDecimal>> combinationToAmountByAccountTable) {
        this.combinationToAmountByAccountTable = combinationToAmountByAccountTable;
    }

    public Map<Map<String, Object>, Map<AcctReClassAmountKey, BigDecimal>> getCombinationToAmountByAssgrpMap() {
        return this.combinationToAmountByAssgrpMap;
    }

    public void setCombinationToAmountByAssgrpMap(Map<Map<String, Object>, Map<AcctReClassAmountKey, BigDecimal>> combinationToAmountByAssgrpMap) {
        this.combinationToAmountByAssgrpMap = combinationToAmountByAssgrpMap;
    }

    public String getComAssistStr() {
        return this.comAssistStr;
    }

    public void setComAssistStr(String comAssistStr) {
        this.comAssistStr = comAssistStr;
    }

    public Map<String, Set<String>> getComAssistToValNumMap() {
        return this.comAssistToValNumMap;
    }

    public void setComAssistToValNumMap(Map<String, Set<String>> comAssistToValNumMap) {
        this.comAssistToValNumMap = comAssistToValNumMap;
    }

    public Set<String> getIncludeNoneAssistSet() {
        return this.includeNoneAssistSet;
    }

    public boolean isHaveComAssist() {
        return !this.comAssistToValNumMap.isEmpty();
    }
}

