/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acctfloat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.util.ReClassUtils;

public class AcctFloatQueryParam {
    private String comOrgNumber;
    private String mainBookTypeNumber;
    private int comYear;
    private int comPeriod;
    private String comAdjustPeriod;
    private List<String> scopePeriods;
    private int comAcctReClass;
    private String formulaName;
    private Map<String, Object> commParamMap;
    private Map<String, Object> refParamMap;
    private Map<String, Object> acctFormulaMap;
    private String comAssistStr;

    public AcctFloatQueryParam(String param) {
        this.init(param);
    }

    private void init(String param) {
        try {
            Map acctMap = (Map)JSONUtils.cast((String)param, Map.class);
            this.acctFormulaMap = (Map)acctMap.get("param");
            this.commParamMap = (Map)acctMap.get("commParam");
            if (this.commParamMap == null) {
                return;
            }
            this.mainBookTypeNumber = this.getMainBookType();
            this.comYear = (Integer)this.commParamMap.get("fy");
            this.comOrgNumber = (String)this.commParamMap.get("org");
            if (this.commParamMap.get("period") instanceof String) {
                this.comAdjustPeriod = AcctUtil.getPeriodParam((String)this.commParamMap.get("period"));
                this.comPeriod = 0;
            } else {
                this.comAdjustPeriod = "";
                this.comPeriod = (Integer)this.commParamMap.get("period");
            }
            this.scopePeriods = (List)this.commParamMap.get("scopePeriod");
            this.comAcctReClass = (Integer)this.commParamMap.getOrDefault("accountreclass", 6);
            this.refParamMap = (Map)acctMap.get("ref_param");
            this.formulaName = (String)acctMap.get("formulaName");
            this.comAssistStr = AcctUtil.getComAssistFromBCM(acctMap);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"AcctFloatQueryParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
    }

    private String getMainBookType() {
        String number = "";
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "number", filters);
        for (Row row : bookTypeSet) {
            number = row.getString("number");
        }
        return number;
    }

    public String getComOrgNumber() {
        return this.comOrgNumber;
    }

    public void setComOrgNumber(String comOrgNumber) {
        this.comOrgNumber = comOrgNumber;
    }

    public String getMainBookTypeNumber() {
        return this.mainBookTypeNumber;
    }

    public void setMainBookTypeNumber(String mainBookTypeNumber) {
        this.mainBookTypeNumber = mainBookTypeNumber;
    }

    public int getComYear() {
        return this.comYear;
    }

    public void setComYear(int comYear) {
        this.comYear = comYear;
    }

    public int getComPeriod() {
        return this.comPeriod;
    }

    public void setComPeriod(int comPeriod) {
        this.comPeriod = comPeriod;
    }

    public String getComAdjustPeriod() {
        return this.comAdjustPeriod;
    }

    public void setComAdjustPeriod(String comAdjustPeriod) {
        this.comAdjustPeriod = comAdjustPeriod;
    }

    public List<String> getScopePeriods() {
        return this.scopePeriods;
    }

    public void setScopePeriods(List<String> scopePeriods) {
        this.scopePeriods = scopePeriods;
    }

    public int getComAcctReClass() {
        return this.comAcctReClass;
    }

    public void setComAcctReClass(int comAcctReClass) {
        this.comAcctReClass = comAcctReClass;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public Map<String, Object> getCommParamMap() {
        return this.commParamMap;
    }

    public void setCommParamMap(Map<String, Object> commParamMap) {
        this.commParamMap = commParamMap;
    }

    public Map<String, Object> getRefParamMap() {
        return this.refParamMap;
    }

    public void setRefParamMap(Map<String, Object> refParamMap) {
        this.refParamMap = refParamMap;
    }

    public Map<String, Object> getAcctFormulaMap() {
        return this.acctFormulaMap;
    }

    public void setAcctFormulaMap(Map<String, Object> acctFormulaMap) {
        this.acctFormulaMap = acctFormulaMap;
    }

    public String getComAssistStr() {
        return this.comAssistStr;
    }

    public void setComAssistStr(String comAssistStr) {
        this.comAssistStr = comAssistStr;
    }
}

