/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.bcmbussiness;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;

public class BcmTaskRunner
implements Callable<Map<String, Map<String, Object>>> {
    private DataSet defset;
    private List<DataSet> unionSets;

    public BcmTaskRunner(DataSet defset, List<DataSet> unionSets) {
        this.defset = defset;
        this.unionSets = unionSets;
    }

    @Override
    public Map<String, Map<String, Object>> call() throws Exception {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        if (this.unionSets == null) {
            this.unionSets = new ArrayList<DataSet>();
        }
        this.unionSets.add(this.defset);
        for (DataSet dataSet : this.unionSets) {
            for (Row row : dataSet) {
                String acctKeyId = row.getString("formulaid");
                BigDecimal value = row.getBigDecimal("value");
                if (value == null) continue;
                Map acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap());
                if (acctValMap.isEmpty()) {
                    acctValMap.put("v", value);
                    acctValMap.put("type", 1);
                    continue;
                }
                BigDecimal cur = (BigDecimal)acctValMap.get("v");
                if (cur == null) continue;
                acctValMap.put("v", cur.add(value));
            }
            dataSet.close();
        }
        return resultMap;
    }
}

