/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.operation.TarAccountAssgrpInfo;
import kd.fi.gl.operation.VoucherConvertInfo;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.QFBuilder;
import kd.sdk.fi.gl.extpoint.syncbookvch.AccountAssgrpMapping;

public class CustomAccountAssgrpMappingInfo {
    private final Map<String, List<AccountAssgrpMapping>> accountAssgrpMappings = new HashMap<String, List<AccountAssgrpMapping>>();
    private final Table<String, Long, TarAccountAssgrpInfo> finalMapping = HashBasedTable.create();
    Map<String, List<Map<String, Object>>> tarAccNumAssgrpMap = new HashMap<String, List<Map<String, Object>>>();
    private DynamicObject destPeriod;

    public Map<String, List<AccountAssgrpMapping>> getAccountAssgrpMappings() {
        return this.accountAssgrpMappings;
    }

    public boolean hasCustom(Long srcBookId, Long destBookId) {
        List<AccountAssgrpMapping> accountAssgrpMapping = this.getAccountAssgrpMapping(srcBookId, destBookId);
        return accountAssgrpMapping != null && !accountAssgrpMapping.isEmpty();
    }

    public List<AccountAssgrpMapping> getAccountAssgrpMapping(Long srcBookId, Long destBookId) {
        return this.accountAssgrpMappings.get("" + srcBookId + destBookId);
    }

    public void setTarAccNumAssgrpMap(Map<String, List<Map<String, Object>>> tarAccNumAssgrpMap) {
        this.tarAccNumAssgrpMap = tarAccNumAssgrpMap;
    }

    public Table<String, Long, TarAccountAssgrpInfo> getFinalMapping() {
        return this.finalMapping;
    }

    public void updateFinalMappingTarInfo(DynamicObject destVoucher, VoucherConvertInfo voucherConvertInfo) {
        boolean isFirstUpdate = false;
        if (this.destPeriod == null) {
            isFirstUpdate = true;
            this.destPeriod = destVoucher.getDynamicObject("period");
        }
        DynamicObject destVoucherPeriod = destVoucher.getDynamicObject("period");
        if (isFirstUpdate || destVoucherPeriod.getDate("begindate").getTime() != this.destPeriod.getDate("begindate").getTime() || destVoucherPeriod.getDate("enddate").getTime() != this.destPeriod.getDate("enddate").getTime()) {
            Object value;
            this.destPeriod = destVoucherPeriod;
            QFBuilder accFilterBuilder = new QFBuilder();
            accFilterBuilder.add("number", "in", this.tarAccNumAssgrpMap.keySet());
            accFilterBuilder.add("enable", "=", (Object)true);
            accFilterBuilder.add("isleaf", "=", (Object)true);
            accFilterBuilder.add("startdate", "<=", (Object)destVoucherPeriod.getDate("enddate"));
            accFilterBuilder.add("enddate", ">=", (Object)destVoucherPeriod.getDate("enddate"));
            Map accDynMap = BusinessDataServiceHelper.loadFromCache((Object[])AccountUtils.queryAccountIds((long)voucherConvertInfo.getDestBook().getBookOrgId(), (long)voucherConvertInfo.getDestBook().getAccTabId(), (List)accFilterBuilder.toList()).toArray(), (String)"bd_accountview");
            HashMap numId = new HashMap(accDynMap.size());
            HashMap<Map<String, Object>, Long> mapAssgrpId = new HashMap<Map<String, Object>, Long>();
            for (Map.Entry entry : accDynMap.entrySet()) {
                value = (DynamicObject)entry.getValue();
                String valueNum = value.getString("number");
                if (numId.containsKey(valueNum)) continue;
                numId.put(valueNum, entry.getValue());
                if (!this.tarAccNumAssgrpMap.containsKey(valueNum)) continue;
                mapAssgrpId.putAll(this.analysisToUseful((DynamicObject)value, this.tarAccNumAssgrpMap.get(valueNum)));
            }
            for (Table.Cell cell : this.finalMapping.cellSet()) {
                value = (TarAccountAssgrpInfo)cell.getValue();
                ((TarAccountAssgrpInfo)value).setTarAccDyn((DynamicObject)numId.get(((TarAccountAssgrpInfo)value).getTarAccNum()));
                ((TarAccountAssgrpInfo)value).setAssgrpIdNew((Long)mapAssgrpId.get(((TarAccountAssgrpInfo)value).getAssgrpValueMapOld()));
            }
        }
    }

    public Map<Map<String, Object>, Long> analysisToUseful(DynamicObject accDyn, List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        Set<String> flexFields = this.getFlexFields(accDyn);
        if (CollectionUtils.isEmpty(flexFields)) {
            return list.stream().collect(Collectors.toMap(key -> key, value -> 0L, (existing, replacement) -> replacement));
        }
        Set<String> tempFlexFields = list.get(0).keySet();
        if (flexFields.equals(tempFlexFields)) {
            return FlexUtils.batchSaveFlexData(list, (boolean)true);
        }
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>(list);
        HashMap old2new = new HashMap(tempList.size());
        for (Map map : tempList) {
            HashMap valTemp = new HashMap(map);
            for (String assistId : tempFlexFields) {
                if (flexFields.contains(assistId)) continue;
                valTemp.remove(assistId);
            }
            old2new.put(map, valTemp);
        }
        Map newMap2NewId = FlexUtils.batchSaveFlexData(old2new.values(), (boolean)true);
        return old2new.keySet().stream().collect(Collectors.toMap(key -> key, value -> (Long)newMap2NewId.get(old2new.get(value))));
    }

    public Set<String> getFlexFields(DynamicObject curAccount) {
        if (!curAccount.getBoolean("isassist")) {
            return Collections.emptySet();
        }
        List assistTypeIdList = curAccount.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getLong(GLField.id_((String)"asstactitem"))).collect(Collectors.toList());
        return new HashSet<String>(FlexUtils.batchGetFlexFields(assistTypeIdList).values());
    }
}

