/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.flex.FlexDefaultValueBatchReader;
import kd.fi.gl.bean.GlVoucherField;
import kd.fi.gl.business.vo.voucher.wrap.DynamicEntryWrap;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.finalprocess.VoucherEntryDBHelper;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.operation.BatchUpdateEntriesUtil;
import kd.fi.gl.operation.CustomAccountAssgrpMappingInfo;
import kd.fi.gl.operation.TarAccountAssgrpInfo;
import kd.fi.gl.operation.VoucherConvertInfo;
import kd.fi.gl.operation.VoucherSummary;
import kd.fi.gl.synvoucher.AccountMapCache;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.replace.AssgrpBatchReplacer;
import kd.sdk.fi.gl.extpoint.syncbookvch.AccountAssgrpMapping;
import kd.sdk.fi.gl.extpoint.syncbookvch.AccountAssgrpMappingParam;
import kd.sdk.fi.gl.extpoint.syncbookvch.IAccountAssgrpMapping;

public class VoucherConvertUtil {
    private static final int BATCH_SAVE_SIZE = 10000;
    private DynamicObjectType voucherDT;
    private DynamicObject destVoucher;
    private List<DynamicObject> destVoucherList = new ArrayList<DynamicObject>(16);
    private Map<Object, DynamicObject> destVoucherMap = new LinkedHashMap<Object, DynamicObject>(16);
    private Map<Object, VoucherSummary> destVoucherSummaryMap = new LinkedHashMap<Object, VoucherSummary>(16);
    private Map<Long, DynamicObject> destAccIdDynMap;
    private Map<Long, DynamicObject> accDynCache;
    private AccountMapCache accountMapCache;
    private GlVoucherField glVoucherField;
    private FlexDefaultValueBatchReader.FlexDefaultValueMatchCollection flexDefaultValueMatchCollection;
    private AssgrpBatchReplacer<DynamicEntryWrap> assgrpBatchReplacer;
    private static final Log logger = LogFactory.getLog((String)VoucherConvertUtil.class.getTypeName());
    private final CustomAccountAssgrpMappingInfo customAccountAssgrpMappingInfo = new CustomAccountAssgrpMappingInfo();

    @Deprecated
    VoucherConvertUtil() {
    }

    public VoucherConvertUtil(Map<Long, DynamicObject> accDynCache, AccountMapCache accountMapCache, GlVoucherField glVoucherField, VoucherConvertInfo convertInfo) {
        this.accDynCache = accDynCache;
        this.accountMapCache = accountMapCache;
        this.voucherDT = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        this.glVoucherField = glVoucherField;
        this.flexDefaultValueMatchCollection = FlexDefaultValueBatchReader.init(Collections.singleton(convertInfo.getDestBook().getBookOrgId()));
        this.assgrpBatchReplacer = new AssgrpBatchReplacer(true, "assgrp", (row, flex) -> this.flexDefaultValueMatchCollection.getDefaultValue(Long.valueOf(row.getLong("account.masterid")), Long.valueOf(row.getLong("currency.id")), flex));
    }

    public void processAssgrpMapping(VoucherConvertInfo voucherConvertInfo, CustomAccountAssgrpMappingInfo customMappingInfo, Map<Long, DynamicObject> accDynMap) {
        Long srcBookId = voucherConvertInfo.getSrcBook().getBookId();
        Long destBookId = voucherConvertInfo.getDestBook().getBookId();
        PluginProxy pluginProxy = PluginProxy.create(null, IAccountAssgrpMapping.class, (String)"kd.sdk.fi.gl.extpoint.syncbookvch.IAccountAssgrpMapping.dealMapping", null);
        pluginProxy.callReplace(plugin -> {
            customMappingInfo.getAccountAssgrpMappings().put("" + srcBookId + destBookId, plugin.dealMapping(new AccountAssgrpMappingParam(srcBookId, destBookId)));
            return null;
        });
        this.preliminaryRevision(srcBookId, destBookId, customMappingInfo, accDynMap);
    }

    void preliminaryRevision(Long srcBookId, Long destBookId, CustomAccountAssgrpMappingInfo customMappingInfo, Map<Long, DynamicObject> accDynMap) {
        List<AccountAssgrpMapping> accountAssgrpMapping = customMappingInfo.getAccountAssgrpMapping(srcBookId, destBookId);
        if (!customMappingInfo.hasCustom(srcBookId, destBookId)) {
            return;
        }
        HashMap<String, List<Map<String, Object>>> tarAccNumAssgrpMap = new HashMap<String, List<Map<String, Object>>>(accountAssgrpMapping.size());
        Table<String, Long, TarAccountAssgrpInfo> table = customMappingInfo.getFinalMapping();
        for (AccountAssgrpMapping mapping : accountAssgrpMapping) {
            List tarAssgrpList = tarAccNumAssgrpMap.getOrDefault(mapping.getTarAccNum(), new ArrayList());
            tarAssgrpList.add(mapping.getTarAssgrpMap());
            tarAccNumAssgrpMap.put(mapping.getTarAccNum(), tarAssgrpList);
            table.put((Object)mapping.getSrcAccNum(), (Object)mapping.getSrcAssgrpId(), (Object)new TarAccountAssgrpInfo(mapping.getTarAccNum(), mapping.getTarAssgrpMap()));
        }
        customMappingInfo.setTarAccNumAssgrpMap(tarAccNumAssgrpMap);
        accDynMap.values().stream().filter(dynamicObject -> table.rowKeySet().contains(dynamicObject.getString("number"))).forEach(dynamicObject -> this.analysisToUseful((DynamicObject)dynamicObject, table));
    }

    void analysisToUseful(DynamicObject curAccount, Table<String, Long, TarAccountAssgrpInfo> table) {
        Set flexFields;
        String curAccountNumber = curAccount.getString("number");
        if (!table.rowKeySet().contains(curAccountNumber)) {
            return;
        }
        if (!curAccount.getBoolean("isassist")) {
            flexFields = Collections.emptySet();
        } else {
            List assistTypeIdList = curAccount.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getLong(GLField.id_((String)"asstactitem"))).collect(Collectors.toList());
            flexFields = new HashSet(FlexUtils.batchGetFlexFields(assistTypeIdList).values());
        }
        Set assgrpIds = table.row((Object)curAccountNumber).keySet();
        if (CollectionUtils.isEmpty(assgrpIds) || CollectionUtils.isEmpty(flexFields)) {
            for (Long assgrpId : assgrpIds) {
                TarAccountAssgrpInfo removed = (TarAccountAssgrpInfo)table.remove((Object)curAccountNumber, (Object)assgrpId);
                table.put((Object)curAccountNumber, (Object)0L, (Object)removed);
            }
            return;
        }
        Object[] oldAssgrpIds = assgrpIds.toArray();
        Map assgrpMap = BusinessDataServiceHelper.loadFromCache((Object[])oldAssgrpIds, (String)"gl_assist");
        String assvals = ((DynamicObject)assgrpMap.get(oldAssgrpIds[0])).getString("assvals");
        if (flexFields.equals(new FlexValueJson(assvals).getValueMap().keySet())) {
            return;
        }
        HashMap<Map, Long> listForBatchSave = new HashMap<Map, Long>(assgrpMap.size());
        for (DynamicObject value : assgrpMap.values()) {
            Map tempAssgrpMap = new FlexValueJson(value.getString("assvals")).getValueMap();
            for (String assistId : new HashSet(tempAssgrpMap.keySet())) {
                if (flexFields.contains(assistId)) continue;
                tempAssgrpMap.remove(assistId);
            }
            listForBatchSave.put(tempAssgrpMap, value.getLong("id"));
        }
        Map mapAfterBatchSave = FlexUtils.batchSaveFlexData(listForBatchSave.keySet(), (boolean)true);
        for (Map.Entry entry : mapAfterBatchSave.entrySet()) {
            TarAccountAssgrpInfo removed = (TarAccountAssgrpInfo)table.remove((Object)curAccountNumber, listForBatchSave.get(entry.getKey()));
            table.put((Object)curAccountNumber, entry.getValue(), (Object)removed);
        }
    }

    public Set<String> getFlexFields(DynamicObject curAccount) {
        if (!curAccount.getBoolean("isassist")) {
            return Collections.emptySet();
        }
        List assistTypeIdList = curAccount.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getLong(GLField.id_((String)"asstactitem"))).collect(Collectors.toList());
        return new HashSet<String>(FlexUtils.batchGetFlexFields(assistTypeIdList).values());
    }

    public CustomAccountAssgrpMappingInfo getCustomAccountAssgrpMappingInfo() {
        return this.customAccountAssgrpMappingInfo;
    }

    public DynamicObjectType getVoucherDT() {
        return this.voucherDT;
    }

    public Map<Object, DynamicObject> getDestVoucherMap() {
        return this.destVoucherMap;
    }

    public VoucherSummary getDestVoucherSummary() {
        return this.destVoucherSummaryMap.get(this.destVoucher.getPkValue());
    }

    public Map<Object, VoucherSummary> getDestVoucherSummaryMap() {
        return this.destVoucherSummaryMap;
    }

    public DynamicObject createDestVoucher(Long destVid, DynamicObject srcVoucher) {
        this.destVoucher = new DynamicObject(this.voucherDT);
        this.destVoucherList.add(this.destVoucher);
        this.destVoucher.set("id", (Object)destVid);
        this.copyHeadFromSrc(srcVoucher, this.destVoucher);
        return this.destVoucher;
    }

    private void copyHeadFromSrc(DynamicObject srcVoucher, DynamicObject destVoucher) {
        destVoucher.set("bizdate", srcVoucher.get("bizdate"));
        destVoucher.set("bookeddate", srcVoucher.get("bookeddate"));
        destVoucher.set("description", srcVoucher.get("description"));
        destVoucher.set("vdescription", srcVoucher.get("vdescription"));
        destVoucher.set("mainstatus", srcVoucher.get("mainstatus"));
        destVoucher.set("suppstatus", srcVoucher.get("suppstatus"));
        destVoucher.set("debitlocamount", srcVoucher.get("debitlocamount"));
        destVoucher.set("creditlocamount", srcVoucher.get("creditlocamount"));
        destVoucher.set("attachment", srcVoucher.get("attachment"));
        destVoucher.set("creator", srcVoucher.get("creator"));
        destVoucher.set("submitter", srcVoucher.get("submitter"));
        destVoucher.set("vouchertype", srcVoucher.get("vouchertype"));
        destVoucher.set("period", srcVoucher.get("period"));
        destVoucher.set("submitter_id", srcVoucher.get("submitter_id"));
        destVoucher.set("creator_id", srcVoucher.get("creator_id"));
        this.setExpandField(srcVoucher, destVoucher);
    }

    private void setExpandField(DynamicObject srcVoucher, DynamicObject destVoucher) {
        if (this.glVoucherField != null) {
            List allHeadFields = this.glVoucherField.getAllHeadFields();
            for (String headField : allHeadFields) {
                destVoucher.set(headField, srcVoucher.get(headField));
                if (!this.glVoucherField.getAllHeadBaseDateFields().contains(headField)) continue;
                destVoucher.set(headField + "_id", srcVoucher.get(headField + "_id"));
            }
        }
    }

    private void copyHead(DynamicObject srcVoucher, DynamicObject destVoucher) {
        this.copyHeadFromSrc(srcVoucher, destVoucher);
        destVoucher.set("id", srcVoucher.get("id"));
        destVoucher.set("errorstatus", srcVoucher.get("errorstatus"));
        destVoucher.set("errormsg", srcVoucher.get("errormsg"));
        destVoucher.set("isreverse", srcVoucher.get("isreverse"));
        destVoucher.set("billno", srcVoucher.get("billno"));
        destVoucher.set("sourcesys_id", srcVoucher.get("sourcesys_id"));
        destVoucher.set("sourcebilltype", srcVoucher.get("sourcebilltype"));
        destVoucher.set("sourcebill", srcVoucher.get("sourcebill"));
        destVoucher.set("sourcetype", srcVoucher.get("sourcetype"));
        destVoucher.set("submitter_id", srcVoucher.get("submitter_id"));
        destVoucher.set("creator_id", srcVoucher.get("creator_id"));
        destVoucher.set("auditor", srcVoucher.get("auditor"));
        destVoucher.set("poster", srcVoucher.get("poster"));
        destVoucher.set("cashier", srcVoucher.get("cashier"));
        destVoucher.set("ischeck", srcVoucher.get("ischeck"));
        destVoucher.set("createtime", srcVoucher.get("createtime"));
        destVoucher.set("auditdate", srcVoucher.get("auditdate"));
        destVoucher.set("posttime", srcVoucher.get("posttime"));
        destVoucher.set("ispost", srcVoucher.get("ispost"));
        destVoucher.set("billstatus", srcVoucher.get("billstatus"));
        destVoucher.set("localcur", srcVoucher.get("localcur"));
        destVoucher.set("localcur_id", srcVoucher.get("localcur_id"));
        destVoucher.set("book", srcVoucher.get("book"));
        destVoucher.set("book_id", srcVoucher.get("book_id"));
        destVoucher.set("org", srcVoucher.get("org"));
        destVoucher.set("org_id", srcVoucher.get("org_id"));
        destVoucher.set("booktype", srcVoucher.get("booktype"));
        destVoucher.set("booktype_id", srcVoucher.get("booktype_id"));
        destVoucher.set("period", srcVoucher.get("period"));
        destVoucher.set("period_id", srcVoucher.get("period_id"));
        destVoucher.set("vouchertype", srcVoucher.get("vouchertype"));
        destVoucher.set("vouchertype_id", srcVoucher.get("vouchertype_id"));
    }

    public DynamicObject createNewEntry() {
        DynamicObjectCollection entries = this.destVoucher.getDynamicObjectCollection("entries");
        if (this.sumTotalEntrySize() >= 10000) {
            this.saveEntriesAndCopyHead();
            entries = this.destVoucher.getDynamicObjectCollection("entries");
        }
        DynamicObject entry = new DynamicObject(entries.getDynamicObjectType());
        entries.add((Object)entry);
        return entry;
    }

    private void saveEntries(List<DynamicObject> destVoucherList) {
        final List vids = destVoucherList.stream().map(e -> e.getPkValue()).collect(Collectors.toList());
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                if (rollbacked) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"), (Object[])vids.toArray());
                }
            }
        });
        try (TXHandle tx = TX.requiresNew((String)"VoucherConvertUtil.saveEntries");){
            try {
                BusinessDataWriter.save((IDataEntityType)this.voucherDT, (Object[])destVoucherList.toArray(new DynamicObject[0]));
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_gl_voucher where ", new Object[0]);
                sqlBuilder.appendIn("fid", vids);
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e2) {
                tx.markRollback();
                throw e2;
            }
        }
    }

    public void saveLastEntries() {
        if (this.sumTotalEntrySize() >= 1) {
            this.saveEntriesAndCopyHead();
        }
    }

    private int sumTotalEntrySize() {
        return this.destVoucherList.stream().mapToInt(e -> e.getDynamicObjectCollection("entries").size()).sum();
    }

    private void saveEntriesAndCopyHead() {
        if (this.assgrpBatchReplacer != null) {
            this.assgrpBatchReplacer.finish();
        }
        this.saveEntries(this.destVoucherList);
        this.copyHeadsToCache();
        DynamicObject newVoucher = new DynamicObject(this.voucherDT);
        this.copyHead(this.destVoucher, newVoucher);
        this.destVoucher = newVoucher;
        this.destVoucherList.add(this.destVoucher);
    }

    private void copyHeadsToCache() {
        for (DynamicObject destVoucher : this.destVoucherList) {
            DynamicObject newVoucher = new DynamicObject(this.voucherDT);
            this.copyHead(destVoucher, newVoucher);
            this.destVoucherMap.put(destVoucher.getPkValue(), newVoucher);
        }
        this.destVoucherList.clear();
    }

    public DynamicObject getDestVoucher() {
        return this.destVoucher;
    }

    public void initDestAccIdDynMap(Set<Long> srcAcctIds, VoucherConvertInfo voucherConvertInfo) {
        Date destPeriodEndDate = this.destVoucher.getDynamicObject("period").getDate("enddate");
        this.destAccIdDynMap = this.queryDestAccIdDynMap(srcAcctIds, voucherConvertInfo, destPeriodEndDate);
        this.customAccountAssgrpMappingInfo.updateFinalMappingTarInfo(this.destVoucher, voucherConvertInfo);
    }

    public Map<Long, DynamicObject> getDestAccIdDynMap() {
        return this.destAccIdDynMap;
    }

    public AssgrpBatchReplacer<DynamicEntryWrap> getAssgrpBatchReplacer() {
        return this.assgrpBatchReplacer;
    }

    private Map<Long, DynamicObject> queryDestAccIdDynMap(Set<Long> srcAcctIds, VoucherConvertInfo voucherConvertInfo, Date destPeriodEndDate) {
        DynamicObject srcAccDO;
        this.cacheAccDOs(srcAcctIds);
        VoucherConvertInfo.GLBook destBook = voucherConvertInfo.getDestBook();
        Long orgId = destBook.getBookOrgId();
        Long accTabId = destBook.getAccTabId();
        Set destAccountIds = AccountUtils.getAccountIdSet((long)orgId, (long)accTabId, (Date)destPeriodEndDate, null);
        HashMap<Long, DynamicObject> destAccIdDynMap = new HashMap<Long, DynamicObject>(srcAcctIds.size());
        HashMap<Long, Long> srcAccDestAccMap = new HashMap<Long, Long>(srcAcctIds.size());
        if (voucherConvertInfo.isSameAccountTable()) {
            HashMap<Long, Long> srcAccMasterIdMap = new HashMap<Long, Long>(srcAcctIds.size());
            destAccountIds.retainAll(srcAcctIds);
            for (Long accountId : destAccountIds) {
                srcAccDO = this.accDynCache.get(accountId);
                Date endDate = srcAccDO.getDate("enddate");
                Date date = srcAccDO.getDate("startdate");
                if (date.getTime() <= destPeriodEndDate.getTime() && endDate.getTime() >= destPeriodEndDate.getTime()) {
                    srcAccDestAccMap.put(accountId, accountId);
                    continue;
                }
                Long srcAccMasterId = srcAccDO.getLong("masterid");
                srcAccMasterIdMap.put(accountId, srcAccMasterId);
            }
            if (!srcAccMasterIdMap.isEmpty()) {
                QFBuilder accFilterBuilder = new QFBuilder();
                accFilterBuilder.add("masterid", "in", srcAccMasterIdMap.values());
                accFilterBuilder.add("accounttable", "=", (Object)accTabId);
                accFilterBuilder.add("enable", "=", (Object)true);
                accFilterBuilder.add("isleaf", "=", (Object)true);
                accFilterBuilder.add("startdate", "<=", (Object)destPeriodEndDate);
                accFilterBuilder.add("enddate", ">=", (Object)destPeriodEndDate);
                accFilterBuilder.add(destBook.getAccBaseDataFilter());
                Map accDynMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])accFilterBuilder.toArray());
                this.accDynCache.putAll(accDynMap.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), Map.Entry::getValue)));
                Map<Long, DynamicObject> masterIdDynMap = accDynMap.entrySet().stream().collect(Collectors.toMap(x -> ((DynamicObject)x.getValue()).getLong("masterid"), Map.Entry::getValue, (oldVal, newVal) -> newVal));
                for (Map.Entry entry : srcAccMasterIdMap.entrySet()) {
                    Long srcAccId = (Long)entry.getKey();
                    Long srcAccMasterId = (Long)entry.getValue();
                    DynamicObject descAccDO = masterIdDynMap.get(srcAccMasterId);
                    if (null == descAccDO) {
                        logger.error("not found dest account, src account: {}, src account masterid: {}", (Object)srcAccId, (Object)srcAccMasterId);
                        continue;
                    }
                    long destAccId = descAccDO.getLong("masterid");
                    srcAccDestAccMap.put(srcAccId, destAccId);
                }
            }
        } else {
            Map<Long, Long> mapCache = this.accountMapCache.getAccountMap(voucherConvertInfo.getSrcBook().getBookOrgId(), voucherConvertInfo.getSrcBook().getAccTabId(), orgId, accTabId, destPeriodEndDate);
            for (Long srcAcctId : srcAcctIds) {
                srcAccDO = this.accDynCache.get(srcAcctId);
                if (srcAccDO == null) {
                    logger.error("not found account: {}", (Object)srcAcctId);
                    throw new KDBizException("not found account: " + srcAcctId);
                }
                Long srcAccMasterId = srcAccDO.getLong("masterid");
                Long l = mapCache.get(srcAccMasterId);
                if (l == null) {
                    logger.error("not found dest account, src account: {}, src account masterid: {}", (Object)srcAcctId, (Object)srcAccMasterId);
                    continue;
                }
                srcAccDestAccMap.put(srcAcctId, l);
            }
        }
        this.cacheAccDOs(new HashSet<Long>(srcAccDestAccMap.values()));
        for (Map.Entry entry : srcAccDestAccMap.entrySet()) {
            destAccIdDynMap.put((Long)entry.getKey(), this.accDynCache.get(entry.getValue()));
        }
        return destAccIdDynMap;
    }

    private void cacheAccDOs(Set<Long> accIds) {
        HashSet<Long> copyIds = new HashSet<Long>(accIds);
        copyIds.removeAll(this.accDynCache.keySet());
        if (!copyIds.isEmpty()) {
            Map accMap = BusinessDataServiceHelper.loadFromCache((Object[])copyIds.toArray(), (String)"bd_accountview");
            Map<Long, DynamicObject> accIdMap = accMap.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), Map.Entry::getValue));
            this.accDynCache.putAll(accIdMap);
        }
    }

    public void handleLocalShortBatch() {
        BatchUpdateEntriesUtil batchUpdateEntriesUtil = new BatchUpdateEntriesUtil();
        for (VoucherSummary voucherSummary : this.destVoucherSummaryMap.values()) {
            this.handleLocalShort(voucherSummary, batchUpdateEntriesUtil);
        }
        batchUpdateEntriesUtil.lastBatchUpdateLocalShort();
    }

    private void handleLocalShort(VoucherSummary voucherSummary, BatchUpdateEntriesUtil batchUpdateEntriesUtil) {
        BigDecimal debitTotal = voucherSummary.debitTotal;
        BigDecimal creditTotal = voucherSummary.creditTotal;
        if (debitTotal.compareTo(creditTotal) == 0) {
            return;
        }
        DynamicObject maxOriCreditEntry = voucherSummary.maxOriCreditEntry;
        DynamicObject maxOriDebitEntry = voucherSummary.maxOriDebitEntry;
        DynamicObject maxLocalCreditEntry = voucherSummary.maxLocalCreditEntry;
        DynamicObject maxLocalDebitEntry = voucherSummary.maxLocalDebitEntry;
        DynamicObject updatedEntry = null;
        BigDecimal newCreditLoc = BigDecimal.ZERO;
        BigDecimal newDebitLoc = BigDecimal.ZERO;
        if (maxOriDebitEntry != null || maxOriCreditEntry != null) {
            if (maxOriCreditEntry == null || maxOriDebitEntry != null && maxOriDebitEntry.getBigDecimal("debitlocal").compareTo(maxOriCreditEntry.getBigDecimal("creditlocal")) >= 0) {
                newDebitLoc = maxOriDebitEntry.getBigDecimal("debitlocal").add(creditTotal.subtract(debitTotal));
                updatedEntry = maxOriDebitEntry;
                BigDecimal debitori = maxOriDebitEntry.getBigDecimal("debitori");
                int localrateScale = maxOriDebitEntry.getBigDecimal("localrate").scale();
                if (debitori != null && debitori.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal localrate = newDebitLoc.divide(debitori, localrateScale, 4);
                    batchUpdateEntriesUtil.addToBatchUpdateMaxOriDebitEntries(voucherSummary.vid, updatedEntry.getLong("id"), newDebitLoc, localrate);
                } else {
                    batchUpdateEntriesUtil.addToBatchUpdateMaxOriDebitEntries(voucherSummary.vid, updatedEntry.getLong("id"), newDebitLoc);
                }
            } else {
                newCreditLoc = maxOriCreditEntry.getBigDecimal("creditlocal").add(debitTotal.subtract(creditTotal));
                updatedEntry = maxOriCreditEntry;
                BigDecimal creditori = maxOriCreditEntry.getBigDecimal("creditori");
                int localrateScale = maxOriCreditEntry.getBigDecimal("localrate").scale();
                if (creditori != null && creditori.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal localrate = newCreditLoc.divide(creditori, localrateScale, 4);
                    batchUpdateEntriesUtil.addToBatchUpdateMaxOriCreditEntries(voucherSummary.vid, updatedEntry.getLong("id"), newCreditLoc, localrate);
                } else {
                    batchUpdateEntriesUtil.addToBatchUpdateMaxOriCreditEntries(voucherSummary.vid, updatedEntry.getLong("id"), newCreditLoc);
                }
            }
        } else if (maxLocalDebitEntry != null && (maxLocalCreditEntry == null || maxLocalDebitEntry.getBigDecimal("debitlocal").compareTo(maxLocalCreditEntry.getBigDecimal("creditlocal")) >= 0)) {
            newDebitLoc = maxLocalDebitEntry.getBigDecimal("debitlocal").add(creditTotal.subtract(debitTotal));
            updatedEntry = maxLocalDebitEntry;
            batchUpdateEntriesUtil.addToBatchUpdateMaxLocalDebitEntries(voucherSummary.vid, updatedEntry.getLong("id"), newDebitLoc);
        } else if (maxLocalCreditEntry != null) {
            newCreditLoc = maxLocalCreditEntry.getBigDecimal("creditlocal").add(debitTotal.subtract(creditTotal));
            updatedEntry = maxLocalCreditEntry;
            batchUpdateEntriesUtil.addToBatchUpdateMaxLocalCreditEntries(voucherSummary.vid, updatedEntry.getLong("id"), newCreditLoc);
        }
        this.updateVoucherSummary(updatedEntry, newDebitLoc, newCreditLoc, voucherSummary);
    }

    private void updateVoucherSummary(DynamicObject updatedEntry, BigDecimal newDebitLoc, BigDecimal newCreditLoc, VoucherSummary voucherSummary) {
        if (null == updatedEntry) {
            return;
        }
        DynamicObject destAccDO = updatedEntry.getDynamicObject("account");
        BigDecimal localAmountV1 = updatedEntry.getBigDecimal("debitlocal").subtract(updatedEntry.getBigDecimal("creditlocal"));
        BigDecimal localAmountV2 = newDebitLoc.subtract(newCreditLoc);
        BigDecimal localAmount = localAmountV2.subtract(localAmountV1);
        if (GLUtil.isCashAcct((DynamicObject)destAccDO)) {
            voucherSummary.newCashLocalAmount = voucherSummary.newCashLocalAmount.add(localAmount);
        }
        if (GLUtil.isPLAcct((DynamicObject)destAccDO)) {
            voucherSummary.newcashSuppcfAmount = voucherSummary.newcashSuppcfAmount.add(localAmount);
        }
    }

    public void handleCfShortBatch() {
    }

    public void clearVoucherCache() {
        Long destVid = this.destVoucher.getLong("id");
        this.destVoucherSummaryMap.remove(destVid);
        this.destVoucherList.remove(this.destVoucher);
        this.destVoucherMap.remove(destVid);
        VoucherEntryDBHelper.deleteEntryById((Object)destVid, (String)(this.getClass().getName() + ".clearVoucherCache"));
    }
}

