/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.operation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.util.GLUtil;

public class VoucherSummary {
    Long vid;
    Long srcVid;
    Long orgId;
    Long periodId;
    Date bizDate;
    Date bookDate;
    BigDecimal debitTotal = BigDecimal.ZERO;
    BigDecimal creditTotal = BigDecimal.ZERO;
    BigDecimal cashLocalAmount = BigDecimal.ZERO;
    BigDecimal cashSuppcfAmount = BigDecimal.ZERO;
    BigDecimal newCashLocalAmount = BigDecimal.ZERO;
    BigDecimal newcashSuppcfAmount = BigDecimal.ZERO;
    BigDecimal newMainCfAmountTotal = BigDecimal.ZERO;
    BigDecimal newSuppcfAmountTotal = BigDecimal.ZERO;
    DynamicObject maxLocalDebitEntry = null;
    DynamicObject maxLocalCreditEntry = null;
    DynamicObject maxOriDebitEntry = null;
    DynamicObject maxOriCreditEntry = null;
    CfEntryInfo maxLocalMaincfEntry = new CfEntryInfo();
    CfEntryInfo maxLocalSuppcfEntry = new CfEntryInfo();
    boolean isHasCash = false;
    boolean isNoCashAndPL = false;
    boolean isHasPL = false;

    public VoucherSummary(DynamicObject destVoucher, long srcVid) {
        this.vid = destVoucher.getLong("id");
        this.srcVid = srcVid;
        this.orgId = destVoucher.getLong("org.id");
        this.periodId = destVoucher.getLong("period.id");
        this.bizDate = destVoucher.getDate("bizdate");
        this.bookDate = destVoucher.getDate("bookeddate");
    }

    public void setMaxLocalDebitEntry(DynamicObject newEntry) {
        if (this.maxLocalDebitEntry == null || newEntry.getBigDecimal("debitlocal").compareTo(this.maxLocalDebitEntry.getBigDecimal("debitlocal")) > 0) {
            this.maxLocalDebitEntry = newEntry;
        }
    }

    public void setMaxLocalCreditEntry(DynamicObject newEntry) {
        if (this.maxLocalCreditEntry == null || newEntry.getBigDecimal("creditlocal").compareTo(this.maxLocalCreditEntry.getBigDecimal("creditlocal")) > 0) {
            this.maxLocalCreditEntry = newEntry;
        }
    }

    public void setMaxOriDebitEntry(DynamicObject newEntry) {
        if (this.maxOriDebitEntry == null || newEntry.getBigDecimal("debitlocal").compareTo(this.maxOriDebitEntry.getBigDecimal("debitlocal")) > 0) {
            this.maxOriDebitEntry = newEntry;
        }
    }

    public void setMaxOriCreditEntry(DynamicObject newEntry) {
        if (this.maxOriCreditEntry == null || newEntry.getBigDecimal("creditlocal").compareTo(this.maxOriCreditEntry.getBigDecimal("creditlocal")) > 0) {
            this.maxOriCreditEntry = newEntry;
        }
    }

    public void recordAccountType(DynamicObject account) {
        if (GLUtil.isCashAcct((DynamicObject)account)) {
            this.isHasCash = true;
        } else if (GLUtil.isPLAcct((DynamicObject)account)) {
            this.isHasPL = true;
        } else {
            this.isNoCashAndPL = true;
        }
    }

    public void recordMaxEntryAndTotal(Row srcEntryRow, DynamicObject newEntry, long destLocCurrencyId, Map<Long, DynamicObject> accDynCache) {
        String dc = newEntry.getString("entrydc");
        if (newEntry.getLong("currency_id") == destLocCurrencyId) {
            if ("1".equalsIgnoreCase(dc)) {
                this.setMaxLocalDebitEntry(newEntry);
            } else {
                this.setMaxLocalCreditEntry(newEntry);
            }
        } else if ("1".equalsIgnoreCase(dc)) {
            this.setMaxOriDebitEntry(newEntry);
        } else {
            this.setMaxOriCreditEntry(newEntry);
        }
        this.debitTotal = this.debitTotal.add(newEntry.getBigDecimal("debitlocal"));
        this.creditTotal = this.creditTotal.add(newEntry.getBigDecimal("creditlocal"));
        DynamicObject destAccDO = newEntry.getDynamicObject("account");
        BigDecimal localAmount = newEntry.getBigDecimal("debitlocal").subtract(newEntry.getBigDecimal("creditlocal"));
        if (GLUtil.isCashAcct((DynamicObject)destAccDO)) {
            this.newCashLocalAmount = this.newCashLocalAmount.add(localAmount);
        }
        if (GLUtil.isPLAcct((DynamicObject)destAccDO)) {
            this.newcashSuppcfAmount = this.newcashSuppcfAmount.add(localAmount);
        }
        long srcAccId = srcEntryRow.getLong("entries.account");
        DynamicObject srcAccDO = accDynCache.get(srcAccId);
        BigDecimal srcLocalAmount = newEntry.getBigDecimal("debitlocal").subtract(newEntry.getBigDecimal("creditlocal"));
        if (GLUtil.isCashAcct((DynamicObject)srcAccDO)) {
            this.cashLocalAmount = this.cashLocalAmount.add(srcLocalAmount);
        }
        if (GLUtil.isPLAcct((DynamicObject)srcAccDO)) {
            this.cashSuppcfAmount = this.cashSuppcfAmount.add(srcLocalAmount);
        }
    }

    public static class CfEntryInfo {
        Long id;
        Long entryId;
        DynamicObject account;
        BigDecimal maincfamount;
        BigDecimal suppcfamount;
        String maincfitemDirection;
        boolean maincfitemIsdealactivity;

        public void setMainCfInfo(long vid, long entryId, DynamicObject account, BigDecimal maincfamount, String maincfitemDirection, boolean maincfitemIsdealactivity) {
            this.id = vid;
            this.entryId = entryId;
            this.account = account;
            this.maincfamount = maincfamount;
            this.maincfitemDirection = maincfitemDirection;
            this.maincfitemIsdealactivity = maincfitemIsdealactivity;
        }

        public void setSuppCfInfo(long vid, long entryId, BigDecimal suppcfamount) {
            this.id = vid;
            this.entryId = entryId;
            this.suppcfamount = suppcfamount;
        }
    }
}

