/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.bcmbussiness.FormulaInfo;
import kd.fi.gl.cashflow.CashFlowQueryExecutor;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLServiceUtils;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.ReClassUtils;

public class CashFolwItemServiceImplHelper {
    private static final Log log = LogFactory.getLog(CashFolwItemServiceImplHelper.class);
    private static final String cfitem = "cfitem";
    private static final String assgrp = "assgrp";
    public static final String amount = "amount";
    public static final String yearAmount = "yearamount";
    private Map<String, Long> numberGroupDetailMap = new HashMap<String, Long>();
    private static final String LJ = "LJ";
    private static final String FS = "FS";
    Map<String, Long> orgNumIdMap = new HashMap<String, Long>(8);
    Map<String, String[]> assistNumMap = new HashMap<String, String[]>(8);
    Map<String, Map<String, DataSet>> orgAssistNumDtMap = new HashMap<String, Map<String, DataSet>>(8);
    Map<String, Long> currencyNumToIdMap = new HashMap<String, Long>(8);
    Set<String> currencySet = new HashSet<String>(8);
    Set<String> orgNumSet = new HashSet<String>(8);
    Table<String, String, Map<String, Set<Long>>> comAssistDispersedValIdTable = HashBasedTable.create();
    Table<String, String, Map<String, Set<Long>>> comAssistRangeValIdTable = HashBasedTable.create();
    private static final String BASE_DATA_TYPE = "1";
    private static final String ASSISTANT_DATA_TYPE = "2";

    public String getLinkParam(String formula) {
        JSONObject resultJson = new JSONObject();
        HashMap<String, String> errorInfoMap = new HashMap<String, String>();
        long beforeTime = System.currentTimeMillis();
        log.info("start query cashflow\uff1a" + beforeTime);
        log.info("cashflow param\uff1a" + formula);
        if (StringUtils.isBlank((CharSequence)formula)) {
            log.info("This formula is empty : " + formula);
            return ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"CashFolwItemServiceImplHelper_0", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        ArrayList<String> errorFormula = new ArrayList<String>();
        HashMap<String, String> errorMessageMap = new HashMap<String, String>(8);
        ArrayList<String> params = new ArrayList<String>(8);
        long onlyFlag = DB.genGlobalLongId();
        formula = formula.replace(" ", "");
        Map acctMap = null;
        try {
            acctMap = (Map)JSONUtils.cast((String)formula, Map.class);
            Map comParam = (Map)acctMap.get("commParam");
            int fy = (Integer)comParam.get("fy");
            String orgNumber = (String)comParam.get("org");
            String adjustPeriod = "";
            int period = 0;
            if (comParam.get("period") instanceof String) {
                adjustPeriod = (String)comParam.get("period");
            } else {
                period = (Integer)comParam.get("period");
            }
            String comDimensionStrFormBCM = AcctUtil.getComAssistFromBCM(acctMap);
            Map acctFormulas = (Map)acctMap.get("param");
            HashMap<String, Map<String, Long>> assistNumValNumMap = new HashMap<String, Map<String, Long>>();
            HashMap<String, Set> keyFormulaInfosMap = new HashMap<String, Set>();
            HashMap<String, Map<String, Set<Long>>> orgCashNumIdsMap = new HashMap<String, Map<String, Set<Long>>>();
            HashMap<String, Map<String, Map<String, Set<Long>>>> orgAssistMap = new HashMap<String, Map<String, Map<String, Set<Long>>>>();
            HashMap<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMap = new HashMap<String, Map<String, Map<String, Map<String, Set<String>>>>>();
            HashBasedTable orgComAssistNumTable = HashBasedTable.create();
            HashMap<String, Long> comAssistStandardMap = new HashMap<String, Long>(8);
            HashMap<String, DataSet> comAssistGroupMap = new HashMap<String, DataSet>(8);
            AccountBookInfo defbook = this.getMainBook(orgNumber);
            String mainBookNumber = defbook == null ? this.getMainBookType() : defbook.getBookTypeNum();
            HashSet<String> orgNumberSet = new HashSet<String>(8);
            for (Map.Entry formulaEntry : acctFormulas.entrySet()) {
                List formulaParam = (List)formulaEntry.getValue();
                orgNumberSet.add(StringUtils.isEmpty((CharSequence)((CharSequence)formulaParam.get(0))) ? orgNumber : (String)formulaParam.get(0));
            }
            Map<String, Long> orgNumIdMap = AcctUtil.getOrgNumIdMap(orgNumberSet);
            HashBasedTable accountBookCache = HashBasedTable.create();
            if (Objects.nonNull(defbook)) {
                accountBookCache.put((Object)orgNumber, (Object)defbook.getBookTypeNum(), (Object)defbook);
            }
            Map<Long, Set<Integer>> periodTypeToYearNumMap = this.getPeriodTypeToYearNum(orgNumber, fy, defbook, (Table<String, String, AccountBookInfo>)accountBookCache, acctFormulas);
            Table<Long, String, List<String>> periodTypeToYearNumTable = AcctUtil.queryPeriodFromYear(periodTypeToYearNumMap);
            HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCTCF);
            String permName = InterfacePermissionService.getPermName(PermissionType.ACCTCF);
            for (Map.Entry entry : acctFormulas.entrySet()) {
                String bookTypeNum;
                String orgNum;
                StringBuilder keySb = new StringBuilder();
                String formulaId = (String)entry.getKey();
                List formulaList = (List)entry.getValue();
                String string = orgNum = StringUtils.isBlank((CharSequence)((CharSequence)formulaList.get(0))) ? orgNumber : (String)formulaList.get(0);
                if (StringUtils.isBlank((CharSequence)orgNum) || !orgNumIdMap.containsKey(orgNum)) {
                    errorFormula.add(formulaId);
                    log.info("this formula org is empty : " + formulaId);
                    errorMessageMap.put(this.buildFormula(formulaList), ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u5b58\u5728\u3002", (String)"CashFolwItemServiceImplHelper_18", (String)"fi-gl-mservice", (Object[])new Object[]{orgNum}));
                    continue;
                }
                String errorMsg = AcctUtil.checkPermByOrgId(orgNum, permName, orgNumIdMap.get(orgNum), permOrgResult);
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    errorInfoMap.put(formulaId, errorMsg);
                    errorFormula.add(formulaId);
                    errorMessageMap.put(this.buildFormula(formulaList), errorMsg);
                    continue;
                }
                this.orgNumSet.add(orgNum);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)formulaList.get(1)))) {
                    bookTypeNum = mainBookNumber;
                } else {
                    bookTypeNum = (String)formulaList.get(1);
                    log.info("This bookTypeNum book is: " + bookTypeNum);
                }
                String acctStr = (String)formulaList.get(2);
                String calType = (String)formulaList.get(3);
                if (StringUtils.isEmpty((CharSequence)calType) || !LJ.equals(calType) && !FS.equals(calType)) {
                    String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef\u3002\u8bf7\u8bbe\u7f6e\u4e3a'LJ'\u6216\u8005'FS'\u3002", (String)"CashFolwItemServiceImplHelper_3", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    errorInfoMap.put(formulaId, mess);
                    errorFormula.add(formulaId);
                    errorMessageMap.put(this.buildFormula(formulaList), mess);
                    continue;
                }
                String currencyNum = (String)formulaList.get(6);
                this.currencySet.add(currencyNum);
                String periodNum = AcctUtil.getPeriodParam((String)formulaList.get(5));
                int yearNum = 0;
                List scopePeriod = (List)comParam.get("scopePeriod");
                if (StringUtils.isNotBlank((CharSequence)periodNum) && !"0".equals(periodNum) || scopePeriod == null || scopePeriod.isEmpty()) {
                    AccountBookInfo book = null;
                    if (Objects.nonNull(accountBookCache.get((Object)orgNum, (Object)bookTypeNum))) {
                        book = (AccountBookInfo)accountBookCache.get((Object)orgNum, (Object)bookTypeNum);
                    } else {
                        book = new AccountBookInfo(orgNum, bookTypeNum);
                        accountBookCache.put((Object)orgNum, (Object)bookTypeNum, (Object)book);
                    }
                    HashMap<String, List<String>> periodNumberFromYearMap = new HashMap();
                    if (Objects.nonNull(book)) {
                        periodNumberFromYearMap = periodTypeToYearNumTable.row((Object)book.getPeriodTypeId());
                    }
                    if (!AcctUtil.checkPeriodFormat(periodNum)) {
                        String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashFolwItemServiceImplHelper_19", (String)"fi-gl-mservice", (Object[])new Object[0]);
                        errorInfoMap.put(formulaId, mess);
                        errorFormula.add(formulaId);
                        errorMessageMap.put(this.buildFormula(formulaList), mess);
                        continue;
                    }
                    String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(periodNum, period, adjustPeriod, (String)formulaList.get(4), fy, periodNumberFromYearMap);
                    String[] yearAndPeriod = yearAndPeriodKey.split("-");
                    if (yearAndPeriod.length == 2) {
                        yearNum = Integer.parseInt(yearAndPeriod[0]);
                        periodNum = yearAndPeriod[1];
                    }
                } else {
                    errorMessageMap.put(this.buildFormula(formulaList), ResManager.loadKDString((String)"ACCTCF\u516c\u5f0f\u4e0d\u652f\u6301\u671f\u95f4\u6bb5\u8054\u67e5\u3002", (String)"CashFolwItemServiceImplHelper_2", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    errorFormula.add(formulaId);
                    continue;
                }
                keySb.append(orgNum).append("@");
                keySb.append(bookTypeNum).append("@");
                keySb.append(yearNum).append("@").append(periodNum);
                if (!periodNum.endsWith("T") && Integer.parseInt(periodNum) <= 0) {
                    String mess = ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74\u3002", (String)"CashFolwItemServiceImplHelper_4", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    errorInfoMap.put(formulaId, mess);
                    errorFormula.add(formulaId);
                    errorMessageMap.put(this.buildFormula(formulaList), mess);
                    continue;
                }
                Map<String, Set<String>> comAssistKeyToNumMap = this.getComAssistNum(comDimensionStrFormBCM, formulaList, (Table<String, String, Map<String, Set<String>>>)orgComAssistNumTable, orgNum, bookTypeNum, errorInfoMap, formulaId);
                String key = keySb.toString();
                FormulaInfo info = new FormulaInfo(formulaList, key, formulaId, comAssistKeyToNumMap);
                Set infos = keyFormulaInfosMap.computeIfAbsent(key, e -> new HashSet());
                infos.add(info);
                String[] acctStrs = acctStr.split("\\|");
                Map assistNumAndValNumIdMap = orgAssistMap.computeIfAbsent(orgNum, e -> new HashMap());
                Map valNumIdMap = null;
                Map groupNumAndGroupIdMap = orgAssistGroupMap.computeIfAbsent(orgNum, e -> new HashMap());
                Map groupIdMap = null;
                for (int i = 0; i < acctStrs.length; ++i) {
                    String[] groups;
                    if (i == 0) {
                        String itemNum = acctStrs[0];
                        if (StringUtils.isEmpty((CharSequence)itemNum)) continue;
                        Map cashNumIdsMap = orgCashNumIdsMap.computeIfAbsent(orgNum, e -> new HashMap());
                        cashNumIdsMap.computeIfAbsent(itemNum, e -> new HashSet());
                        continue;
                    }
                    if (i % 2 != 0) {
                        if (StringUtils.isEmpty((CharSequence)acctStrs[i])) continue;
                        assistNumValNumMap.put(acctStrs[i], new HashMap());
                        valNumIdMap = assistNumAndValNumIdMap.computeIfAbsent(acctStrs[i], e -> new HashMap());
                        groupIdMap = groupNumAndGroupIdMap.computeIfAbsent(acctStrs[i], e -> new HashMap());
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)acctStrs[i])) continue;
                    boolean isNoCategory = ReClassUtils.isCollectionNumber(acctStrs[i]);
                    if (!isNoCategory) {
                        String[] assgrps = acctStrs[i].split(",");
                        if (valNumIdMap == null) continue;
                        HashSet<Long> valIds = new HashSet<Long>(8);
                        valIds.add(0L);
                        for (String string2 : assgrps) {
                            valNumIdMap.put(string2, valIds);
                        }
                        continue;
                    }
                    String[] valueStrings = acctStrs[i].split("#");
                    String groupStandard = valueStrings[0];
                    String groupString = valueStrings[1];
                    if (groupIdMap == null) continue;
                    Map groupMap = groupIdMap.computeIfAbsent(groupStandard, e -> new HashMap());
                    for (String group : groups = groupString.split(",")) {
                        groupMap.put(group, new HashSet());
                    }
                }
            }
            orgNumIdMap = this.getOrgNumIdMap(orgCashNumIdsMap);
            if (orgNumIdMap.isEmpty()) {
                log.info("this formula org not find");
                resultJson.put("pageParam", params);
                resultJson.put("error", errorMessageMap);
                return resultJson.toJSONString();
            }
            Map<String, String[]> assistNumMap = this.getAssistNumMap(assistNumValNumMap);
            HashMap<String, Integer> itemLevelMap = new HashMap<String, Integer>(8);
            this.setOrgCashNumIdsMapId(orgNumIdMap, orgCashNumIdsMap, itemLevelMap);
            Map<String, Map<String, DataSet>> orgAssistNumDtMap = this.getOrgAssistNumDtMap(orgAssistMap, orgNumIdMap, assistNumMap);
            this.setOrgAssistMapByGroup(orgAssistGroupMap, orgAssistMap, assistNumMap);
            Map<String, Long> bookTypeNumToIdMap = this.queryBookTypeNumToId(orgComAssistNumTable.columnKeySet());
            Table<String, String, Set<Long>> orgAndBookTypeToIdTable = this.getOrgAndBookTypeToAccountTableId(orgNumIdMap, bookTypeNumToIdMap, (Table<String, String, Map<String, Set<String>>>)orgComAssistNumTable);
            HashSet<Long> allAccountTableIdSet = new HashSet<Long>(8);
            orgAndBookTypeToIdTable.values().forEach(allAccountTableIdSet::addAll);
            Table<Long, String, String> accountTableToValSourceTable = this.getAccountTableToValSourceTable(allAccountTableIdSet);
            this.setComAssistId((Table<String, String, Map<String, Set<String>>>)orgComAssistNumTable, orgNumIdMap, comAssistStandardMap, comAssistGroupMap, orgAndBookTypeToIdTable, accountTableToValSourceTable);
            CashFlowQueryExecutor cashFlowQueryExecutor = CashFlowQueryExecutor.getInstance();
            StringBuilder selectedFiles = new StringBuilder();
            selectedFiles.append(cfitem).append(',').append(assgrp).append(',').append(yearAmount).append(',').append(amount);
            for (Map.Entry entry : keyFormulaInfosMap.entrySet()) {
                String key = (String)entry.getKey();
                String[] keysplits = key.split("@");
                String orgNum = keysplits[0];
                String booktypeNum = keysplits[1];
                AccountBookInfo book = new AccountBookInfo(orgNum, booktypeNum);
                Map assistNumAndValNumIdMap = (Map)orgAssistMap.get(orgNum);
                long periodId = this.getPeriodId(Integer.parseInt(keysplits[2]), keysplits[3], book.getPeriodTypeId());
                if (periodId == 0L) {
                    ((Set)entry.getValue()).forEach(formulaInfo -> errorMessageMap.put(this.buildFormula(formulaInfo.getFormulaStr()), ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CashFolwItemServiceImplHelper_14", (String)"fi-gl-mservice", (Object[])new Object[0])));
                    continue;
                }
                if (periodId < book.getStartPeriodId()) {
                    ((Set)entry.getValue()).forEach(formulaInfo -> errorMessageMap.put(this.buildFormula(formulaInfo.getFormulaStr()), ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u671f\u95f4\u4e0d\u5f97\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"CashFolwItemServiceImplHelper_15", (String)"fi-gl-mservice", (Object[])new Object[0])));
                    continue;
                }
                long orgId = orgNumIdMap.get(orgNum);
                long bookTypeId = bookTypeNumToIdMap.get(booktypeNum) == null ? 0L : bookTypeNumToIdMap.get(booktypeNum);
                long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
                Map comAssistKeyToValSourceMap = accountTableToValSourceTable.row((Object)accountTableId);
                Set comAssistKeySet = comAssistKeyToValSourceMap.keySet();
                StringBuilder curSelectFields = new StringBuilder();
                curSelectFields.append((CharSequence)selectedFiles);
                for (String comAssistKey : comAssistKeySet) {
                    curSelectFields.append(",").append(comAssistKey);
                }
                DataSet cashSet = this.getCashJoinAssistSet(cashFlowQueryExecutor, curSelectFields.toString(), book, periodId, orgCashNumIdsMap, orgAssistNumDtMap, orgAssistMap, orgNum);
                this.dumpDataSet(onlyFlag, cashSet.copy(), key);
                for (FormulaInfo formulaInfo2 : (Set)entry.getValue()) {
                    String calType = formulaInfo2.getCalType();
                    if (!LJ.equals(calType) && !FS.equals(calType)) {
                        errorMessageMap.put(this.buildFormula(formulaInfo2.getFormulaStr()), ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"CashFolwItemServiceImplHelper_16", (String)"fi-gl-mservice", (Object[])new Object[0]));
                        continue;
                    }
                    Tuple2<Boolean, List<String>> tuple = this.getFormulaListFilters(formulaInfo2, (Map)orgCashNumIdsMap.get(orgNum), assistNumMap, assistNumAndValNumIdMap, errorInfoMap, (Map)orgAssistGroupMap.get(orgNum), errorMessageMap);
                    if (((Boolean)tuple.t1).booleanValue()) continue;
                    Set mainViewIds = AccSysUtil.getViewByOrg((Long)orgNumIdMap.get(orgNum));
                    Long defaultViewId = 0L;
                    if (mainViewIds.size() > 0) {
                        defaultViewId = (Long)mainViewIds.iterator().next();
                    }
                    QFilter accLevelFilter = new QFilter("accounttable_id", "=", (Object)book.getAccountTableId());
                    DynamicObjectCollection levelCollection = QueryServiceHelper.query((String)"bd_accountview", (String)"level", (QFilter[])new QFilter[]{accLevelFilter}, (String)"level desc");
                    int accLevel = levelCollection.isEmpty() ? 1 : ((DynamicObject)levelCollection.get(0)).getInt("level");
                    ((Map)orgCashNumIdsMap.get(orgNum)).get(formulaInfo2.getCashItemNum());
                    log.info("query account level size : " + levelCollection.size());
                    ReportShowParameter formShowParameter = new ReportShowParameter();
                    FilterInfo filter = new FilterInfo();
                    if (!formulaInfo2.getAssistNumValsMap().isEmpty()) {
                        ArrayList<FilterItemInfo> filterItems = new ArrayList<FilterItemInfo>(8);
                        filter.addFilterItem("showassist", (Object)true);
                        for (Map.Entry<String, Set<Object>> entry2 : formulaInfo2.getAssistNumValsMap().entrySet()) {
                            String assistNum = entry2.getKey();
                            Set<Object> valueNumSet = entry2.getValue();
                            if (valueNumSet.contains("None")) continue;
                            String[] assistFlexAndType = assistNumMap.get(assistNum);
                            String flexFiled = assistFlexAndType[0];
                            HashSet assistVal = new HashSet(8);
                            for (String string : valueNumSet) {
                                Map assistMap = (Map)assistNumAndValNumIdMap.get(assistNum);
                                if (assistMap == null || assistMap.get(string) == null) continue;
                                assistVal.addAll((Collection)assistMap.get(string));
                            }
                            filterItems.add(new FilterItemInfo(flexFiled, assistVal, "in"));
                        }
                        filter.setFlexFilterItems(filterItems);
                    }
                    Map<String, Set<Long>> commonAssistFilterMap = this.getCommonAssistFilter(formulaInfo2, comAssistKeyToValSourceMap);
                    for (Map.Entry<String, Set<Long>> entry3 : commonAssistFilterMap.entrySet()) {
                        filter.addFilterItem(entry3.getKey(), entry3.getValue());
                    }
                    filter.addFilterItem("org", (Object)orgNumIdMap.get(orgNum));
                    filter.addFilterItem("booktype", (Object)book.getBookTypeId());
                    filter.addFilterItem("periodtype", (Object)book.getPeriodTypeId());
                    filter.addFilterItem("startperiod", (Object)periodId);
                    filter.addFilterItem("endperiod", (Object)periodId);
                    filter.addFilterItem("itemlevel", itemLevelMap.get(orgNum));
                    filter.addFilterItem("accounttable", (Object)book.getAccountTableId());
                    filter.addFilterItem("orgview", (Object)defaultViewId);
                    filter.addFilterItem("accountlevel", (Object)accLevel);
                    filter.addFilterItem("currency", (Object)book.getBaseCurrencyId());
                    if (!formulaInfo2.getComAssistKeyToNumMap().isEmpty()) {
                        filter.addFilterItem("showcomassist", (Object)true);
                    }
                    ReportQueryParam queryParam = new ReportQueryParam();
                    queryParam.setFilter(filter);
                    OpenStyle openStyle = new OpenStyle();
                    openStyle.setShowType(ShowType.MainNewTabPage);
                    formShowParameter.setOpenStyle(openStyle);
                    formShowParameter.setFormId("gl_rpt_cashflow");
                    formShowParameter.setQueryParam(queryParam);
                    formShowParameter.setCustomParam("accounttable", (Object)String.valueOf(book.getAccountTableId()));
                    params.add(ReportShowParameter.toJsonString((FormShowParameter)formShowParameter));
                }
            }
        }
        catch (IOException e2) {
            log.error("get cashflow report exception: " + e2.getMessage(), (Throwable)e2);
            resultJson.put("pageParam", params);
            resultJson.put("error", errorMessageMap);
            this.printErrorMessageLog(errorInfoMap);
            return resultJson.toJSONString();
        }
        resultJson.put("pageParam", params);
        resultJson.put("error", errorMessageMap);
        log.info("this query result pageParam size : " + params.size() + "thses formulas don't meet query criteria : " + JSON.toJSON(errorFormula));
        this.printErrorMessageLog(errorInfoMap);
        return resultJson.toJSONString();
    }

    private Tuple2<Boolean, List<String>> getFormulaListFilters(FormulaInfo info, Map<String, Set<Long>> cashNumIdsMap, Map<String, String[]> assistNumMap, Map<String, Map<String, Set<Long>>> assistNumAndValNumIdMap, Map<String, String> errorInfoMap, Map<String, Map<String, Map<String, Set<String>>>> assistGroupIdMap, Map<String, String> errorMessageMap) {
        String assistNum;
        ArrayList<String> filters = new ArrayList<String>();
        StringBuilder filtersb = new StringBuilder();
        boolean continueFlag = false;
        Set<Long> curCashItemIds = cashNumIdsMap.get(info.getCashItemNum());
        if (curCashItemIds.isEmpty()) {
            continueFlag = true;
            String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CashFolwItemServiceImplHelper_5", (String)"fi-gl-mservice", (Object[])new Object[0]);
            errorInfoMap.put(info.getFormulaId(), mess);
            errorMessageMap.put(this.buildFormula(info.getFormulaStr()), mess);
        } else {
            filtersb.append(cfitem).append(" in (");
            int i = 0;
            for (Long l : curCashItemIds) {
                if (i++ != 0) {
                    filtersb.append(',');
                }
                filtersb.append(l);
            }
            filtersb.append(")");
        }
        filters.add(filtersb.toString());
        HashSet<String> groupEmptyMemberToAssistSet = new HashSet<String>();
        for (Map.Entry entry : info.getGroupValsMap().entrySet()) {
            assistNum = (String)entry.getKey();
            Map groupStandardToGroupMap = (Map)entry.getValue();
            for (Map.Entry groupStandardToGroupMapEntry : groupStandardToGroupMap.entrySet()) {
                String groupStandardNum = (String)groupStandardToGroupMapEntry.getKey();
                Set groupNumMap = (Set)groupStandardToGroupMapEntry.getValue();
                for (String groupNum : groupNumMap) {
                    Set<String> assistNumSet = assistGroupIdMap.get(assistNum).get(groupStandardNum).get(groupNum);
                    if (assistNumSet.isEmpty()) {
                        groupEmptyMemberToAssistSet.add(assistNum);
                        String mss = ResManager.loadKDString((String)"\u516c\u5f0f\u7684%s\u5206\u7c7b\uff0c\u4e0d\u5b58\u5728\u6838\u7b97\u7ef4\u5ea6\u6210\u5458", (String)"CashflowServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[]{groupNum});
                        errorInfoMap.put(info.getFormulaId(), mss);
                        errorMessageMap.put(this.buildFormula(info.getFormulaStr()), mss);
                        continue;
                    }
                    info.getAssistNumValsMap().get(assistNum).addAll(assistNumSet);
                }
            }
        }
        for (Map.Entry entry : info.getAssistNumValsMap().entrySet()) {
            assistNum = (String)entry.getKey();
            String[] assistInfo = assistNumMap.get(assistNum);
            if (assistInfo == null) {
                continueFlag = true;
                String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u7684%s\u4e0d\u5b58\u5728", (String)"CashFolwItemServiceImplHelper_6", (String)"fi-gl-mservice", (Object[])new Object[]{assistNum});
                errorInfoMap.put(info.getFormulaId(), mess);
                errorMessageMap.put(this.buildFormula(info.getFormulaStr()), mess);
                continue;
            }
            Map<String, Set<Long>> valNumIdMap = assistNumAndValNumIdMap.get(assistNum);
            Set valNums = (Set)entry.getValue();
            int i = 0;
            StringBuilder filterStr = new StringBuilder();
            for (String valNum : valNums) {
                Set<Long> valId = valNumIdMap.get(valNum);
                if (valId == null) {
                    continueFlag = true;
                    String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u7684%1$s\u7684%2$s\u4e0d\u5b58\u5728", (String)"CashFolwItemServiceImplHelper_8", (String)"fi-gl-mservice", (Object[])new Object[]{assistNum, valNum});
                    errorInfoMap.put(info.getFormulaId(), mess);
                    errorMessageMap.put(this.buildFormula(info.getFormulaStr()), mess);
                    continue;
                }
                if (i++ != 0) {
                    filterStr.append(',');
                }
                filterStr.append(valId.toString().substring(1, valId.toString().length() - 1));
            }
            if (groupEmptyMemberToAssistSet.contains(assistNum)) {
                if (i++ != 0) {
                    filterStr.append(',');
                }
                filterStr.append(0);
            }
            if (filterStr.length() != 0) {
                String filterS = filterStr.toString();
                filters.add(assistInfo[0] + " in (" + filterS + ")");
                continue;
            }
            filters.add(assistInfo[0] + " <> 0");
        }
        return new Tuple2((Object)continueFlag, filters);
    }

    private String getMainBookType() {
        QFilter ftype = new QFilter("accounttype", "=", (Object)BASE_DATA_TYPE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "number", filters);
        return ((Row)bookTypeSet.iterator().next()).getString("number");
    }

    private void dumpDataSet(long onlyFlag, DataSet ds, String key) {
        int cols = ds.getRowMeta().getFieldCount();
        StringBuilder cashFlowLog = new StringBuilder();
        cashFlowLog.append(ResManager.loadKDString((String)"\u552f\u4e00\u6807\u8bc6\uff1a%1$sacctcf\u73b0\u91d1\u6d41\u91cf\u6570\u636e\uff1akey\u503c%2$s;%3$s\u5217;", (String)"CashFolwItemServiceImplHelper_11", (String)"fi-gl-mservice", (Object[])new Object[]{onlyFlag, key, cols}));
        for (int i = 0; i < cols; ++i) {
            cashFlowLog.append(ds.getRowMeta().getFieldAlias(i));
            cashFlowLog.append(",");
        }
        cashFlowLog.deleteCharAt(cashFlowLog.length() - 1);
        cashFlowLog.append(";");
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                cashFlowLog.append(obj);
                cashFlowLog.append(',');
            }
            cashFlowLog.deleteCharAt(cashFlowLog.length() - 1);
            cashFlowLog.append("/t");
        }
        log.info(cashFlowLog.toString());
    }

    private DataSet getCashJoinAssistSet(CashFlowQueryExecutor cashFlowQueryExecutor, String select, AccountBookInfo book, long periodId, Map<String, Map<String, Set<Long>>> orgCashNumIdsMap, Map<String, Map<String, DataSet>> orgAssistNumDtMap, Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, String orgNum) {
        Map<String, Set<Long>> cashNumIdsMap = orgCashNumIdsMap.get(orgNum);
        HashSet itemIds = new HashSet();
        for (Map.Entry<String, Set<Long>> cashNumIdsMapentry : cashNumIdsMap.entrySet()) {
            itemIds.addAll(cashNumIdsMapentry.getValue());
        }
        DataSet cashSet = cashFlowQueryExecutor.getCashFlow(this.getClass().getName(), select, new long[]{book.getOrgId()}, book.getBookTypeId(), periodId, periodId, new QFilter(cfitem, "in", itemIds).toArray());
        Map<String, DataSet> assistNumDtMap = orgAssistNumDtMap.get(orgNum);
        for (Map.Entry<String, DataSet> dtEntry : assistNumDtMap.entrySet()) {
            DataSet dt = dtEntry.getValue();
            List<String> dtFields = GLServiceUtils.getFieldsByDs(dt);
            dtFields.remove(0);
            cashSet = cashSet.leftJoin(dt).on(assgrp, "hg").select(GLServiceUtils.getFieldsByDs(cashSet).toArray(new String[0]), dtFields.toArray(new String[0])).finish();
        }
        return cashSet;
    }

    private Long getPeriodId(int year, String periodNum, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "=", (Object)year);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        if (StringUtils.isNotBlank((CharSequence)periodNum)) {
            QFilter fperiod;
            if (periodNum.endsWith("T")) {
                fperiod = new QFilter("periodnumber", "=", (Object)Integer.parseInt(periodNum.substring(0, periodNum.length() - 1)));
                filters.add(fperiod);
            } else {
                fperiod = new QFilter("periodnumber", "=", (Object)Integer.parseInt(periodNum));
                filters.add(fperiod);
            }
        }
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"periodyear, periodnumber, id, isadjustperiod", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashMap<String, Long> periodIdsMap = new HashMap<String, Long>(8);
        for (Row row : periodSet) {
            int periodNumber = row.getInteger("periodnumber");
            if (periodNumber >= 13) {
                periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
                periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
                continue;
            }
            if (row.getBoolean("isadjustperiod").booleanValue()) {
                periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
                continue;
            }
            periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
        }
        if (periodIdsMap.isEmpty()) {
            return 0L;
        }
        long periodId = periodIdsMap.get(year + "," + periodNum) == null ? 0L : (Long)periodIdsMap.get(year + "," + periodNum);
        return periodId;
    }

    private String getDataSetFilterstr(List<String> filters) {
        StringBuilder sb = new StringBuilder();
        for (String filter : filters) {
            if (sb.length() != 0) {
                sb.append(" and ");
            }
            sb.append(filter);
        }
        return sb.toString();
    }

    public int dealPeriod(String periodStr, int comPeriod) {
        String string = periodStr = StringUtils.isBlank((CharSequence)periodStr) ? "0" : periodStr;
        if (periodStr == null) {
            return 0;
        }
        int period = Integer.parseInt(periodStr);
        if (period <= 0) {
            period += comPeriod;
        }
        return period;
    }

    public int dealYear(String yearStr, int comFy, int period) {
        int year = Integer.parseInt(yearStr = StringUtils.isBlank((CharSequence)yearStr) ? "0" : yearStr);
        if (year <= 1000) {
            year += comFy;
        }
        if (period > -12 && period <= 0) {
            --year;
        }
        return year;
    }

    private void setOrgAssistMapByGroup(Map<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMap, Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, Map<String, String[]> assistNumMap) {
        HashMap<String, Long> groupStandardIdMap = new HashMap<String, Long>();
        HashMap groupStandardToGroupIdMap = new HashMap();
        HashMap<Long, Set> groupToAssistMemberNumMap = new HashMap<Long, Set>();
        for (Map.Entry<String, Map<String, Map<String, Map<String, Set<String>>>>> orgAssistGroupMapEntry : orgAssistGroupMap.entrySet()) {
            String orgId = orgAssistGroupMapEntry.getKey();
            Map<String, Map<String, Map<String, Set<String>>>> assistGroupMap = orgAssistGroupMapEntry.getValue();
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> assistGroupMapEntry : assistGroupMap.entrySet()) {
                String assistNum = assistGroupMapEntry.getKey();
                String[] assistNumAndSource = assistNumMap.get(assistNum);
                if (assistNumAndSource == null) continue;
                String entityId = assistNumAndSource[1];
                Map<String, Map<String, Set<String>>> groupStandardToGroupMap = assistGroupMapEntry.getValue();
                for (Map.Entry<String, Map<String, Set<String>>> groupStandardToGroupMapEntry : groupStandardToGroupMap.entrySet()) {
                    String groupStandardNum = groupStandardToGroupMapEntry.getKey();
                    if (groupStandardIdMap.get(entityId + "_" + groupStandardNum) == null) {
                        DataSet groupStandardDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(entityId + "groupstandard"), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupStandardNum)}, null);
                        for (Row row : groupStandardDataSet) {
                            groupStandardIdMap.put(entityId + "_" + groupStandardNum, row.getLong("id"));
                        }
                    }
                    if (groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum) == null) {
                        Long groupStandardId = (Long)groupStandardIdMap.get(entityId + "_" + groupStandardNum);
                        QFilter groupStandardQF = new QFilter("standard", "in", (Object)groupStandardId);
                        QFilter groupNumsQF = new QFilter("number", "in", groupStandardToGroupMapEntry.getValue().keySet());
                        DataSet assistDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(entityId + "group"), (String)"id,number", (QFilter[])new QFilter[]{groupStandardQF, groupNumsQF}, null);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (Row row : assistDataSet) {
                            hashMap.put(row.getString("number"), row.getLong("id"));
                        }
                        groupStandardToGroupIdMap.put(entityId + "_" + groupStandardNum, hashMap);
                    }
                    HashSet groupIdSet = new HashSet(((Map)groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum)).values());
                    String selectProperties = entityId.substring(3) + ".number,group.id";
                    DynamicObject[] assistMembers = BusinessDataServiceHelper.load((String)(entityId + "groupdetail"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("group.id", "in", groupIdSet)});
                    for (DynamicObject assistMember : assistMembers) {
                        long groupId = assistMember.getLong("group.id");
                        String assistMemberNum = assistMember.getString(entityId.substring(3) + ".number");
                        HashSet<Long> valIds = new HashSet<Long>(8);
                        valIds.add(0L);
                        orgAssistMap.get(orgId).get(assistNum).put(assistMemberNum, valIds);
                        Set assistMemberNumSet = groupToAssistMemberNumMap.computeIfAbsent(groupId, e -> new HashSet());
                        assistMemberNumSet.add(assistMemberNum);
                    }
                    for (Map.Entry entry : groupStandardToGroupMapEntry.getValue().entrySet()) {
                        String groupNum = (String)entry.getKey();
                        Long groupId = (Long)((Map)groupStandardToGroupIdMap.get(entityId + "_" + groupStandardNum)).get(groupNum);
                        ((Set)entry.getValue()).addAll(groupToAssistMemberNumMap.get(groupId) == null ? new HashSet() : (Collection)groupToAssistMemberNumMap.get(groupId));
                    }
                }
            }
        }
    }

    private Map<String, Long> getOrgNumIdMap(Map<String, Map<String, Set<Long>>> orgCashNumIdsMap) {
        HashMap<String, Long> orgNumIdMap = new HashMap<String, Long>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFBuilder("number", "in", orgCashNumIdsMap.keySet()).toArray(), null);){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                String number = row.getString("number");
                long orgId = row.getLong("id");
                orgNumIdMap.put(number, orgId);
            }
        }
        return orgNumIdMap;
    }

    private void setOrgCashNumIdsMapId(Map<String, Long> orgNumIdMap, Map<String, Map<String, Set<Long>>> orgCashNumIdsMap, Map<String, Integer> itemLevelMap) {
        for (Map.Entry<String, Long> entry : orgNumIdMap.entrySet()) {
            String number = entry.getKey();
            long orgId = entry.getValue();
            Map<String, Set<Long>> cashNumIdsMap = orgCashNumIdsMap.get(number);
            if (cashNumIdsMap == null) continue;
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter[] qfs = new QFilter[]{qids, new QFilter("number", "in", cashNumIdsMap.keySet())};
            DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)"masterid,number,level", (QFilter[])qfs, (String)"level desc");
            Throwable throwable = null;
            try {
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    Set<Long> ids = cashNumIdsMap.get(row.getString("number"));
                    ids.add(row.getLong("masterid"));
                    Integer itemLevel = Integer.valueOf(row.getString("level"));
                    if (itemLevelMap.containsKey(number) && itemLevelMap.get(number) >= itemLevel) continue;
                    itemLevelMap.put(number, itemLevel);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dt == null) continue;
                if (throwable != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dt.close();
            }
        }
    }

    private Map<String, String[]> getAssistNumMap(Map<String, Map<String, Long>> assistNumValNumMap) {
        HashMap<String, String[]> assistNumMap = new HashMap<String, String[]>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"number,valuetype,assistanttype,valuesource,flexfield", (QFilter[])new QFilter("number", "in", assistNumValNumMap.keySet()).toArray(), null, (int)-1);){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                String number = row.getString("number");
                String valType = row.getString("valuetype");
                if (ASSISTANT_DATA_TYPE.equals(valType)) {
                    this.numberGroupDetailMap.put(number, row.getLong("assistanttype"));
                }
                assistNumMap.put(number, new String[]{row.getString("flexfield"), row.getString("valuesource")});
            }
        }
        return assistNumMap;
    }

    private Map<String, Map<String, DataSet>> getOrgAssistNumDtMap(Map<String, Map<String, Map<String, Set<Long>>>> orgAssistMap, Map<String, Long> orgNumIdMap, Map<String, String[]> assistNumMap) {
        HashMap<String, Map<String, DataSet>> orgAssistNumDtMap = new HashMap<String, Map<String, DataSet>>();
        for (Map.Entry<String, Map<String, Map<String, Set<Long>>>> entry : orgAssistMap.entrySet()) {
            String orgNum = entry.getKey();
            Map assistNumDtMap = orgAssistNumDtMap.computeIfAbsent(orgNum, e -> new HashMap());
            Map<String, Map<String, Set<Long>>> assistNumAndValNumIdMap = entry.getValue();
            long orgId = orgNumIdMap.get(orgNum);
            for (Map.Entry<String, Map<String, Set<Long>>> assistNumAndValNumIdMapEntry : assistNumAndValNumIdMap.entrySet()) {
                String assistNum = assistNumAndValNumIdMapEntry.getKey();
                Map<String, Set<Long>> valNumIdMap = assistNumAndValNumIdMapEntry.getValue();
                String[] assistInfo = assistNumMap.get(assistNum);
                if (assistInfo == null) continue;
                String valuesource = assistInfo[1];
                QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)valuesource, (Long)orgId);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
                if (qids != null) {
                    qFilters.add(qids);
                }
                if (this.numberGroupDetailMap.get(assistNum) != null) {
                    long assistantTypeId = this.numberGroupDetailMap.get(assistNum);
                    QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)orgId);
                    if (assistantOrgFilter != null) {
                        qFilters.add(assistantOrgFilter);
                    }
                    qFilters.add(new QFilter("group", "=", (Object)assistantTypeId));
                }
                Map<String, Set<Long>> valNumberDetailMap = this.queryDetailAssist(valuesource, valNumIdMap.keySet(), qFilters, orgId);
                valNumIdMap.putAll(valNumberDetailMap);
                HashSet valIds = new HashSet(8);
                valNumIdMap.values().stream().forEach(c -> valIds.addAll(c));
                assistNumDtMap.put(assistNum, QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)("hg,assval " + assistInfo[0]), (QFilter[])new QFilter[]{new QFilter("asstype", "=", (Object)assistInfo[0]), new QFilter("assval", "in", valIds)}, null));
            }
        }
        return orgAssistNumDtMap;
    }

    private Map<String, Set<Long>> queryDetailAssist(String entityId, Set<String> numbers, List<QFilter> filter, long orgId) {
        MakeBaseDateDetailHelper helper = new MakeBaseDateDetailHelper();
        Map<String, Set<Long>> numberToIdsMap = helper.getDetailAssists(entityId, numbers, filter);
        return numberToIdsMap;
    }

    private AccountBookInfo getMainBook(String comOrgNumber) {
        AccountBookInfo book = null;
        long orgId = 0L;
        if (!StringUtils.isBlank((CharSequence)comOrgNumber)) {
            QFilter filter = new QFilter("number", "=", (Object)comOrgNumber);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(filter);
            try (DataSet querySet = this.queryDataSet("bos_org", "number, id", qFilters);){
                while (querySet.hasNext()) {
                    orgId = querySet.next().getLong("id");
                }
            }
        }
        if (orgId != 0L) {
            QFilter qorg = new QFilter("org", "=", (Object)orgId);
            QFilter qbooktype = new QFilter("bookstype.accounttype", "=", (Object)BASE_DATA_TYPE);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])new QFilter[]{qorg, qbooktype}, null, (int)-1);
            if (!ids.isEmpty()) {
                book = new AccountBookInfo(((Long)ids.get(0)).longValue());
            }
        }
        return book;
    }

    private DataSet queryDataSet(String entityName, String selFields, List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BCMBalanceParamParseUtils.queryDataSet", (String)entityName, (String)selFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return dataSet;
    }

    private void printErrorMessageLog(Map<String, String> errorInfoMap) {
        StringBuilder logSb = new StringBuilder();
        logSb.append("error formula and message : ");
        for (Map.Entry<String, String> errorInfoEntry : errorInfoMap.entrySet()) {
            logSb.append(errorInfoEntry.getKey()).append(":").append(errorInfoEntry.getValue()).append(";");
        }
        log.info(logSb.toString());
    }

    private String buildFormula(List<String> paramFields) {
        StringBuilder formulaStr = new StringBuilder();
        if (CollectionUtils.isNotEmpty(paramFields)) {
            formulaStr.append("acctcf(");
            for (int i = 0; i < paramFields.size(); ++i) {
                if (i == 4 || i == 5) {
                    formulaStr.append(paramFields.get(i)).append(",");
                    continue;
                }
                formulaStr.append("\"").append(paramFields.get(i)).append("\"").append(",");
            }
            return formulaStr.deleteCharAt(formulaStr.length() - 1).append(")").toString();
        }
        return formulaStr.toString();
    }

    private Map<String, Set<Long>> getCommonAssistFilter(FormulaInfo info, Map<String, String> comAssistKeyToValSourceMap) {
        Map<String, Set<String>> comAssistKeyToNumMap = info.getComAssistKeyToNumMap();
        String[] keySplits = info.getKey().split("@");
        String orgNum = keySplits[0];
        HashMap<String, Set<Long>> comAssistFilterMap = new HashMap<String, Set<Long>>(8);
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            Set<String> comAssistValNumSet;
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            String valueSource = comAssistKeyToValSourceMap.get(comAssistKey);
            if (!StringUtils.isNotBlank((CharSequence)valueSource) || !CollectionUtils.isNotEmpty(comAssistValNumSet = comAssistKeyToNumEntry.getValue())) continue;
            for (String comAssistValNum : comAssistValNumSet) {
                Set valueIdSet;
                Set comAssistIdSet;
                Map comAssistIdMap;
                if (AcctUtil.isRangeValueNumber(comAssistValNum)) {
                    comAssistIdMap = (Map)this.comAssistRangeValIdTable.get((Object)orgNum, (Object)valueSource);
                    if (comAssistIdMap == null || comAssistIdMap.isEmpty() || !CollectionUtils.isNotEmpty((Collection)(comAssistIdSet = (Set)comAssistIdMap.get(comAssistValNum)))) continue;
                    valueIdSet = comAssistFilterMap.computeIfAbsent(comAssistKey, k -> new HashSet(8));
                    valueIdSet.addAll(comAssistIdSet);
                    comAssistFilterMap.put(comAssistKey, valueIdSet);
                    continue;
                }
                comAssistIdMap = (Map)this.comAssistDispersedValIdTable.get((Object)orgNum, (Object)valueSource);
                if (comAssistIdMap == null || comAssistIdMap.isEmpty() || !CollectionUtils.isNotEmpty((Collection)(comAssistIdSet = (Set)comAssistIdMap.get(comAssistValNum)))) continue;
                valueIdSet = comAssistFilterMap.computeIfAbsent(comAssistKey, k -> new HashSet(8));
                valueIdSet.addAll(comAssistIdSet);
                comAssistFilterMap.put(comAssistKey, valueIdSet);
            }
        }
        if (DebugTrace.enable()) {
            log.info("CashfolwServiceImplHelper_getCommonAssistFilter comAssistFilterMap:" + comAssistFilterMap);
        }
        return comAssistFilterMap;
    }

    private Map<String, Long> queryBookTypeNumToId(Collection<String> bookTypeNums) {
        HashMap<String, Long> bookTypeNumToIdMap = new HashMap<String, Long>(8);
        DynamicObjectCollection bookTypeDyns = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", bookTypeNums)});
        for (DynamicObject bookTypeDyn : bookTypeDyns) {
            bookTypeNumToIdMap.put(bookTypeDyn.getString("number"), bookTypeDyn.getLong("id"));
        }
        return bookTypeNumToIdMap;
    }

    private Table<String, String, Set<Long>> getOrgAndBookTypeToAccountTableId(Map<String, Long> orgNumIdMap, Map<String, Long> bookTypeNumToIdMap, Table<String, String, Map<String, Set<String>>> orgComAssistNumTable) {
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashMap<Long, String> orgIdToNumMap = new HashMap<Long, String>(8);
        for (String orgNum : orgComAssistNumTable.rowKeySet()) {
            long orgId = orgNumIdMap.get(orgNum);
            orgIdSet.add(orgId);
            orgIdToNumMap.put(orgId, orgNum);
        }
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(bookTypeNumToIdMap.values());
        HashMap<Long, String> bookTypeIdToNumMap = new HashMap<Long, String>(8);
        for (Map.Entry<String, Long> bookTypeNumToIdEntry : bookTypeNumToIdMap.entrySet()) {
            bookTypeIdToNumMap.put(bookTypeNumToIdEntry.getValue(), bookTypeNumToIdEntry.getKey());
        }
        HashBasedTable orgAndBookTypeToIdTable = HashBasedTable.create();
        ArrayList<QFilter> accountBookFilterList = new ArrayList<QFilter>(8);
        accountBookFilterList.add(new QFilter("org", "in", orgIdSet));
        accountBookFilterList.add(new QFilter("bookstype", "in", bookTypeIdSet));
        DynamicObjectCollection accountBookDyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, bookstype, accounttable", (QFilter[])accountBookFilterList.toArray(new QFilter[0]));
        for (DynamicObject accountBookDyn : accountBookDyns) {
            String bookTypeNum;
            String orgNum = (String)orgIdToNumMap.get(accountBookDyn.getLong("org"));
            HashSet<Long> accountTableIdSet = (HashSet<Long>)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)bookTypeIdToNumMap.get(accountBookDyn.getLong("bookstype"))));
            if (accountTableIdSet != null) {
                accountTableIdSet.add(accountBookDyn.getLong("accounttable"));
                continue;
            }
            accountTableIdSet = new HashSet<Long>(8);
            accountTableIdSet.add(accountBookDyn.getLong("accounttable"));
            orgAndBookTypeToIdTable.put((Object)orgNum, (Object)bookTypeNum, accountTableIdSet);
        }
        ArrayList<QFilter> bookVersionFilterList = new ArrayList<QFilter>(8);
        bookVersionFilterList.add(new QFilter("org", "in", orgIdSet));
        bookVersionFilterList.add(new QFilter("booktype", "in", bookTypeIdSet));
        DynamicObjectCollection bookVersionDyns = QueryServiceHelper.query((String)"gl_book_version", (String)"org, booktype, accounttable", (QFilter[])bookVersionFilterList.toArray(new QFilter[0]));
        for (DynamicObject bookVersionDyn : bookVersionDyns) {
            String bookTypeNum;
            String orgNum = (String)orgIdToNumMap.get(bookVersionDyn.getLong("org"));
            HashSet<Long> accountTableIdSet = (HashSet<Long>)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)bookTypeIdToNumMap.get(bookVersionDyn.getLong("booktype"))));
            if (accountTableIdSet != null) {
                accountTableIdSet.add(bookVersionDyn.getLong("accounttable"));
                continue;
            }
            accountTableIdSet = new HashSet<Long>(8);
            accountTableIdSet.add(bookVersionDyn.getLong("accounttable"));
            orgAndBookTypeToIdTable.put((Object)orgNum, (Object)bookTypeNum, accountTableIdSet);
        }
        return orgAndBookTypeToIdTable;
    }

    private Table<Long, String, String> getAccountTableToValSourceTable(Collection<Long> accountTableIdSet) {
        DynamicObjectCollection accountTableDyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"id, comassistentry.seq seq, comassistentry.valuesourcetype valuesourcetype, comassistentry.valuesource valuesource, comassistentry.assistantvaluesource.id assistantvaluesource.id", (QFilter[])new QFilter[]{new QFilter("id", "in", accountTableIdSet)});
        HashBasedTable comAssistValSourceTable = HashBasedTable.create();
        for (DynamicObject accountTableDyn : accountTableDyns) {
            if (accountTableDyn == null) continue;
            String comAssistKey = CommonAssistUtil.getComassistField((int)accountTableDyn.getInt("seq"));
            String valueSourceType = accountTableDyn.getString("valuesourcetype");
            long accountTableId = accountTableDyn.getLong("id");
            String entityId = "";
            if (BASE_DATA_TYPE.equals(valueSourceType)) {
                entityId = accountTableDyn.getString("valuesource");
            } else if (ASSISTANT_DATA_TYPE.equals(valueSourceType)) {
                entityId = "bos_assistantdata_detail_" + accountTableDyn.getLong("assistantvaluesource.id");
            }
            if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
            comAssistValSourceTable.put((Object)accountTableId, (Object)comAssistKey, (Object)entityId);
        }
        return comAssistValSourceTable;
    }

    private void setComAssistId(Table<String, String, Map<String, Set<String>>> orgComAssistNumTable, Map<String, Long> orgNumIdMap, Map<String, Long> standardMap, Map<String, DataSet> groupMap, Table<String, String, Set<Long>> orgAndBookTypeToIdTable, Table<Long, String, String> comAssistValSourceTable) {
        HashBasedTable allComAssistToValueNumTable = HashBasedTable.create();
        HashBasedTable allComAssistToRangeNumTable = HashBasedTable.create();
        for (Table.Cell orgComAssistNumCell : orgComAssistNumTable.cellSet()) {
            String bookTypeNum;
            String orgNum = (String)orgComAssistNumCell.getRowKey();
            Set accountTableIdSet = (Set)orgAndBookTypeToIdTable.get((Object)orgNum, (Object)(bookTypeNum = (String)orgComAssistNumCell.getColumnKey()));
            if (!CollectionUtils.isNotEmpty((Collection)accountTableIdSet)) continue;
            for (Long accountTableId : accountTableIdSet) {
                if (accountTableId == 0L) continue;
                Map comAssistKeyToNumMap = (Map)orgComAssistNumCell.getValue();
                for (Map.Entry comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
                    String comAssistKey = (String)comAssistKeyToNumEntry.getKey();
                    String valueSource = (String)comAssistValSourceTable.get((Object)accountTableId, (Object)comAssistKey);
                    if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
                    for (String comAssistValueNum : (Set)comAssistKeyToNumEntry.getValue()) {
                        HashSet<String> allComAssistValueSet;
                        if (AcctUtil.isRangeValueNumber(comAssistValueNum)) {
                            if (allComAssistToRangeNumTable.contains((Object)orgNum, (Object)valueSource) && allComAssistToRangeNumTable.get((Object)orgNum, (Object)valueSource) != null) {
                                ((Set)allComAssistToRangeNumTable.get((Object)orgNum, (Object)valueSource)).add(comAssistValueNum);
                                continue;
                            }
                            allComAssistValueSet = new HashSet<String>(8);
                            allComAssistValueSet.add(comAssistValueNum);
                            allComAssistToRangeNumTable.put((Object)orgNum, (Object)valueSource, allComAssistValueSet);
                            continue;
                        }
                        if (allComAssistToValueNumTable.contains((Object)orgNum, (Object)valueSource) && allComAssistToValueNumTable.get((Object)orgNum, (Object)valueSource) != null) {
                            ((Set)allComAssistToValueNumTable.get((Object)orgNum, (Object)valueSource)).add(comAssistValueNum);
                            continue;
                        }
                        allComAssistValueSet = new HashSet(8);
                        allComAssistValueSet.add(comAssistValueNum);
                        allComAssistToValueNumTable.put((Object)orgNum, (Object)valueSource, allComAssistValueSet);
                    }
                }
            }
        }
        this.comAssistDispersedValIdTable = AcctUtil.queryComAssistDispersedValueId((Table<String, String, Set<String>>)allComAssistToValueNumTable, orgNumIdMap);
        this.comAssistRangeValIdTable = AcctUtil.queryComAssistRangeValueId((Table<String, String, Set<String>>)allComAssistToRangeNumTable, orgNumIdMap, standardMap, groupMap);
    }

    private Map<String, Set<String>> getComAssistNum(String comDimensionStrFormBCM, List<String> formulaList, Table<String, String, Map<String, Set<String>>> orgComAssistNumTable, String orgNum, String bookTypeNum, Map<String, String> errorInfoMap, String formulaId) {
        Map<String, Set<String>> comAssistKeyToNumMap = new HashMap<String, Set<String>>(8);
        String comAssistStr = comDimensionStrFormBCM;
        if (formulaList.size() > 7 && StringUtils.isNotBlank((CharSequence)formulaList.get(7))) {
            comAssistStr = formulaList.get(7);
        }
        if (StringUtils.isNotBlank((CharSequence)comAssistStr)) {
            if (AcctUtil.checkComAssistFormat(comAssistStr, Boolean.FALSE)) {
                comAssistKeyToNumMap = AcctUtil.parseComAssistStr(comAssistStr);
                Map<String, Set> allComAssistKeyToNumMap = new HashMap(8);
                if (Objects.nonNull(orgComAssistNumTable.get((Object)orgNum, (Object)bookTypeNum))) {
                    allComAssistKeyToNumMap = (Map)orgComAssistNumTable.get((Object)orgNum, (Object)bookTypeNum);
                } else {
                    orgComAssistNumTable.put((Object)orgNum, (Object)bookTypeNum, allComAssistKeyToNumMap);
                }
                for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
                    Set allComAssistNumSet = allComAssistKeyToNumMap.computeIfAbsent(comAssistKeyToNumEntry.getKey(), k -> new HashSet(8));
                    allComAssistNumSet.addAll((Collection)comAssistKeyToNumEntry.getValue());
                }
            } else {
                errorInfoMap.put(formulaId, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CashFolwItemServiceImplHelper_17", (String)"fi-gl-mservice", (Object[])new Object[0]));
            }
        }
        return comAssistKeyToNumMap;
    }

    private Map<Long, Set<Integer>> getPeriodTypeToYearNum(String comOrgNumber, int comYear, AccountBookInfo defbook, Table<String, String, AccountBookInfo> accountBookCache, Map<String, Object> acctFormulas) {
        HashMap<Long, Set<Integer>> periodTypeToYearNumMap = new HashMap<Long, Set<Integer>>(8);
        for (Map.Entry<String, Object> acctFormulaEntry : acctFormulas.entrySet()) {
            List formulaParamList = (List)acctFormulaEntry.getValue();
            String orgNum = StringUtils.isEmpty((CharSequence)((CharSequence)formulaParamList.get(0))) ? comOrgNumber : (String)formulaParamList.get(0);
            String bookTypeNum = (String)formulaParamList.get(1);
            if (Objects.nonNull(defbook) && StringUtils.isEmpty((CharSequence)bookTypeNum)) {
                bookTypeNum = defbook.getBookTypeNum();
            }
            AccountBookInfo book = null;
            if (Objects.nonNull(accountBookCache.get((Object)orgNum, (Object)bookTypeNum))) {
                book = (AccountBookInfo)accountBookCache.get((Object)orgNum, (Object)bookTypeNum);
            } else {
                book = new AccountBookInfo(orgNum, bookTypeNum);
                accountBookCache.put((Object)orgNum, (Object)bookTypeNum, (Object)book);
            }
            if (!Objects.nonNull(book)) continue;
            Set yearNumSet = periodTypeToYearNumMap.computeIfAbsent(book.getPeriodTypeId(), k -> new HashSet(8));
            yearNumSet.add(Integer.parseInt(AcctUtil.getCurYear((String)formulaParamList.get(4), String.valueOf(comYear))));
        }
        return periodTypeToYearNumMap;
    }
}

