/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;
import kd.fi.gl.acct.param.ReClassParam;
import kd.fi.gl.service.CashFolwItemServiceImplHelper;
import kd.fi.gl.service.DataCollectMsService;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;
import org.apache.commons.io.IOUtils;

public class DataCollectMsServiceImpl
implements DataCollectMsService {
    private static final Log log = LogFactory.getLog(DataCollectMsServiceImpl.class);
    private static final String FORMULA_NAME = "formulaName";
    private static final String FORMALA_ACCTCF = "acctcf";
    private long acctOrgId;
    private long bookTypeId;
    private long acctTableId;
    private static final String[] SHOW_TY = new String[]{"QC", "QY", "QJF", "QDF", "QJL", "QDL"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws IOException {
        InputStream formula_def_list = null;
        String formula_def = "";
        InputStream formula_catalog_list = null;
        String formula_catalog = "";
        try {
            formula_def_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/rpt_formulas_list.json");
            if (formula_def_list != null) {
                formula_def = IOUtils.toString((InputStream)formula_def_list);
            }
        }
        finally {
            if (formula_def_list != null) {
                formula_def_list.close();
            }
        }
        try {
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/rpt_formulas_catalog_list.json");
            if (formula_catalog_list != null) {
                formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
            }
        }
        finally {
            if (formula_catalog_list != null) {
                formula_catalog_list.close();
            }
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)formula_def) && StringUtils.isNotEmpty((CharSequence)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        String configStr = SerializationUtils.toJsonString(configMap);
        return configStr;
    }

    /*
     * Could not resolve type clashes
     */
    public String getLinkParam(String formula) {
        JSONObject resultJson = new JSONObject();
        long beforeTime = System.currentTimeMillis();
        log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u5f00\u59cb\uff1a" + beforeTime);
        log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u53c2\u6570\uff1a" + formula);
        if (StringUtils.isBlank((CharSequence)formula)) {
            return ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DataCollectMsServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        ArrayList<String> errorFormula = new ArrayList<String>();
        HashMap<String, String> errorMessageMap = new HashMap<String, String>(8);
        ArrayList<String> params = new ArrayList<String>(8);
        try {
            formula = formula.replace(" ", "");
            Map acctMap = (Map)JSONUtils.cast((String)formula, Map.class);
            if ("ACCT".equalsIgnoreCase(acctMap.get(FORMULA_NAME).toString())) {
                String[] periodList;
                ReClassParam reClassParam = new ReClassParam(formula);
                this.printLog(reClassParam);
                String comOrgNumber = reClassParam.getOrgNumber();
                Map<String, Long> mainBookTypeMap = this.getMainBookType();
                String mainBookTypeNumber = "";
                if (mainBookTypeMap.size() > 0) {
                    mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
                }
                if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
                    String mess = ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"DataCollectMsServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    log.info("Don't get mainBook for current org: " + comOrgNumber);
                    errorMessageMap.put("", mess);
                    throw new KDBizException(mess);
                }
                int comFy = reClassParam.getFy();
                int comPeriod = reClassParam.getPeriod();
                String comAdjustPeriod = reClassParam.getAdjustPeriod();
                List<String> scopePeriods = reClassParam.getScopePeriods();
                if (!StringUtils.isBlank((CharSequence)comAdjustPeriod) && (periodList = comAdjustPeriod.split(",")).length == 2 && (scopePeriods == null || scopePeriods.isEmpty())) {
                    scopePeriods = new ArrayList<String>(2);
                    scopePeriods.add(periodList[0]);
                    scopePeriods.add(periodList[1]);
                    reClassParam.setScopePeriods(scopePeriods);
                }
                String comAssistStr = "";
                Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(paramMap.size());
                Map<String, Map<String, List<String>>> bookStrToFormulasMap = this.getBookStrSet(paramMap, mainBookTypeNumber, comOrgNumber, scopePeriods, resultMap);
                HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCT);
                String permName = InterfacePermissionService.getPermName(PermissionType.ACCT);
                for (Map.Entry<String, Map<String, List<String>>> bookEntry : bookStrToFormulasMap.entrySet()) {
                    String bookStr = bookEntry.getKey();
                    Map<String, List<String>> formulasMap = bookEntry.getValue();
                    ReClassNumberIDParam numberIDParam = new ReClassNumberIDParam(reClassParam, formulasMap, bookStr);
                    this.acctOrgId = numberIDParam.getOrgId();
                    this.bookTypeId = numberIDParam.getBookTypeId();
                    this.acctTableId = numberIDParam.getAcctTableId();
                    String bookErrorMessage = this.checkBook(bookStr);
                    String orgPermMsg = AcctUtil.checkPermByOrgId(bookStr.split(",")[0], permName, this.acctOrgId, permOrgResult);
                    Map<String, Map<String, Object>> errorInfoMap = numberIDParam.getErrorInfoMap();
                    for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                        Long endPeriodId;
                        Long startPeriodId;
                        DynamicObjectCollection levelCollection;
                        QFilter levelFilter;
                        String periodParam;
                        String tmpBookTypeNumber;
                        ReportShowParameter formShowParameter = new ReportShowParameter();
                        FilterInfo filter = new FilterInfo();
                        String acctKeyId = entry.getKey();
                        List paramFields = (List)entry.getValue();
                        if (errorInfoMap.containsKey(acctKeyId)) {
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), (String)errorInfoMap.get(acctKeyId).get("v"));
                            continue;
                        }
                        String tmpOrgNumber = (String)paramFields.get(0);
                        if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                            tmpOrgNumber = comOrgNumber;
                        }
                        if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                            tmpBookTypeNumber = mainBookTypeNumber;
                        }
                        if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                            periodParam = String.valueOf(scopePeriods.get(1));
                        }
                        if (!bookStr.equals(tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam)) {
                            log.info("check this fomula org and bookStr is falied : " + entry.getKey());
                            errorFormula.add(entry.getKey());
                            Map tipsMap = (Map)resultMap.get(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), tipsMap.get("v").toString());
                            continue;
                        }
                        if (!AcctUtil.checkPeriodFormat(periodParam)) {
                            String mess = ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u671f\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"DataCollectMsServiceImpl_16", (String)"fi-gl-mservice", (Object[])new Object[0]);
                            this.setErrorMessage(resultMap, mess, entry.getKey());
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), mess);
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)bookErrorMessage)) {
                            this.setErrorMessage(resultMap, bookErrorMessage, entry.getKey());
                            errorFormula.add(entry.getKey());
                            log.info("check this fomula org and booktype is falied : " + entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), bookErrorMessage);
                            continue;
                        }
                        if (StringUtils.isNotBlank((CharSequence)orgPermMsg)) {
                            this.setErrorMessage(resultMap, orgPermMsg, entry.getKey());
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), orgPermMsg);
                            continue;
                        }
                        String acctToAssistList = (String)paramFields.get(2);
                        Map<Long, Map<String, Set<Object>>> assistToAcctMap = this.parseAcctAssistList(acctToAssistList, numberIDParam, acctKeyId);
                        Set<Long> accountIds = new HashSet<Long>(8);
                        if (StringUtils.isBlank((CharSequence)acctToAssistList)) {
                            String mess = ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u7f3a\u5c11\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataCollectMsServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0]);
                            this.setErrorMessage(resultMap, mess, entry.getKey());
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), mess);
                            continue;
                        }
                        int accLevel = 0;
                        if (!assistToAcctMap.isEmpty()) {
                            levelFilter = new QFilter("id", "in", assistToAcctMap.keySet());
                            levelCollection = QueryServiceHelper.query((String)"bd_accountview", (String)"level", (QFilter[])new QFilter[]{levelFilter}, (String)"level desc");
                        } else {
                            levelFilter = new QFilter("number", "in", Arrays.asList(acctToAssistList.split(",")));
                            levelFilter.and("accounttable.id", "=", (Object)this.acctTableId);
                            levelCollection = QueryServiceHelper.query((String)"bd_accountview", (String)"id,level", (QFilter[])new QFilter[]{levelFilter}, (String)"level desc");
                            for (DynamicObject dynamicObject : levelCollection) {
                                accountIds.add(dynamicObject.getLong("id"));
                            }
                            if (levelCollection.isEmpty()) {
                                log.info("query Acc is Failed ,No those Acc ");
                                errorFormula.add(entry.getKey());
                                errorMessageMap.put(this.buildFormula(paramFields), ResManager.loadKDString((String)"\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DataCollectMsServiceImpl_17", (String)"fi-gl-mservice", (Object[])new Object[0]));
                                continue;
                            }
                        }
                        accLevel = ((DynamicObject)levelCollection.get(0)).getInt("level");
                        boolean isSupportLink = false;
                        String formId = "gl_rpt_generalledger";
                        ArrayList<FilterItemInfo> ass = new ArrayList<FilterItemInfo>(assistToAcctMap.size());
                        HashMap<String, Set> flexToValueIdMap = new HashMap<String, Set>(10);
                        for (Map.Entry<Long, Map<String, Set<Object>>> isAssit : assistToAcctMap.entrySet()) {
                            Map<String, Set<Object>> value = isAssit.getValue();
                            if (isAssit.getValue().isEmpty()) continue;
                            formId = "gl_assisttotal";
                            for (Map.Entry<String, Set<Object>> assist : value.entrySet()) {
                                Set<Object> assVals = assist.getValue();
                                HashSet<Object> allAssists = new HashSet<Object>(8);
                                for (Object assVal : assVals) {
                                    if (assVal instanceof Collection) {
                                        allAssists.addAll((Collection)assVal);
                                    } else {
                                        allAssists.add(assVal);
                                    }
                                    isSupportLink = assVal == null;
                                }
                                flexToValueIdMap.computeIfAbsent(assist.getKey(), k -> new HashSet(10)).addAll(allAssists);
                            }
                        }
                        for (Map.Entry<Long, Map<String, Set<Object>>> flexToValue : flexToValueIdMap.entrySet()) {
                            ass.add(new FilterItemInfo((String)((Object)flexToValue.getKey()), ((Set)((Object)flexToValue.getValue())).stream().filter(Objects::nonNull).collect(Collectors.toSet()), "in"));
                        }
                        if (this.isSupportLink(errorFormula, errorMessageMap, entry, paramFields, acctToAssistList, isSupportLink)) {
                            errorFormula.add(entry.getKey());
                            continue;
                        }
                        String fetchType = (String)paramFields.get(3);
                        if (StringUtils.isBlank((CharSequence)fetchType)) {
                            String mess = ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCollectMsServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[0]);
                            this.setErrorMessage(resultMap, mess, entry.getKey());
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), mess);
                            continue;
                        }
                        fetchType = fetchType.toUpperCase();
                        boolean issubstractpl = false;
                        if (BCMBalanceIndexParam.getSubPlFetchType().contains(fetchType)) {
                            issubstractpl = true;
                        }
                        boolean showqty = false;
                        if (Arrays.asList(SHOW_TY).contains(fetchType)) {
                            showqty = true;
                        }
                        int fy = -1;
                        String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
                        String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(AcctUtil.getPeriodParam((String)paramFields.get(5)), comPeriod, comAdjustPeriod, (String)paramFields.get(4), comFy, numberIDParam.getPeriodFromYearMap());
                        String[] yearAndPeriod = yearAndPeriodKey.split("-");
                        if (yearAndPeriod.length == 2) {
                            fy = Integer.parseInt(yearAndPeriod[0]);
                            periodStr = yearAndPeriod[1];
                        }
                        if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                            startPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + scopePeriods.get(0));
                            endPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + scopePeriods.get(1));
                        } else if (periodStr.endsWith("T") || fy != -1) {
                            endPeriodId = startPeriodId = numberIDParam.getPeriodIdsMap().get(fy + "," + periodStr);
                        } else {
                            String mess = ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74\u3002", (String)"DataCollectMsServiceImpl_4", (String)"fi-gl-mservice", (Object[])new Object[0]);
                            this.setErrorMessage(resultMap, mess, entry.getKey());
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), mess);
                            continue;
                        }
                        if (startPeriodId == null) {
                            String mess = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"DataCollectMsServiceImpl_5", (String)"fi-gl-mservice", (Object[])new Object[0]);
                            this.setErrorMessage(resultMap, mess, entry.getKey());
                            errorFormula.add(entry.getKey());
                            log.info("don't get period :" + entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), mess);
                            continue;
                        }
                        int periodTypeId = 0;
                        periodTypeId = this.getPeriodTypeId(periodTypeId);
                        String currencyNumber = (String)paramFields.get(6);
                        long currencyId = 0L;
                        if (!StringUtils.isBlank((CharSequence)currencyNumber)) {
                            currencyId = numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber) == null ? 0L : numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber);
                            filter.addFilterItem("currency", (Object)currencyId);
                        } else {
                            filter.addFilterItem("currency", (Object)"basecurrency");
                        }
                        HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>();
                        HashMap<Long, Set<Long>> acctToRCAcctIdsMap = new HashMap<Long, Set<Long>>();
                        int acctReClass = reClassParam.getAcctReClass();
                        if (!BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType)) {
                            Map<Long, Set<Long>> leafMap = numberIDParam.getAcctToAllLeafMap();
                            Set<Long> acctIds = assistToAcctMap.keySet();
                            Iterator<Long> iterator = acctIds.iterator();
                            while (iterator.hasNext()) {
                                Long acctId = iterator.next();
                                acctToAssistStyleMap.put(acctId, 2);
                                acctToRCAcctIdsMap.put(acctId, leafMap.get(acctId));
                            }
                            accountIds.addAll(acctIds);
                        } else {
                            if (paramFields.size() > 7 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(7)))) {
                                acctReClass = Integer.parseInt((String)paramFields.get(7));
                            }
                            this.acctReClassDeal(acctReClass, assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam);
                            int type = 0;
                            for (Map.Entry acctToRAcctIdsMap : acctToRCAcctIdsMap.entrySet()) {
                                type = (Integer)acctToAssistStyleMap.get(acctToRAcctIdsMap.getKey());
                                Set accIds = (Set)acctToRAcctIdsMap.getValue();
                                accountIds.addAll(accIds);
                            }
                        }
                        if (acctToAssistStyleMap.isEmpty()) {
                            String[] accountValues = acctToAssistList.split("\\|");
                            String acctsStr = accountValues[0];
                            HashMap<String, Integer> message = new HashMap<String, Integer>(8);
                            message.put("type", -1);
                            message.put("v", (Integer)((Object)String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d%2$s\u79d1\u76ee\u6743\u9650\u3002", (String)"DataCollectMsServiceImpl_6", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, acctsStr)));
                            errorInfoMap.put(entry.getKey(), (Map<String, Object>)message);
                            numberIDParam.setErrorInfoMap(errorInfoMap);
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d%2$s\u79d1\u76ee\u6743\u9650\u3002", (String)"DataCollectMsServiceImpl_6", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, acctsStr));
                            continue;
                        }
                        HashMap comAssistIdMap = new HashMap(8);
                        String tempComAssistStr = comAssistStr;
                        if (paramFields.size() > 9 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(9)))) {
                            tempComAssistStr = (String)paramFields.get(9);
                        }
                        if (StringUtils.isNotBlank((CharSequence)tempComAssistStr)) {
                            errorFormula.add(entry.getKey());
                            errorMessageMap.put(this.buildFormula(paramFields), ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u6682\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"DataCollectMsServiceImpl_19", (String)"fi-gl-mservice", (Object[])new Object[0]));
                            continue;
                        }
                        for (Map.Entry comAssistIdEntry : comAssistIdMap.entrySet()) {
                            filter.addFilterItem((String)comAssistIdEntry.getKey(), comAssistIdEntry.getValue());
                        }
                        filter.addFilterItem("org", (Object)this.acctOrgId);
                        filter.addFilterItem("booktype", (Object)this.bookTypeId);
                        filter.addFilterItem("periodtype", (Object)periodTypeId);
                        filter.addFilterItem("startperiod", (Object)startPeriodId);
                        filter.addFilterItem("endperiod", (Object)endPeriodId);
                        filter.addFilterItem("accounttable", (Object)numberIDParam.getAcctTableId());
                        if ("gl_assisttotal".equals(formId)) {
                            accountIds = accountIds.stream().filter(accountId -> CollectionUtils.isNotEmpty((Collection)numberIDParam.getAcctToFlexsMap().get(accountId))).collect(Collectors.toSet());
                        }
                        filter.addFilterItem("account", accountIds, "in");
                        filter.addFilterItem("accountlevel", (Object)accLevel);
                        if (issubstractpl) {
                            filter.addFilterItem("issubstractpl", (Object)issubstractpl);
                        }
                        if (showqty) {
                            filter.addFilterItem("showqty", (Object)showqty);
                        }
                        if (!ass.isEmpty()) {
                            filter.setFlexFilterItems(ass);
                        }
                        ReportQueryParam queryParam = new ReportQueryParam();
                        queryParam.setFilter(filter);
                        OpenStyle openStyle = new OpenStyle();
                        openStyle.setShowType(ShowType.MainNewTabPage);
                        formShowParameter.setOpenStyle(openStyle);
                        formShowParameter.setQueryParam(queryParam);
                        formShowParameter.setFormId(formId);
                        params.add(ReportShowParameter.toJsonString((FormShowParameter)formShowParameter));
                    }
                }
                log.info("this query result pageParam size : " + params.size() + "thses formulas don't meet query criteria : " + JSON.toJSON(errorFormula));
            }
            if (FORMALA_ACCTCF.equalsIgnoreCase(acctMap.get(FORMULA_NAME).toString())) {
                CashFolwItemServiceImplHelper cashFolwItemServiceImplHelper = new CashFolwItemServiceImplHelper();
                String acctCfResult = cashFolwItemServiceImplHelper.getLinkParam(formula);
                return acctCfResult;
            }
        }
        catch (Exception e) {
            log.error("parse formula exception: " + e.getMessage(), (Throwable)e);
            resultJson.put("pageParam", params);
            resultJson.put("error", errorMessageMap);
            return resultJson.toJSONString();
        }
        resultJson.put("pageParam", params);
        resultJson.put("error", errorMessageMap);
        return resultJson.toJSONString();
    }

    private boolean isSupportLink(List<String> errorFormula, Map<String, String> errorMessageMap, Map.Entry<String, Object> entry, List<String> paramFields, String acctToAssistList, boolean isSupportLink) {
        String[] accountValues;
        if (StringUtils.isNotBlank((CharSequence)acctToAssistList) && isSupportLink && (accountValues = acctToAssistList.split("\\|")).length > 2 && accountValues[2].contains(":")) {
            errorMessageMap.put(this.buildFormula(paramFields), ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u6682\u4e0d\u652f\u6301\u5c5e\u6027\u53d6\u6570\u8054\u67e5\u3002", (String)"DataCollectMsServiceImpl_14", (String)"fi-gl-mservice", (Object[])new Object[0]));
            errorFormula.add(entry.getKey());
            return true;
        }
        return false;
    }

    private int getPeriodTypeId(int periodTypeId) {
        try (DataSet resDataSet = DB.queryDataSet((String)"DataCollectMsServiceImpl", (DBRoute)DBRoute.of((String)"gl"), (String)String.format("select forgid,fbookstypeid,faccounttableid,fperiodtypeid from t_bd_accountbooks  where forgid = %s and fbookstypeid = %s", this.acctOrgId, this.bookTypeId));){
            while (resDataSet.hasNext()) {
                Row row = resDataSet.next();
                periodTypeId = row.getInteger("fperiodtypeid");
            }
        }
        return periodTypeId;
    }

    private void acctReClassDeal(int acctReClass, Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, ReClassNumberIDParam numberIDParam) {
        Map<Long, Set<Long>> directLeafMap = numberIDParam.getAcctToDirectLeafMap();
        Map<Long, Set<Long>> allLeafMap = numberIDParam.getAcctToAllLeafMap();
        Map<Long, Set<String>> acctToFlexMap = numberIDParam.getAcctToFlexsMap();
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMapFor = new HashMap<Long, Map<String, Set<Object>>>();
        acctIdToAssistMapFor.putAll(acctIdToAssistMap);
        switch (acctReClass) {
            case 1: {
                for (Map.Entry entry : acctIdToAssistMapFor.entrySet()) {
                    long acctId = (Long)entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>();
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 2: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    Set<Long> allLeafIds;
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 3);
                        continue;
                    }
                    allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 3: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 4: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 5: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 6: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    HashSet<Long> acctIds;
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>();
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctIds = new HashSet();
                    acctIds.add(acctId);
                    acctToRCAcctIdsMap.put(acctId, acctIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
        }
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> acctToFlexMap, long acctId) {
        boolean isContainAssist = true;
        Set<String> flexs = acctToFlexMap.get(acctId);
        if (flexs == null || flexs.size() == 0) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private boolean isSelectAssist(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, long acctId) {
        Map<String, Set<Object>> assistMap = acctIdToAssistMap.get(acctId);
        boolean isSelectAssist = assistMap != null && !assistMap.isEmpty();
        return isSelectAssist;
    }

    private Map<Long, Map<String, Set<Object>>> parseAcctAssistList(String accountListStr, ReClassNumberIDParam numberIDParam, String acctKeyId) {
        Map<String, Long> numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
        Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
        if (StringUtils.isEmpty((CharSequence)accountListStr)) {
            Map<String, Map<String, Object>> errorMap = numberIDParam.getErrorInfoMap();
            HashMap<String, Object> message = new HashMap<String, Object>(8);
            message.put("type", -1);
            message.put("v", ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DataCollectMsServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]));
            errorMap.put(acctKeyId, message);
        }
        String[] accountValues = accountListStr.split("\\|");
        String acctsStr = accountValues[0];
        boolean isContinueAcct = ReClassUtils.isContinueNumber(acctsStr);
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMap = new HashMap<Long, Map<String, Set<Object>>>();
        HashMap<String, Set<Object>> asstMap = new HashMap<String, Set<Object>>();
        Set<Object> acctIds = new HashSet();
        String accountNumber = this.parseAssistStr(accountListStr, asstMap, numberIDParam);
        if (isContinueAcct) {
            acctIds = rangeNumberToIdsMap.get(accountNumber);
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else if (StringUtils.isEmpty((CharSequence)acctsStr)) {
            StringBuilder flexsStr = new StringBuilder();
            Set flexs = asstMap.keySet();
            for (String flex : flexs) {
                flexsStr = flexsStr.append(flex);
                flexsStr = flexsStr.append("*");
            }
            Map<String, Set<Long>> flexsToAcctIdsMap = numberIDParam.getFlexsToAcctIdsMap();
            acctIds = flexsToAcctIdsMap.get(flexsStr.toString());
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else {
            String[] accountList;
            for (String acctNumberStr : accountList = acctsStr.split(",")) {
                Long acctId = numberToIdMap.get(acctNumberStr);
                if (acctId == null) continue;
                acctIds.add(acctId);
                acctIdToAssistMap.put(acctId, asstMap);
            }
        }
        return acctIdToAssistMap;
    }

    private String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, ReClassNumberIDParam numberIDParam) {
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountNumber;
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Object> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            HashSet<Object> valIds = new HashSet<Object>();
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                String valStr = accountValues[i + 1].trim();
                boolean isContinue = ReClassUtils.isContinueNumber(valStr);
                if (isContinue) {
                    Set<Object> valIdSet = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                    if (Objects.nonNull(valIdSet)) {
                        valIds.addAll(valIdSet);
                    }
                } else {
                    String[] valList;
                    for (String valNumber : valList = valStr.split(",")) {
                        valIds.add(valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                    }
                }
            }
            asstMap.put(flex, valIds);
        }
        return accountNumber;
    }

    private void setErrorMessage(Map<String, Map<String, Object>> resultMap, String errorMessage, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", ResManager.loadKDString((String)errorMessage, (String)"BCMBalanceParamParseUtils", (String)"DataCollectMsServiceImpl_8", (Object[])new Object[0]));
        map.put("type", -1);
        resultMap.put(key, map);
    }

    private Map<String, Map<String, List<String>>> getBookStrSet(Map<String, Object> paramMap, String comBookTypeNumber, String comOrgNumber, List<String> scopePeriods, Map<String, Map<String, Object>> resultMap) {
        HashMap<String, Map<String, List<String>>> bookStrToFormulasMap = new HashMap<String, Map<String, List<String>>>(8);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String periodParam;
            String tmpBookTypeNumber;
            String key = entry.getKey();
            List paramFields = (List)entry.getValue();
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                if (StringUtils.isBlank((CharSequence)comOrgNumber)) {
                    String tip = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7", (String)"DataCollectMsServiceImpl_9", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    HashMap<String, String> tipMap = new HashMap<String, String>();
                    tipMap.put("v", tip);
                    tipMap.put("type", "-1");
                    resultMap.put(key, tipMap);
                    continue;
                }
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                if (StringUtils.isBlank((CharSequence)comBookTypeNumber)) {
                    String tip = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"DataCollectMsServiceImpl_10", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    HashMap<String, String> tipMap = new HashMap<String, String>();
                    tipMap.put("v", tip);
                    tipMap.put("type", "-1");
                    resultMap.put(key, tipMap);
                    continue;
                }
                tmpBookTypeNumber = comBookTypeNumber;
            }
            if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                periodParam = String.valueOf(scopePeriods.get(1));
            }
            String bookStr = tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam;
            Map formulasMap = bookStrToFormulasMap.computeIfAbsent(bookStr, x -> new HashMap(64));
            formulasMap.put(key, paramFields);
        }
        return bookStrToFormulasMap;
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }

    private void printLog(ReClassParam reClassParam) {
        log.info("REACCT\uff0creport param\uff1a" + reClassParam.getAcctReClass() + ",orgNum\uff1a" + reClassParam.getOrgNumber() + ",period\uff1a" + reClassParam.getPeriod());
        Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (paramMap.size() > 1000) {
            log.info("REACCT FORMULA\uff1a" + logBuilder);
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                log.info("REACCT FORMULA" + logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            log.info("REACCT FORMULA\uff1a" + logBuilder);
        } else {
            log.info("REACCT FORMULA" + logIndex + "\uff1a" + logBuilder);
        }
    }

    private String checkBook(String bookStr) {
        String bookErrorMessage = "";
        String[] orgBookTypes = bookStr.split(",");
        String orgNumber = orgBookTypes[0];
        String bookTypeNumber = orgBookTypes[1];
        if (this.acctOrgId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"DataCollectMsServiceImpl_11", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        } else if (this.bookTypeId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"DataCollectMsServiceImpl_12", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        } else if (this.acctTableId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\uff0c\u5c1a\u672a\u5efa\u7acb\u8d26\u7c3f\u3002", (String)"DataCollectMsServiceImpl_13", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber, bookTypeNumber);
        }
        return bookErrorMessage;
    }

    private String buildFormula(List<String> paramFields) {
        StringBuilder formulaStr = new StringBuilder();
        if (CollectionUtils.isNotEmpty(paramFields)) {
            formulaStr.append("acct(");
            for (int i = 0; i < paramFields.size(); ++i) {
                if (i == 4 || i == 5) {
                    formulaStr.append(paramFields.get(i)).append(",");
                    continue;
                }
                formulaStr.append("\"").append(paramFields.get(i)).append("\"").append(",");
            }
            return formulaStr.deleteCharAt(formulaStr.length() - 1).append(")").toString();
        }
        return formulaStr.toString();
    }

    private Map<String, Set<Long>> getComAssistIdMap(String tempComAssistStr, Table<String, String, Set<Long>> comAssistToValueIdTable, Table<String, String, Set<Long>> comAssistToValRangeIdTable) {
        HashMap<String, Set<Long>> comAssistIdMap = new HashMap<String, Set<Long>>(8);
        Map<String, Set<String>> comAssistKeyToNumMap = AcctUtil.parseComAssistStr(tempComAssistStr);
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            Set allValueIdSet;
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            Set<String> valueNumberSet = comAssistKeyToNumEntry.getValue();
            if (valueNumberSet != null && valueNumberSet.isEmpty()) {
                comAssistIdMap.put(comAssistKey, new HashSet(8));
                continue;
            }
            if (valueNumberSet == null) continue;
            String tempValueNumber = valueNumberSet.iterator().next();
            if (AcctUtil.isRangeValueNumber(tempValueNumber)) {
                for (String valueNumber : valueNumberSet) {
                    allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)valueNumber)))) {
                        allValueIdSet.addAll((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)valueNumber));
                        continue;
                    }
                    allValueIdSet.add(0L);
                }
                continue;
            }
            for (String valueNumber : valueNumberSet) {
                allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber)))) {
                    allValueIdSet.addAll((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber));
                    continue;
                }
                allValueIdSet.add(0L);
            }
        }
        return comAssistIdMap;
    }
}

