/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.service.DetailBalanceQueryParam;
import kd.fi.gl.service.DetailBalanceService;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Triple;

public class DetailBalanceServiceImpl
implements DetailBalanceService {
    private static final Log log = LogFactory.getLog(DetailBalanceServiceImpl.class);
    private static final String BEGIN_PROP = "beginfor,beginlocal,beginqty";
    private static final String END_PROP = "endfor,endlocal,endqty";
    private static final String YEAR_PROP = "yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty";
    private static final String DCP_PROP = "debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty";
    public HashSet<String> balanceFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("booktype");
            this.add("period");
            this.add("endperiod");
            this.add("accounttable");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("measureunit");
            this.add("beginfor");
            this.add("debitfor");
            this.add("creditfor");
            this.add("endfor");
            this.add("beginlocal");
            this.add("debitlocal");
            this.add("creditlocal");
            this.add("endlocal");
            this.add("yeardebitfor");
            this.add("yeardebitlocal");
            this.add("yearcreditfor");
            this.add("yearcreditlocal");
            this.add("beginqty");
            this.add("debitqty");
            this.add("creditqty");
            this.add("endqty");
            this.add("yeardebitqty");
            this.add("yearcreditqty");
            this.add("count");
        }
    };

    public String getDetailBalance(String param) {
        try {
            log.info("\u4f59\u989d\u8868\u53d6\u6570\u63a5\u6536\u53c2\u6570\uff1a" + param);
            if (param == null || StringUtils.isBlank((CharSequence)param)) {
                return null;
            }
            DetailBalanceQueryParam queryParam = (DetailBalanceQueryParam)JSONUtils.cast((String)param, DetailBalanceQueryParam.class);
            Map<String, Object> data = this.getDetailBalanceData(queryParam);
            if (DebugTrace.enable()) {
                log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a" + data);
            }
            return JSONUtils.toString(data);
        }
        catch (Exception e) {
            log.error("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u6570\u636e\u62a5\u9519getMessage()\uff1a" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public Map<String, Object> getDetailBalanceData(DetailBalanceQueryParam queryParam) {
        Result result = new Result();
        ArrayList<QFilter> balanceQfilters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> balanceLogQfilters = new ArrayList<QFilter>(10);
        HashSet<Long> accountMasterIds = new HashSet<Long>(10);
        HashMap<String, String> selAliasMap = new HashMap<String, String>(16);
        if (!this.validateQueryParam(queryParam, accountMasterIds, result)) {
            return result.toMap();
        }
        String selectFieldNames = this.getSelector(queryParam.getSelector(), selAliasMap);
        DataSet balanceDS = this.getBalanceDataSet(queryParam, balanceQfilters, accountMasterIds, selectFieldNames);
        DataSet balanceLogDS = this.getBalanceLogDataSet(queryParam, balanceLogQfilters, accountMasterIds, selectFieldNames);
        DataSet balanceSet = this.unionBalanceData(queryParam, balanceDS, balanceLogDS, selectFieldNames);
        try {
            int totalCount = this.getBalaceCount(queryParam, balanceQfilters, result);
            List<Map<String, Object>> rs = this.trans2List(balanceSet, selAliasMap);
            result.getData().setRows(rs);
            result.getData().setPageNo(queryParam.getPageNo());
            result.getData().setPageSize(queryParam.getPageSize());
            result.getData().setFilter(String.join((CharSequence)" | ", balanceQfilters.stream().map(x -> x.toString()).collect(Collectors.toList())));
            result.getData().setLastPage(totalCount <= queryParam.getPageNo() * queryParam.getPageSize());
            result.getData().setTotalCount(totalCount);
            if (DebugTrace.enable()) {
                log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u7ed3\u679c\uff1a" + rs);
            }
            Map<String, Object> map = result.toMap();
            return map;
        }
        catch (Exception e) {
            log.error("\u4f59\u989d\u8868\u53d6\u6570\u5f02\u5e38e.getMessage()\uff1a" + e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        finally {
            if (balanceSet != null) {
                balanceSet.close();
            }
            if (balanceLogDS != null) {
                balanceLogDS.close();
            }
        }
    }

    private int getBalaceCount(DetailBalanceQueryParam queryParam, List<QFilter> balanceQfilters, Result result) {
        DistributeSessionlessCache totalCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + ":querybalance");
        int totalCount = 0;
        String total = "";
        if (!StringUtils.isEmpty((CharSequence)queryParam.getRequestId())) {
            total = (String)totalCache.get(queryParam.getRequestId());
        }
        if (StringUtils.isEmpty((CharSequence)total)) {
            Map<String, Set<Object>> assgrps = queryParam.getAssgrps();
            if (!assgrps.isEmpty()) {
                Collection<FlexUtils.AssistFilterEntry> assistFilterEntries = this.buildAssistFilterInfo(assgrps);
                Triple balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterEntries, (String)"gl_balance", (boolean)true);
                MainEntityType mainEntityType = (MainEntityType)balanceOrmInfo.getLeft();
                ORM orm = ORM.create();
                orm.setDataEntityType("gl_balance", (IDataEntityType)mainEntityType);
                totalCount = orm.count(this.getClass().getName(), "gl_balance", "id", balanceQfilters.toArray(new QFilter[0]));
            } else {
                totalCount = ORM.create().count(this.getClass().getName(), "gl_balance", "id", balanceQfilters.toArray(new QFilter[0]));
            }
            total = String.valueOf(totalCount);
            String newRequestId = Uuid16.create().toString();
            totalCache.put(newRequestId, (Object)total);
            result.setRequestId(newRequestId);
        } else {
            totalCount = Integer.parseInt(total);
        }
        return totalCount;
    }

    private DataSet getBalanceDataSet(DetailBalanceQueryParam queryParam, List<QFilter> balanceQfilters, Set<Long> accountMasterIds, String selectFieldNames) {
        Map<String, Set<Object>> assgrps = queryParam.getAssgrps();
        balanceQfilters.add(new QFilter("booktype", "=", (Object)queryParam.getBookTypeId()));
        balanceQfilters.add(new QFilter("org", "in", (Object)queryParam.getOrgIds()));
        balanceQfilters.add(new QFilter("accounttable", "=", (Object)queryParam.getAccountTableId()));
        balanceQfilters.add(new QFilter("period", ">=", (Object)(queryParam.getPeriodId() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        balanceQfilters.add(new QFilter("period", "<=", (Object)queryParam.getPeriodId()));
        balanceQfilters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)queryParam.getPeriodId(), (Long[])this.toLongArray(queryParam.getOrgIds()))));
        if (queryParam.getCurrencyId() > 0L) {
            balanceQfilters.add(new QFilter("currency", "=", (Object)queryParam.getCurrencyId()));
        }
        if (queryParam.getMeasureUnitIds() != null && queryParam.getMeasureUnitIds().length > 0) {
            balanceQfilters.add(new QFilter("measureunit", "in", (Object)queryParam.getMeasureUnitIds()));
        }
        if (!accountMasterIds.isEmpty()) {
            balanceQfilters.add(new QFilter("account", "in", accountMasterIds));
        }
        if (Objects.nonNull(queryParam.getComassit()) && !queryParam.getComassit().isEmpty()) {
            queryParam.getComassit().forEach((k, v) -> balanceQfilters.add(new QFilter(k, "in", v)));
        }
        HashSet<String> selectFieldToSet = new HashSet<String>(Arrays.asList(selectFieldNames.split(",")));
        selectFieldToSet.add("account");
        selectFieldToSet.add("account.dc");
        selectFieldToSet.add("period");
        selectFieldToSet.add("booktype");
        selectFieldToSet.add("comassist1");
        selectFieldToSet.add("comassist2");
        ArrayList<String> allSelectFields = new ArrayList<String>(selectFieldToSet);
        DataSet balanceSet = null;
        HashMap<String, String> assTypeAndAlias = new HashMap<String, String>(16);
        if (!assgrps.isEmpty()) {
            Collection<FlexUtils.AssistFilterEntry> assistFilterEntries = this.buildAssistFilterInfo(assgrps);
            Triple balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterEntries, (String)"gl_balance", (boolean)true);
            MainEntityType mainEntityType = (MainEntityType)balanceOrmInfo.getLeft();
            balanceQfilters.addAll((Collection)balanceOrmInfo.getMiddle());
            allSelectFields.addAll((Collection)balanceOrmInfo.getRight());
            for (String assType : (List)balanceOrmInfo.getRight()) {
                String[] asstypeSplit = assType.split(" ");
                assTypeAndAlias.put(asstypeSplit[0], asstypeSplit[1]);
            }
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_balance", (IDataEntityType)mainEntityType);
            balanceSet = orm.queryDataSet(this.getClass().getName(), "gl_balance", String.join((CharSequence)",", allSelectFields), balanceQfilters.toArray(new QFilter[0]), "id", (queryParam.getPageNo() - 1) * queryParam.getPageSize(), queryParam.getPageNo() * queryParam.getPageSize());
        } else {
            ORM orm = ORM.create();
            balanceSet = orm.queryDataSet(this.getClass().getName(), "gl_balance", String.join((CharSequence)",", allSelectFields), balanceQfilters.toArray(new QFilter[0]), "id", (queryParam.getPageNo() - 1) * queryParam.getPageSize(), queryParam.getPageNo() * queryParam.getPageSize());
        }
        long yearPeriodid = queryParam.getPeriodId() / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L;
        for (int i = 0; i < allSelectFields.size(); ++i) {
            String selectField = (String)allSelectFields.get(i);
            String[] strs = selectField.trim().split("\\s+");
            String alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
            String name = strs[0].trim();
            if ("period".equals(name)) {
                selectField = queryParam.getPeriodId() + " as " + alias;
                allSelectFields.set(i, selectField);
                continue;
            }
            if ("beginfor".equals(name)) {
                selectField = String.format("case when period < %1$d then %2$s else %3$s end as %4$s", queryParam.getPeriodId(), "endfor", alias, alias);
                allSelectFields.set(i, selectField);
                continue;
            }
            if ("beginlocal".equals(name)) {
                selectField = String.format("case when period < %1$d then %2$s else %3$s end as %4$s", queryParam.getPeriodId(), "endlocal", alias, alias);
                allSelectFields.set(i, selectField);
                continue;
            }
            if ("beginqty".equals(name)) {
                selectField = String.format("case when period < %1$d then %2$s else %3$s end as %4$s", queryParam.getPeriodId(), "endqty", alias, alias);
                allSelectFields.set(i, selectField);
                continue;
            }
            if ("debitfor".equals(name) || "debitlocal".equals(name) || "debitqty".equals(name) || "creditfor".equals(name) || "creditlocal".equals(name) || "creditqty".equals(name)) {
                selectField = "case when period < " + queryParam.getPeriodId() + " then 0 else " + alias + " end as " + alias;
                allSelectFields.set(i, selectField);
                continue;
            }
            if ("yeardebitfor".equals(name) || "yeardebitlocal".equals(name) || "yeardebitqty".equals(name) || "yearcreditfor".equals(name) || "yearcreditlocal".equals(name) || "yearcreditqty".equals(name)) {
                selectField = "case when period < " + yearPeriodid + " then 0 else " + alias + " end as " + alias;
                allSelectFields.set(i, selectField);
                continue;
            }
            if (!assTypeAndAlias.containsKey(name)) continue;
            allSelectFields.set(i, alias);
        }
        balanceSet = balanceSet.select(String.join((CharSequence)",", allSelectFields));
        return balanceSet;
    }

    private DataSet getBalanceLogDataSet(DetailBalanceQueryParam queryParam, List<QFilter> balanceLogQfilters, Set<Long> accountMasterIds, String selectFieldNames) {
        Map<String, Set<Object>> assgrps = queryParam.getAssgrps();
        balanceLogQfilters.add(new QFilter("booktype", "=", (Object)queryParam.getBookTypeId()));
        balanceLogQfilters.add(new QFilter("org", "in", (Object)queryParam.getOrgIds()));
        balanceLogQfilters.add(new QFilter("accounttable", "=", (Object)queryParam.getAccountTableId()));
        balanceLogQfilters.add(new QFilter("calculated", "=", (Object)"0"));
        balanceLogQfilters.add(new QFilter("period", ">=", (Object)(queryParam.getPeriodId() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        balanceLogQfilters.add(new QFilter("period", "<=", (Object)queryParam.getPeriodId()));
        if (queryParam.getCurrencyId() > 0L) {
            balanceLogQfilters.add(new QFilter("currency", "=", (Object)queryParam.getCurrencyId()));
        }
        if (queryParam.getMeasureUnitIds() != null && queryParam.getMeasureUnitIds().length > 0) {
            balanceLogQfilters.add(new QFilter("measureunit", "in", (Object)queryParam.getMeasureUnitIds()));
        }
        if (!accountMasterIds.isEmpty()) {
            balanceLogQfilters.add(new QFilter("account", "in", accountMasterIds));
        }
        if (Objects.nonNull(queryParam.getComassit()) && !queryParam.getComassit().isEmpty()) {
            queryParam.getComassit().forEach((k, v) -> balanceLogQfilters.add(new QFilter(k, "in", v)));
        }
        ArrayList<String> allSelectFields = new ArrayList<String>(10);
        String selectFields = "voucherid,booktype,period,currency,assgrp,operation,calculated,account,measureunit,debitqty,creditqty,debitfor,creditfor,debitlocal,creditlocal,org,createtime,comassist1,comassist2";
        ArrayList<String> balanceLogSelectFields = new ArrayList<String>(Arrays.asList(selectFields.split(",")));
        for (String field : balanceLogSelectFields) {
            allSelectFields.add(field);
        }
        ArrayList<String> groupList = new ArrayList<String>(10);
        groupList.add("org");
        groupList.add("booktype");
        groupList.add("account");
        if (allSelectFields.contains("currency")) {
            groupList.add("currency");
        }
        if (allSelectFields.contains("assgrp") && !allSelectFields.contains("assgrp_")) {
            groupList.add("assgrp");
        }
        if (allSelectFields.contains("measureunit")) {
            groupList.add("measureunit");
        }
        groupList.add("period");
        Set<String> comField = queryParam.getComassit().keySet();
        groupList.addAll(comField);
        DataSet balanceLog = null;
        if (!assgrps.isEmpty()) {
            Collection<FlexUtils.AssistFilterEntry> assistFilterEntries = this.buildAssistFilterInfo(assgrps);
            Triple balanceLogOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterEntries, (String)"gl_balance_log", (boolean)true);
            MainEntityType balanceLogBalEntity = (MainEntityType)balanceLogOrmInfo.getLeft();
            balanceLogQfilters.addAll((Collection)balanceLogOrmInfo.getMiddle());
            allSelectFields.addAll((Collection)balanceLogOrmInfo.getRight());
            ORM logOrm = ORM.create();
            logOrm.setDataEntityType("gl_balance_log", (IDataEntityType)balanceLogBalEntity);
            balanceLog = logOrm.queryDataSet(this.getClass().getName(), "gl_balance_log", String.join((CharSequence)",", allSelectFields), balanceLogQfilters.toArray(new QFilter[0]), "id", (queryParam.getPageNo() - 1) * queryParam.getPageSize(), queryParam.getPageNo() * queryParam.getPageSize());
        } else {
            balanceLog = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance_log", (String)String.join((CharSequence)",", allSelectFields), (QFilter[])balanceLogQfilters.toArray(new QFilter[0]), (String)String.join((CharSequence)",", groupList));
        }
        QFilter fid = new QFilter("id", "=", (Object)queryParam.getPeriodId());
        DataSet endPeriodSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".period"), (String)"bd_period", (String)"periodyear", (QFilter[])new QFilter[]{fid}, null);
        int periodyear = ((Row)endPeriodSet.iterator().next()).getInteger("periodyear");
        String allPeriodSel = "id period, periodyear";
        QFilter fstperiod = new QFilter("id", ">=", (Object)(queryParam.getPeriodId() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L));
        QFilter fedperiod = new QFilter("id", "<=", (Object)queryParam.getPeriodId());
        DataSet allPeriodSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".period"), (String)"bd_period", (String)allPeriodSel, (QFilter[])new QFilter[]{fstperiod, fedperiod}, null);
        List<String> balanceFields = this.getDSFileds(balanceLog);
        balanceLog = balanceLog.join(allPeriodSet, JoinType.LEFT).on("period", "period").select(balanceFields.toArray(new String[balanceFields.size()]), new String[]{"periodyear"}).finish();
        ArrayList<QFilter> accountQFilters = new ArrayList<QFilter>(10);
        accountQFilters.add(new QFilter("accounttable.id", "=", (Object)queryParam.getAccountTableId()));
        if (!queryParam.getAccountIds().isEmpty()) {
            accountQFilters.add(new QFilter("id", "in", queryParam.getAccountIds()));
        }
        DataSet allAccountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,dc", (QFilter[])accountQFilters.toArray(new QFilter[accountQFilters.size()]), null);
        balanceFields = this.getDSFileds(balanceLog);
        balanceLog = balanceLog.join(allAccountDataSet, JoinType.LEFT).on("account", "id").select(balanceFields.toArray(new String[balanceFields.size()]), new String[]{"dc account.dc"}).finish();
        balanceLog = balanceLog.addField("debitfor", "yeardebitfor").addField("creditfor", "yearcreditfor").addField("debitlocal", "yeardebitlocal").addField("creditlocal", "yearcreditlocal").addField("debitqty", "yeardebitqty").addField("creditqty", "yearcreditqty").addField("debitfor-creditfor", "endfor").addField("debitlocal-creditlocal", "endlocal").addField("debitqty-creditqty", "endqty").addField("debitfor-creditfor", "beginfor").addField("debitlocal-creditlocal", "beginlocal").addField("debitqty-creditqty", "beginqty");
        List<String> logList = this.getDSFileds(balanceLog);
        ArrayList<String> selList = new ArrayList<String>();
        List<String> periodList = Arrays.asList(DCP_PROP.split(","));
        List<String> startPeriodList = Arrays.asList(BEGIN_PROP.split(","));
        List<String> yearList = Arrays.asList(YEAR_PROP.split(","));
        for (String field : logList) {
            String pcase;
            if (yearList.contains(field)) {
                String ycase = "case when periodyear=" + periodyear + " then " + field + " else 0 end as " + field;
                selList.add(ycase);
                continue;
            }
            if (periodList.contains(field)) {
                pcase = "case when period = " + queryParam.getPeriodId() + " then " + field + " else 0 end as " + field;
                selList.add(pcase);
                continue;
            }
            if (startPeriodList.contains(field)) {
                pcase = "case when period<" + queryParam.getPeriodId() + " then " + field + " else 0 end as " + field;
                selList.add(pcase);
                continue;
            }
            selList.add(field);
        }
        balanceLog = balanceLog.select(selList.toArray(new String[selList.size()]));
        List<String> balList = this.getDSFileds(balanceLog);
        balanceLog = balanceLog.select(balList.toArray(new String[0]));
        return balanceLog;
    }

    private DataSet unionBalanceData(DetailBalanceQueryParam queryParam, DataSet balanceDS, DataSet balanceLogDS, String selectFieldNames) {
        Field[] fields;
        ArrayList<String> allSelectFields = new ArrayList<String>(Arrays.asList(selectFieldNames.split(",")));
        ArrayList<String> groupList = new ArrayList<String>(10);
        groupList.add("org");
        groupList.add("booktype");
        groupList.add("account.dc");
        groupList.add("account");
        if (allSelectFields.contains("currency")) {
            groupList.add("currency");
        }
        if (allSelectFields.contains("assgrp") && !allSelectFields.contains("assgrp_")) {
            groupList.add("assgrp");
        }
        if (allSelectFields.contains("measureunit")) {
            groupList.add("measureunit");
        }
        groupList.add("period");
        Set<String> comField = queryParam.getComassit().keySet();
        groupList.addAll(comField);
        for (Field field : fields = balanceDS.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (field.getDataType() instanceof BigDecimalType || "count".equals(name) || groupList.contains(name)) continue;
            groupList.add(name);
        }
        List<String> balanceSels = this.getDSFileds(balanceDS);
        balanceLogDS = balanceLogDS.select(balanceSels.toArray(new String[balanceSels.size()]));
        balanceDS = balanceDS.union(balanceLogDS).orderBy(groupList.toArray(new String[groupList.size()]));
        for (int i = 0; i < allSelectFields.size(); ++i) {
            String selectField = (String)allSelectFields.get(i);
            String[] strs = selectField.trim().split("\\s+");
            String alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
            String name = strs[0].trim();
            if (!BEGIN_PROP.contains(name) && !END_PROP.contains(name)) continue;
            selectField = "case when account.dc = '1' then " + alias + " else -1 * " + alias + " end as " + alias;
            allSelectFields.set(i, selectField);
        }
        balanceDS = balanceDS.select(String.join((CharSequence)",", allSelectFields));
        return balanceDS;
    }

    private boolean validateQueryParam(DetailBalanceQueryParam queryParam, Set<Long> accountMasterIds, Result result) {
        ResultData data = result.getData();
        data.setPageNo(queryParam.getPageNo());
        data.setPageSize(queryParam.getPageSize());
        if (queryParam.getSelector() == null || queryParam.getSelector().isEmpty()) {
            result.setErrorCode("400");
            result.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"DetailBalanceService_11", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return false;
        }
        if (queryParam.getAccountTableId() == 0L) {
            List<Long> accountTableIds = this.getAccountTableIds(queryParam.getOrgIds(), queryParam.getBookTypeId());
            if (accountTableIds == null) {
                result.setErrorCode("400");
                result.setMessage(ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7id\u548c\u79d1\u76ee\u8868\u67e5\u8be2\u83b7\u53d6\u5230\u7684\u79d1\u76ee\u8868\u4e3a\u7a7a\u3002", (String)"DetailBalanceService_12", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return false;
            }
            if (accountTableIds.size() > 1) {
                result.setErrorCode("400");
                result.setMessage(ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7id\u548c\u79d1\u76ee\u8868\u67e5\u8be2\u83b7\u53d6\u5230\u7684\u79d1\u76ee\u8868\u4e3a\u6709\u591a\u4e2a\uff0c\u8bf7\u6307\u5b9a\u79d1\u76ee\u8868\u3002", (String)"DetailBalanceService_13", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return false;
            }
            queryParam.setAccountTableId(accountTableIds.get(0));
        }
        if (queryParam.getPageNo() <= 0) {
            result.setErrorCode("400");
            result.setMessage(ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\u7684\u67e5\u8be2\u9875\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u5206\u9875\u53c2\u6570\u7684\u67e5\u8be2\u9875\u7801\u3002", (String)"DetailBalanceService_14", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return false;
        }
        if (queryParam.getPageSize() <= 0 || queryParam.getPageSize() > 100000) {
            result.setErrorCode("400");
            result.setMessage(ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\u7684\u5206\u9875\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u5206\u9875\u53c2\u6570\u7684\u5206\u9875\u6570\u91cf\u3002", (String)"DetailBalanceService_15", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return false;
        }
        List<Long> faccountIds = queryParam.getAccountIds();
        Map<String, Set<Object>> assgrps = queryParam.getAssgrps();
        if (faccountIds != null && !faccountIds.isEmpty()) {
            ArrayList<QFilter> accountQFiltes = new ArrayList<QFilter>(10);
            accountQFiltes.add(new QFilter("id", "in", faccountIds));
            if (!assgrps.isEmpty()) {
                accountQFiltes.add(new QFilter("checkitementry.asstactitem.flexfield", "in", assgrps.keySet()));
            }
            DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"masterid", (QFilter[])accountQFiltes.toArray(new QFilter[0]), null);
            for (Row row : acctDataSet) {
                accountMasterIds.add(row.getLong("masterid"));
            }
            if (accountMasterIds.isEmpty()) {
                result.setErrorCode("400");
                result.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u79d1\u76ee\u4e0e\u6838\u7b97\u7ef4\u5ea6\u7ec4\u7ec7\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u4e0e\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"DetailBalanceService_16", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private Collection<FlexUtils.AssistFilterEntry> buildAssistFilterInfo(Map<String, Set<Object>> propValues) {
        Set<String> props = propValues.keySet();
        if (props.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Map propInfos = FlexUtils.batchGetFlexProperty((String[])props.toArray(new String[0]));
        ArrayList<FlexUtils.AssistFilterEntry> result = new ArrayList<FlexUtils.AssistFilterEntry>(2);
        for (Map.Entry<String, Set<Object>> entry : propValues.entrySet()) {
            FlexProperty flexProperty = (FlexProperty)propInfos.get(entry.getKey());
            Set<Object> vals = entry.getValue();
            FlexUtils.AssistFilterEntry assistFilterEntry = new FlexUtils.AssistFilterEntry(entry.getKey(), vals, flexProperty);
            result.add(assistFilterEntry);
        }
        return result;
    }

    public Long[] toLongArray(long[] values) {
        Long[] value = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            value[i] = values[i];
        }
        return value;
    }

    private Set<String> getMapValue(Map<String, String> selMap) {
        HashSet<String> aliasList = new HashSet<String>();
        aliasList.addAll(selMap.values());
        return aliasList;
    }

    private List<Long> getAccountTableIds(long[] orgIds, long bookTypeId) {
        QFilter orgFilter = new QFilter("org.id", "in", (Object)orgIds);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        ArrayList<Long> accounttableIds = new ArrayList<Long>(10);
        List orgIdList = Arrays.stream(orgIds).boxed().collect(Collectors.toList());
        try (DataSet set = BatchProcessUtil.batchQueryDataSet(orgIdList, k -> QueryServiceHelper.queryDataSet((String)"BalanceService", (String)"gl_accountbook", (String)"accounttable.id accounttableId", (QFilter[])new QFilter[]{bookFilter, new QFilter("org.id", "in", k)}, null));){
            for (Row row : set) {
                accounttableIds.add(row.getLong("accounttableId"));
            }
        }
        return accounttableIds;
    }

    private List<Map<String, Object>> trans2List(DataSet ds, Map<String, String> selAliasMap) {
        ArrayList<Map<String, Object>> rs = new ArrayList<Map<String, Object>>();
        HashSet<String> selector = new HashSet<String>(selAliasMap.values());
        int selSize = selector.size();
        for (Row row : ds) {
            HashMap<String, Object> rowData = new HashMap<String, Object>(selSize);
            for (String sel : selector) {
                rowData.put(sel, row.get(sel));
            }
            rs.add(rowData);
        }
        return rs;
    }

    private String getSelector(List<String> selector, Map<String, String> selAliasMap) {
        ArrayList<String> sels = new ArrayList<String>(10);
        HashSet<String> fs = new HashSet<String>();
        fs.addAll(selector);
        for (String f : fs) {
            String fieldName;
            String[] strs = f.trim().split("\\s+");
            String alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
            String name = strs[0].trim();
            String[] nameArray = name.split("\\.");
            String string = fieldName = nameArray.length == 0 ? name : nameArray[0];
            if (!this.balanceFields.contains(fieldName) && !fieldName.startsWith("comassist")) continue;
            sels.add(f);
            selAliasMap.put(name, alias);
        }
        return String.join((CharSequence)",", sels);
    }

    public List<String> getDSFileds(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String alias = field.getAlias();
            result.add(alias);
        }
        return result;
    }

    private static class ResultData {
        private Object rows;
        private Integer pageNo = 1;
        private Integer pageSize;
        private Object filter;
        private boolean lastPage;
        private Integer totalCount;

        public ResultData() {
            this.rows = null;
            this.pageNo = 1;
            this.pageSize = 1000;
            this.filter = null;
            this.lastPage = true;
            this.totalCount = 0;
        }

        public ResultData(Object rows, Integer pageNo, Integer pageSize, Object filter, boolean lastPage, Integer totalCount) {
            this.rows = rows;
            this.pageNo = pageNo;
            this.pageSize = pageSize;
            this.filter = filter;
            this.lastPage = lastPage;
            this.totalCount = totalCount;
        }

        public Object toMap() {
            HashMap<String, Object> data = new HashMap<String, Object>(6);
            data.put("rows", this.rows);
            data.put("pageNo", this.pageNo);
            data.put("pageSize", this.pageSize);
            data.put("filter", this.filter);
            data.put("lastPage", this.lastPage);
            data.put("totalCount", this.totalCount);
            return data;
        }

        public Object getRows() {
            return this.rows;
        }

        public void setRows(Object rows) {
            this.rows = rows;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Object getFilter() {
            return this.filter;
        }

        public void setFilter(Object filter) {
            this.filter = filter;
        }

        public boolean isLastPage() {
            return this.lastPage;
        }

        public void setLastPage(boolean lastPage) {
            this.lastPage = lastPage;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }
    }

    private static class Result {
        private boolean status;
        private String errorCode;
        private String message;
        private String requestId;
        private ResultData data;

        public Result() {
            this.status = true;
            this.errorCode = "";
            this.message = "";
            this.requestId = "";
            this.data = new ResultData();
        }

        public Result(boolean status, String errorCode, String message, String requestId, ResultData data) {
            this.status = status;
            this.errorCode = errorCode;
            this.message = message;
            this.requestId = requestId;
            this.data = data;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("status", this.status);
            result.put("errorCode", this.errorCode);
            result.put("message", this.message);
            result.put("requestId", this.requestId);
            result.put("data", this.data.toMap());
            return result;
        }

        public boolean isStatus() {
            return this.status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ResultData getData() {
            return this.data;
        }

        public void setData(ResultData data) {
            this.data = data;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }
    }
}

