/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.kpi.thread.FdaKpiWorkTask;
import kd.fi.gl.kpi.thread.FdaWorkTaskManager;
import kd.fi.gl.report.GLReportQueryParams;
import kd.fi.gl.service.FdaKpiService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class FdaKpiServiceImpl
implements FdaKpiService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private static final String GL_MANAGE_RPTITEM = "gl_manage_rptitem";

    public Map<Long, List<List<BigDecimal>>> getReportItemCalcValues(String reportTypeCode, Collection<Long> orgIds, Long orgViewId, Long acctBookTypeId, Long acctTableId, Long periodTypeId, Collection<Long> periodIds, int amtPrecision) {
        return TaxReportFormHelper.getReportItemCalcValues((GLReportQueryParams)new GLReportQueryParams(reportTypeCode, orgIds, this.geteChildOrgs(orgIds, orgViewId), orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodIds, Integer.valueOf(amtPrecision)));
    }

    public Map<Long, Map<String, BigDecimal[]>> getReportItemValues(String reportTypeCode, Collection<Long> orgIds, Long orgViewId, Long acctBookTypeId, Long acctTableId, Long periodTypeId, Collection<Long> periodIds, int amtPrecision) {
        return TaxReportFormHelper.getReportItemValues((GLReportQueryParams)new GLReportQueryParams(reportTypeCode, orgIds, this.geteChildOrgs(orgIds, orgViewId), orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodIds, Integer.valueOf(amtPrecision)));
    }

    private boolean checkNull(Collection<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long acctTableId, Long periodTypeId, Long periodId) {
        return orgIds != null && !orgIds.isEmpty() && childOrgSet != null && !childOrgSet.isEmpty() && orgViewId != null && bookTypeId != null && acctTableId != null && periodTypeId != null && periodId != null;
    }

    private Map<Object, DynamicObject> getAllKpiDynamicObjects(boolean isSys, Collection<Long> orgIds) {
        Long orgId = orgIds == null || orgIds.isEmpty() ? null : (Long)orgIds.toArray()[0];
        QFilter filter = QFilter.of((String)"enable = ? and status = ? ", (Object[])new Object[]{Character.valueOf('1'), Character.valueOf('C')}).and(QFilter.of((String)"reporttype like ? or reporttype like ? or reporttype like ? ", (Object[])new Object[]{"%income%", "%cashflow%", "%balancesheet%"}));
        QFilter preDataFilter = new QFilter("kpitype", "=", (Object)"1");
        if (isSys) {
            filter.and(preDataFilter);
        } else if (orgId != null) {
            QFilter permissionFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_business_analskpi", (Long)orgId);
            if (permissionFilter != null) {
                String permissionFilterStr = permissionFilter.toString();
                if (permissionFilterStr.indexOf("join") > -1) {
                    QFilter joinFilter = QFilter.joinSQL((String)"gl_business_analskpi", (String)permissionFilterStr, (Object[])new Object[0]);
                    filter.and(joinFilter).or(preDataFilter);
                } else {
                    filter.and(permissionFilter).or(preDataFilter);
                }
            } else {
                filter.or(preDataFilter);
            }
        } else {
            filter.and("status", "=", (Object)"A");
        }
        return BusinessDataServiceHelper.loadFromCache((String)"gl_business_analskpi", (String)"number,desp,name, reporttype, org", (QFilter[])filter.toArray());
    }

    public String getKpi(Collection<Long> orgIds, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        return this.getKpi(orgIds, this.geteChildOrgs(orgIds, orgViewId), orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
    }

    public String getKpi(Collection<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtPrecision) {
        this.log.info("\u603b\u8d26\u6307\u6807\u8fd4\u56de\u5165\u53c2\u6570\u636e\uff1aorgIds-" + orgIds + "\uff0cchildOrgSet-" + childOrgSet + "\uff0corgViewId-" + orgViewId + "\uff0cbookTypeId-" + bookTypeId + "\uff0caccTableId-" + accTableId + "\uff0cperiodTypeId-" + periodTypeId + "\uff0cperiodId-" + periodId + "\uff0camtPrecision-" + amtPrecision);
        if (!this.checkNull(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId)) {
            return null;
        }
        try {
            Map<Object, DynamicObject> kpis = this.getAllKpiDynamicObjects(false, orgIds);
            this.log.info("\u7ec4\u7ec7\uff1a" + orgIds + "\u603b\u8d26\u6307\u6807\u8fd4\u56de\u8d22\u52a1\u6307\u6807\u6570\u636e\uff1a" + JSONUtils.toString(kpis));
            Map<String, BigDecimal> itemValue = this.getItemfromKpiDesp(kpis, orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtPrecision);
            this.log.info("\u7ec4\u7ec7\uff1a" + orgIds + "\u603b\u8d26\u6307\u6807\u8fd4\u56de\u62a5\u8868\u503c\u6570\u636e\uff1a" + JSONUtils.toString(itemValue));
            Map<String, Map<String, Object>> resultMap = this.getKpiResultByItemValue(itemValue, kpis.values());
            String data = JSONUtils.toString(resultMap);
            this.log.info("\u603b\u8d26\u6307\u6807\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\uff1a" + data);
            return data;
        }
        catch (Exception e) {
            this.log.info("\u603b\u8d26\u6307\u6807\u53d6\u6570\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a" + GLUtil.printError((Throwable)e));
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Map<String, BigDecimal> getItemfromKpiDesp(Map<Object, DynamicObject> kpis, Collection<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtPrecision) {
        ArrayList<String> desps = new ArrayList<String>(kpis.size());
        for (DynamicObject kpi : kpis.values()) {
            desps.add(kpi.getString("desp"));
        }
        Set<String> itemSet = this.getAllItems(desps);
        HashSet<String> items = new HashSet<String>(itemSet.size());
        for (String item : itemSet) {
            items.add(item.substring(0, item.length() - 1));
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)GL_MANAGE_RPTITEM, (String)"id,rptunit", (QFilter[])new QFilter("number", "in", items).toArray());
        HashSet<String> reportTypes = new HashSet<String>();
        for (DynamicObject item : dyns) {
            reportTypes.add(item.getString("rptunit"));
        }
        Map<String, BigDecimal> itemValue = this.getReportItemValues(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, reportTypes, amtPrecision);
        return itemValue;
    }

    private Set<Long> geteChildOrgs(Collection<Long> orgIds, Long orgViewId) {
        if (orgIds == null || orgIds.isEmpty() || orgViewId == null) {
            return null;
        }
        Set childOrgSet = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, new HashSet<Long>(orgIds), (boolean)true);
        Map viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        Map orgBTMap = (Map)viewOrgBTMap.get(orgViewId);
        if (orgBTMap != null) {
            childOrgSet.retainAll(orgBTMap.keySet());
        }
        return childOrgSet;
    }

    public String getKpi(String param) {
        return null;
    }

    public String translateDesc(String desp, Map<String, BigDecimal> itemValue) {
        HashSet<String> desps = new HashSet<String>();
        Pattern p = Pattern.compile("\\d{7}");
        Matcher m = p.matcher(desp);
        while (m.find()) {
            desps.add(m.group());
        }
        for (String des : desps) {
            if (itemValue.get(des) != null) {
                desp = desp.replace(des, itemValue.get(des) + "");
                continue;
            }
            desp = desp.replace(des, "0");
        }
        return desp;
    }

    private Map<String, Map<String, Object>> getKpiResultByItemValue(Map<String, BigDecimal> itemValue, Collection<DynamicObject> collection) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(collection.size());
        for (DynamicObject kpi : collection) {
            Double value;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String desp = kpi.getString("desp");
            desp = this.translateDesc(desp, itemValue);
            try {
                value = Double.parseDouble(FormulaEngine.execExcelFormula((String)desp) + "");
                if ("Infinity".equals(value + "")) {
                    value = null;
                }
            }
            catch (Exception e) {
                value = null;
            }
            if ("Infinity".equals(value + "") || "-Infinity".equals(value + "")) {
                value = null;
            }
            map.put("number", kpi.getString("number"));
            map.put("value", value == null ? "" : value);
            map.put("name", kpi.getString("name"));
            resultMap.put(kpi.getString("number"), map);
        }
        return resultMap;
    }

    private Map<String, BigDecimal> getReportItemValues(Collection<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, Set<String> reportTypes, int amtprecision) {
        FdaKpiWorkTask kpiWorkTask;
        FdaWorkTaskManager taskManager = FdaWorkTaskManager.getInstance();
        ArrayList taskList = new ArrayList();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (reportTypes.contains("gl_balancesheet")) {
            kpiWorkTask = new FdaKpiWorkTask(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, "gl_balancesheet", amtprecision);
            taskList.add(taskManager.submit(kpiWorkTask));
        }
        if (reportTypes.contains("gl_showincome")) {
            kpiWorkTask = new FdaKpiWorkTask(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, "gl_showincome", amtprecision);
            taskList.add(taskManager.submit(kpiWorkTask));
        }
        if (reportTypes.contains("gl_cashflowstat")) {
            kpiWorkTask = new FdaKpiWorkTask(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, "gl_cashflowstat", amtprecision);
            taskList.add(taskManager.submit(kpiWorkTask));
        }
        if (!taskList.isEmpty()) {
            for (Future future : taskList) {
                try {
                    map.putAll((Map)future.get());
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return map;
    }

    private Set<String> getAllItems(List<String> desps) {
        HashSet<String> itemSet = new HashSet<String>();
        Pattern p = Pattern.compile("\\d{7}");
        for (String desp : desps) {
            Matcher m = p.matcher(desp);
            while (m.find()) {
                itemSet.add(m.group());
            }
        }
        return itemSet;
    }
}

