/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acccurrent.AcccurrentQueryExecutor;
import kd.fi.gl.acccurrentfloat.AcccurrentFloatQueryExecutor;
import kd.fi.gl.acct.action.AcctBalParseAction;
import kd.fi.gl.acct.param.ReClassParam;
import kd.fi.gl.acctfloat.AcctQueryExecutor;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.service.CashflowServiceImpl;
import kd.fi.gl.service.ReClassBalanceService;
import org.apache.commons.io.IOUtils;

public class ReClassBalanceServiceImpl
implements ReClassBalanceService {
    private final Log log = LogFactory.getLog((String)"BCMBalanceParamParseUtils");

    public String getBalance(String formulaName, String acctStr) {
        String resultStr = null;
        try {
            Map<Object, Object> result = new HashMap();
            long beforeTime = System.currentTimeMillis();
            this.log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u5f00\u59cb\uff1a" + beforeTime);
            this.log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u53c2\u6570\uff1a" + acctStr);
            if (StringUtils.isBlank((CharSequence)acctStr)) {
                return ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"ReClassBalanceServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]);
            }
            ReClassParam param = new ReClassParam(acctStr);
            Map acctMap = (Map)JSONUtils.cast((String)acctStr, Map.class);
            if (!"ACCT".equalsIgnoreCase(acctMap.get("formulaName").toString())) {
                return String.format(ResManager.loadKDString((String)"\u975eACCT\u53d6\u6570\u53c2\u6570\uff0c\u4f20\u8f93\u53c2\u6570\u4e3a%s\u3002", (String)"ReClassBalanceServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0]), acctMap.get("formulaName").toString());
            }
            AcctBalParseAction utils = new AcctBalParseAction();
            result = utils.parseParam(param);
            resultStr = JSONUtils.toString(result);
            long afterTime = System.currentTimeMillis();
            this.log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u7ed3\u679c\uff1a" + result.toString());
            this.log.info("\u603b\u8d26\u91cd\u5206\u7c7b\u53d6\u6570\u7ed3\u675f\uff1a" + afterTime + "\u82b1\u8d39\u65f6\u95f4\uff1a" + (afterTime - beforeTime));
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws ParseException, IOException {
        InputStream formula_def_list = null;
        String formula_def = "";
        InputStream formula_catalog_list = null;
        String formula_catalog = "";
        try {
            formula_def_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/rpt_formulas_list.json");
            if (formula_def_list != null) {
                formula_def = IOUtils.toString((InputStream)formula_def_list);
            }
        }
        finally {
            if (formula_def_list != null) {
                formula_def_list.close();
            }
        }
        try {
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/rpt_formulas_catalog_list.json");
            if (formula_catalog_list != null) {
                formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
            }
        }
        finally {
            if (formula_catalog_list != null) {
                formula_catalog_list.close();
            }
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)formula_def) && StringUtils.isNotEmpty((CharSequence)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        String configStr = SerializationUtils.toJsonString(configMap);
        return configStr;
    }

    public String dipatchCal(String formulaName, String param) {
        long beforeTime = System.currentTimeMillis();
        this.log.info("acct dipatchCal begin time\uff1a" + beforeTime);
        this.log.info("acct dipatchCal param\uff1a" + param);
        String result = "";
        if ("ACCT".equalsIgnoreCase(formulaName)) {
            result = this.getBalance(formulaName, param);
        } else if ("acctage".equalsIgnoreCase(formulaName)) {
            result = AcccurrentQueryExecutor.getInstance().getBalance(param);
        } else {
            CashflowServiceImpl cashflowService = new CashflowServiceImpl();
            result = cashflowService.getCashFlowAmountFromBCM(param);
        }
        long afterTime = System.currentTimeMillis();
        if (DebugTrace.enable()) {
            this.log.info("acct dipatchCal result\uff1a" + result);
        }
        this.log.info("acct dipatchCal end time\uff1a" + afterTime + " cost time\uff1a" + (afterTime - beforeTime));
        return result;
    }

    public String dispatchBatchCal(String formulaName, String param) {
        long beforeTime = System.currentTimeMillis();
        this.log.info("acct dispatchBatchCal begin time\uff1a" + beforeTime);
        this.log.info("acct dispatchBatchCal param\uff1a" + param);
        if (StringUtils.isBlank((CharSequence)param)) {
            return ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"ReClassBalanceServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]);
        }
        String result = "";
        if ("ACCT".equalsIgnoreCase(formulaName)) {
            result = AcctQueryExecutor.getInstance().getBalance(param);
        } else if ("acctage".equalsIgnoreCase(formulaName)) {
            result = AcccurrentFloatQueryExecutor.getInstance().getBalance(param);
        }
        long afterTime = System.currentTimeMillis();
        if (DebugTrace.enable()) {
            this.log.info("acct dispatchBatchCal result\uff1a" + result);
        }
        this.log.info("acct dispatchBatchCal end time\uff1a" + afterTime + " cost time\uff1a" + (afterTime - beforeTime));
        return result;
    }
}

