/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.synvoucher;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.fi.gl.business.service.synbook.VoucherRefTrackerService;
import kd.fi.gl.business.vo.synbook.VoucherRefTrackerVO;
import kd.fi.gl.util.TipsUtils;

public class VoucherRefTrackerCollector
implements AutoCloseable {
    private final List<VoucherRefTrackerVO> voucherRefTrackerVOList;
    private boolean closeStatus = false;

    public VoucherRefTrackerCollector(int initialCapacity) {
        this.voucherRefTrackerVOList = new ArrayList<VoucherRefTrackerVO>(initialCapacity);
    }

    public void addTracker(Long sourceVoucherId, Long targetBookId, String msg) {
        this.ensureCloseStatus();
        msg = TipsUtils.safeTruncate((String)msg, (int)500, (DBRoute)DBRoute.of((String)"fi"));
        VoucherRefTrackerVO voucherRefTrackerVO = new VoucherRefTrackerVO(RequestContext.get().getUserName(), msg, new Date(), sourceVoucherId.longValue(), targetBookId.longValue());
        this.voucherRefTrackerVOList.add(voucherRefTrackerVO);
    }

    private void ensureCloseStatus() {
        if (this.closeStatus) {
            throw new IllegalStateException("Collector was already closed.");
        }
    }

    @Override
    public void close() {
        if (this.closeStatus || this.voucherRefTrackerVOList.isEmpty()) {
            return;
        }
        VoucherRefTrackerService.clearAndSaveVoucherRefTrackers(this.voucherRefTrackerVOList);
        this.closeStatus = true;
    }
}

