/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.orm.util.CollectionUtils;

public class AccountQuickSearchDs
implements AutoCloseable {
    private Map<String, Map<Long, List<Row>>> ds;
    private Map<String, Set<Long>> hgIdCache = new HashMap<String, Set<Long>>(16);
    private Map<String, Optional<DataSet>> dataSetCache = new HashMap<String, Optional<DataSet>>(16);
    private RowMeta dsRowMeta = null;

    public AccountQuickSearchDs(Map<String, DataSet> keyBalSetMap) {
        if (CollectionUtils.isEmpty(keyBalSetMap)) {
            this.ds = Collections.EMPTY_MAP;
        }
        this.ds = new HashMap<String, Map<Long, List<Row>>>(keyBalSetMap.size());
        for (Map.Entry<String, DataSet> originEntry : keyBalSetMap.entrySet()) {
            DataSet allAccountDs = originEntry.getValue();
            Throwable throwable = null;
            try {
                if (Objects.isNull(this.dsRowMeta)) {
                    this.dsRowMeta = allAccountDs.getRowMeta();
                }
                HashMap accountMap = new HashMap(16);
                int cols = this.dsRowMeta.getFieldCount();
                while (allAccountDs.hasNext()) {
                    Row row = allAccountDs.next();
                    Long account = row.getLong("account");
                    if (Objects.isNull(account)) continue;
                    if (!accountMap.containsKey(account)) {
                        accountMap.put(account, new ArrayList(16));
                    }
                    Object[] values = new Object[cols];
                    for (int i = 0; i < cols; ++i) {
                        values[i] = row.get(i);
                    }
                    ((List)accountMap.get(account)).add(new PersistedArrayRow(this.dsRowMeta, values, false));
                }
                this.ds.put(originEntry.getKey(), accountMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (allAccountDs == null) continue;
                if (throwable != null) {
                    try {
                        allAccountDs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                allAccountDs.close();
            }
        }
        keyBalSetMap.clear();
    }

    public Set<Long> getAvailableHgIds(String key, Collection<Long> accountIds, long currencyId) {
        if (!this.ds.containsKey(key)) {
            throw new IllegalArgumentException(String.format("parameter key=%s invalid.", key));
        }
        String cacheKey = this.buildCacheKey(key, accountIds, currencyId);
        if (!this.hgIdCache.containsKey(cacheKey)) {
            List<Row> rebuildDsRows = this.collectFilterRows(key, accountIds, currencyId);
            Set<Object> filterAccs = new HashSet(16);
            filterAccs = CollectionUtils.isEmpty(rebuildDsRows) ? Collections.EMPTY_SET : rebuildDsRows.stream().map(x -> x.getLong("hg")).collect(Collectors.toSet());
            this.hgIdCache.put(cacheKey, filterAccs);
        }
        return this.hgIdCache.get(cacheKey);
    }

    public Optional<DataSet> rebuildDatasetByFilter(String key, Collection<Long> accountIds, long currencyId) {
        Optional<DataSet> cacheResult;
        if (!this.ds.containsKey(key)) {
            throw new IllegalArgumentException(String.format("parameter key=%s invalid.", key));
        }
        String cacheKey = this.buildCacheKey(key, accountIds, currencyId);
        if (!this.dataSetCache.containsKey(cacheKey)) {
            Optional<Object> cacheValue;
            List<Row> rebuildDsRows = this.collectFilterRows(key, accountIds, currencyId);
            if (CollectionUtils.isEmpty(rebuildDsRows)) {
                cacheValue = Optional.empty();
            } else {
                Algo algo = Algo.create((String)(AccountQuickSearchDs.class.getName() + ".rebuild"));
                DataSetBuilder builder = algo.createDataSetBuilder(this.dsRowMeta);
                rebuildDsRows.stream().forEach(row -> builder.append(row));
                cacheValue = Optional.of(builder.build());
            }
            this.dataSetCache.put(cacheKey, cacheValue);
        }
        if ((cacheResult = this.dataSetCache.get(cacheKey)).isPresent()) {
            return Optional.of(cacheResult.get().copy());
        }
        return Optional.empty();
    }

    private String buildCacheKey(String key, Collection<Long> accountIds, long currencyId) {
        ArrayList<Long> sortedAccounts = new ArrayList<Long>(new HashSet<Long>(accountIds));
        Collections.sort(sortedAccounts);
        return String.format("key_%s,accs_%s,currency_%s", key, String.join((CharSequence)"|", sortedAccounts.stream().map(x -> String.valueOf(x)).collect(Collectors.toList())), currencyId);
    }

    private List<Row> collectFilterRows(String key, Collection<Long> accountIds, long currencyId) {
        Map<Long, List<Row>> subAccountRows = this.ds.get(key);
        ArrayList<Row> rebuildDsRows = new ArrayList<Row>(100);
        if (CollectionUtils.isEmpty(accountIds)) {
            subAccountRows.values().stream().forEach(x -> rebuildDsRows.addAll((Collection<Row>)x));
        } else {
            new HashSet<Long>(accountIds).stream().forEach(accId -> {
                if (!CollectionUtils.isEmpty((Collection)((Collection)subAccountRows.get(accId)))) {
                    rebuildDsRows.addAll((Collection)subAccountRows.get(accId));
                }
            });
        }
        if (currencyId > 0L) {
            rebuildDsRows.removeIf(x -> currencyId != x.getLong("currency"));
        }
        return rebuildDsRows;
    }

    @Override
    public void close() throws Exception {
        if (!this.hgIdCache.isEmpty()) {
            this.hgIdCache.clear();
        }
        this.dataSetCache.entrySet().forEach(x -> {
            Optional pds = (Optional)x.getValue();
            if (pds.isPresent()) {
                ((DataSet)pds.get()).close();
            }
        });
        this.dataSetCache.clear();
    }
}

