/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.orm.util.CollectionUtils;

public class AssitQuickSearchDs {
    private static final String ASSISTTXT = "gl_assist_txt";
    private Map<String, Map<Long, List<Row>>> ds;
    private Map<String, List<Row>> flexValueRowMap = new HashMap<String, List<Row>>(1000);

    public AssitQuickSearchDs() {
        this.ds = new HashMap<String, Map<Long, List<Row>>>(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInvolve(String flex, DataSet assistDs) {
        try {
            HashMap assistMap = new HashMap(16);
            RowMeta dsRowMeta = assistDs.getRowMeta();
            int cols = dsRowMeta.getFieldCount();
            while (assistDs.hasNext()) {
                Row row = assistDs.next();
                Long hgId = row.getLong("hg");
                if (Objects.isNull(hgId)) continue;
                if (!assistMap.containsKey(hgId)) {
                    assistMap.put(hgId, new ArrayList(16));
                }
                Object[] values = new Object[cols];
                for (int i = 0; i < cols; ++i) {
                    values[i] = row.get(i);
                }
                PersistedArrayRow lightRow = new PersistedArrayRow(dsRowMeta, values, false);
                ((List)assistMap.get(hgId)).add(lightRow);
                Object flexValue = row.get(flex);
                String flexValueKey = this.buildFlexFilterKey(flex, flexValue);
                if (!this.flexValueRowMap.containsKey(flexValueKey)) {
                    this.flexValueRowMap.put(flexValueKey, new ArrayList(8));
                }
                this.flexValueRowMap.get(flexValueKey).add((Row)lightRow);
            }
            this.ds.put(flex, assistMap);
        }
        finally {
            if (Objects.nonNull(assistDs)) {
                assistDs.close();
            }
        }
    }

    public Optional<DataSet> rebuildDatasetByFilter(String entityId, String flex, Collection<Long> hgIds) {
        if (!this.ds.containsKey(flex)) {
            return Optional.empty();
        }
        Map<Long, List<Row>> assistRowsMap = this.ds.get(flex);
        ArrayList rebuildDsRows = new ArrayList(100);
        if (CollectionUtils.isEmpty(hgIds)) {
            return Optional.empty();
        }
        new HashSet<Long>(hgIds).stream().forEach(hgId -> {
            if (Objects.nonNull(assistRowsMap.get(hgId))) {
                rebuildDsRows.addAll((Collection)assistRowsMap.get(hgId));
            }
        });
        if (CollectionUtils.isEmpty(rebuildDsRows)) {
            return Optional.empty();
        }
        Algo algo = Algo.create((String)(AssitQuickSearchDs.class.getName() + ".rebuild"));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"hg", flex}, (DataType[])new DataType[]{DataType.LongType, ASSISTTXT.equals(entityId) ? DataType.StringType : DataType.LongType});
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        rebuildDsRows.stream().forEach(row -> builder.append(row));
        return Optional.of(builder.build());
    }

    private String buildFlexFilterKey(String flex, Object flexValue) {
        return String.format("%s_%s", flex, String.valueOf(flexValue));
    }

    public Optional<DataSet> rebuildDatasetByFlex(String entityId, String flex, Collection<Object> flexValues, Set<Long> availableHgIds) {
        if (!this.ds.containsKey(flex)) {
            return Optional.empty();
        }
        if (CollectionUtils.isEmpty(flexValues)) {
            return this.rebuildDatasetByFilter(entityId, flex, availableHgIds);
        }
        Set flexFilterKeys = flexValues.stream().map(x -> this.buildFlexFilterKey(flex, x)).collect(Collectors.toSet());
        ArrayList rebuildDsRows = new ArrayList(100);
        this.flexValueRowMap.entrySet().stream().filter(x -> flexFilterKeys.contains(x.getKey())).forEach(entry -> rebuildDsRows.addAll(((List)entry.getValue()).stream().filter(y -> availableHgIds.contains(y.getLong("hg"))).collect(Collectors.toList())));
        if (CollectionUtils.isEmpty(rebuildDsRows)) {
            return Optional.empty();
        }
        Algo algo = Algo.create((String)(AssitQuickSearchDs.class.getName() + ".rebuild"));
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"hg", flex}, (DataType[])new DataType[]{DataType.LongType, ASSISTTXT.equals(entityId) ? DataType.StringType : DataType.LongType});
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        rebuildDsRows.stream().forEach(row -> builder.append(row));
        return Optional.of(builder.build());
    }
}

