/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class BCMBalanceIndex {
    protected static final String[] BALANCE_INDEX = new String[]{"account", "currency", "hg", "beginfor", "beginlocal", "beginqty", "endfor", "endlocal", "endqty", "yeardebitfor", "yeardebitlocal", "yeardebitqty", "yearcreditfor", "yearcreditlocal", "yearcreditqty", "debitfor", "debitlocal", "debitqty", "creditfor", "creditlocal", "creditqty"};
    protected static final Map<String, Object[]> FETCHJTYPE_INDEX = new HashMap<String, Object[]>();

    public static BigDecimal rowCountByFetchType(Row row, String fetchType, boolean isBaseCurrency) {
        Object[] fieldIndex;
        String _ALL = "";
        if (isBaseCurrency) {
            _ALL = "_ALL";
        }
        if ((fieldIndex = FETCHJTYPE_INDEX.get(fetchType + _ALL)) == null) {
            throw new KDBizException(String.format("%1$s %2$s", ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"BCMBalanceIndex_0", (String)"fi-gl-mservice", (Object[])new Object[0]), fetchType));
        }
        int index0 = (Integer)fieldIndex[0];
        BigDecimal obj = row.getBigDecimal(BALANCE_INDEX[index0]);
        BigDecimal result = obj == null ? new BigDecimal("0") : obj;
        for (int i = 1; i < fieldIndex.length; ++i) {
            if (i % 2 != 1) continue;
            String flag = (String)fieldIndex[i];
            int index = (Integer)fieldIndex[i + 1];
            if ("+".equals(flag)) {
                result = result.add(row.getBigDecimal(BALANCE_INDEX[index]));
                continue;
            }
            if (!"-".equals(flag)) continue;
            result = result.subtract(row.getBigDecimal(BALANCE_INDEX[index]));
        }
        return result;
    }

    static {
        FETCHJTYPE_INDEX.put("C", new Object[]{3});
        FETCHJTYPE_INDEX.put("C_ALL", new Object[]{4});
        FETCHJTYPE_INDEX.put("Y", new Object[]{6});
        FETCHJTYPE_INDEX.put("Y_ALL", new Object[]{7});
        FETCHJTYPE_INDEX.put("JF", new Object[]{15});
        FETCHJTYPE_INDEX.put("JF_ALL", new Object[]{16});
        FETCHJTYPE_INDEX.put("DF", new Object[]{18});
        FETCHJTYPE_INDEX.put("DF_ALL", new Object[]{19});
        FETCHJTYPE_INDEX.put("JL", new Object[]{9});
        FETCHJTYPE_INDEX.put("JL_ALL", new Object[]{10});
        FETCHJTYPE_INDEX.put("DL", new Object[]{12});
        FETCHJTYPE_INDEX.put("DL_ALL", new Object[]{13});
        FETCHJTYPE_INDEX.put("QC", new Object[]{5});
        FETCHJTYPE_INDEX.put("QC_ALL", new Object[]{5});
        FETCHJTYPE_INDEX.put("QY", new Object[]{8});
        FETCHJTYPE_INDEX.put("QY_ALL", new Object[]{8});
        FETCHJTYPE_INDEX.put("QJF", new Object[]{17});
        FETCHJTYPE_INDEX.put("QJF_ALL", new Object[]{17});
        FETCHJTYPE_INDEX.put("QDF", new Object[]{20});
        FETCHJTYPE_INDEX.put("QDF_ALL", new Object[]{20});
        FETCHJTYPE_INDEX.put("QJL", new Object[]{11});
        FETCHJTYPE_INDEX.put("QJL_ALL", new Object[]{11});
        FETCHJTYPE_INDEX.put("QDL", new Object[]{14});
        FETCHJTYPE_INDEX.put("QDL_ALL", new Object[]{14});
        FETCHJTYPE_INDEX.put("CY", new Object[]{6, "-", 9, "+", 12});
        FETCHJTYPE_INDEX.put("CY_ALL", new Object[]{7, "-", 10, "+", 13});
        FETCHJTYPE_INDEX.put("JFCY", new Object[]{6, "-", 9, "+", 12});
        FETCHJTYPE_INDEX.put("JFCY_ALL", new Object[]{7, "-", 10, "+", 13});
        FETCHJTYPE_INDEX.put("DFCY", new Object[]{6, "-", 9, "+", 12});
        FETCHJTYPE_INDEX.put("DFCY_ALL", new Object[]{7, "-", 10, "+", 13});
        FETCHJTYPE_INDEX.put("JC", new Object[]{3});
        FETCHJTYPE_INDEX.put("JC_ALL", new Object[]{4});
        FETCHJTYPE_INDEX.put("DC", new Object[]{3});
        FETCHJTYPE_INDEX.put("DC_ALL", new Object[]{4});
        FETCHJTYPE_INDEX.put("JY", new Object[]{6});
        FETCHJTYPE_INDEX.put("JY_ALL", new Object[]{7});
        FETCHJTYPE_INDEX.put("DY", new Object[]{6});
        FETCHJTYPE_INDEX.put("DY_ALL", new Object[]{7});
        FETCHJTYPE_INDEX.put("FS", new Object[]{15, "-", 18});
        FETCHJTYPE_INDEX.put("FS_ALL", new Object[]{16, "-", 19});
        FETCHJTYPE_INDEX.put("SY", new Object[]{15, "-", 18});
        FETCHJTYPE_INDEX.put("SY_ALL", new Object[]{16, "-", 19});
        FETCHJTYPE_INDEX.put("LJ", new Object[]{9, "-", 12});
        FETCHJTYPE_INDEX.put("LJ_ALL", new Object[]{10, "-", 13});
        FETCHJTYPE_INDEX.put("SL", new Object[]{9, "-", 12});
        FETCHJTYPE_INDEX.put("SL_ALL", new Object[]{10, "-", 13});
    }
}

