/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FdaFormUtil {
    public static DynamicObject getCurYearMaxPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static BigDecimal setScale(BigDecimal val, int scale) {
        if (val == null) {
            return val;
        }
        return val.setScale(scale, 4);
    }

    public static DynamicObject getSamePeriodOfYear(long curperiodID, int beforeValue) {
        QFilter filterNum2;
        QFilter filterYear2;
        DynamicObject result = null;
        String entityName = "bd_period";
        String selector = "id,name,periodtype,periodyear,periodnumber,begindate,enddate";
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curperiodID)});
        if (taskObjs == null || taskObjs.length == 0) {
            return result;
        }
        DynamicObject curPeriod = taskObjs[0];
        QFilter filterType2 = new QFilter("periodtype", "=", curPeriod.get("periodtype_id"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl.glutil.samePeriodOfYear", (String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType2, filterYear2 = new QFilter("periodyear", "=", (Object)(curPeriod.getInt("periodyear") - beforeValue)), filterNum2 = new QFilter("periodnumber", "=", (Object)curPeriod.getInt("periodnumber"))}, null);
        if (cols.size() > 0) {
            result = (DynamicObject)cols.get(0);
        }
        return result;
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
            if (coll == null || coll.isEmpty()) {
                return null;
            }
            return (DynamicObject)coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }
}

