/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ReClassUtils {
    public static final int BATCH_COUNT = 1000;

    public static Map<String, Long> numbersToIds(String entityName, Set<String> numbers, List<QFilter> filters) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (filters != null && !filters.isEmpty()) {
            qFilters.addAll(filters);
        }
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        if (numbers.size() < 1000) {
            ReClassUtils.queryNumber(entityName, numbers, qFilters, numberToIdMap);
        } else {
            HashSet<String> batchNumbers = new HashSet<String>(1028);
            for (String number : numbers) {
                batchNumbers.add(number);
                if (batchNumbers.size() < 1000) continue;
                ReClassUtils.queryNumber(entityName, numbers, qFilters, numberToIdMap);
                batchNumbers.clear();
            }
            if (!batchNumbers.isEmpty()) {
                ReClassUtils.queryNumber(entityName, numbers, qFilters, numberToIdMap);
            }
        }
        return numberToIdMap;
    }

    public static void queryNumber(String entityName, Set<String> numbers, List<QFilter> filters, Map<String, Long> numberToIdMap) {
        if (numbers != null && numbers.size() > 0) {
            QFilter filter = new QFilter("number", "in", numbers);
            filters.add(filter);
        }
        DataSet querySet = ReClassUtils.queryDataSet(entityName, "number, id", filters);
        for (Row row : querySet) {
            numberToIdMap.put(row.getString("number"), row.getLong("id"));
        }
    }

    public static Map<String, Long> numbersToMasterids(String entityName, Set<String> numbers, List<QFilter> filters) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (filters != null && !filters.isEmpty()) {
            qFilters.addAll(filters);
        }
        String number = "number";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (mainEntityType instanceof BasedataEntityType) {
            number = ((BasedataEntityType)mainEntityType).getNumberProperty();
        }
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        if (numbers != null && numbers.size() > 0) {
            QFilter filter = new QFilter(number, "in", numbers);
            qFilters.add(filter);
        }
        String idField = "id";
        if (ReClassUtils.hasMasteridProp(entityName)) {
            idField = "masterid";
        }
        DataSet querySet = ReClassUtils.queryDataSet(entityName, number + "," + idField, qFilters);
        for (Row row : querySet) {
            numberToIdMap.put(row.getString(number), row.getLong(idField));
        }
        return numberToIdMap;
    }

    public static boolean hasMasteridProp(String entityId) {
        if ("bos_assistantdata_detail".equals(entityId)) {
            return true;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicProperty masterid = type.getProperty("masterid");
        return Objects.nonNull(masterid) && Objects.nonNull(masterid.getAlias());
    }

    public static DataSet queryDataSet(String entityName, String selFields, List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)selFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return dataSet;
    }

    public static boolean isContinueNumber(String acctAssistListStr) {
        return acctAssistListStr.contains("[") && acctAssistListStr.contains("]") || ReClassUtils.isCollectionNumber(acctAssistListStr);
    }

    public static boolean isCollectionNumber(String acctAssistListStr) {
        return !StringUtils.isBlank((String)acctAssistListStr) && acctAssistListStr.endsWith("#") && acctAssistListStr.split("#").length == 2;
    }

    public static DataSet queryAssistByBal(String entityId, String selFields, long orgId, List<QFilter> filters, String fieldEntity) {
        try {
            MainEntityType entityType = (MainEntityType)EntityMetadataCache.getDataEntityType((String)entityId).clone();
            DynamicObjectType type = (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)fieldEntity).clone();
            BasedataProp prop = new BasedataProp();
            String fieldKey = "assgrp_balance";
            prop.setAlias("fid");
            prop.setName(fieldKey);
            prop.setComplexType((IDataEntityType)type);
            entityType.addProperty((DynamicProperty)prop);
            type.getProperty("id").setAlias("fassgrpid");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            qFilters.addAll(filters);
            QFilter assgrpFilter = QFilter.join((String)"hg", (String)(fieldKey + ".assgrp"), (QFilter)new QFilter(fieldKey + ".org", "=", (Object)orgId), (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)false);
            qFilters.add(assgrpFilter);
            if (fieldEntity.equals("gl_balance_log")) {
                qFilters.add(new QFilter(fieldKey + ".calculated", "=", (Object)Character.valueOf('0')));
            }
            ORM orm = ORM.create();
            orm.setDataEntityType(entityId, (IDataEntityType)entityType);
            DataSet asssitSet = orm.queryDataSet("ReClassUtils.queryAssistByBal()", entityId, selFields, qFilters.toArray(new QFilter[qFilters.size()]), null);
            return asssitSet;
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException("ReClassUtils.queryAssistByBal() query ACCT assist join balance error!");
        }
    }
}

