/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.formplugin.comassist.ComAssistListDataProvider;
import kd.fi.gl.util.AccountBookHelper;
import kd.fi.gl.util.QFBuilder;

class ListVoucherNumber
extends ComAssistListDataProvider {
    private static final String VOUCHERNUM = "vouchernumber";
    private String formId;

    public ListVoucherNumber(String paramsName, IFormView view) {
        super(view);
        this.formId = paramsName;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(VOUCHERNUM, String.class, (Object)""));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            ids.add((Long)row.getPkValue());
        }
        Map<String, String> idAndVouncherNumber = this.getVouncherNumber(ids);
        if (idAndVouncherNumber != null && idAndVouncherNumber.size() > 0) {
            for (DynamicObject row : rows) {
                row.set(VOUCHERNUM, (Object)idAndVouncherNumber.get(row.getPkValue().toString()));
            }
        }
        return rows;
    }

    public String getFormId() {
        return this.formId;
    }

    private Map<String, String> getVouncherNumber(List<Long> sourceBillIdList) {
        if (CollectionUtils.isEmpty(sourceBillIdList)) {
            return null;
        }
        String bookTypeField = FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)this.getFormId());
        DynamicObject[] sourceBillDynObjs = BusinessDataServiceHelper.load((String)this.getFormId(), (String)("org," + bookTypeField), (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdList)});
        if (sourceBillDynObjs.length == 0) {
            return null;
        }
        List orgIDs = Arrays.stream(sourceBillDynObjs).map(schemeDyo -> schemeDyo.getLong("org.id")).collect(Collectors.toList());
        List bookTypeIDs = Arrays.stream(sourceBillDynObjs).map(schemeDyo -> schemeDyo.getLong(bookTypeField + ".id")).collect(Collectors.toList());
        Map curPeriodRepo = AccountBookHelper.get().queryAcctBooks(orgIDs, bookTypeIDs, "curperiod");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("srcentity", "in", sourceBillIdList);
        HashMap srcId2Period2VchId = new HashMap(sourceBillIdList.size());
        try (DataSet relationDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucherrelation", (String)String.join((CharSequence)",", "targentity", "srcentity", "period"), (QFilter[])qfBuilder.toArray(), (String)"id");){
            for (Row row : relationDataSet) {
                Long srcBillId = row.getLong("srcentity");
                Long periodId = row.getLong("period");
                srcId2Period2VchId.putIfAbsent(srcBillId, new HashMap(16));
                ((Map)srcId2Period2VchId.get(srcBillId)).putIfAbsent(periodId, new ArrayList(8));
                ((List)((Map)srcId2Period2VchId.get(srcBillId)).get(periodId)).add(row.getLong("targentity"));
            }
        }
        Collection voucherIdCollection = srcId2Period2VchId.values().stream().flatMap(x -> x.values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<Long, String> voucherIdPeriodVoucherNoMap = new HashMap<Long, String>(voucherIdCollection.size());
        qfBuilder.clear();
        qfBuilder.add("id", "in", (Object)voucherIdCollection);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet voucherDataSet = VoucherQueryUtils.queryDataSet((String)String.join((CharSequence)",", "id", "period", "billno"), (QFilter[])qfBuilder.toArray(), null, (int)-1);){
            for (Row row : voucherDataSet) {
                voucherIdPeriodVoucherNoMap.put(row.getLong("id"), row.getString("billno"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        HashMap<String, String> sourceBillIdVoucherNoMap = new HashMap<String, String>(sourceBillDynObjs.length);
        for (DynamicObject sourceBillDynObj : sourceBillDynObjs) {
            String voucherNo;
            Long bookTypeID;
            long sourceBillId = sourceBillDynObj.getLong("id");
            Long orgID = sourceBillDynObj.getLong("org.id");
            DynamicObject acctBookDyn = (DynamicObject)curPeriodRepo.get(new AccountBookHelper.Key(orgID, bookTypeID = Long.valueOf(sourceBillDynObj.getLong(bookTypeField + ".id"))));
            long curPeriodId = acctBookDyn == null ? 0L : acctBookDyn.getLong("curperiod");
            List voucherId = srcId2Period2VchId.getOrDefault(sourceBillId, Collections.emptyMap()).getOrDefault(curPeriodId, Collections.emptyList());
            List voucherNoList = voucherId.stream().map(voucherIdPeriodVoucherNoMap::get).collect(Collectors.toList());
            String string = voucherNo = CollectionUtils.isNotEmpty(voucherNoList) ? String.join((CharSequence)";", voucherNoList) : "";
            if (!StringUtils.isNotBlank((CharSequence)voucherNo)) continue;
            sourceBillIdVoucherNoMap.put(String.valueOf(sourceBillId), voucherNo.length() < 256 ? voucherNo : voucherNo.substring(0, 255));
        }
        return sourceBillIdVoucherNoMap;
    }
}

