/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.formplugin.AbstractNoticeListDataProvider;
import kd.fi.gl.interfaces.service.dap.IDAPService;

public class ACListDataProvider
extends AbstractNoticeListDataProvider {
    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    @Override
    public Map<String, List<String>> getNoticeVoucherFieldMapping() {
        Map<String, List<String>> noticeVoucherFieldMapping = super.getNoticeVoucherFieldMapping();
        return noticeVoucherFieldMapping;
    }

    @Override
    public Map<String, List<String>> getOpNoticeVoucherFieldMapping() {
        Map<String, List<String>> opNoticeVoucherFieldMapping = super.getOpNoticeVoucherFieldMapping();
        return opNoticeVoucherFieldMapping;
    }

    @Override
    protected final String getLogEntityName() {
        return "gl_acnotice_relation";
    }

    @Override
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection notices = super.getData(start, limit);
        if (notices.isEmpty()) {
            return notices;
        }
        return this.setGenerateVoucher(notices);
    }

    private DynamicObjectCollection setGenerateVoucher(DynamicObjectCollection notices) {
        notices.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("generatevoucher", String.class, (Object)"0"));
        HashSet vchEntryIds = new HashSet(notices.size());
        notices.forEach(x -> vchEntryIds.add(x.getLong("voucherentry")));
        HashMap vchEntryToSourceIdMap = new HashMap(notices.size());
        QFilter noticeTypeFilter = new QFilter("noticetype", "=", (Object)"0");
        QFilter vchEntryFilter = new QFilter("voucherentry", "in", vchEntryIds);
        try (DataSet acNoticeDt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_acnotice", (String)"id, voucherentry", (QFilter[])new QFilter[]{noticeTypeFilter, vchEntryFilter}, null);){
            acNoticeDt.forEach(x -> vchEntryToSourceIdMap.put(x.getLong("voucherentry"), x.getLong("id")));
        }
        HashSet<Long> dapSourBillIds = new HashSet<Long>(16);
        Collection receiveAcNoticeIds = vchEntryToSourceIdMap.values();
        BillToVchRelationDto voucherRelations = ACListDataProvider.getDAPService().getBillToVchReDtoByBillTypeAndIds("gl_acnotice", new HashSet(receiveAcNoticeIds));
        for (BillToVchRelationDto.BillToVoucherRelation bill : voucherRelations) {
            dapSourBillIds.add(bill.getBillId());
        }
        notices.forEach(x -> {
            if (dapSourBillIds.contains(vchEntryToSourceIdMap.get(x.getLong("voucherentry")))) {
                x.set("generatevoucher", (Object)"1");
            }
        });
        return notices;
    }
}

