/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.constant.FieldConfig;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PeriodEndingSolveUtil;
import kd.fi.gl.util.PermissonType;

public class AbstractFinalProcessList
extends AbstractListPlugin {
    private static final String IS_FIRST = "isFirst";

    private String getBookTypeField() {
        IListView listView = (IListView)this.getView();
        String billFormId = listView.getBillFormId();
        return FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)billFormId);
    }

    public void setFilter(SetFilterEvent e) {
        List ids;
        super.setFilter(e);
        if ("gl_voucheramortacheme".equals(((BillList)e.getSource()).getBillFormId())) {
            e.setOrderBy("org desc,number");
        } else {
            e.setOrderBy("org desc,billno");
        }
        boolean hasBookType = false;
        for (QFilter filter : e.getQFilters()) {
            if (!filter.getProperty().startsWith(this.getBookTypeField())) continue;
            hasBookType = true;
            break;
        }
        if (!hasBookType && null != (ids = AccSysUtil.getBookTypeDataPermission(null))) {
            e.getQFilters().add(new QFilter(this.getBookTypeField(), "in", (Object)ids));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List orgIds;
        List ids;
        super.filterContainerBeforeF7Select(args);
        IListView listView = (IListView)this.getView();
        String billFormId = listView.getBillFormId();
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.addCustomQFilter(new QFilter("id", "in", (Object)pkSet));
        } else if (field.startsWith(this.getBookTypeField()) && null != (ids = AccSysUtil.getBookTypeIdList((List)(orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id"))))) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filValues = args.getFilterValues();
        List customFils = (List)filValues.get("customfilter");
        if (customFils == null || customFils.size() == 0) {
            return;
        }
        boolean isClear = true;
        List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
        if (orgIds.isEmpty()) {
            return;
        }
        List comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
        for (Map map : customFils) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            List val = (List)map.get("Value");
            if (!fieldName.startsWith(this.getBookTypeField())) continue;
            if (CollectionUtils.isEmpty((Collection)val) || "".equals(val.get(0))) break;
            for (ComboItem ci : comboItems) {
                if (!ci.getValue().equals(val.get(0).toString())) continue;
                isClear = false;
                break;
            }
            if (!isClear) continue;
            val.clear();
            if (comboItems.size() > 0) {
                val.add(((ComboItem)comboItems.get(0)).getValue());
                continue;
            }
            val.add("");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IListView listView = (IListView)this.getView();
        String billFormId = listView.getBillFormId();
        List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        for (CommonFilterColumn commFilter : listFilterColumns) {
            List comboItems;
            String fieldName = commFilter.getFieldName();
            if (fieldName.startsWith("org.")) {
                comboItems = AccSysUtil.getAcctOrgComboItem((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW);
                commFilter.setComboItems(comboItems);
                String orgFilterObjId = (String)paramMap.get("org");
                if (!StringUtils.isBlank((CharSequence)orgFilterObjId) && !"0".equals(orgFilterObjId)) {
                    commFilter.setDefaultValue(orgFilterObjId);
                    this.getPageCache().put("initorg", orgFilterObjId);
                } else if (null != comboItems && comboItems.size() > 0) {
                    String defaultOrgid = this.getDefaultId(comboItems);
                    long orgId = AccSysUtil.getDefaultOrgId((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW);
                    if (AccSysUtil.getAllOrgIdByComboItems((Collection)comboItems).contains(orgId)) {
                        defaultOrgid = String.valueOf(orgId);
                    }
                    commFilter.setDefaultValue(defaultOrgid);
                    this.getPageCache().put("initorg", defaultOrgid);
                }
                if (!StringUtils.isBlank((CharSequence)this.getPageCache().get(IS_FIRST)) && orgIds != null) continue;
                List defaultValue = commFilter.getDefaultValues();
                orgIds = defaultValue.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
                continue;
            }
            if (!fieldName.startsWith(this.getBookTypeField())) continue;
            comboItems = null;
            if (orgIds == null || orgIds.isEmpty()) {
                comboItems = commFilter.getComboItems();
            } else {
                comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
                commFilter.setComboItems(comboItems);
            }
            String defBookType = comboItems.isEmpty() ? null : ((ComboItem)comboItems.get(0)).getValue();
            commFilter.setDefaultValue(defBookType);
            this.getPageCache().put("initbt", defBookType);
        }
        if (this.getPageCache().get(IS_FIRST) == null) {
            this.getPageCache().put(IS_FIRST, "false");
        }
    }

    private String getDefaultId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(items.get(i).getValue())).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("voucherback".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("queryvoucher".equalsIgnoreCase(operateKey) && args.getOperationResult().isSuccess()) {
            FPFormUtil.queryVcouher((IFormView)listView);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        PeriodEndingSolveUtil.setCustomParamsToBill(e, this.getView(), this.getOrgKey());
        PeriodEndingSolveUtil.setCustomParamsToBill(e, this.getView(), this.getBookTypeKey());
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus()) {
            PeriodEndingSolveUtil.setComAssistFilterToBill(e, this.getView());
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
    }

    protected String getOrgKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)((ListView)this.getView()).getListModel().getEntityId()).item1;
    }

    protected String getBookTypeKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)((ListView)this.getView()).getListModel().getEntityId()).item2;
    }
}

