/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.VoucherUtil;

public abstract class AbstractNoticeList
extends AbstractListPlugin {
    private static final String ACCOUNT_TYPE = "accounttype";
    private static final String CACHE_KEY_MAIN_BOOK_TYPE_ID = "CacheKey_MainBookTypeId";

    public void filterContainerInit(FilterContainerInitArgs args) {
        block7: {
            String billFormId;
            List commonFilterColumns;
            block6: {
                DynamicObject noticeDyn;
                super.filterContainerInit(args);
                commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
                ListShowParameter list = (ListShowParameter)this.getView().getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                billFormId = ((IListView)this.getView()).getBillFormId();
                if (qFilters == null || qFilters.isEmpty()) break block6;
                boolean hasIdFilter = false;
                for (Object qFilter : qFilters) {
                    if (!"id".equals(qFilter.getProperty())) continue;
                    hasIdFilter = true;
                    break;
                }
                if (!hasIdFilter || (noticeDyn = QueryServiceHelper.queryOne((String)billFormId, (String)String.join((CharSequence)",", "org", "bookeddate"), (QFilter[])qFilters.toArray(new QFilter[0]))) == null) break block7;
                for (FilterColumn column : commonFilterColumns) {
                    String fieldName = column.getFieldName();
                    if ("org.number".equals(fieldName)) {
                        column.setDefaultValue(noticeDyn.getString("org"));
                        continue;
                    }
                    if (!"bookeddate".equals(fieldName)) continue;
                    ArrayList<String> book = new ArrayList<String>(2);
                    Date date = noticeDyn.getDate("bookeddate");
                    if (null != date) {
                        book.add(date.toString());
                        book.add(date.toString());
                    }
                    column.setDefaultValues(book);
                }
                break block7;
            }
            for (FilterColumn column : commonFilterColumns) {
                String fieldName = column.getFieldName();
                if (!"org.number".equals(fieldName)) continue;
                CommonFilterColumn commFilter = (CommonFilterColumn)column;
                List comboItems = AccSysUtil.getAcctOrgComboItem((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW);
                commFilter.setComboItems(comboItems);
                long defaultOrgId = AccSysUtil.getDefaultOrgId((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW);
                if (AccSysUtil.getAcctOrgPkList2((String)billFormId, (boolean)false, (PermissonType)PermissonType.VIEW).contains(defaultOrgId)) {
                    commFilter.setDefaultValue(defaultOrgId + "");
                    continue;
                }
                if (comboItems.isEmpty()) continue;
                commFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            String entityId = ((IListView)this.getView()).getBillFormId();
            List pkSet = AccSysUtil.getAcctOrgPkList((String)entityId, (boolean)Boolean.FALSE, (PermissonType)PermissonType.VIEW);
            args.getQfilters().clear();
            args.addCustomQFilter(new QFilter("id", "in", (Object)pkSet));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        BillList billList = (BillList)evt.getSource();
        String billFormId = billList.getBillFormId();
        Object selectId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String selectFields = String.join((CharSequence)",", "voucher", "voucherentry", "org");
        DynamicObject selectNotice = QueryServiceHelper.queryOne((String)billFormId, (String)selectFields, (QFilter[])new QFilter("id", "=", selectId).toArray());
        if (Objects.isNull(selectNotice)) {
            IListView view = (IListView)this.getView();
            view.refresh();
            return;
        }
        String fieldName = evt.getFieldName();
        long orgId = selectNotice.getLong("org");
        if (Objects.equals("voucherbillno", fieldName)) {
            List voucherIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter("id", "=", selectNotice.get("voucher")).toArray(), null, (int)1);
            if (!voucherIds.isEmpty()) {
                this.showVoucherForm(voucherIds.get(0), orgId);
            }
        } else if (Objects.equals("peervoucherno", fieldName)) {
            List voucherIds = NoticeUtils.getTheOtherCheckVoucherIds((long)selectNotice.getLong("voucherentry"), (String)this.getCheckLogEntity());
            this.showVoucherList(voucherIds, orgId);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && formShowParameter.getCustomParam("id") != null) {
            Object id = formShowParameter.getCustomParam("id");
            qFilters.clear();
            qFilters.add(new QFilter("id", "=", id));
        } else {
            QFilter orgFilter = e.getMainOrgQFilter();
            QFilter voucherIdFilter = null;
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String filterName = qFilter.getProperty();
                if (filterName.startsWith("org.")) {
                    orgFilter = qFilter;
                    continue;
                }
                if ("voucherbillno".equals(filterName)) {
                    voucherIdFilter = qFilter;
                    iterator.remove();
                    continue;
                }
                if (!"bookeddate".equals(filterName)) continue;
                this.parseDateFilter(qFilter);
            }
            if (orgFilter != null) {
                String property = orgFilter.getProperty();
                if ("org".equals(property)) {
                    property = "id";
                } else if (property.startsWith("org.")) {
                    property = property.substring(property.indexOf(".") + 1);
                }
                List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter(property, orgFilter.getCP(), orgFilter.getValue()).toArray(), null, (int)1);
                if (!orgIds.isEmpty()) {
                    Object pk = orgIds.get(0);
                    this.setVisibleByOrg(Long.valueOf(pk.toString()));
                }
                qFilters.add(new QFilter("booktype", "=", (Object)this.getMainBookTypeId()));
                if (voucherIdFilter != null) {
                    QFilter voucherFilter = new QFilter("gl_voucher.booktype", "=", (Object)this.getMainBookTypeId()).and(new QFilter("gl_voucher.billno", voucherIdFilter.getCP(), voucherIdFilter.getValue()));
                    qFilters.add(QFilter.join((String)"voucher", (String)"gl_voucher.id", (QFilter)voucherFilter, (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)Boolean.TRUE));
                }
            }
        }
    }

    private void parseDateFilter(QFilter qFilter) {
        QFilter qFilterNest;
        List nests;
        Object value = qFilter.getValue();
        if (value instanceof Date) {
            Date date = (Date)value;
            if (">=".equals(qFilter.getCP())) {
                this.setStartDate(date);
            } else {
                this.setEndDate(date);
            }
        }
        if (!(nests = qFilter.getNests(false)).isEmpty() && (qFilterNest = ((QFilter.QFilterNest)nests.get(0)).getFilter()).getValue() instanceof Date) {
            Date dateNest = (Date)qFilterNest.getValue();
            if (">=".equals(qFilterNest.getCP())) {
                this.setStartDate(dateNest);
            } else if ("<".equals(qFilterNest.getCP())) {
                this.setEndDate(DateUtils.getLastDay((Date)dateNest, (int)1));
            } else {
                this.setEndDate(dateNest);
            }
        }
    }

    private long getMainBookTypeId() {
        IPageCache cache = this.getPageCache();
        String cacheMainBookTypeId = cache.get(CACHE_KEY_MAIN_BOOK_TYPE_ID);
        if (StringUtils.isBlank((CharSequence)cacheMainBookTypeId)) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(ACCOUNT_TYPE, "=", (Object)AccountBooksType.MAIN_BOOK.getValue());
            DynamicObject mainBookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])qfBuilder.toArray());
            if (null != mainBookType) {
                long mainBookTypeId = mainBookType.getLong("id");
                cache.put(CACHE_KEY_MAIN_BOOK_TYPE_ID, String.valueOf(mainBookTypeId));
                return mainBookTypeId;
            }
            return 0L;
        }
        return Long.parseLong(cacheMainBookTypeId);
    }

    private void setVisibleByOrg(Long orgId) {
        String entityId = ((IListView)this.getView()).getBillFormId();
        if (entityId.equals("gl_acnotice")) {
            Object result = SystemParamHelper.getObjectParam((String)"showgenvoucher", (long)orgId);
            boolean checkVisiable = true;
            boolean voucherVisiable = true;
            if ("0".equals(result)) {
                voucherVisiable = false;
            } else if ("1".equals(result)) {
                checkVisiable = false;
            }
            this.getView().setVisible(Boolean.valueOf(voucherVisiable), new String[]{"createvoucher", "previewvoucher", "deletevch", "tracevoucher"});
            this.getView().setVisible(Boolean.valueOf(checkVisiable), new String[]{"baritemap1", "baritemap3"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        IListView listview = (IListView)this.getView();
        String entityName = listview.getBillFormId();
        switch (key) {
            case "checkstatusf7": {
                Object pkValue;
                String selectFields;
                DynamicObject noticeDyn;
                List noticeids;
                if (!evt.getOperationResult().isSuccess() || (noticeids = evt.getOperationResult().getSuccessPkIds()).isEmpty() || (noticeDyn = QueryServiceHelper.queryOne((String)entityName, (String)(selectFields = "org,peerorg,currency"), (QFilter[])new QFilter("id", "=", pkValue = noticeids.get(0)).toArray())) == null) break;
                ReportShowParameter report = new ReportShowParameter();
                report.setFormId(this.getNoticeCheckFormId());
                report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                FilterInfo filter = new FilterInfo();
                filter.addFilterItem("org", (Object)noticeDyn.getLong("org"));
                filter.addFilterItem("oporg", (Object)noticeDyn.getLong("peerorg"));
                filter.addFilterItem("currencyfield", (Object)noticeDyn.getLong("currency"));
                filter.addFilterItem("status", (Object)"0");
                filter.addFilterItem("checktype", (Object)"0");
                filter.addFilterItem("startdate", (Object)this.getStartDate());
                filter.addFilterItem("enddate", (Object)this.getEndDate());
                listview.getControlFilters();
                ReportQueryParam queryParam = new ReportQueryParam();
                queryParam.setFilter(filter);
                report.setQueryParam(queryParam);
                listview.showForm((FormShowParameter)report);
                break;
            }
            case "cancelcheck": {
                int cancelCheckCount = evt.getOperationResult().getBillCount();
                int cancelCheckSucCount = evt.getOperationResult().getSuccessPkIds().size();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53cd\u52fe\u7a3d\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"AbstractNoticeList_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), cancelCheckSucCount, cancelCheckCount - cancelCheckSucCount));
                listview.refresh();
                break;
            }
            case "cancelcheckout": {
                int selectCount = evt.getOperationResult().getBillCount();
                int successCount = evt.getOperationResult().getSuccessPkIds().size();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u542f\u7528\u7ed3\u8d26\u6821\u9a8c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"AbstractNoticeList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), successCount, selectCount - successCount));
                listview.refresh();
                break;
            }
            case "checkoutop": {
                int checkOutselCount = evt.getOperationResult().getBillCount();
                int checkOutSuccCount = evt.getOperationResult().getSuccessPkIds().size();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u89e3\u9664\u7ed3\u8d26\u6821\u9a8c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"AbstractNoticeList_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), checkOutSuccCount, checkOutselCount - checkOutSuccCount));
                listview.refresh();
                break;
            }
        }
    }

    protected abstract String getNoticeCheckFormId();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "generatevoucher": 
            case "previewvoucher": {
                this.checkInfo(args);
                break;
            }
            case "checkstatusf7": {
                if (args.getListSelectedData().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u3002", (String)"AbstractNoticeList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private void checkInfo(BeforeDoOperationEventArgs args) {
        String entityId = ((IListView)this.getView()).getBillFormId();
        Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
        QFilter idQF = new QFilter("id", "in", (Object)primaryKeyValues);
        QFilter sendQF = new QFilter("noticetype", "=", (Object)"1").or(new QFilter("checkstatus", "=", (Object)"1"));
        if (QueryServiceHelper.exists((String)entityId, (QFilter[])new QFilter[]{idQF, sendQF})) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u5b58\u5728\u901a\u77e5\u5355\u7c7b\u578b\u4e3a\u53d1\u9001\u6216\u8005\u5df2\u52fe\u7a3d\u7684\u901a\u77e5\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractNoticeList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void setStartDate(Date startDate) {
        this.setDate(startDate, "startDate");
    }

    private void setEndDate(Date endDate) {
        this.setDate(endDate, "endDate");
    }

    private void setDate(Date date, String key) {
        if (Objects.isNull(date)) {
            this.getPageCache().remove(key);
            return;
        }
        this.getPageCache().put(key, SerializationUtils.toJsonString((Object)date));
    }

    private Date getStartDate() {
        return this.getDate("startDate");
    }

    private Date getEndDate() {
        return this.getDate("endDate");
    }

    private Date getDate(String key) {
        String startDateVal = this.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)startDateVal)) {
            return (Date)SerializationUtils.fromJsonString((String)startDateVal, Date.class);
        }
        return null;
    }

    private void showVoucherForm(Object pk, long orgId) {
        VoucherUtil.hyperVoucher(orgId, Long.parseLong(pk.toString()), this.getView());
    }

    private void showVoucherList(List<Long> voucherIds, long orgId) {
        if (voucherIds.isEmpty()) {
            return;
        }
        if (voucherIds.size() == 1) {
            this.showVoucherForm(voucherIds.get(0), orgId);
            return;
        }
        ListShowParameter list = new ListShowParameter();
        list.setBillFormId("gl_voucher");
        list.setFormId("bos_list");
        list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        list.getOpenStyle().setTargetKey("tabap");
        for (Long pk : voucherIds) {
            list.addLinkQueryPkId((Object)pk);
        }
        this.getView().showForm((FormShowParameter)list);
    }

    protected abstract String getCheckLogEntity();
}

