/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.common.NoticeData;
import kd.fi.gl.util.QFBuilder;

public abstract class AbstractNoticeListDataProvider
extends ListDataProvider {
    private static final String DEFAULT_ORDER = "id desc";
    private static final String INDEX_ORDER = "org desc, bookeddate desc";
    private List<String> noticeFields;
    private Map<String, List<String>> noticeVoucherFieldMapping;
    private Map<String, List<String>> opNoticeVoucherFieldMapping;
    private static final String VOUCHER_ENTRY_ID_FIELD = String.join((CharSequence)".", "entries", "id");

    public List<String> getNoticeQueryFields() {
        if (this.noticeFields == null) {
            this.noticeFields = new ArrayList<String>(10);
            this.noticeFields.add("voucherentry");
            this.noticeFields.add("voucher");
            this.noticeFields.add("checkstatus");
        }
        return this.noticeFields;
    }

    public Map<String, List<String>> getNoticeVoucherFieldMapping() {
        if (this.noticeVoucherFieldMapping == null) {
            this.noticeVoucherFieldMapping = new HashMap<String, List<String>>(16);
            ArrayList<String> voucherNoFields = new ArrayList<String>(2);
            voucherNoFields.add("vouchertype.name");
            voucherNoFields.add("billno");
            this.noticeVoucherFieldMapping.put("voucherbillno", voucherNoFields);
        }
        return this.noticeVoucherFieldMapping;
    }

    public Map<String, List<String>> getOpNoticeVoucherFieldMapping() {
        if (this.opNoticeVoucherFieldMapping == null) {
            this.opNoticeVoucherFieldMapping = new HashMap<String, List<String>>(16);
            ArrayList<String> voucherNoFields = new ArrayList<String>(2);
            voucherNoFields.add("vouchertype.name");
            voucherNoFields.add("billno");
            this.opNoticeVoucherFieldMapping.put("peervoucherno", voucherNoFields);
        }
        return this.opNoticeVoucherFieldMapping;
    }

    private void registerStringProperties(DynamicObjectType dynamicObjectType) {
        Set<String> noticeFields = this.noticeVoucherFieldMapping.keySet();
        Set<String> opNoticeFields = this.opNoticeVoucherFieldMapping.keySet();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        List propertyNames = properties.stream().map(IMetadata::getName).collect(Collectors.toList());
        for (String field : noticeFields) {
            if (propertyNames.contains(field)) continue;
            properties.add((Object)new DynamicSimpleProperty(field, String.class, null));
            propertyNames.add(field);
        }
        for (String field : opNoticeFields) {
            if (propertyNames.contains(field)) continue;
            properties.add((Object)new DynamicSimpleProperty(field, String.class, null));
            propertyNames.add(field);
        }
    }

    private String getVoucherSelectFields() {
        Set voucherSelectFields = this.noticeVoucherFieldMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set opVoucherSelectFields = this.opNoticeVoucherFieldMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        voucherSelectFields.addAll(opVoucherSelectFields);
        voucherSelectFields.add(VOUCHER_ENTRY_ID_FIELD);
        return String.join((CharSequence)",", voucherSelectFields);
    }

    private Map<Long, Set<Long>> getEntryIdOpEntryIdMapping(List<Long> entryIds, List<Long> voucherIdList) {
        if (entryIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String logEntityName = this.getLogEntityName();
        HashMap<Long, Set<Long>> entryIdOpEntryIdMapping = new HashMap<Long, Set<Long>>(entryIds.size());
        QFilter entryIdFilter = new QFilter(NoticeData.ENTRY_ID_FIELD, "in", entryIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)AbstractNoticeListDataProvider.class.getName(), (String)logEntityName, (String)String.join((CharSequence)",", NoticeData.ENTRY_ID_FIELD, NoticeData.OP_ENTRY_ID_FIELD, NoticeData.OP_VOUCHER_ID_FIELD), (QFilter[])entryIdFilter.toArray(), null);){
            for (Row row : ds) {
                entryIds.remove(row.getLong(NoticeData.ENTRY_ID_FIELD));
                entryIdOpEntryIdMapping.compute(row.getLong(NoticeData.ENTRY_ID_FIELD), (k, v) -> {
                    if (null == v) {
                        v = new HashSet<Long>();
                    }
                    v.add(row.getLong(NoticeData.OP_ENTRY_ID_FIELD));
                    voucherIdList.add(row.getLong(NoticeData.OP_VOUCHER_ID_FIELD));
                    return v;
                });
            }
        }
        if (entryIds.isEmpty()) {
            return entryIdOpEntryIdMapping;
        }
        QFilter opentryIdFilter = new QFilter(NoticeData.OP_ENTRY_ID_FIELD, "in", entryIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)AbstractNoticeListDataProvider.class.getName(), (String)logEntityName, (String)String.join((CharSequence)",", NoticeData.ENTRY_ID_FIELD, NoticeData.VOUCHER_ID_FIELD, NoticeData.OP_ENTRY_ID_FIELD), (QFilter[])opentryIdFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : ds) {
                entryIdOpEntryIdMapping.compute(row.getLong(NoticeData.OP_ENTRY_ID_FIELD), (k, v) -> {
                    if (null == v) {
                        v = new HashSet<Long>();
                    }
                    v.add(row.getLong(NoticeData.ENTRY_ID_FIELD));
                    voucherIdList.add(row.getLong(NoticeData.VOUCHER_ID_FIELD));
                    return v;
                });
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return entryIdOpEntryIdMapping;
    }

    protected abstract String getLogEntityName();

    public void setListFields(List<ListField> listFields) {
        HashSet<String> fields = new HashSet<String>(listFields.size());
        for (ListField listField : listFields) {
            fields.add(listField.getFieldName());
        }
        this.noticeFields = this.getNoticeQueryFields();
        for (String sfield : this.noticeFields) {
            if (!fields.add(sfield)) continue;
            ListField listField = new ListField(sfield);
            listField.setFieldName(sfield);
            listFields.add(listField);
        }
        super.setListFields(listFields);
    }

    protected void initContext(int start, int limit) {
        super.initContext(start, limit);
        QueryBuilder queryBuilder = this.getQueryBuilder();
        String orderBys = queryBuilder.getOrderBys();
        if (DEFAULT_ORDER.equalsIgnoreCase(orderBys)) {
            queryBuilder.setOrderBys(INDEX_ORDER);
        }
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection notices = super.getData(start, limit);
        if (notices.isEmpty()) {
            return notices;
        }
        this.noticeVoucherFieldMapping = this.getNoticeVoucherFieldMapping();
        this.opNoticeVoucherFieldMapping = this.getOpNoticeVoucherFieldMapping();
        this.registerStringProperties(notices.getDynamicObjectType());
        List entryIds = notices.stream().map(x -> x.getLong("voucherentry")).collect(Collectors.toList());
        List<Long> voucherIdList = notices.stream().map(x -> x.getLong("voucher")).collect(Collectors.toList());
        List<Long> checkedEntryIds = notices.stream().filter(x -> "1".equals(x.getString("checkstatus"))).map(x -> x.getLong("voucherentry")).collect(Collectors.toList());
        Map<Long, Set<Long>> entryIdOpEntryIdMapping = this.getEntryIdOpEntryIdMapping(checkedEntryIds, voucherIdList);
        Set opEntryIds = entryIdOpEntryIdMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        entryIds.addAll(opEntryIds);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", voucherIdList);
        qfBuilder.add(VOUCHER_ENTRY_ID_FIELD, "in", entryIds);
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"gl_voucher", (String)this.getVoucherSelectFields(), (QFilter[])qfBuilder.toArray());
        Map<Long, DynamicObject> entryIdVoucherMapping = ds.stream().collect(Collectors.toMap(x -> x.getLong(VOUCHER_ENTRY_ID_FIELD), x -> x));
        for (DynamicObject notice : notices) {
            this.setCustomVoucherInfoToNotice(notice, entryIdVoucherMapping, entryIdOpEntryIdMapping);
        }
        return notices;
    }

    private void setCustomVoucherInfoToNotice(DynamicObject notice, Map<Long, DynamicObject> entryIdVoucherMapping, Map<Long, Set<Long>> entryIdOpEntryIdMapping) {
        long entryId = notice.getLong("voucherentry");
        this.setVoucherInfoToNotice(notice, this.noticeVoucherFieldMapping, entryIdVoucherMapping.get(entryId));
        Set<Long> opEntryIds = entryIdOpEntryIdMapping.get(entryId);
        if (opEntryIds == null || opEntryIds.isEmpty()) {
            return;
        }
        DynamicObject[] vouchers = (DynamicObject[])opEntryIds.stream().map(entryIdVoucherMapping::get).filter(Objects::nonNull).toArray(DynamicObject[]::new);
        this.setVoucherInfoToNotice(notice, this.opNoticeVoucherFieldMapping, vouchers);
    }

    private void setVoucherInfoToNotice(DynamicObject notice, Map<String, List<String>> voucherNoticeFieldMapping, DynamicObject ... vouchers) {
        if (vouchers == null || vouchers.length == 0) {
            return;
        }
        voucherNoticeFieldMapping.forEach((noticeField, voucherFields) -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject voucher : vouchers) {
                if (voucher == null) continue;
                for (String voucherField : voucherFields) {
                    stringBuilder.append(voucher.get(voucherField));
                }
                stringBuilder.append("\uff1b");
            }
            if (stringBuilder.length() > 0) {
                notice.set(noticeField, (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        });
    }
}

