/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;

public class AccRiskSetEdit
extends AbstractFormPlugin {
    public static final String ACCOUNT = "accounts";
    public static final String CUR_FOR = "curfor";
    public static final String FIELD = "field";
    public static final String SYMBOL = "symbol";
    public static final String VALUE = "value";
    public static final String ORG = "org";
    public static final String USER = "user";
    public static final String ACCOUNTTABLE = "accounttable";
    public static final String FILTER_STR = "encodefilter";
    public static final String ACC_EIDT = "accedit";
    public static final String CUR_LOCAL = "curlocal";
    public static final String CURRENCY_NUMBER = "currency.number";
    public static final String DEBIT_LOCAL = "debitlocal";
    public static final String CREDIT_LOCAL = "creditlocal";
    public static final String END_LOCAL = "endlocal";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        String str = (String)param.getCustomParam("riskAccMap");
        if (str != null) {
            Map riskAccMap = (Map)GLUtil.fromSerializedString((String)str);
            model.setValue(ACC_EIDT, (Object)str);
            Collection values = riskAccMap.values();
            HashSet accSet = new HashSet();
            for (Set value : values) {
                accSet.addAll(value);
            }
            model.setValue(ACCOUNT, (Object)accSet.toArray());
            if (riskAccMap.size() == 1) {
                for (Long accRiskSetId : riskAccMap.keySet()) {
                    String sel = String.join((CharSequence)",", CUR_FOR, FIELD, SYMBOL, VALUE);
                    DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_bill_accriskset", (String)sel, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accRiskSetId)});
                    if (dyn == null) continue;
                    for (String field : sel.split(",")) {
                        model.setValue(field, dyn.get(field));
                    }
                }
            }
        }
        model.setValue(CUR_LOCAL, (Object)this.getBookInfo().getBaseCurrencyId());
        model.setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        if ("save".equals(source.getOperateKey())) {
            this.setHideValue();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result.isSuccess() && afterDoOperationEventArgs.getOperateKey().equals("save")) {
            this.getView().close();
        }
    }

    public void registerListener(EventObject eventObject) {
        BasedataEdit account = (BasedataEdit)this.getControl(ACCOUNT);
        account.addBeforeF7SelectListener(evt -> {
            FormShowParameter param = this.getView().getFormShowParameter();
            String bookStr = (String)param.getCustomParam("accountbookinfo");
            AccountBookInfo bookInfo = (AccountBookInfo)GLUtil.fromSerializedString((String)bookStr);
            ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
            List filters = paramd.getListFilterParameter().getQFilters();
            filters.add(AccountUtils.getAccountDataFilter((long)bookInfo.getOrgId(), (long)bookInfo.getAccountTableId()));
            filters.add(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
        });
    }

    private void setHideValue() {
        IDataModel model = this.getModel();
        model.setValue(ORG, (Object)this.getBookInfo().getOrgId());
        model.setValue(ACCOUNTTABLE, (Object)this.getBookInfo().getAccountTableId());
        model.setValue(USER, (Object)Long.valueOf(RequestContext.get().getUserId()));
        model.setValue(FILTER_STR, (Object)this.getFilterStr());
    }

    private String getFilterStr() {
        IDataModel model = this.getModel();
        StringBuilder sb = new StringBuilder();
        BigDecimal valB = (BigDecimal)model.getValue(VALUE);
        this.getModel().setValue(VALUE, (Object)BigDecimal.ONE.add(valB));
        this.getModel().setValue(VALUE, (Object)valB);
        valB = (BigDecimal)model.getValue(VALUE);
        String valStr = valB.toString();
        if ("0E-10".equals(valStr)) {
            valStr = "0.00";
        }
        sb.append(model.getValue(FIELD)).append(" ").append(model.getValue(SYMBOL)).append(" ").append(valStr);
        DynamicObject curFor = (DynamicObject)model.getValue(CUR_FOR);
        if (curFor != null) {
            String number = curFor.getString("number");
            sb.append(" AND currency.number = ").append("'").append(number).append("'");
        }
        return sb.toString();
    }

    private AccountBookInfo getBookInfo() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String bookStr = (String)param.getCustomParam("accountbookinfo");
        return (AccountBookInfo)GLUtil.fromSerializedString((String)bookStr);
    }
}

