/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.formplugin.AddendumAjustListDataProvider;
import kd.fi.gl.listfilter.FilterContainerValues;
import kd.fi.gl.listfilter.FilterValues;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class AddendumAjustList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(AddendumAjustList.class);
    private static final String ENTITY_NAME = "gl_accedit";
    private String[] statues = new String[]{"a", "b", "c"};
    protected static final String CACHEKEY_HASPERMORG = "hasPermOrg";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AddendumAjustListDataProvider(this.getView()));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("ctlsetting")) {
            this.accountSetting();
        } else if (itemKey.equals("ctlapply")) {
            // empty if block
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String hasPermOrg;
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String operateKey = operateInfo.getOperateKey();
        if ("cfadjust".equals(operateKey) || "canceladjust".equals(operateKey)) {
            Map<Long, Long> map;
            String org = this.getPageCache().get("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AddendumAjustList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            String booktype = Optional.ofNullable(this.getPageCache().get("booktype")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AddendumAjustList_11", (String)"fi-gl-formplugin", (Object[])new Object[0])));
            if ("cfadjust".equals(operateKey) && (map = AddendumAjustList.getAccAddendMap(Long.valueOf(org), Long.valueOf(booktype))) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u79d1\u76ee\u8bbe\u7f6e\u3002", (String)"AddendumAjustList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("refresh".equals(operateKey) && (hasPermOrg = this.getPageCache().get(CACHEKEY_HASPERMORG)) != null && "0".equals(hasPermOrg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u6216\u8005\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"DesignateCommonPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("cfadjust".equals(operateKey) || "canceladjust".equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                String message = args.getOperationResult().getMessage();
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    this.getView().showErrorNotification(message);
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"AddendumAjustList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
            Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
            toolbar.itemClick("refresh", "refresh");
        }
    }

    private static Map<Long, Long> getAccAddendMap(Long org, Long booktype) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter booktypeFilter = new QFilter("booktype", "=", (Object)booktype);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{orgFilter, booktypeFilter});
        if (dyn == null) {
            return Collections.EMPTY_MAP;
        }
        DynamicObject accedit = BusinessDataServiceHelper.loadSingle((Object)dyn.getLong("id"), (String)ENTITY_NAME);
        DynamicObjectCollection entryentity = accedit.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            long suppitem = obj.getLong("suppitem_id");
            DynamicObjectCollection accounts = obj.getDynamicObjectCollection("accounts");
            for (DynamicObject account : accounts) {
                long accId = account.getLong("fbasedataid_id");
                map.put(accId, suppitem);
            }
        }
        return map;
    }

    private void accountSetting() {
        String org = this.getPageCache().get("org");
        String booktype = this.getPageCache().get("booktype");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AddendumAjustList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(org));
        DynamicObject accedit = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{orgFilter, new QFilter("booktype", "=", (Object)Long.parseLong(booktype))});
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(ENTITY_NAME);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accedit"));
        if (accedit == null) {
            parameter.setStatus(OperationStatus.ADDNEW);
        } else {
            parameter.setPkId((Object)accedit.getLong("id"));
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setCustomParam("org", (Object)org);
        parameter.setCustomParam("booktype", (Object)booktype);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1000px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void setFilter(SetFilterEvent e) {
        String hasPermOrg = this.getPageCache().get(CACHEKEY_HASPERMORG);
        if (hasPermOrg != null && "0".equals(hasPermOrg)) {
            return;
        }
        List baseFilters = e.getQFilters();
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        baseFilters.add(mainOrgQFilter);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(baseFilters.size());
        logger.info("AddendumAjustList setFilter baseFilters : " + baseFilters.toString());
        for (QFilter qFilter : baseFilters) {
            DynamicObject dynamicObject;
            Object value;
            if (qFilter == null) continue;
            String property = qFilter.getProperty();
            if (property.equals("suppstatus")) {
                value = qFilter.getValue().toString();
                if ("c".equals(value)) {
                    this.statues = new String[]{"c"};
                    continue;
                }
                if ("a".equals(value)) {
                    this.statues = new String[]{"a", "b"};
                    continue;
                }
                if ("b".equals(value)) {
                    this.statues = new String[]{"b"};
                    continue;
                }
                if (!"0".equals(value) && !"1".equals(value) && !"2".equals(value) && !"3".equals(value)) continue;
                this.statues = new String[0];
                continue;
            }
            if (property.equals("entries.edescription")) {
                QFilter suppsQfilter = qFilter.copy();
                qFilter.setProperty("entries.suppcfitem.number");
                suppsQfilter.setProperty("entries.suppcfitem.name");
                if ("not like".equals(qFilter.getCP()) || "!=".equals(qFilter.getCP())) {
                    qFilter.and(suppsQfilter);
                } else {
                    qFilter.or(suppsQfilter);
                }
            }
            qFilters.add(qFilter);
            if (property.equals("org")) {
                if (!(qFilter.getValue() instanceof List) || (value = (List)qFilter.getValue()).size() <= 0) continue;
                this.getPageCache().put("org", String.valueOf(value.get(0)));
                continue;
            }
            if (property.equals("org.name") || property.equals("org.id")) {
                value = String.valueOf(qFilter.getValue());
                if (qFilter.getCP().equals("=") && !"EMPTY".equals(value)) {
                    if (property.equals("org.name")) {
                        dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("name", "=", value).toArray());
                        if (dynamicObject != null) {
                            this.getPageCache().put("org", dynamicObject.getString("id"));
                            continue;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u6838\u7b97\u7ec4\u7ec7", (String)"AddendumAjustList_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    this.getPageCache().put("org", (String)value);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u7ec4\u7ec7\u67e5\u8be2\u3002", (String)"AddendumAjustList_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            if (!property.equals("booktype.name") && !property.equals("booktype.id")) continue;
            value = String.valueOf(qFilter.getValue());
            if (qFilter.getCP().equals("=") && !"EMPTY".equals(value)) {
                if (property.equals("booktype.name")) {
                    dynamicObject = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("name", "=", value).toArray());
                    if (dynamicObject != null) {
                        this.getPageCache().put("booktype", dynamicObject.getString("id"));
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u8d26\u7c3f\u7c7b\u578b", (String)"AddendumAjustList_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                this.getPageCache().put("booktype", (String)value);
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u8d26\u7c3f\u67e5\u8be2\u3002", (String)"AddendumAjustList_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        qFilters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        qFilters.add(new QFilter("suppstatus", "in", (Object)this.statues));
        qFilters.add(new QFilter("sourcetype", "!=", (Object)"c"));
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)Long.parseLong(this.getPageCache().get("org")), (long)Long.parseLong(this.getPageCache().get("booktype")));
        if (book != null) {
            if (book.getCashinitPeriodId() == 0L) {
                qFilters.clear();
                qFilters.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            } else {
                qFilters.add(new QFilter("period", ">=", (Object)book.getCashinitPeriodId()));
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(qFilters);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            QFilter filter = AccSysUtil.getAcctOrgFilter((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List acctOrgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
        if (acctOrgPkList.isEmpty()) {
            this.getPageCache().put(CACHEKEY_HASPERMORG, "0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u6216\u8005\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"DesignateCommonPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHEKEY_HASPERMORG, "1");
        FilterContainerInitEvent event = args.getFilterContainerInitEvent();
        List commonFilterColumns = event.getCommonFilterColumns();
        Iterator iterator = commonFilterColumns.iterator();
        List<Long> orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
        while (iterator.hasNext()) {
            List comboItems;
            FilterColumn col = (FilterColumn)iterator.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)col;
            if ("org.name".equals(col.getFieldName())) {
                comboItems = AccSysUtil.getAcctOrgComboItem((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                commonFilterColumn.setComboItems(comboItems);
                if (orgIds == null || orgIds.size() == 0) {
                    long defaultOrgId = AccSysUtil.getDefaultOrgId((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
                    if (AccSysUtil.getAllOrgIdByComboItems((Collection)comboItems).contains(defaultOrgId)) {
                        orgIds = Collections.singletonList(defaultOrgId);
                        commonFilterColumn.setDefaultValue(String.valueOf(defaultOrgId));
                    } else {
                        List defaultOrgs = commonFilterColumn.getDefaultValues();
                        orgIds = defaultOrgs.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
                    }
                }
                if (!orgIds.isEmpty() && (Long)orgIds.get(0) != 0L) continue;
                commonFilterColumn.setDefaultValue(String.valueOf(((ComboItem)comboItems.get(0)).getValue()));
                orgIds.add(Long.parseLong(((ComboItem)comboItems.get(0)).getValue()));
                continue;
            }
            if (!"booktype.name".equals(col.getFieldName())) continue;
            if (orgIds == null || orgIds.isEmpty()) {
                comboItems = commonFilterColumn.getComboItems();
            } else {
                comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
                commonFilterColumn.setComboItems(comboItems);
            }
            String defBookType = comboItems.isEmpty() ? null : ((ComboItem)comboItems.get(0)).getValue();
            List values = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
            commonFilterColumn.setDefaultValue(defBookType);
            int bookTypeCount = AccSysUtil.getAllBookTypeCount();
            if (bookTypeCount > 1) break;
            if (bookTypeCount == 1 && StringUtils.isNotBlank((CharSequence)defBookType)) {
                this.getPageCache().put("booktype", defBookType);
            }
            iterator.remove();
            break;
        }
        args.setFilterContainerInitEvent(event);
        Optional<SchemeFilterColumn> suppStatusFilter = args.getSchemeFilterColumns().stream().filter(c -> c instanceof SchemeFilterColumn && c.getFieldName().equals("suppstatus")).map(SchemeFilterColumn.class::cast).findFirst();
        suppStatusFilter.ifPresent(column -> column.getComboItems().removeIf(item -> StringUtils.isNumeric((CharSequence)item.getValue())));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filValues = args.getFilterValues();
        List customFils = (List)filValues.get("customfilter");
        if (customFils != null && customFils.size() != 0) {
            boolean isClear = true;
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            if (orgIds != null && orgIds.size() >= 1) {
                List comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
                for (Map map : customFils) {
                    String fieldName = (String)((List)map.get("FieldName")).get(0);
                    List val = (List)map.get("Value");
                    if (!"booktype.id".equals(fieldName)) continue;
                    if (val.isEmpty() || "".equals(val.get(0))) break;
                    Iterator iterator = comboItems.iterator();
                    while (iterator.hasNext()) {
                        ComboItem ci = (ComboItem)iterator.next();
                        if (!ci.getValue().equals(val.get(0).toString())) continue;
                        isClear = false;
                        break;
                    }
                    if (!isClear) continue;
                    val.clear();
                    if (comboItems.size() > 0) {
                        val.add(((ComboItem)comboItems.get(0)).getValue());
                        continue;
                    }
                    val.add("");
                }
            }
        }
        FilterContainerValues filterContainerValues = new FilterContainerValues(args.getFilterValues());
        List<FilterValues> customFilterValuesList = filterContainerValues.getCustomFilterValuesList();
        for (FilterValues filterValues : customFilterValuesList) {
            if (!filterValues.getFieldName().startsWith("org") || filterValues.isValueSingle()) continue;
            this.clearSummryColumn();
            break;
        }
        List<FilterValues> schemeFilterValuesList = filterContainerValues.getSchemeFilterValuesList();
        for (FilterValues filterValues : schemeFilterValuesList) {
            if (!filterValues.getFieldName().startsWith("org") || filterValues.isValueSingle()) continue;
            this.clearSummryColumn();
            break;
        }
    }

    private void clearSummryColumn() {
        List listColumns = this.getVoucherList().getShowListColumns();
        for (IListColumn column : listColumns) {
            if (!(column instanceof DecimalListColumn)) continue;
            ((DecimalListColumn)column).setSummary(0);
        }
    }

    private BillList getVoucherList() {
        return (BillList)this.getControl("billlistap");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            args.addCustomQFilter(new QFilter("id", "in", (Object)pkSet));
        } else if (fieldName.startsWith("booktype")) {
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            List bookTypeIdList = AccSysUtil.getBookTypeIdList((List)orgIds);
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIdList));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("accedit".equals(actionId) && e.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"AddendumAjustList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }
}

