/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.formplugin.AbstractFinalProcessList;
import kd.fi.gl.formplugin.FPFormUtil;

public class AdjustExchangeRateList
extends AbstractFinalProcessList {
    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        FPFormUtil.parseAssistSetupBeforeExport(e);
        for (DynamicObject value : e.getQueryValues()) {
            Optional<IDataEntityProperty> first = value.getDataEntityType().getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty.getName().equals("mulcuradjust")).findFirst();
            if (!first.isPresent()) continue;
            long orgId = value.getLong("org_id");
            long bookTypeId = value.getLong("bookstype_id");
            String mulCurAdjust = value.getString("mulcuradjust");
            if (!StringUtils.isNotBlank((CharSequence)mulCurAdjust)) continue;
            Map<String, String> collect = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)bookTypeId).stream().collect(Collectors.toMap(LocalCurrencyConfigVO::getNumber, configVO -> configVO.getName().getLocaleValue()));
            for (Map.Entry<String, String> entry : collect.entrySet()) {
                mulCurAdjust = mulCurAdjust.replace(entry.getKey(), entry.getValue());
            }
            value.set("mulcuradjust", (Object)mulCurAdjust);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }
}

