/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.ContextUtil;

public class AssgrpDefValList
extends AbstractListPlugin {
    private static final String[] STRUCTFIELDS = new String[]{"entryentity.basepk"};
    private static final String ASSIST_DETAIL = "bos_assistantdata_detail";

    public void setFilter(SetFilterEvent e) {
        IFormView view = this.getView();
        Map params = view.getFormShowParameter().getCustomParams();
        if (params != null) {
            Object org = params.get("org");
            Object accounttable = params.get("accounttable");
            Long curUser = ContextUtil.getUserId();
            QFilter userFilter = new QFilter("usertype", "=", (Object)"1").and(new QFilter("muluser.fbasedataid", "=", (Object)curUser)).or(new QFilter("usertype", "=", (Object)"0")).or(new QFilter("user", "=", (Object)curUser));
            if (org != null && accounttable != null) {
                userFilter = userFilter.and(new QFilter("org", "=", org).and(new QFilter("accounttable", "=", accounttable)));
            }
            e.getQFilters().add(userFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new AssgrpDefValListDataProvider());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        IFormView view = this.getView();
        Map params = view.getFormShowParameter().getCustomParams();
        if (params != null) {
            Object org = params.get("org");
            Object accounttable = params.get("accounttable");
            if (org != null && accounttable != null) {
                e.getParameter().setCustomParams(params);
            } else {
                e.setCancel(true);
            }
        } else {
            e.setCancel(true);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        HashMap<Long, Long> entityBasePkMap = new HashMap<Long, Long>();
        this.queryBasePk(queryValues, entityBasePkMap);
        for (DynamicObject queryValue : queryValues) {
            DynamicObjectCollection dynamicObjectCollection = queryValue.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject valueSourceDy = dynamicObject.getDynamicObject("assgrptype").getDynamicObject("valuesource");
                if (null == valueSourceDy) continue;
                String valueSource = valueSourceDy.getString("number");
                Long entryId = (Long)dynamicObject.getPkValue();
                QFilter qFilter = new QFilter("id", "=", entityBasePkMap.get(entryId));
                DynamicObject dy = QueryServiceHelper.queryOne((String)valueSource, (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
                dynamicObject.set("assgrpnumber", (Object)dy.getString("number"));
                dynamicObject.set("assgrpname", (Object)dy.getString("name"));
            }
        }
    }

    private void queryBasePk(DynamicObject[] queryValues, Map<Long, Long> entryEntityMap) {
        HashSet allEntryId = new HashSet(8);
        Arrays.stream(queryValues).forEach(entryCollection -> {
            for (DynamicObject dynamicObject : entryCollection.getDynamicObjectCollection("entryentity")) {
                allEntryId.add((Long)dynamicObject.getPkValue());
            }
        });
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fbasepk,fentryid from t_gl_assgrpdefvalentry where ", new Object[0]);
        sqlBuilder.appendIn("fentryid", new ArrayList(allEntryId));
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        for (Row row : dataSet) {
            entryEntityMap.put(row.getLong("fentryid"), StringUtils.isNotBlank((Object)row.get("fbasepk")) ? Long.parseLong(row.get("fbasepk").toString()) : 0L);
        }
    }

    private static class AssgrpDefValListDataProvider
    extends ListDataProvider {
        private AssgrpDefValListDataProvider() {
        }

        private boolean isIdNotNull(Object pk) {
            return StringUtils.isNotBlank((Object)pk) && !"0".equalsIgnoreCase(pk.toString());
        }

        public void setListFields(List<ListField> listFields) {
            HashSet<String> fields = new HashSet<String>(listFields.size());
            for (ListField listField : listFields) {
                fields.add(listField.getFieldName());
            }
            for (String sfield : STRUCTFIELDS) {
                if (fields.contains(sfield)) continue;
                ListField listField = new ListField(sfield);
                listField.setFieldName(sfield);
                listFields.add(listField);
            }
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection datas = super.getData(arg0, arg1);
            HashMap entityToPks = new HashMap();
            HashMap<Long, String> assgrpTypeToEntity = new HashMap<Long, String>();
            for (DynamicObject rowData : datas) {
                String entityId = null;
                DynamicObject assgrp = null;
                if (this.checkDefaultValue(rowData, "entryentity.assgrptype")) {
                    assgrp = rowData.getDynamicObject("entryentity.assgrptype");
                }
                if (assgrp != null) {
                    String valuetype = assgrp.getString("valuetype");
                    if ("1".equalsIgnoreCase(valuetype)) {
                        DynamicObject valuesource = assgrp.getDynamicObject("valuesource");
                        if (valuesource != null) {
                            entityId = valuesource.getString("number");
                        }
                    } else if ("2".equalsIgnoreCase(valuetype)) {
                        entityId = AssgrpDefValList.ASSIST_DETAIL;
                    }
                }
                if (!StringUtils.isNotBlank(entityId)) continue;
                assgrpTypeToEntity.put(rowData.getLong("assgrptype_id"), entityId);
                Long basedatavalid = Long.parseLong(rowData.getString("entryentity.basepk"));
                if (!this.isIdNotNull(basedatavalid)) continue;
                if (entityToPks.get(entityId) == null) {
                    ArrayList<Long> pks = new ArrayList<Long>();
                    pks.add(basedatavalid);
                    entityToPks.put(entityId, pks);
                    continue;
                }
                ((List)entityToPks.get(entityId)).add(basedatavalid);
            }
            if (!entityToPks.isEmpty()) {
                HashMap entityToPkToVals = new HashMap();
                for (Map.Entry entityToPksEntry : entityToPks.entrySet()) {
                    Set fullIndexFields;
                    String key = (String)entityToPksEntry.getKey();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)key);
                    if (dataEntityType == null || (fullIndexFields = dataEntityType.getFullIndexFields()).isEmpty()) continue;
                    QFilter filters = new QFilter("id", "in", entityToPksEntry.getValue());
                    DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.formplugin.AssgrpDefValList.AssgrpDefValListDataProvider.getData", (String)key, (String)(String.join((CharSequence)",", fullIndexFields) + ",id"), (QFilter[])filters.toArray(), null);
                    Throwable throwable = null;
                    try {
                        for (Row row : ds) {
                            StringBuilder sb = new StringBuilder();
                            for (String field : fullIndexFields) {
                                sb.append(row.getString(field));
                                sb.append(" ");
                            }
                            if (entityToPkToVals.get(key) == null) {
                                HashMap<String, String> pkToVal = new HashMap<String, String>();
                                pkToVal.put(row.getString("id"), sb.toString());
                                entityToPkToVals.put(key, pkToVal);
                                continue;
                            }
                            ((Map)entityToPkToVals.get(key)).put(row.getString("id"), sb.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ds == null) continue;
                        if (throwable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ds.close();
                    }
                }
                if (!entityToPkToVals.isEmpty()) {
                    for (DynamicObject rowData : datas) {
                        String val;
                        Object pk;
                        Map pkToVal;
                        long assgrpTypeId = rowData.getLong("assgrptype_id");
                        String entityid = (String)assgrpTypeToEntity.get(assgrpTypeId);
                        if (!StringUtils.isNotBlank((CharSequence)entityid) || (pkToVal = (Map)entityToPkToVals.get(entityid)) == null || !this.isIdNotNull(pk = rowData.get("entryentity.basepk")) || !StringUtils.isNotBlank((CharSequence)(val = (String)pkToVal.get(pk))) || !this.checkDefaultValue(rowData, "entryentity.txtval")) continue;
                        rowData.set("entryentity.txtval", (Object)val);
                    }
                }
            }
            return datas;
        }

        private boolean checkDefaultValue(DynamicObject rowData, String s) {
            DynamicObjectType dynamicObjectType = rowData.getDynamicObjectType();
            DynamicProperty property = dynamicObjectType.getProperty(s);
            return property != null;
        }
    }
}

