/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.util.GLUtil;

public class AssgrpFilterEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String Key_Account = "account";
    private static final String Key_Assgrp = "assgrp";
    private static final String Key_Fdesc = "filterdesc";
    private static final String Key_Fvaldesc = "filtervaldesc";
    private static final String Key_Fval = "filterval";
    private static final String Key_FCondition = "filtercondition";
    private static final String Key_FCondition_Tag = "filtercondition_tag";
    private static final String Key_Entry = "entryentity";
    private static final String formId = "gl_assistfilter";
    private final DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{Key_Fdesc, Key_Fvaldesc});
        BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
        final Long org = (Long)this.getModel().getValue("org_id");
        accountTableEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                List accounttableIdByOrg = GLUtil.getAccounttableIdByOrg((Long)org);
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)accounttableIdByOrg));
            }
        });
        BasedataEdit accountEdit = (BasedataEdit)this.getControl(Key_Account);
        final Long accounttableid = (Long)this.getModel().getValue("accounttable_id");
        accountEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("accounttable", "=", (Object)accounttableid).and(new QFilter("isassist", "=", (Object)Boolean.TRUE)));
            }
        });
        accountEdit.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                AssgrpFilterEdit.this.clearNoDataRow();
            }
        });
        BasedataEdit assgrpEdit = (BasedataEdit)this.getControl(Key_Assgrp);
        final ArrayList<Object> assgrppks = new ArrayList<Object>();
        int index = this.getModel().getEntryCurrentRowIndex(Key_Entry);
        DynamicObject account = (DynamicObject)this.getModel().getValue(Key_Account, index);
        if (account != null) {
            DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
            for (DynamicObject dyn : col) {
                DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
                if (assgrp == null) continue;
                assgrppks.add(assgrp.getPkValue());
            }
        } else {
            List assistPKByOrg = GLUtil.getAssistPKByOrg((Long)org);
            assgrppks.addAll(assistPKByOrg);
        }
        assgrpEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("id", "in", (Object)assgrppks));
                qFilters.add(new QFilter("valuetype", "in", (Object)new String[]{"1", "2"}));
            }
        });
    }

    private void clearNoDataRow() {
        IDataModel model = this.getModel();
        model.clearNoDataRow();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        int rowIndex = model.getEntryCurrentRowIndex(Key_Entry);
        DynamicObject assisType = (DynamicObject)model.getValue(Key_Assgrp, rowIndex);
        this.setFilterValProp(assisType, type);
    }

    private void setFilterValProp(DynamicObject assisType, MainEntityType type) {
        EntryProp entry = (EntryProp)type.getProperty(Key_Entry);
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(Key_Fval);
        if (assisType == null) {
            return;
        }
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String orgid = null;
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            IPageCache cache = (IPageCache)parentView.getService(IPageCache.class);
            orgid = cache.get("orgid");
        }
        IDataModel model = this.getModel();
        if (StringUtils.isNotBlank(orgid)) {
            Long org = Long.valueOf(orgid);
            model.setValue("org", (Object)Long.valueOf(orgid));
            Map accountTable = GLUtil.getBookTypeAndAccountTable((Long)org);
            if (accountTable.get("1") != null) {
                model.setValue("accounttable", ((List)accountTable.get("1")).get(0));
            } else if (accountTable.get("2") != null) {
                model.setValue("accounttable", ((List)accountTable.get("2")).get(0));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long orgId = (Long)this.getModel().getValue("org_id");
        if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"gl", (String)"gl_assgrpfilter", (String)"4715a0df000000ac") != 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnsave"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u7ef4\u5ea6\u503c\u8303\u56f4\u8bbe\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssgrpFilterEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        DynamicObject valuesource;
        Control control = (Control)evt.getSource();
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(Key_Entry);
        DynamicObject assgrp = (DynamicObject)this.getModel().getValue(Key_Assgrp, row);
        if (assgrp != null && (valuesource = assgrp.getDynamicObject("valuesource")) != null) {
            switch (control.getKey()) {
                case "filterdesc": {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("gl_flex_propcondition");
                    showParameter.setCustomParam("filterjson", model.getValue(Key_FCondition_Tag, row));
                    showParameter.setCustomParam("baseformid", (Object)valuesource.getString("number"));
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_Fdesc));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(Key_Entry);
        switch (actionId) {
            case "filterdesc": {
                Map data = (Map)returnData;
                if (data == null || data.get("display") == null) break;
                model.setValue(Key_Fdesc, data.get("display"), row);
                model.setValue(Key_FCondition, data.get("display"), row);
                model.setValue(Key_FCondition_Tag, data.get("value"), row);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        int rowIndex = changeSet.getRowIndex();
        switch (name) {
            case "accounttable": {
                model.deleteEntryData(Key_Entry);
                break;
            }
            case "account": {
                DynamicObject account = (DynamicObject)changeSet.getNewValue();
                this.autoSetAssgrp(account, model, rowIndex);
                break;
            }
            case "assgrp": {
                DynamicObject assgrp = (DynamicObject)changeSet.getNewValue();
                this.existAccountAndAssgrp(assgrp, model, rowIndex);
                break;
            }
        }
    }

    private void autoSetAssgrp(DynamicObject account, IDataModel model, int row) {
        if (account == null || row < 0) {
            return;
        }
        if (!this.checkIfAccountHasTheAssistItem(account, model.getValue("assgrp_id"))) {
            model.setValue(Key_Fval, null, row);
            model.setValue(Key_Fvaldesc, null, row);
            model.setValue(Key_Fdesc, null, row);
            model.setValue(Key_FCondition, null, row);
            model.setValue(Key_FCondition_Tag, null, row);
        }
        Long newid = account.getLong("id");
        DynamicObjectCollection entryEntity = model.getEntryEntity(Key_Entry);
        for (DynamicObject entry : entryEntity) {
            Long accountid;
            if (entry.getInt("seq") == row + 1 || !(accountid = Long.valueOf(entry.getLong("account_id"))).equals(newid)) continue;
            model.setValue(Key_Assgrp, null, row);
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{Key_Account, Key_Assgrp});
        DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
        ArrayList assgrpIDList = new ArrayList(col.size());
        col.stream().forEach(dyn -> {
            if (dyn.getDynamicObject("asstactitem") != null) {
                assgrpIDList.add(dyn.getDynamicObject("asstactitem").getPkValue());
            }
        });
        QFilter typeFilter = new QFilter("valuetype", "<>", (Object)"3");
        QFilter idFilter = new QFilter("id", "in", assgrpIDList);
        Set ids = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"", (QFilter[])new QFilter[]{idFilter, typeFilter}).keySet();
        boolean first = true;
        for (Object id : ids) {
            if (first) {
                model.setValue(Key_Assgrp, id, row);
                first = false;
                continue;
            }
            vs.addRow(new Object[]{newid, id});
        }
        dataModel.batchCreateNewEntryRow(Key_Entry, vs);
        dataModel.endInit();
        this.getView().updateView(Key_Entry);
    }

    private boolean checkIfAccountHasTheAssistItem(DynamicObject acctDyo, Object assistItemPK) {
        return acctDyo.getDynamicObjectCollection("checkitementry").stream().anyMatch(entryDyo -> entryDyo.getDynamicObject("asstactitem").getPkValue().equals(assistItemPK));
    }

    private void existAccountAndAssgrp(DynamicObject assgrp, IDataModel model, int row) {
        Long assgrpid = 0L;
        if (assgrp == null || (assgrpid = Long.valueOf(assgrp.getLong("id"))) <= 0L) {
            return;
        }
        Long accountid = (Long)model.getValue("account_id", row);
        DynamicObjectCollection entryEntity = model.getEntryEntity(Key_Entry);
        for (DynamicObject entry : entryEntity) {
            if (entry.getInt("seq") == row + 1) continue;
            Long rowaccountid = entry.getLong("account_id");
            Long rowassgrpid = entry.getLong("assgrp_id");
            if (!accountid.equals(rowaccountid) || !assgrpid.equals(rowassgrpid)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0e\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u5df2\u5b58\u5728\u3002", (String)"AssgrpFilterEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            model.setValue(Key_Assgrp, null, row);
            break;
        }
        model.setValue(Key_Fval, null, row);
        model.setValue(Key_Fvaldesc, null, row);
        model.setValue(Key_Fdesc, null, row);
        model.setValue(Key_FCondition, null, row);
        model.setValue(Key_FCondition_Tag, null, row);
    }

    public void initImportData(InitImportDataEventArgs e) {
        String cacheKey = RequestContext.getOrCreate().getUserId() + formId;
        String curOrgId = this.distributeCache.get(cacheKey);
        List dataList = e.getSourceDataList();
        if (curOrgId != null) {
            HashSet<String> orgNumberSet = new HashSet<String>(8);
            for (Map data2 : dataList) {
                Map org = (Map)data2.get("org");
                if (org == null || !StringUtils.isNotBlank(org.get("number"))) continue;
                orgNumberSet.add((String)org.get("number"));
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumberSet)}, null);
            HashMap<String, Long> orgNumberToIdMap = new HashMap<String, Long>(8);
            for (Row row : dataSet) {
                orgNumberToIdMap.put(row.getString("number"), row.getLong("id"));
            }
            dataList.forEach(data -> {
                String orgId = curOrgId;
                Map orgnization = (Map)data.get("org");
                if (orgnization != null && StringUtils.isNotBlank(orgnization.get("number")) && orgNumberToIdMap.get(orgnization.get("number")) != null) {
                    orgId = String.valueOf(orgNumberToIdMap.get(orgnization.get("number")));
                    orgnization.put("id", orgId);
                }
                List entryentity = (List)data.get(Key_Entry);
                String accountTableNumber = (String)((Map)data.get("accounttable")).get("number");
                long accountTableId = this.getAccountTableIdByNumber(accountTableNumber);
                String finalOrgId = orgId;
                entryentity.forEach(entry -> {
                    Map account = (Map)entry.get(Key_Account);
                    if (account != null) {
                        account.put("id", this.getAccountId(finalOrgId, accountTableId, (String)account.get("number")));
                    }
                });
            });
        }
    }

    private Long getAccountId(String orgId, long accountTableId, String accountNumber) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("number", "=", (Object)accountNumber));
        Set accountIds = AccountUtils.queryAccountIds((long)Long.parseLong(orgId), (long)accountTableId, qFilters);
        return accountIds.isEmpty() ? Long.valueOf(0L) : (Long)accountIds.iterator().next();
    }

    private Long getAccountTableIdByNumber(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject accountTable = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        return accountTable == null ? 0L : accountTable.getLong("id");
    }
}

