/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.util.StringUtils;
import kd.fi.gl.util.GLUtil;

public class AssistPropFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String F7_SELECTED_LISTAP = "f7selectedlistap";
    private static final String TREE_VIEW = "treeviewap";
    private static final String ROOT_NODE = "0";
    private static final String VALUE_SOURCE = "valuesource";
    private static final String BTN_OK = "btnok";
    private static final String SELECTED_FIELDS = "selectedfields";
    private static final String TREE_NODE_CACHE = "treeNodeCache";
    private static final String SELECTED_FIELDS_CACHE = "selectedfieldscache";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String valueSource = (String)this.getView().getFormShowParameter().getCustomParam(VALUE_SOURCE);
        if (StringUtils.isEmpty((String)valueSource)) {
            return;
        }
        TreeNode treeNode = this.getAssistPropsNode(valueSource);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW);
        tree.addNode(treeNode);
        this.getPageCache().put(TREE_NODE_CACHE, GLUtil.toSerializedString((Object)treeNode));
        String fields = (String)this.getView().getFormShowParameter().getCustomParam(SELECTED_FIELDS);
        if (!StringUtils.isEmpty((String)fields)) {
            Map map = (Map)GLUtil.fromSerializedString((String)fields);
            HashSet<String> selectedFields = new HashSet<String>(map.keySet());
            this.setSelectedList(treeNode, selectedFields);
            this.cacheSelectFields(selectedFields);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        F7SelectedList selectedList = (F7SelectedList)this.getControl(F7_SELECTED_LISTAP);
        selectedList.addF7SelectedListRemoveListener(new F7SelectedListRemoveListener(){

            public void RemoveClick(F7SelectedListRemoveEvent evt) {
                Object param = evt.getParam();
                if (null == param) {
                    return;
                }
                Set selectFields = AssistPropFormPlugin.this.getSelectFieldsFromCache();
                if (null == selectFields) {
                    return;
                }
                selectFields.remove(param.toString());
                AssistPropFormPlugin.this.cacheSelectFields(selectFields);
            }
        });
        selectedList.addF7SelectedListRemoveAllListener(new F7SelectedListRemoveListener(){

            public void RemoveClick(F7SelectedListRemoveEvent evt) {
                AssistPropFormPlugin.this.removeSelectFieldCache();
            }
        });
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId;
        TreeNode treeNode = this.getTreeNode();
        if (treeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"AssistPropFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> selectFields = this.getSelectFieldsFromCache();
        if (null == selectFields) {
            selectFields = new HashSet<String>(8);
        }
        if (null == (nodeId = evt.getNodeId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"AssistPropFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode selectNode = treeNode.getTreeNode(nodeId.toString(), 5);
        if (selectNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u5bf9\u5e94\u6570\u636e\u3002", (String)"AssistPropFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null != selectNode.getChildren() && !selectNode.getChildren().isEmpty()) {
            return;
        }
        selectFields.add(nodeId.toString());
        this.setSelectedList(treeNode, selectFields);
        this.cacheSelectFields(selectFields);
    }

    private void setSelectedList(TreeNode treeNode, Set<String> selectFields) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selectFields.size());
        for (String selectField : selectFields) {
            TreeNode node = treeNode.getTreeNode(selectField, 5);
            if (null == node) continue;
            valueTextItems.add(new ValueTextItem(node.getId(), node.getText()));
        }
        F7SelectedList ctrl = (F7SelectedList)this.getView().getControl(F7_SELECTED_LISTAP);
        ctrl.addItems(valueTextItems);
    }

    private TreeNode getTreeNode() {
        TreeNode treeNode = null;
        String treeNodeCache = this.getPageCache().get(TREE_NODE_CACHE);
        if (!StringUtils.isEmpty((String)treeNodeCache)) {
            treeNode = (TreeNode)GLUtil.fromSerializedString((String)treeNodeCache);
        }
        return treeNode;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String Key2 = control.getKey();
        if (BTN_OK.equals(Key2)) {
            this.returnSelectResult();
        }
    }

    private void returnSelectResult() {
        HashMap<String, String> result = new HashMap<String, String>(32);
        Set<String> selectFields = this.getSelectFieldsFromCache();
        TreeNode treeNode = this.getTreeNode();
        if (null != treeNode && null != selectFields) {
            for (String selectField : selectFields) {
                TreeNode node = treeNode.getTreeNode(selectField, 5);
                if (null == node) continue;
                result.put(selectField, node.getText());
            }
        }
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private TreeNode getAssistPropsNode(String valueSource) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)valueSource);
        DataEntityPropertyCollection propertys = entityType.getProperties();
        TreeNode root = new TreeNode("", ROOT_NODE, entityType.getDisplayName().toString());
        root.setIsOpened(true);
        for (IDataEntityProperty property : propertys) {
            if (StringUtils.isEmpty((String)property.getAlias()) || property instanceof EntryProp) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                String propertyName = property.getName();
                String displayName = null == property.getDisplayName() ? "" : property.getDisplayName().toString();
                TreeNode node = new TreeNode(ROOT_NODE, propertyName, displayName);
                IDataEntityType bdType = bdProp.getComplexType();
                for (IDataEntityProperty childProp : bdType.getProperties()) {
                    LocaleString localeString = childProp.getDisplayName();
                    if (null == localeString) continue;
                    String fullName = propertyName + "." + childProp.getName();
                    TreeNode detailNode = new TreeNode(propertyName, fullName, displayName + "." + localeString.toString());
                    node.addChild(detailNode);
                }
                root.addChild(node);
                continue;
            }
            LocaleString localeString = property.getDisplayName();
            if (null == localeString) continue;
            TreeNode node = new TreeNode(ROOT_NODE, property.getName(), localeString.getLocaleValue());
            root.addChild(node);
        }
        return root;
    }

    private void cacheSelectFields(Set<String> selectFields) {
        this.getPageCache().put(SELECTED_FIELDS_CACHE, GLUtil.toSerializedString(selectFields));
    }

    private Set<String> getSelectFieldsFromCache() {
        String selectFieldsCache = this.getPageCache().get(SELECTED_FIELDS_CACHE);
        Set selectFields = null;
        if (!StringUtils.isEmpty((String)selectFieldsCache)) {
            selectFields = (Set)GLUtil.fromSerializedString((String)selectFieldsCache);
        }
        return selectFields;
    }

    private void removeSelectFieldCache() {
        this.getPageCache().remove(SELECTED_FIELDS_CACHE);
    }
}

