/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.util.StringUtils;

public class AutoTransExcelPlugin
extends AbstractBillPlugIn
implements UploadListener,
ClickListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnresetfile", "btnsave"});
        this.addItemClickListeners(new String[]{"checkitemtoolbarap"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnsave": {
                String url = (String)this.getModel().getValue("filepath");
                IFormView view = this.getView();
                if (StringUtils.isEmpty((String)url)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6", (String)"AutoTransExcelPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
                boolean isMoneyEmpty = true;
                for (DynamicObject row : entry) {
                    if (row.get("assgrp") != null || !StringUtils.isNotEmpty((String)row.getString("page")) || !StringUtils.isNotEmpty((String)row.getString("position"))) continue;
                    isMoneyEmpty = false;
                }
                if (isMoneyEmpty) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u884c\u7684\u53d6\u503c\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoTransExcelPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.getPageCache().put("indatabase", "1");
            }
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"filepanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"uploadpanel"});
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("indatabase") != null) {
            e.setCheckDataChange(false);
            this.getView().returnDataToParent((Object)"indatabase");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter params = view.getFormShowParameter();
        String autorowid = (String)params.getCustomParam("autorowid");
        model.setValue("account", params.getCustomParam("accountid"));
        model.setValue("autorowid", (Object)autorowid);
        DynamicObject account = (DynamicObject)model.getValue("account");
        DynamicObjectCollection entry = account.getDynamicObjectCollection("checkitementry");
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", entry.size() + 1);
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject item = row.getDynamicObject("asstactitem");
            model.setValue("assgrp", (Object)item.getLong("id"), i);
            model.setValue("valuetype", (Object)item.getString("name"), i);
        }
        model.setValue("valuetype", (Object)ResManager.loadKDString((String)"\u91d1\u989d", (String)"AutoTransExcelPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.size());
        model.endInit();
        view.updateView("entryentity");
    }

    public void afterLoadData(EventObject e) {
        int i;
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String url = (String)model.getValue("filepath");
        FormShowParameter params = view.getFormShowParameter();
        model.setValue("account", params.getCustomParam("accountid"));
        DynamicObject account = (DynamicObject)model.getValue("account");
        DynamicObjectCollection acctEntry = account.getDynamicObjectCollection("checkitementry");
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (i = 0; i < acctEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)acctEntry.get(i);
            DynamicObject item = row.getDynamicObject("asstactitem");
            if (item == null) continue;
            String number = item.getString("number");
            DynamicObject dbItem = (DynamicObject)model.getValue("assgrp", i);
            if (dbItem != null && number.equals(dbItem.getString("number"))) continue;
            model.createNewEntryRow("entryentity", i, null);
            model.setValue("assgrp", (Object)item.getLong("id"), i);
            model.setValue("valuetype", (Object)item.getString("name"), i);
        }
        model.beginInit();
        model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
        for (i = 0; i < entry.size(); ++i) {
            DynamicObject item = ((DynamicObject)entry.get(i)).getDynamicObject("assgrp");
            if (item == null) {
                model.setValue("valuetype", (Object)ResManager.loadKDString((String)"\u91d1\u989d", (String)"AutoTransExcelPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), i);
                continue;
            }
            model.setValue("valuetype", (Object)item.getString("name"), i);
        }
        model.setDataChanged(false);
        model.endInit();
        this.getPageCache().put("indatabase", "1");
        view.updateView("filename");
    }

    public void afterBindData(EventObject e) {
        int row = this.getModel().getEntryRowCount("entryentity");
        if (row == 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnfill", "btncopy"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnfill": 
            case "btncopy": {
                IDataModel model = this.getModel();
                IFormView view = this.getView();
                int index = model.getEntryCurrentRowIndex("entryentity");
                String field = model.getEntryCurrentFieldKey("entryentity");
                if (StringUtils.isBlank((String)field)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"AutoTransExcelPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("valuetype".equals(field)) {
                    if ("btnfill".equals(key)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"AutoTransExcelPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"AutoTransExcelPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                DynamicObjectCollection entry = model.getEntryEntity("entryentity");
                String defvalue = ((DynamicObject)entry.get(index)).getString(field);
                if (StringUtils.isBlank((String)defvalue) || "0".equals(defvalue)) {
                    if ("btnfill".equals(key)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8981\u586b\u5145\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AutoTransExcelPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8981\u590d\u5236\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AutoTransExcelPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                for (int i = index + 1; i < entry.size(); ++i) {
                    String fillvalue = "btnfill".equals(key) ? this.getFillValue(defvalue, field, i - index) : defvalue;
                    model.setValue(field, (Object)fillvalue, i);
                }
                break;
            }
        }
    }

    private String getFillValue(String fieldValue, String key, int count) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fieldValue.length(); ++i) {
            char c = fieldValue.charAt(i);
            if ("page".equals(key)) {
                s.append((char)(c + count));
                continue;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                s.append((char)(c + count));
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            view.setVisible(Boolean.valueOf(true), new String[]{"filepanel"});
            view.setVisible(Boolean.valueOf(false), new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue("filepath", (Object)url);
        }
    }
}

