/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.PercentExpBuilder;
import kd.fi.gl.autotrans.PercentExpObject;

public class AutoTransPercentPlugin
extends AbstractBillPlugIn {
    private static final String Cache_Desc = "pagecache-desc";

    public void registerListener(EventObject e) {
        IPageCache cache = this.getPageCache();
        BasedataEdit acctEdit = (BasedataEdit)this.getView().getControl("account");
        acctEdit.addBeforeF7SelectListener(evt -> {
            String tableStr = cache.get("accountTableId");
            long acctTableId = 0L;
            if (!StringUtils.isBlank((CharSequence)tableStr)) {
                acctTableId = Long.parseLong(tableStr);
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("accounttable", "=", (Object)acctTableId));
            filters.add(new QFilter("ismanual", "=", (Object)true));
        });
        BasedataEdit curEdit = (BasedataEdit)this.getControl("currency");
        curEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue("account", evt.getRow());
            if (accoutDyn != null) {
                ArrayList<Long> ids = new ArrayList<Long>();
                if ("descurrency".equals(accoutDyn.get("acctcurrency"))) {
                    DynamicObjectCollection coll = (DynamicObjectCollection)accoutDyn.get("currencyentry");
                    for (DynamicObject dyn : coll) {
                        Long acctCur = dyn.getLong("currency_id");
                        ids.add(acctCur);
                    }
                    String baseid = cache.get("baseCurrency");
                    ids.add(Long.valueOf(baseid));
                    QFilter filter = new QFilter("id", "in", ids);
                    ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(filter);
                }
            }
        });
    }

    public void afterLoadData(EventObject e) {
        this.setOrgAndBook();
    }

    public void afterCreateNewData(EventObject e) {
        this.setOrgAndBook();
    }

    private void setOrgAndBook() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customValue = formShowParameter.getCustomParams();
        if (customValue == null) {
            return;
        }
        Object orgObj = customValue.get("param-org");
        Object bookObj = customValue.get("param-book");
        if (orgObj == null || bookObj == null) {
            return;
        }
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)Long.parseLong(orgObj.toString()), (long)Long.parseLong(bookObj.toString()));
        if (book == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0e\u8d26\u7c3f\u7c7b\u578b\u4e0b\u7684\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"AutoTransPercentPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("org", (Object)Long.valueOf(orgObj.toString()));
        model.setValue("accountbook", (Object)book.getId());
        model.setValue("period", (Object)book.getCurPeriodId());
        long accountTableId = book.getAccountTableId();
        long baseCurrencyId = book.getBaseCurrencyId();
        IPageCache cache = this.getPageCache();
        cache.put("accountTableId", String.valueOf(accountTableId));
        cache.put("baseCurrency", String.valueOf(baseCurrencyId));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("account".equals(name)) {
            IDataModel model = this.getModel();
            int i = e.getChangeSet()[0].getRowIndex();
            model.setValue("currency", (Object)this.getPageCache().get("baseCurrency"), i);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            try {
                DynamicObject bill = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
                PercentExpObject expObject = PercentExpObject.create((DynamicObject)bill);
                PercentExpBuilder builder = PercentExpBuilder.create((PercentExpObject)expObject);
                builder.build(Boolean.FALSE.booleanValue());
                String desc = expObject.getDesc();
                if (StringUtils.isBlank((CharSequence)desc)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7f16\u8f91\u6709\u6548\u516c\u5f0f\u3002", (String)"AutoTransPercentPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
                this.getPageCache().put(Cache_Desc, desc);
            }
            catch (Exception exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff1a%s\u3002", (String)"AutoTransPercentPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), exp.getMessage()));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List successPkIds;
        if ("save".equalsIgnoreCase(e.getOperateKey()) && !(successPkIds = e.getOperationResult().getSuccessPkIds()).isEmpty()) {
            this.returnData(successPkIds.get(0));
        }
    }

    private void returnData(Object pk) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("data-desc", this.getPageCache().get(Cache_Desc));
        data.put("data-pk", pk);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }
}

