/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class BalanceSheetExpEdit
extends AbstractFormPlugin
implements ClickListener {
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "isTotalRow";
    private static final String entryKey = "entryentity";
    private static final String project = "project";
    private static final String sign = "sign";
    private static final String fetchRule = "fetchrule";
    private static final String btnOk = "btnok";
    private static final String addRow = "add";
    private static final String balrowId = "balrowid";
    private static final String columnKey = "columnkey";
    private static final String org = "org";
    private static final String accTable = "accounttable";
    private static final String orgField = "orgfield";

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btnOk)) {
            this.returnToData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void returnToData() {
        if (this.validate()) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("value", GlFormUtil.toDynamicObjectJson(this.getModel().getDataEntity(true)));
            para.put("entryEntity", this.getPageCache().get("entryEntity"));
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private boolean validate() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        if (collection == null) {
            return true;
        }
        Boolean isTotalRow = Boolean.valueOf(this.getModel().getValue(ISTOTALROW).toString());
        for (DynamicObject dynamicObject : collection) {
            if (isTotalRow.booleanValue()) {
                if (!StringUtils.isBlank((Object)dynamicObject.get(RPTITEM)) && !StringUtils.isBlank((Object)dynamicObject.get(sign))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b2c%s\u884c\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"BalanceSheetExpEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), dynamicObject.getInt(1)), Integer.valueOf(3000));
                return false;
            }
            if (!StringUtils.isBlank((Object)dynamicObject.get(project)) && !StringUtils.isBlank((Object)dynamicObject.get(sign)) && !StringUtils.isBlank((Object)dynamicObject.get(fetchRule))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b2c%s\u884c\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"BalanceSheetExpEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), dynamicObject.getInt(1)), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btnOk, addRow});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.filterAcct();
    }

    private void filterAcct() {
        BasedataEdit acctTarget = (BasedataEdit)this.getView().getControl(project);
        acctTarget.addBeforeF7SelectListener(e -> {
            long accounttable = (Long)this.getModel().getValue("accounttable_id");
            List filters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(AccountUtils.getAccountDataFilter((long)((Long)this.getModel().getValue(org)), (long)accounttable));
        });
        BasedataEdit itemEdit = (BasedataEdit)this.getView().getControl(RPTITEM);
        itemEdit.addBeforeF7SelectListener(e -> {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            long orgId = (Long)this.getModel().getValue(org);
            TaxReportFormHelper.filterTaxProject((long)orgId, (ListShowParameter)param, (String)"balancesheet");
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("name", "is not null", null));
            Object projectId = this.getView().getFormShowParameter().getCustomParam(project);
            if (projectId != null) {
                filters.add(new QFilter("id", "!=", projectId));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        block4: {
            DynamicObjectCollection defaultColl;
            IDataModel model;
            String type;
            Map value;
            block6: {
                String rowTag;
                String balrowIdStr;
                long bookTypeId;
                long accTableId;
                long orgId;
                FormShowParameter formShowParameter;
                block5: {
                    formShowParameter = this.getView().getFormShowParameter();
                    value = formShowParameter.getCustomParams();
                    if (value == null || !StringUtils.isNotBlank(value.get("periodType"))) break block4;
                    type = (String)value.get("periodType");
                    if (StringUtils.isBlank(value.get("orgId"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceSheetExpEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    model = this.getModel();
                    orgId = Long.parseLong(value.get("orgId").toString());
                    accTableId = Long.parseLong(value.get("accTableId").toString());
                    bookTypeId = Long.parseLong(value.get("booktype").toString());
                    balrowIdStr = value.get(balrowId).toString();
                    rowTag = value.get("rowtag").toString();
                    Boolean isTotalRow = Boolean.valueOf(value.get("istotalrow").toString());
                    model.setValue(org, (Object)orgId);
                    model.setValue(accTable, (Object)accTableId);
                    model.setValue("booktype", (Object)bookTypeId);
                    model.setValue(balrowId, (Object)balrowIdStr);
                    model.setValue(columnKey, (Object)type);
                    model.setValue("rowtag", (Object)rowTag);
                    model.setValue(ISTOTALROW, (Object)isTotalRow);
                    BasedataEdit rptItem = (BasedataEdit)this.getControl(RPTITEM);
                    rptItem.setMustInput(isTotalRow.booleanValue());
                    BasedataEdit projectbEdit = (BasedataEdit)this.getControl(project);
                    projectbEdit.setMustInput(isTotalRow == false);
                    this.getPageCache().put(balrowId, balrowIdStr);
                    this.getPageCache().put(columnKey, type);
                    this.getPageCache().put(org, String.valueOf(orgId));
                    this.getPageCache().put("entryEntity", value.get("entryEntity").toString());
                    if (value.get("value") == null) break block5;
                    MainEntityType mainEntityType = model.getDataEntityType();
                    DynamicObject dynamicObject = GlFormUtil.fromDynamicString((String)value.get("value"), mainEntityType);
                    DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection(entryKey);
                    if (coll != null && coll.size() > 0) {
                        model.getEntryEntity(entryKey).clear();
                    }
                    this.setEntry(coll);
                    break block4;
                }
                QFilter forg = new QFilter(org, "=", (Object)orgId);
                QFilter facctTable = new QFilter(accTable, "=", (Object)accTableId);
                QFilter bookType = new QFilter("booktype", "=", (Object)bookTypeId);
                QFilter fbalRowId = new QFilter(balrowId, "=", (Object)balrowIdStr);
                QFilter fcolumnKey = new QFilter(columnKey, "=", (Object)type);
                QFilter frowTag = new QFilter("rowtag", "=", (Object)rowTag);
                QFilter[] filters = new QFilter[]{forg, facctTable, bookType, fbalRowId, fcolumnKey, frowTag};
                String selectFields = "entryentity.project, entryentity.sign, entryentity.fetchrule, entryentity.rptitem rptitem";
                DynamicObjectCollection collection = QueryServiceHelper.query((String)formShowParameter.getFormId(), (String)selectFields, (QFilter[])filters);
                defaultColl = model.getEntryEntity(entryKey);
                if (collection == null || collection.size() <= 0) break block6;
                model.getEntryEntity(entryKey).clear();
                int[] indexs = this.getModel().batchCreateNewEntryRow(entryKey, collection.size());
                for (int i = 0; i < collection.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                    model.setValue(project, dynamicObject.get(0), indexs[i]);
                    model.setValue(sign, dynamicObject.get(1), indexs[i]);
                    model.setValue(fetchRule, dynamicObject.get(2), indexs[i]);
                    model.setValue(RPTITEM, dynamicObject.get(RPTITEM), indexs[i]);
                    model.setValue(orgField, value.get("orgId"), indexs[i]);
                }
                break block4;
            }
            if (defaultColl == null || defaultColl.size() <= 0) break block4;
            int count = defaultColl.size();
            for (int i = 0; i < count; ++i) {
                model.setValue(orgField, value.get("orgId"), i);
                model.setValue(fetchRule, (Object)this.fetchRuleByType(type), i);
            }
        }
    }

    private void setEntry(DynamicObjectCollection collection) {
        IDataModel model = this.getModel();
        if (collection != null && collection.size() > 0) {
            int[] indexs = this.getModel().batchCreateNewEntryRow(entryKey, collection.size());
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                model.setValue(project, dynamicObject.get(project), indexs[i]);
                model.setValue(sign, dynamicObject.get(sign), indexs[i]);
                model.setValue(fetchRule, dynamicObject.get(fetchRule), indexs[i]);
                model.setValue(RPTITEM, dynamicObject.get("rptitem_id"), indexs[i]);
                model.setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(org)), indexs[i]);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (addRow.equals(key)) {
            String type = this.getPageCache().get(columnKey);
            String value = this.fetchRuleByType(type);
            int index = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(fetchRule, (Object)value, index);
            this.getModel().setValue(sign, (Object)"+", index);
            this.getModel().setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(org)), index);
        }
    }

    private String fetchRuleByType(String type) {
        String value = "1";
        if ("1".equals(type) || "3".equals(type)) {
            value = "1";
        } else if ("2".equals(type) || "4".equals(type)) {
            value = "2";
        }
        return value;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (project.equals(name)) {
            IDataModel model = this.getModel();
            int index = e.getChangeSet()[0].getRowIndex();
            String type = this.fetchRuleByType(this.getPageCache().get(columnKey));
            String ruleIndex = (String)model.getValue(fetchRule, index);
            if (StringUtils.isEmpty((CharSequence)ruleIndex)) {
                model.setValue(fetchRule, (Object)type, index);
            }
            model.setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(org)), index);
        }
    }
}

