/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.formplugin.CardHomePlugin;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class CardAccountCarePlugin
extends CardHomePlugin
implements TabSelectListener,
HyperLinkClickListener {
    private static final String ADD_ROW = "addrow";
    private static final String EDIT_ROW = "editrow";
    private static final String DEL_ROW = "delrow";
    private static final String YEAR_COMPARE = "yearcompare";
    private static final String MONTH_COMPARE = "monthcompare";
    private static final String YEARCOMPARE_ENTRY = "yearcompareentry";
    private static final String MONTHCOMPARE_ENTRY = "monthcompareentry";
    private static final String[] TYPE_ARRAY = new String[]{"beginlocal", "debitlocal", "creditlocal", "endlocal", "yeardebitlocal", "yearcreditlocal"};

    public void afterCreateNewData(EventObject e) {
        this.initValue(false);
        this.getPageCache().put("isMonthCompare", "0");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_ROW, EDIT_ROW, DEL_ROW});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl(YEARCOMPARE_ENTRY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entry2 = (EntryGrid)this.getControl(MONTHCOMPARE_ENTRY);
        entry2.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initValue(boolean isMonthCompare) {
        if (this.getAccountBook() == null) {
            return;
        }
        if (isMonthCompare) {
            this.getModel().deleteEntryData(MONTHCOMPARE_ENTRY);
        } else {
            this.getModel().deleteEntryData(YEARCOMPARE_ENTRY);
        }
        AccountBookInfo accountBook = this.getAccountBook();
        QFilter userFilter = new QFilter("creator", "=", (Object)ContextUtil.getUserId());
        QFilter orgFilter = new QFilter("org", "=", (Object)accountBook.getOrgId());
        DynamicObject[] accountConfigDyos = BusinessDataServiceHelper.load((String)"gl_myattention", (String)"account,type", (QFilter[])new QFilter[]{userFilter, orgFilter});
        HashMap<String, List<CareAccount>> accountConfigMap = new HashMap<String, List<CareAccount>>(accountConfigDyos.length);
        for (DynamicObject accountConfigDyo : accountConfigDyos) {
            DynamicObjectCollection accountDyos = accountConfigDyo.getDynamicObjectCollection("account");
            accountConfigMap.computeIfAbsent(accountConfigDyo.getString("type"), k -> accountDyos.stream().map(x -> x.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(x -> new CareAccount(x.getLong("id"), x.getString("number"))).collect(Collectors.toList()));
        }
        this.createEntry(accountConfigMap, isMonthCompare);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (this.getAccountBook() == null) {
            return;
        }
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "addrow": {
                this.addRow();
                break;
            }
            case "editrow": {
                this.editRow();
                break;
            }
            case "delrow": {
                this.delRow();
                break;
            }
        }
    }

    private void delRow() {
        AccountBookInfo accountBook = this.getAccountBook();
        String isMonthCompare = this.getPageCache().get("isMonthCompare");
        HashMap<String, ArrayList<String>> editData = isMonthCompare.equals("0") ? this.getEntryAccountData(YEARCOMPARE_ENTRY, "account", "type", true) : this.getEntryAccountData(MONTHCOMPARE_ENTRY, "account1", "type1", true);
        if (editData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CardAccountCarePlugin_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<String, ArrayList<String>> editSinleData : editData.entrySet()) {
            String accountType = editSinleData.getKey();
            ArrayList<String> accountValue = editSinleData.getValue();
            DynamicObject db1 = this.getAttentionData(ContextUtil.getUserId(), accountBook.getOrgId(), accountType);
            if (db1 == null) continue;
            long primaryKey = db1.getLong("id");
            DynamicObject attentionSingleDb = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"gl_myattention");
            DynamicObjectCollection attentionColl = attentionSingleDb.getDynamicObjectCollection("account");
            Iterator iter = attentionColl.iterator();
            while (iter.hasNext()) {
                Long basedataId = ((DynamicObject)iter.next()).getDynamicObject("fbasedataid").getLong("id");
                if (!accountValue.contains(String.valueOf(basedataId))) continue;
                iter.remove();
            }
            if (attentionColl.size() == 0) {
                DeleteServiceHelper.delete((IDataEntityType)attentionSingleDb.getDataEntityType(), (Object[])new Object[]{primaryKey});
                continue;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attentionSingleDb});
        }
    }

    private void editRow() {
        String isMonthCompare = this.getPageCache().get("isMonthCompare");
        HashMap<String, ArrayList<String>> editData = isMonthCompare.equals("0") ? this.getEntryAccountData(YEARCOMPARE_ENTRY, "account", "type", false) : this.getEntryAccountData(MONTHCOMPARE_ENTRY, "account1", "type1", false);
        if (editData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7f16\u8f91\u7684\u6570\u636e\u3002", (String)"CardAccountCarePlugin_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        this.showAttentionAccount(true, editData);
    }

    private HashMap<String, ArrayList<String>> getEntryAccountData(String entryName, String accountTag, String typeTag, boolean isDel) {
        int[] selectRows;
        HashMap<String, ArrayList<String>> editData = new HashMap<String, ArrayList<String>>();
        EntryGrid entry = (EntryGrid)this.getControl(entryName);
        for (int selectRow : selectRows = entry.getSelectRows()) {
            DynamicObject singleEntry = this.getModel().getEntryRowEntity(entryName, selectRow);
            if (singleEntry == null) continue;
            String accountId = String.valueOf(singleEntry.getDynamicObject(accountTag).getLong("id"));
            String type = singleEntry.getString(typeTag);
            ArrayList<Object> dataList = editData.get(type) == null ? new ArrayList() : editData.get(type);
            dataList.add(accountId);
            editData.put(type, dataList);
        }
        if (isDel) {
            this.getModel().deleteEntryRows(entryName, selectRows);
        }
        return editData;
    }

    private void addRow() {
        this.showAttentionAccount(false, null);
    }

    private void showAttentionAccount(boolean isedit, HashMap<String, ArrayList<String>> editData) {
        AccountBookInfo accountBook = this.getAccountBook();
        long orgId = accountBook.getOrgId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gl_myattention");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("accountbookinfo", GLUtil.toSerializedString((Object)accountBook));
        param.put("org", String.valueOf(orgId));
        param.put("isedit", isedit);
        param.put("editData", SerializationUtils.toJsonString(editData));
        parameter.setCustomParam("param", param);
        CloseCallBack closeCall = new CloseCallBack((IFormPlugin)this, "addMyAttention");
        parameter.setCloseCallBack(closeCall);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("addMyAttention".equalsIgnoreCase(e.getActionId())) {
            String isMonthCompare = this.getPageCache().get("isMonthCompare");
            this.initValue(!isMonthCompare.equals("0"));
        }
    }

    private void createEntry(Map<String, List<CareAccount>> accountConfigMap, boolean isMonthCompare) {
        AccountBookInfo accountBook = this.getAccountBook();
        Long curPeroidId = accountBook.getCurPeriodId();
        if (curPeroidId == 0L) {
            return;
        }
        Long baseCurrencyId = accountBook.getBaseCurrencyId();
        Long orgId = accountBook.getOrgId();
        Long bookTypeId = accountBook.getBookTypeId();
        Long accountTableId = accountBook.getAccountTableId();
        IDataModel model = this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if (isMonthCompare) {
            vs.addField("account1", new Object[0]);
            vs.addField("type1", new Object[0]);
            vs.addField("currency1", new Object[0]);
            vs.addField("curamount1", new Object[0]);
            vs.addField("yearamount1", new Object[0]);
            vs.addField("rangetext1", new Object[0]);
            vs.addField("rangecombo1", new Object[0]);
        } else {
            vs.addField("account", new Object[0]);
            vs.addField("type", new Object[0]);
            vs.addField("currency", new Object[0]);
            vs.addField("curamount", new Object[0]);
            vs.addField("yearamount", new Object[0]);
            vs.addField("rangetext", new Object[0]);
            vs.addField("rangecombo", new Object[0]);
        }
        List<CareAccount> accounts = accountConfigMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<String, Map<CareAccount, BigDecimal>> dataMap = this.combineAmount(curPeroidId, orgId, bookTypeId, accountTableId, accounts, isMonthCompare, true);
        Map<String, Map<CareAccount, BigDecimal>> dataMap2 = this.combineAmount(curPeroidId, orgId, bookTypeId, accountTableId, accounts, isMonthCompare, false);
        ArrayList<HashMap> dataList = new ArrayList<HashMap>();
        for (Map.Entry<String, List<CareAccount>> entry : accountConfigMap.entrySet()) {
            String key = entry.getKey();
            List<CareAccount> careAccounts = entry.getValue();
            for (CareAccount careAccount : careAccounts) {
                int rangeCombo;
                String range;
                BigDecimal curAmount = new BigDecimal(0);
                BigDecimal otherAmount = new BigDecimal(0);
                if (dataMap.get(key) != null) {
                    curAmount = dataMap.get(key).computeIfAbsent(careAccount, k -> BigDecimal.ZERO);
                }
                if (dataMap2.get(key) != null) {
                    otherAmount = dataMap2.get(key).computeIfAbsent(careAccount, k -> BigDecimal.ZERO);
                }
                BigDecimal endAmount = curAmount.subtract(otherAmount);
                if (otherAmount.signum() != 0) {
                    if (endAmount.signum() != 0) {
                        BigDecimal rangeBig = endAmount.divide(otherAmount, 2, RoundingMode.HALF_UP);
                        range = rangeBig.abs().multiply(new BigDecimal(100)) + "%";
                        rangeCombo = endAmount.signum() > 0 ? 1 : 2;
                    } else {
                        rangeCombo = 0;
                        range = "";
                    }
                } else if (endAmount.compareTo(new BigDecimal(0)) < 0) {
                    range = "100%";
                    rangeCombo = 2;
                } else if (endAmount.compareTo(new BigDecimal(0)) > 0) {
                    range = "100%";
                    rangeCombo = 1;
                } else {
                    rangeCombo = 0;
                    range = "";
                }
                HashMap<String, Object> singleRow = new HashMap<String, Object>();
                singleRow.put("account", careAccount.getId());
                singleRow.put("accountnumber", careAccount.getAccountNumber());
                singleRow.put("type", key);
                singleRow.put("currency", baseCurrencyId);
                singleRow.put("curamount", curAmount);
                singleRow.put("yearamount", otherAmount);
                singleRow.put("rangetext", range);
                singleRow.put("rangecombo", rangeCombo);
                dataList.add(singleRow);
            }
        }
        dataList.sort(Comparator.comparing(a -> (String)a.get("accountnumber")));
        for (HashMap singleData : dataList) {
            vs.addRow(new Object[]{singleData.get("account"), singleData.get("type"), singleData.get("currency"), singleData.get("curamount"), singleData.get("yearamount"), singleData.get("rangetext"), singleData.get("rangecombo")});
        }
        AbstractFormDataModel model2 = (AbstractFormDataModel)model;
        model2.beginInit();
        if (isMonthCompare) {
            model2.batchCreateNewEntryRow(MONTHCOMPARE_ENTRY, vs);
            model2.endInit();
            this.getView().updateView(MONTHCOMPARE_ENTRY);
        } else {
            model2.batchCreateNewEntryRow(YEARCOMPARE_ENTRY, vs);
            model2.endInit();
            this.getView().updateView(YEARCOMPARE_ENTRY);
        }
    }

    private Map<String, Map<CareAccount, BigDecimal>> combineAmount(Long curPeroidId, Long orgId, Long bookTypeId, Long accountTableId, List<CareAccount> careAccounts, boolean isMonthCompare, boolean isCur) {
        long comparePeroidId = 0L;
        DynamicObject comparePeroid = isMonthCompare ? GLUtil.getPreviousPeriod((Object)curPeroidId) : GlFormUtil.getSamePeriodOfYear(curPeroidId, 1);
        if (comparePeroid != null) {
            comparePeroidId = comparePeroid.getLong("id");
        }
        Map<String, Map<CareAccount, BigDecimal>> balanceMap = new HashMap<String, Map<CareAccount, BigDecimal>>(16);
        if (isCur) {
            balanceMap = this.queryBalance(curPeroidId, orgId, bookTypeId, accountTableId, careAccounts);
        } else if (comparePeroidId != 0L) {
            balanceMap = this.queryBalance(comparePeroidId, orgId, bookTypeId, accountTableId, careAccounts);
        }
        return balanceMap;
    }

    private Map<String, Map<CareAccount, BigDecimal>> queryBalance(Long curPeroidId, Long orgId, Long bookTypeId, Long accountTableId, List<CareAccount> careAccounts) {
        HashMap accountMap = new HashMap(careAccounts.size());
        careAccounts.forEach(x -> accountMap.put(x.getAccountNumber(), x));
        QueryParam queryParam = new QueryParam();
        Set numbers = careAccounts.stream().map(CareAccount::getAccountNumber).collect(Collectors.toSet());
        QFilter accountFilter = new QFilter("number", "in", numbers);
        queryParam.setAccountFilter(accountFilter);
        String selectField = "beginlocal,debitlocal,creditlocal,endlocal,yeardebitlocal,yearcreditlocal,account.number";
        HashMap<String, Map<CareAccount, BigDecimal>> result = new HashMap<String, Map<CareAccount, BigDecimal>>(TYPE_ARRAY.length);
        try (DataSet balanceData = BalanceQueryExecutor.getInstance().getBalance(selectField, new Long[]{orgId}, bookTypeId.longValue(), accountTableId.longValue(), curPeroidId.longValue(), curPeroidId.longValue(), queryParam);){
            while (balanceData.hasNext()) {
                Row row = balanceData.next();
                CareAccount careAccount = (CareAccount)accountMap.get(row.getString("number"));
                if (careAccount == null) continue;
                for (String singleType : TYPE_ARRAY) {
                    Map balanceMap = result.computeIfAbsent(singleType, k -> new HashMap(careAccounts.size()));
                    balanceMap.put(careAccount, row.getBigDecimal(singleType));
                }
            }
        }
        return result;
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "yearcompare": {
                this.initValue(false);
                this.getPageCache().put("isMonthCompare", "0");
                break;
            }
            case "monthcompare": {
                this.initValue(true);
                this.getPageCache().put("isMonthCompare", "1");
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (this.getAccountBook() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        String isMonthCompare = this.getPageCache().get("isMonthCompare");
        long account = isMonthCompare.equals("0") ? this.getModel().getEntryRowEntity(YEARCOMPARE_ENTRY, selectRow).getDynamicObject("account").getLong("id") : this.getModel().getEntryRowEntity(MONTHCOMPARE_ENTRY, selectRow).getDynamicObject("account1").getLong("id");
        ReportQueryParam queryParam = this.createQueryParm(account);
        new NavToSubLedgerRpt.SLBuilder(queryParam, this.getView()).accountId(Long.valueOf(account)).build().apply();
    }

    private ReportQueryParam createQueryParm(Long accId) {
        DynamicObject accountView = BusinessDataServiceHelper.loadSingle((Object)accId, (String)"bd_accountview");
        AccountBookInfo accountBook = this.getAccountBook();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("org", (Object)accountBook.getOrgId());
        filter.addFilterItem("booktype", (Object)accountBook.getBookTypeId());
        filter.addFilterItem("periodtype", (Object)accountBook.getPeriodTypeId());
        filter.addFilterItem("startperiod", (Object)accountBook.getCurPeriodId());
        filter.addFilterItem("endperiod", (Object)accountBook.getCurPeriodId());
        filter.addFilterItem("accounttable", (Object)accountBook.getAccountTableId());
        filter.addFilterItem("account", (Object)accId);
        filter.addFilterItem("accountlevel", (Object)accountView.getString("level"));
        filter.addFilterItem("currency", (Object)"basecurrency");
        filter.addFilterItem("showdailysum", (Object)false);
        filter.addFilterItem("showqty", (Object)false);
        filter.addFilterItem("showleafaccount", (Object)false);
        filter.addFilterItem("nodisplayforzero", (Object)false);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        return queryParam;
    }

    private DynamicObject getAttentionData(Long creator, Long org, String type) {
        QFilter userFilter = new QFilter("creator", "=", (Object)creator);
        QFilter fieldFilter = new QFilter("type", "=", (Object)type);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        return QueryServiceHelper.queryOne((String)"gl_myattention", (String)"id", (QFilter[])new QFilter[]{userFilter, fieldFilter, orgFilter});
    }

    private static class CareAccount {
        private final long id;
        private final String accountNumber;

        private CareAccount(long id, String accountNumber) {
            this.id = id;
            this.accountNumber = accountNumber;
        }

        public long getId() {
            return this.id;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CareAccount that = (CareAccount)o;
            return Objects.equals(this.accountNumber, that.accountNumber);
        }

        public int hashCode() {
            return Objects.hash(this.accountNumber);
        }
    }
}

