/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ListExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.enums.CashStatusType;
import kd.fi.gl.formplugin.CashFlowDesignate;
import kd.fi.gl.formplugin.DesignateCommonPluginNew;
import kd.fi.gl.formplugin.PresetCashFlowDesignateNew;
import kd.fi.gl.util.CashFlowItemHelperNew;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MutexRequireHelper;
import kd.fi.gl.util.cashflow.CashFlowSumHelper;
import kd.fi.gl.util.cashflow.FilterContext;

public class CashFlowDesignatePluginNew
extends DesignateCommonPluginNew
implements HyperLinkClickListener {
    public static final String PC_ORG = "orgId";
    private static final String ENTRYKEY = "entry";
    private static final String ITEMNAME = "accountname";
    private static final String AMOUNT = "amount";
    private static final String VOUCHERIDS = "voucherid";
    private static final String COUNT = "count";
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String OPTIONCOLUMN = "operationcolumn";
    private static final String SUPPCALLBACK = "suppcallback";
    private static final String SUPERIOR = "superior";
    private static final String ACCTNO = "accountno";
    private static final String CFNO = "cfno";
    private static final String ISNDEAL = "isnotdeal";
    private static final String ISDETAILACT = "isdetailact";
    private static final String KEY_CURRENCY = "currency";
    private static final String FOLD = "cancel";
    private static final String EXPANDBYACCT = "bysubacct";
    private static final String CANCELAPPENDIXITEM = "cancelappendixitem";
    private static final String EXPANDBYAPPENDIXITEM = "byappendixitem";
    private static final String DESIGNITEM = "designitem";
    public static final String TYPE_ACC = "1";
    public static final String TYPE_CF = "2";
    public static final int DEFAULT_VOUCHERBATCH_SIZE = 200;
    public static final String ACC_SHOW_LEVEL = "acc_show_level";
    private Map<String, PresetCashFlowDesignateNew> map = null;
    private Map<Long, DynamicObject> cfItemMapCache = new HashMap<Long, DynamicObject>(8);
    public static final Log logger = LogFactory.getLog(CashFlowDesignatePluginNew.class);
    private static final String selectFields = "id,period, mainstatus, suppstatus, entries.id, entries.debitlocal, entries.creditlocal, entries.account.pltype, entries.account.longnumber,entries.account.number, entries.account.name, entries.account.iscash, entries.account.isbank, entries.account.iscashequivalent, entries.maincfitem.isdealactivity,entries.maincfitem.direction, entries.suppcfitem, entries.maincfamount, entries.suppcfamount,billstatus,entries.account,entries.entrydc,entries.assgrp,entries.account.accounttype.accounttype";

    private static String getDefsuppname() {
        return ResManager.loadKDString((String)"\u672a\u5904\u7406\u73b0\u91d1\u6d41\u91cf", (String)"CashFlowDesignatePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    private static String getAllacct() {
        return ResManager.loadKDString((String)"\u6240\u6709\u79d1\u76ee", (String)"CashFlowDesignatePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.optionColumn();
    }

    private void optionColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYKEY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && OPTIONCOLUMN.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                DynamicObject obj = pkEvent.getRowData();
                String type = obj.getString(TYPE);
                Boolean isdetailact = obj.getBoolean(ISDETAILACT);
                int level = obj.getInt(LEVEL);
                int count = obj.getInt(COUNT);
                String itemName = obj.getString(ITEMNAME);
                if (CashFlowDesignatePluginNew.getAllacct().equals(itemName) || "".equals(itemName)) {
                    ((OperationColItem)operationColItems.get(0)).setVisible(false);
                    ((OperationColItem)operationColItems.get(3)).setVisible(false);
                }
                if (count == 0) {
                    ((OperationColItem)operationColItems.get(4)).setVisible(false);
                } else {
                    ((OperationColItem)operationColItems.get(4)).setVisible(true);
                }
                if (type != null) {
                    if (type.equals(TYPE_ACC) && isdetailact.booleanValue()) {
                        ((OperationColItem)operationColItems.get(1)).setVisible(false);
                    } else if (type.equals(TYPE_CF)) {
                        ((OperationColItem)operationColItems.get(2)).setVisible(false);
                        if (level >= 3) {
                            ((OperationColItem)operationColItems.get(1)).setVisible(false);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "refresh": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                this.doQuery(filterContext);
                break;
            }
            case "preset": {
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
                HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)"gl_cashflowdesignate_new", (String)"0YH1QK63ECUV");
                if (null == hasPermOrg || !hasPermOrg.hasAllOrgPerm() && hasPermOrg.getHasPermOrgs().size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0[\u8865\u5145\u8d44\u6599\u6307\u5b9a]\u7684\u64cd\u4f5c[\u5e94\u7528\u9884\u8bbe]\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CashFlowDesignatePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showConfirmTipForPreset("preset", ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5df2\u6307\u5b9a\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1f", (String)"CashFlowDesignatePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void preset(boolean coverDesigned) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        AccountBookInfo book = filterContext.getBook();
        String checkMsg = this.checkPeriod(book);
        if (checkMsg != null) {
            this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
            return;
        }
        if (this.checkModifyHisCf()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5305\u542b\u5df2\u7ed3\u8d26\u671f\u95f4\u51ed\u8bc1\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"MainDesignateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filters = filterContext.getqFilter();
        if (!coverDesigned) {
            filters.and(new QFilter("suppstatus", "in", Arrays.asList(TYPE_CF, TYPE_ACC)));
            filters.and(new QFilter("entries.suppcfitem", "=", (Object)0L));
        }
        filters.and(new QFilter("billstatus", "in", Arrays.asList("B", "C")));
        this.getPageCache().put("isDesignFinish", "false");
        this.getPageCache().put("isDesignSuccess", "false");
        this.getPageCache().put("presetCount", "0");
        ((ProgressBar)this.getControl("progressbarap")).start();
        ThreadService.execute(() -> {
            boolean isDesignateSuccess = this.getSubAcctForPreset(filters, TYPE_ACC, "");
            this.getPageCache().put("isDesignFinish", "true");
            this.getPageCache().put("isDesignSuccess", String.valueOf(isDesignateSuccess));
        }, (TaskType)TaskType.GL_COMMON_ASYNC_TASK);
    }

    private boolean asynDesign(Map<String, PresetCashFlowDesignateNew> subAcct) {
        ArrayList<PresetCashFlowItemParam> paramList = new ArrayList<PresetCashFlowItemParam>(subAcct.size());
        this.initPresetParamAndVoucherIds(subAcct, paramList);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        AccountBookInfo book = filterContext.getBook();
        long orgId = book.getOrgId();
        long accountTableId = book.getAccountTableId();
        long batchGetCashFlowItemIdsStart = System.currentTimeMillis();
        Map presetMap = PresetCashItemUtil.batchGetCashFlowItemIds(paramList, (long)orgId, (long)accountTableId);
        long batchGetCashFlowItemIdsEnd = System.currentTimeMillis();
        logger.info("[T_preset]batchGetCashFlowItemIds_cost: {} ms", (Object)(batchGetCashFlowItemIdsEnd - batchGetCashFlowItemIdsStart));
        if (CollectionUtils.isEmpty((Map)presetMap)) {
            return false;
        }
        this.getPageCache().put("presetCount", String.valueOf(presetMap.size()));
        if (DebugTrace.enable()) {
            logger.info("\u6620\u5c04\u5173\u7cfb\u6253\u5370\u683c\u5f0f:acctId-acctLongnumber-assgrp-dc-itemType=value,\u6620\u5c04\u5173\u7cfbmap={}", (Object)this.presetMapToString(presetMap));
        }
        HashSet<Long> vIds = new HashSet<Long>(16);
        HashSet<Long> veIds = new HashSet<Long>(16);
        HashMap<Long, Long> entryIdItemIdMap = new HashMap<Long, Long>(16);
        for (CashFlowDesignate cashFlowDesignate : subAcct.values()) {
            PresetCashFlowDesignateNew value = (PresetCashFlowDesignateNew)cashFlowDesignate;
            Long itemId = (Long)presetMap.get(this.buildPresetParam(value));
            if (DebugTrace.enable()) {
                logger.info("\u5206\u5f55={},\u9644\u8868\u9884\u8bbe\u503c={}", (Object)value, (Object)itemId);
            }
            if (itemId == null) continue;
            Multimap<Long, Long> vchIdEntriesIdMap = value.getVchIdEntriesIdMap();
            for (Map.Entry vEntry : vchIdEntriesIdMap.asMap().entrySet()) {
                Long vid = (Long)vEntry.getKey();
                Collection entriesIds = (Collection)vEntry.getValue();
                vIds.add(vid);
                veIds.addAll(entriesIds);
                for (Long entryid : entriesIds) {
                    entryIdItemIdMap.put(entryid, itemId);
                }
            }
        }
        boolean isDesignateSuccess = this.designateV1(vIds, veIds, entryIdItemIdMap);
        return isDesignateSuccess;
    }

    private boolean designateV1(Set<Long> vIds, Set<Long> veIds, Map<Long, Long> entryIdItemIdMap) {
        logger.info("[T_preset]designateV1, voucherIds.size: {}, entryIdItemIdMap.size: {} ", (Object)vIds.size(), (Object)entryIdItemIdMap.size());
        QFilter entryIdFilter = new QFilter("id", "in", vIds).and(new QFilter("entries.id", "in", veIds));
        return this.designate(entryIdFilter, null, vIds, entryIdItemIdMap);
    }

    @Override
    protected void doQuery(FilterContext filterContext) {
        QFilter qFilter = filterContext.getqFilter();
        if (qFilter == null) {
            logger.error("filterContext.getqFilter() return null!");
            return;
        }
        BigDecimal amt = this.getSumAmt(filterContext);
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYKEY);
        if (amt != null) {
            int index = model.createNewEntryRow(ENTRYKEY);
            model.setValue(ITEMNAME, (Object)CashFlowDesignatePluginNew.getAllacct(), index);
            model.setValue(AMOUNT, (Object)amt, index);
            model.setValue(LEVEL, (Object)TYPE_ACC, index);
        }
    }

    @Override
    protected void doUpdateView() {
    }

    private void buildSuppRow(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignateNew> map, String newL, String superior, String acctNo, String cfNo, Boolean isnotdeal, Boolean isdetailact) {
        String key;
        Long cfitemId = row.getLong("cfitem");
        if (cfitemId != 0L) {
            DynamicObject cfItem = CashFlowItemHelperNew.getCfItem(this.cfItemMapCache, (Long)cfitemId);
            if (cfItem == null) {
                throw new KDBizException("cfItem is null , maincfitemId: " + cfitemId);
            }
            String cfnumber = cfItem.getString("number");
            String cfname = cfItem.getString("name");
            key = cfnumber + "_" + cfname;
            cfNo = cfnumber;
            isnotdeal = Boolean.FALSE;
        } else {
            key = CashFlowDesignatePluginNew.getDefsuppname();
            cfNo = "";
            isnotdeal = Boolean.TRUE;
        }
        PresetCashFlowDesignateNew cf = null;
        if (map.get(key) == null) {
            cf = new PresetCashFlowDesignateNew();
            map.put(key, cf);
            cf.setAmt(amt);
            cf.setName(key);
            cf.setType(TYPE_CF);
            cf.setSuperior(superior);
            cf.setLevel(newL);
            cf.setAcctNo(acctNo);
            cf.setCfNo(cfNo);
            cf.setIsNotDeal(isnotdeal);
            cf.setIsDetailAct(isdetailact);
        } else {
            cf = map.get(key);
            cf.setAmt(cf.getAmt().add(amt));
        }
    }

    private void buildAcctRow(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignateNew> map, String newL, String superior, String acctNo, String cfNo, Boolean isnotdeal) {
        String name = row.getString("number") + "_" + row.getString("name");
        String idKey = String.valueOf(row.getLong("account"));
        if (map.get(idKey) == null) {
            PresetCashFlowDesignateNew cf = new PresetCashFlowDesignateNew();
            map.put(idKey, cf);
            cf.setAmt(amt);
            cf.setName(name);
            cf.setType(TYPE_ACC);
            cf.setLevel(newL);
            cf.setSuperior(superior);
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            entryIds.add(row.getLong("id"));
            cf.setVoucherEntryIds(entryIds);
            cf.setAcctId(row.getLong("account"));
            cf.setAcctLongNumber(row.getString("longnumber"));
            cf.setItemType("3");
            cf.setAcctNo(acctNo);
            cf.setCfNo(cfNo);
            cf.setIsNotDeal(isnotdeal);
        } else {
            PresetCashFlowDesignateNew cf = map.get(idKey);
            cf.setAmt(cf.getAmt().add(amt));
        }
    }

    private Map<String, PresetCashFlowDesignateNew> getSubAcct(FilterContext context, String newL, String superior, String acctNo, String cfNo, Boolean isnotdeal) {
        LinkedHashMap<String, PresetCashFlowDesignateNew> map = new LinkedHashMap<String, PresetCashFlowDesignateNew>();
        DataSet ds = CashFlowSumHelper.getDesignDataSet((FilterContext)context);
        ds = ds.orderBy(new String[]{"number"});
        for (Row row : ds) {
            this.buildAcctRow(row.getBigDecimal(AMOUNT), row, map, newL, superior, acctNo, cfNo, isnotdeal);
        }
        return map;
    }

    private boolean getSubAcctForPreset(QFilter filters, String newL, String superior) {
        boolean result = false;
        HashSet<Long> vIdSet = new HashSet<Long>(16);
        LinkedHashMap<String, PresetCashFlowDesignateNew> map = new LinkedHashMap<String, PresetCashFlowDesignateNew>();
        AtomicInteger finshTaskCnt = new AtomicInteger(0);
        ArrayList<Future> futures = new ArrayList<Future>(16);
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])filters.toArray(), (String)"id", (int)-1);){
            int buildNum = 0;
            long voucherId = 0L;
            for (Row row : ds) {
                if (this.isBudgetAcct(row)) continue;
                Long vid = row.getLong("id");
                if (voucherId != 0L && vid != voucherId && vIdSet.size() >= 999) {
                    LinkedHashMap<String, PresetCashFlowDesignateNew> tempMap = new LinkedHashMap<String, PresetCashFlowDesignateNew>(map.size());
                    tempMap.putAll(map);
                    Future future = ThreadService.submit(() -> {
                        boolean asynDesign = this.asynDesign(tempMap);
                        this.getPageCache().put("designFinishCount", String.valueOf(finshTaskCnt.incrementAndGet() * 999));
                        return asynDesign;
                    }, (TaskType)TaskType.GL_PARELLEL_COMPUTE);
                    futures.add(future);
                    vIdSet.clear();
                    map.clear();
                }
                ++buildNum;
                voucherId = vid;
                vIdSet.add(voucherId);
                String mainStatus = row.getString("mainstatus");
                String suppstatus = row.getString("suppstatus");
                if (!mainStatus.equals("0") && !mainStatus.equals(TYPE_ACC)) {
                    if (this.isCashAcct(row)) continue;
                    if (this.isPLAcct(row) && !this.isDealactivity(row)) {
                        if (row.getString("suppstatus").equals("3")) {
                            if (row.getLong("entries.suppcfitem") == 0L) continue;
                            this.buildAcctRowForPreset(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                            continue;
                        }
                        this.buildAcctRowForPreset(row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal")), row, map, newL, superior);
                        continue;
                    }
                    if (this.isPLAcct(row) || !this.isDealactivity(row)) continue;
                    if (row.getString("suppstatus").equals("3")) {
                        if (row.getLong("entries.suppcfitem") == 0L) continue;
                        this.buildAcctRowForPreset(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                        continue;
                    }
                    BigDecimal amt = "o".equals(row.getString("entries.maincfitem.direction")) ? row.getBigDecimal("entries.maincfamount").negate() : row.getBigDecimal("entries.maincfamount");
                    this.buildAcctRowForPreset(amt, row, map, newL, superior);
                    continue;
                }
                if (!suppstatus.equals(TYPE_ACC) && !suppstatus.equals("3") && !suppstatus.equals(TYPE_CF) || this.isPLAcct(row)) continue;
                if (row.getString("suppstatus").equals("3")) {
                    if (row.getLong("entries.suppcfitem") == 0L) continue;
                    this.buildAcctRowForPreset(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
                    continue;
                }
                this.buildAcctRowForPreset(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
            }
            if (vIdSet.size() > 0) {
                Future future = ThreadService.submit(() -> this.asynDesign(map), (TaskType)TaskType.GL_PARELLEL_COMPUTE);
                futures.add(future);
            }
            this.getPageCache().put("designTotalCount", String.valueOf(buildNum));
        }
        for (Future future : futures) {
            try {
                if (!((Boolean)future.get()).booleanValue() || result) continue;
                result = (Boolean)future.get();
            }
            catch (Exception e) {
                logger.error("[T_preset]designateV1In error", (Throwable)e);
            }
        }
        return result;
    }

    private void buildAcctRowForPreset(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignateNew> map, String newL, String superior) {
        String name = row.getString("entries.account.number") + "_" + row.getString("entries.account.name");
        String idKey = row.getLong("entries.account") + row.getString("entries.entrydc");
        if (map.get(idKey) == null) {
            HashSet<Long> ids = new HashSet<Long>(16);
            ids.add(row.getLong("id"));
            PresetCashFlowDesignateNew cf = new PresetCashFlowDesignateNew();
            map.put(idKey, cf);
            cf.setAmt(amt);
            cf.setName(name);
            cf.setVchIds(ids);
            cf.setType(TYPE_ACC);
            cf.setLevel(newL);
            cf.setSuperior(superior);
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            entryIds.add(row.getLong("entries.id"));
            cf.setVoucherEntryIds(entryIds);
            ArrayListMultimap vchIdEntriesIdMap = ArrayListMultimap.create();
            vchIdEntriesIdMap.put((Object)row.getLong("id"), (Object)row.getLong("entries.id"));
            cf.setVchIdEntriesIdMap((Multimap<Long, Long>)vchIdEntriesIdMap);
            cf.setAcctId(row.getLong("entries.account"));
            cf.setAcctLongNumber(row.getString("entries.account.longnumber"));
            cf.setItemType("3");
            cf.setAssgrpId(row.getLong("entries.assgrp"));
            cf.setDc(row.getString("entries.entrydc"));
        } else {
            PresetCashFlowDesignateNew cf = map.get(idKey);
            cf.setAmt(cf.getAmt().add(amt));
            cf.getVchIds().add(row.getLong("id"));
            cf.getVoucherEntryIds().add(row.getLong("entries.id"));
            Multimap<Long, Long> vchIdEntriesIdMap = cf.getVchIdEntriesIdMap();
            vchIdEntriesIdMap.put((Object)row.getLong("id"), (Object)row.getLong("entries.id"));
        }
    }

    private Map<String, PresetCashFlowDesignateNew> setSuperAccount(Map<String, PresetCashFlowDesignateNew> map) {
        String str = this.getPageCache().get(ACC_SHOW_LEVEL);
        int level = str == null ? 1 : Integer.parseInt(str);
        Map<Object, TreeNode> accIdMap = this.getAccountMap();
        LinkedHashMap<String, PresetCashFlowDesignateNew> newMap = new LinkedHashMap<String, PresetCashFlowDesignateNew>();
        for (Map.Entry<String, PresetCashFlowDesignateNew> entry : map.entrySet()) {
            Long id = Long.valueOf(entry.getKey());
            TreeNode node = accIdMap.get(id);
            if (node == null || (node = this.getNodeByLevel(node, level)) == null) continue;
            PresetCashFlowDesignateNew value = entry.getValue();
            String name = node.getPropValue("number") + "_" + node.getPropValue("name");
            value.setName(name);
            value.setAcctNo((String)node.getPropValue("number"));
            value.setIsDetailAct(id.longValue() == node.getId());
            String idKey = String.valueOf(node.getId());
            newMap.compute(idKey, (k, v) -> {
                if (v == null) {
                    return value;
                }
                v.setAmt(v.getAmt().add(value.getAmt()));
                return v;
            });
        }
        return newMap;
    }

    private TreeNode getNodeByLevel(TreeNode node, int level) {
        int nodeLevel = (Integer)node.getPropValue(LEVEL);
        if (nodeLevel == level) {
            return node;
        }
        if (nodeLevel > level) {
            return this.getNodeByLevel(node.getParent(), level);
        }
        return null;
    }

    private void foldCurrentRow(IDataModel model, int curIndex) {
        List<Integer> rmvIndexes = this.getRvmRows(model, curIndex);
        int[] ints = rmvIndexes.stream().mapToInt(Integer::intValue).toArray();
        model.deleteEntryRows(ENTRYKEY, ints);
        model.setValue(COUNT, (Object)0, curIndex);
    }

    private List<Integer> getRvmRows(IDataModel model, int curIndex) {
        int count = (Integer)model.getValue(COUNT, curIndex);
        ArrayList<Integer> rmvIndexes = new ArrayList<Integer>();
        this.setRvmIndexes(curIndex, count, rmvIndexes, model);
        return rmvIndexes;
    }

    private void setRvmIndexes(int curIndex, int count, List<Integer> rmvIndexes, IDataModel model) {
        for (int i = 0; i < count; ++i) {
            rmvIndexes.add(++curIndex);
            int cnt = (Integer)model.getValue(COUNT, curIndex);
            this.setRvmIndexes(curIndex, cnt, rmvIndexes, model);
            curIndex += cnt;
        }
    }

    private String getSupAccountNumber() {
        int index = this.getSupAccountIndex();
        if (index != 0) {
            String name = ((String)this.getModel().getValue(ITEMNAME, index)).trim();
            return name.split("_")[0];
        }
        return null;
    }

    private int getSupAccountIndex() {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        return this.getSupAccountIndex(curIndex);
    }

    private int getSupAccountIndex(int curIndex) {
        IDataModel model = this.getModel();
        int curLevel = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
        String curType = (String)model.getValue(TYPE, curIndex);
        if (TYPE_ACC.equals(curType)) {
            return curIndex;
        }
        for (int i = curIndex; i > 0; --i) {
            int level = Integer.parseInt((String)model.getValue(LEVEL, i));
            if (level >= curLevel) continue;
            String type = (String)model.getValue(TYPE, i);
            if (type.equals(TYPE_ACC)) {
                return i;
            }
            if (level == 2) break;
            --curLevel;
        }
        return 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String id;
        switch (id = evt.getCallBackId()) {
            case "designate": {
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.openSuppItemF7Page();
                break;
            }
            case "preset": {
                if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.preset(true);
                    break;
                }
                if (!evt.getResult().equals((Object)MessageBoxResult.No)) break;
                this.preset(false);
                break;
            }
            case "cancelcf": {
                boolean hasCancel;
                String curIndex;
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes) || !kd.bos.util.StringUtils.isNotEmpty((String)(curIndex = this.getPageCache().get("curindex"))) || !(hasCancel = this.cancelSuppOp(this.getModel(), Integer.parseInt(curIndex)))) break;
                this.setCfNo(Integer.parseInt(curIndex), 0L);
                this.treeLoad();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"CashFlowDesignatePlugin_21", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean designItemOp(long itemId) {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        this.dealSumFilter(filterContext, curIndex);
        Set voucherIds = CashFlowSumHelper.getVocherIds((FilterContext)filterContext);
        QFilter fid = new QFilter("id", "in", (Object)voucherIds);
        QFilter qfilter = filterContext.getqFilter();
        this.dealVoucherFilter(qfilter, curIndex);
        boolean hasDesignate = this.designateV1Single(fid.and(qfilter), itemId, voucherIds);
        if (hasDesignate) {
            this.setCfNo(curIndex, itemId);
            this.treeLoad();
        }
        return hasDesignate;
    }

    private boolean designateV1Single(QFilter qfilter, long itemId, Set<Long> vids) {
        boolean result = false;
        HashSet<Long> subVids = new HashSet<Long>(999);
        for (Long vid : vids) {
            subVids.add(vid);
            if (subVids.size() < 999) continue;
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designate(fidQF, itemId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
            subVids.clear();
        }
        if (subVids.size() > 0) {
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designate(fidQF, itemId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean designate(QFilter qfilter, Long itemId, Set<Long> voucherIds, Map<Long, Long> entryidItemIdMap) {
        if (null == itemId && null == entryidItemIdMap) {
            throw new KDBizException("itemId & entryidItemIdMap is null");
        }
        HashSet bookIds = new HashSet();
        ArrayList paramList = new ArrayList(voucherIds.size());
        ArrayList vchParams = new ArrayList(voucherIds.size());
        ArrayList entryParams = new ArrayList(voucherIds.size());
        HashSet vchIds = new HashSet(voucherIds.size());
        HashMap dataMap = new HashMap(voucherIds.size());
        HashMap itemMap = new HashMap(voucherIds.size());
        this.checkParam(qfilter);
        boolean hasDesignate = false;
        boolean hasAuditVchs = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        qfilter.and(new QFilter("billstatus", "in", Arrays.asList("B", "C")));
        String opertion = "designate";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])qfilter.toArray(), (String)"id", (int)-1);){
            if (ds.hasNext()) {
                HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>(16);
                HashMap<Long, Long> itemIDMap = new HashMap<Long, Long>(16);
                long voucherId = 0L;
                for (Row row : ds) {
                    if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)row.getLong("period"), (String)row.getString("billstatus"))) {
                        hasAuditVchs = true;
                        continue;
                    }
                    if (voucherId != 0L && row.getLong("id") != voucherId) {
                        amtMap = new HashMap(16);
                        itemIDMap = new HashMap(16);
                        if (dataMap.size() > 200) {
                            CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)0L);
                            dataMap.clear();
                            itemMap.clear();
                            hasDesignate = true;
                        }
                    }
                    voucherId = row.getLong("id");
                    dataMap.put(voucherId, amtMap);
                    itemMap.put(voucherId, itemIDMap);
                    Long entryId = row.getLong("entries.id");
                    Long itemIdParam = itemId;
                    if (itemIdParam == null && (itemIdParam = entryidItemIdMap.get(entryId)) == null) {
                        throw new KDBizException("itemId is null, entryId: " + entryId);
                    }
                    itemIDMap.put(entryId, itemIdParam);
                    String suppStatus = row.getString("suppstatus");
                    if (suppStatus.equals("3")) {
                        if (row.getLong("entries.suppcfitem") == 0L) continue;
                        amtMap.put(entryId, row.getBigDecimal("entries.suppcfamount"));
                        continue;
                    }
                    String mainStatus = row.getString("mainstatus");
                    if (!mainStatus.equals("0")) {
                        if (this.isCashAcct(row)) continue;
                        if (this.isPLAcct(row) && !this.isDealactivity(row)) {
                            amtMap.put(entryId, row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal")));
                            continue;
                        }
                        if (this.isPLAcct(row) || !this.isDealactivity(row)) continue;
                        BigDecimal amt = row.getBigDecimal("entries.maincfamount");
                        if ("o".equals(row.getString("entries.maincfitem.direction"))) {
                            amt = amt.negate();
                        }
                        amtMap.put(entryId, amt);
                        continue;
                    }
                    if (this.isPLAcct(row)) continue;
                    amtMap.put(entryId, row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")));
                }
                if (dataMap.size() > 0) {
                    CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)0L);
                    hasDesignate = true;
                }
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vchIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", voucherIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                CashFlowItemHelperNew.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return hasDesignate;
    }

    private void treeLoad() {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        if (curIndex == 0) {
            this.firstLineDeploy(curIndex);
        } else {
            String type;
            switch (type = (String)model.getValue(TYPE, curIndex)) {
                case "1": {
                    int cfIndex = this.getSuperCashFlowExcludeSelf(curIndex, model);
                    if (cfIndex != -1) {
                        int supAccountIndex = this.getSupAccountIndex(cfIndex);
                        if (supAccountIndex == 0) {
                            this.firstLineDeploy(0);
                            break;
                        }
                        this.callDeploy(model, supAccountIndex, true);
                        break;
                    }
                    this.callDeploy(model, curIndex, true);
                    break;
                }
                case "2": {
                    int supAccountIndex = this.getSupAccountIndex();
                    if (supAccountIndex == 0) {
                        this.firstLineDeploy(0);
                        break;
                    }
                    this.callDeploy(model, supAccountIndex, true);
                    break;
                }
                default: {
                    this.callDeploy(model, curIndex, true);
                }
            }
        }
    }

    private int getSuperCashFlowExcludeSelf(int curIndex, IDataModel model) {
        int level = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
        boolean isSupContainCashFlow = false;
        for (int i = curIndex - 1; i > 0; --i) {
            int lv = Integer.parseInt((String)model.getValue(LEVEL, i));
            if (lv >= level) continue;
            String t = (String)model.getValue(TYPE, i);
            if (t.equals(TYPE_CF)) {
                curIndex = i;
                isSupContainCashFlow = true;
            }
            if (lv == 2) break;
        }
        return isSupContainCashFlow ? curIndex : -1;
    }

    private void firstLineDeploy(int curIndex) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        this.dealSumFilter(filterContext, curIndex);
        this.deploy(filterContext, true, 2, curIndex, "");
    }

    private void callDeploy(IDataModel model, int curIndex, boolean isByAccount) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        this.dealSumFilter(filterContext, curIndex);
        if (isByAccount) {
            this.deploy(filterContext, false, 2, curIndex, "");
        } else {
            this.deploy(filterContext, false, 1, curIndex, "");
        }
    }

    private Set<String> getSubAccNumber(String acctNum) {
        HashSet<String> result = new HashSet<String>();
        DataSet dyn = this.getDataSetByNumber(acctNum);
        this.getLeafAccount(dyn, result, "fnumber");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelSuppOp(IDataModel model, int curIndex) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        this.dealSumFilter(filterContext, curIndex);
        Set voucherIds = CashFlowSumHelper.getVocherIds((FilterContext)filterContext);
        QFilter fid = new QFilter("id", "in", (Object)voucherIds);
        QFilter qfilter = filterContext.getqFilter();
        this.dealVoucherFilter(qfilter, curIndex);
        qfilter.and(fid);
        HashSet bookIds = new HashSet(10);
        HashSet vouIds = new HashSet(16);
        ArrayList paramList = new ArrayList(16);
        ArrayList vchParams = new ArrayList(16);
        ArrayList entryParams = new ArrayList(16);
        HashMap dataMap = new HashMap(16);
        this.checkParam(qfilter);
        boolean hasAuditVchs = false;
        boolean hasCancel = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        String opertion = "cancelSuppOp";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", (Set)voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)"id, period,billstatus, entries.id", (QFilter[])qfilter.toArray(), null, (int)-1);){
            ArrayList<Long> entryIds = new ArrayList<Long>(10);
            long voucherId = 0L;
            for (Row r : ds) {
                if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)r.getLong("period"), (String)r.getString("billstatus"))) {
                    hasAuditVchs = true;
                    continue;
                }
                if (voucherId != 0L && r.getLong("id") != voucherId) {
                    entryIds = new ArrayList(10);
                    if (dataMap.size() > 200) {
                        CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vouIds);
                        dataMap.clear();
                        hasCancel = true;
                    }
                }
                voucherId = r.getLong("id");
                dataMap.put(voucherId, entryIds);
                if (r.getLong("entries.id") == 0L) continue;
                entryIds.add(r.getLong("entries.id"));
            }
            if (dataMap.size() > 0) {
                CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vouIds);
                hasCancel = true;
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vouIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                CashFlowItemHelperNew.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return hasCancel;
    }

    private void deploy(FilterContext context, boolean firstLine, int type, int curIndex, String superior) {
        String level = (String)this.getModel().getValue(LEVEL, curIndex);
        String acctNo = (String)this.getModel().getValue(ACCTNO, curIndex);
        String cfNo = (String)this.getModel().getValue(CFNO, curIndex);
        Boolean isnotdeal = (Boolean)this.getModel().getValue(ISNDEAL, curIndex);
        Boolean isdetailact = (Boolean)this.getModel().getValue(ISDETAILACT, curIndex);
        String newL = String.valueOf(Integer.parseInt(level) + 1);
        if (type == 1) {
            this.map = this.getSubAcct(context, newL, superior, acctNo, cfNo, isnotdeal);
            this.map = this.setSuperAccount(this.map);
        } else if (type == 2) {
            this.map = this.getAppendixItem(context, newL, superior, acctNo, cfNo, isnotdeal, isdetailact);
        }
        if (this.map != null && this.map.size() > 0) {
            IDataModel model = this.getModel();
            model.getDataEntity(true);
            DynamicObjectCollection col = model.getEntryEntity(ENTRYKEY);
            long[] infoKey = this.batchGenGlobalIds(this.map.size());
            int keyIndex = 0;
            if (firstLine) {
                int size = col.size();
                for (int i = size - 1; i > 0; --i) {
                    col.remove(i);
                }
                for (PresetCashFlowDesignateNew cf : this.map.values()) {
                    DynamicObject obj = col.addNew();
                    String tabs = this.getTabs(cf.getLevel());
                    obj.set(ITEMNAME, (Object)(tabs + cf.getName()));
                    obj.set(AMOUNT, (Object)cf.getAmt());
                    obj.set(TYPE, (Object)cf.getType());
                    obj.set(LEVEL, (Object)cf.getLevel());
                    obj.set(VOUCHERIDS, (Object)Long.toString(infoKey[keyIndex]));
                    obj.set(SUPERIOR, (Object)cf.getSuperior());
                    obj.set(ACCTNO, (Object)cf.getAcctNo());
                    obj.set(CFNO, (Object)cf.getCfNo());
                    obj.set(ISNDEAL, (Object)cf.getIsNotDeal());
                    obj.set(ISDETAILACT, (Object)cf.getIsDetailAct());
                    ++keyIndex;
                }
            } else {
                List<Integer> rvmRows = this.getRvmRows(model, curIndex);
                rvmRows.sort(Comparator.reverseOrder());
                for (int rvmRow : rvmRows) {
                    col.remove(rvmRow);
                }
                int index = curIndex;
                for (PresetCashFlowDesignateNew cf : this.map.values()) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)model.getDataEntityType().getAllEntities().get(ENTRYKEY));
                    col.add(++index, obj);
                    String tabs = this.getTabs(cf.getLevel());
                    obj.set(ITEMNAME, (Object)(tabs + cf.getName()));
                    obj.set(AMOUNT, (Object)cf.getAmt());
                    obj.set(TYPE, (Object)cf.getType());
                    obj.set(LEVEL, (Object)cf.getLevel());
                    obj.set(VOUCHERIDS, (Object)Long.toString(infoKey[keyIndex]));
                    obj.set(SUPERIOR, (Object)cf.getSuperior());
                    obj.set(ACCTNO, (Object)cf.getAcctNo());
                    obj.set(CFNO, (Object)cf.getCfNo());
                    obj.set(ISNDEAL, (Object)cf.getIsNotDeal());
                    obj.set(ISDETAILACT, (Object)cf.getIsDetailAct());
                    ++keyIndex;
                }
            }
            model.setValue(COUNT, (Object)this.map.size(), curIndex);
            this.getView().updateView(ENTRYKEY);
        }
    }

    private String getTabs(String level) {
        return "";
    }

    private Map<String, PresetCashFlowDesignateNew> getAppendixItem(FilterContext context, String newL, String superior, String acctNo, String cfNo, Boolean isnotdeal, Boolean isdetailact) {
        LinkedHashMap<String, PresetCashFlowDesignateNew> map = new LinkedHashMap<String, PresetCashFlowDesignateNew>();
        try (DataSet ds = CashFlowSumHelper.getDesignDataSet((FilterContext)context);){
            if (ds.hasNext()) {
                for (Row row : ds) {
                    BigDecimal amt = row.getBigDecimal(AMOUNT);
                    this.buildSuppRow(amt, row, map, newL, superior, acctNo, cfNo, isnotdeal, isdetailact);
                }
            }
        }
        return map;
    }

    private BigDecimal getSumAmt(FilterContext filterContext) {
        filterContext.setTypes(new String[]{CashStatusType.SUPPITEM.getValue()});
        try (DataSet dataset = CashFlowSumHelper.getDesignDataSet((FilterContext)filterContext);){
            if (dataset.hasNext()) {
                BigDecimal sumAmt = new BigDecimal("0");
                long time = System.currentTimeMillis();
                for (Row row : dataset) {
                    sumAmt = sumAmt.add(row.getBigDecimal(AMOUNT));
                }
                logger.info("for each cost : " + (System.currentTimeMillis() - time) + " ms");
                BigDecimal bigDecimal = sumAmt;
                return bigDecimal;
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String id;
        switch (id = evt.getActionId()) {
            case "suppcallback": {
                long itemId;
                boolean result;
                ListSelectedRowCollection col = (ListSelectedRowCollection)evt.getReturnData();
                if (col == null || col.size() <= 0 || !(result = this.designItemOp(itemId = Long.parseLong(col.get(0).getPrimaryKeyValue().toString())))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u6210\u529f\u3002", (String)"CashFlowDesignatePlugin_20", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    private void openSuppItemF7Page() {
        ListShowParameter bsp = ShowFormHelper.createShowListForm((String)"gl_cashflowitem", (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SUPPCALLBACK);
        bsp.setCloseCallBack(callBack);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)filterContext.getOrgId());
        QFilter ftype = new QFilter(TYPE, "=", (Object)"3");
        QFilter fisleaf = new QFilter("isleaf", "=", (Object)TYPE_ACC).and(new QFilter("isprefit", "=", (Object)Boolean.FALSE));
        QFilter enableFilter = new QFilter("enable", "=", (Object)TYPE_ACC);
        List qFilters = bsp.getListFilterParameter().getQFilters();
        qFilters.add(ftype);
        qFilters.add(fisleaf);
        qFilters.add(enableFilter);
        qFilters.add(orgFilter);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private boolean isDealactivity(Row row) {
        return row.getBoolean("entries.maincfitem.isdealactivity");
    }

    private boolean isPLAcct(Row row) {
        return !"0".equals(row.getString("entries.account.pltype"));
    }

    private boolean isCashAcct(Row row) {
        return row.getBoolean("entries.account.iscash") != false || row.getBoolean("entries.account.isbank") != false || row.getBoolean("entries.account.iscashequivalent") != false;
    }

    private boolean isBudgetAcct(Row row) {
        return AccountType.isBudgetProp((String)row.getString("entries.account.accounttype.accounttype"));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals(ITEMNAME)) {
            int index = evt.getRowIndex();
            FilterContext filterContext = this.getFilterContextFromPageCache();
            this.dealSumFilter(filterContext, index);
            Set voucherIds = CashFlowSumHelper.getVocherIds((FilterContext)filterContext);
            String type = (String)this.getModel().getValue(TYPE, index);
            if (TYPE_ACC.equals(type)) {
                QFilter fid = new QFilter("id", "in", (Object)voucherIds);
                this.hyperVoucher(fid);
            } else if (TYPE_CF.equals(type)) {
                String itemName = (String)this.getModel().getValue(ITEMNAME, index);
                String num = itemName.split("_")[0];
                if (CashFlowDesignatePluginNew.getDefsuppname().equals(itemName)) {
                    this.hyperCashFlowList("", voucherIds, "supp");
                } else {
                    this.hyperCashFlowList(num, voucherIds, "supp");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate eo = (FormOperate)args.getSource();
        String key = eo.getOperateKey();
        IDataModel model = this.getModel();
        int curIndex = this.getModel().getEntryCurrentRowIndex(ENTRYKEY);
        switch (key) {
            case "bysubacct": {
                boolean firstLine = true;
                if (curIndex == 0) {
                    this.getPageCache().put(ACC_SHOW_LEVEL, TYPE_ACC);
                } else {
                    String supAcctNum;
                    String itemName = ((String)model.getValue(ITEMNAME, curIndex)).trim();
                    String acctNum = itemName.split("_")[0];
                    String itemType = ((String)model.getValue(TYPE, curIndex)).trim();
                    if (TYPE_ACC.equals(itemType)) {
                        supAcctNum = acctNum;
                    } else {
                        int level = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
                        if (level > 2) break;
                        supAcctNum = this.getSupAccountNumber();
                    }
                    DataSet ds = this.getDataSetByNumber(supAcctNum);
                    int level = 1;
                    for (Row d : ds) {
                        level = d.getInteger("flevel") + 1;
                    }
                    this.getPageCache().put(ACC_SHOW_LEVEL, String.valueOf(level));
                    firstLine = false;
                }
                FilterContext filterContext = this.getFilterContextFromPageCache();
                this.dealSumFilter(filterContext, curIndex);
                this.deploy(filterContext, firstLine, 1, curIndex, "");
                break;
            }
            case "byappendixitem": {
                int cfIndex = this.getSuperCashFlowExcludeSelf(curIndex, model);
                if (cfIndex != -1) break;
                if (curIndex == 0) {
                    this.firstLineDeploy(curIndex);
                    break;
                }
                this.callDeploy(model, curIndex, true);
                break;
            }
            case "designitem": {
                AccountBookInfo book = this.getFilterContextFromPageCache().getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CashFlowDesignatePlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                FilterContext context = this.getFilterContextFromPageCache();
                this.dealSumFilter(context, curIndex);
                String checkMsg = this.checkPeriod(book);
                if (checkMsg != null) {
                    this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
                    return;
                }
                if (this.checkModifyHisCf()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5305\u542b\u5df2\u7ed3\u8d26\u671f\u95f4\u51ed\u8bc1\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"MainDesignateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.showConfirmTip("designate", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u7528\u9009\u62e9\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\u66ff\u6362\u5df2\u9009\u884c\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CashFlowDesignatePlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cancelappendixitem": {
                AccountBookInfo book = this.getFilterContextFromPageCache().getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CashFlowDesignatePlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                FilterContext context2 = this.getFilterContextFromPageCache();
                this.dealSumFilter(context2, curIndex);
                if (this.checkModifyHisCf()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"CashFlowDesignatePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("curindex", curIndex + "");
                this.showConfirmTip("cancelcf", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u53d6\u6d88\u5df2\u9009\u884c\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CashFlowDesignatePlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cancel": {
                if (curIndex == 0) {
                    int count = model.getEntryRowCount(ENTRYKEY);
                    for (int i = count - 1; i > 0; --i) {
                        model.deleteEntryRow(ENTRYKEY, i);
                    }
                    model.setValue(COUNT, (Object)0, 0);
                    break;
                }
                this.foldCurrentRow(model, curIndex);
                break;
            }
            case "exportexcel": {
                ArrayList<String> columnNames = new ArrayList<String>(2);
                columnNames.add(ITEMNAME);
                columnNames.add(AMOUNT);
                this.exportEntry(columnNames);
            }
        }
    }

    public OperationResult exportEntry(List<String> columnNames) {
        IDataModel model = this.getModel();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYKEY);
        if (entryRowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CashFlowDesignatePlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return null;
        }
        DynamicObjectCollection dynColl = model.getEntryEntity(ENTRYKEY);
        EntityType entryType = (EntityType)dynColl.getDynamicObjectType();
        List<KeyValue> captions = this.prepareCaptions(entryType, columnNames);
        ListExporter exporter = new ListExporter(ENTRYKEY, captions);
        int i = 1;
        ArrayList<Object> rowdata = new ArrayList<Object>();
        for (DynamicObject row : dynColl) {
            for (IDataEntityProperty prop : entryType.getFields().values()) {
                if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
                Object val = row.get(prop);
                if (!StringUtils.isBlank((Object)val)) {
                    if (prop instanceof FlexProp) {
                        List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)row, (FlexProp)((FlexProp)prop), (String)((FlexProp)prop).getBasePropertyKey());
                        ArrayList<String> displayValues = new ArrayList<String>();
                        for (Map item : flexValues) {
                            String alias = (String)item.get("alias");
                            if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                            displayValues.add(alias);
                        }
                        val = String.join((CharSequence)"; ", displayValues);
                    } else if (prop instanceof DecimalProp) {
                        if (prop instanceof AmountProp) {
                            if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                                val = ((Object[])val)[0];
                            }
                            DynamicObject currency = (DynamicObject)model.getValue(KEY_CURRENCY);
                            NumberPrecision number = new NumberPrecision(currency.getInt("amtprecision"), currency.getString("sign"), false, new BigDecimal(val.toString()));
                            val = number;
                        } else {
                            NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                            val = number.toString();
                        }
                        if (!((DecimalProp)prop).isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(val.toString().replace(",", ""))) == 0) {
                            val = null;
                        }
                    }
                }
                rowdata.add(val);
            }
            exporter.writeLine(rowdata, i++);
            rowdata.clear();
        }
        LocalDate now = LocalDate.now();
        String url = exporter.flush(model.getDataEntityType(), ResManager.loadKDString((String)"\u5bfc\u51fa\u8865\u5145\u8d44\u6599\u6307\u5b9a\u5206\u5f55\u6570\u636e_%1$s%2$s", (String)"CashFlowDesignatePlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[]{now.getMonthValue(), now.getDayOfMonth()}));
        this.getView().download(UrlService.getAttachmentFullUrl((String)url));
        return null;
    }

    private List<KeyValue> prepareCaptions(EntityType entryType, List<String> columnNames) {
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>(columnNames.size());
        for (IDataEntityProperty prop : entryType.getFields().values()) {
            if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
            if (prop instanceof AmountProp) {
                captions.add(new KeyValue(prop.getName(), (Object)prop.getDisplayName().toString(), new Object[]{1, 100, "right"}));
                continue;
            }
            captions.add(new KeyValue(prop.getName(), (Object)new KeyValue(prop.getDisplayName().toString(), new ArrayList())));
        }
        return captions;
    }

    private void setCfNo(int curIndex, long cfId) {
        IDataModel model = this.getModel();
        String itemType = ((String)model.getValue(TYPE, curIndex)).trim();
        if (TYPE_ACC.equals(itemType) && this.getSuperCashFlowExcludeSelf(curIndex, model) == -1) {
            return;
        }
        DynamicObject cfItem = BusinessDataServiceHelper.loadSingleFromCache((Object)cfId, (String)"gl_cashflowitem");
        String cfNo = "";
        boolean isNotDeal = Boolean.TRUE;
        if (cfItem != null) {
            cfNo = cfItem.getString("number");
            isNotDeal = Boolean.FALSE;
        }
        model.setValue(CFNO, (Object)cfNo, curIndex);
        model.setValue(ISNDEAL, (Object)isNotDeal, curIndex);
    }

    private void dealSumFilter(FilterContext filterContext, int curIndex) {
        String acctNo = (String)this.getModel().getValue(ACCTNO, curIndex);
        String cfNo = (String)this.getModel().getValue(CFNO, curIndex);
        Boolean isnotdeal = (Boolean)this.getModel().getValue(ISNDEAL, curIndex);
        Boolean isdetailact = (Boolean)this.getModel().getValue(ISDETAILACT, curIndex);
        filterContext.setTypes(new String[]{CashStatusType.SUPPITEM.getValue()});
        if (kd.bos.util.StringUtils.isNotEmpty((String)acctNo)) {
            HashSet<String> actNumbers = new HashSet<String>();
            if (isdetailact.booleanValue()) {
                actNumbers.add(acctNo);
            } else {
                actNumbers.addAll(this.getSubAccNumber(acctNo));
            }
            filterContext.setActNumbers(actNumbers);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)cfNo)) {
            Set cfItemIdSet = CashFlowItemHelperNew.getCFItemIdByNumber((String)cfNo);
            if (cfItemIdSet.size() == 0) {
                throw new KDBizException("cfItemIds is empty, maincfnumber: " + cfNo);
            }
            filterContext.setCfItemIds(cfItemIdSet);
        }
        filterContext.setIsnotdeal(isnotdeal);
    }

    private void dealVoucherFilter(QFilter qFilter, int curIndex) {
        String acctNo = (String)this.getModel().getValue(ACCTNO, curIndex);
        String cfNo = (String)this.getModel().getValue(CFNO, curIndex);
        Boolean isnotdeal = (Boolean)this.getModel().getValue(ISNDEAL, curIndex);
        Boolean isdetailact = (Boolean)this.getModel().getValue(ISDETAILACT, curIndex);
        if (kd.bos.util.StringUtils.isNotEmpty((String)acctNo)) {
            if (isdetailact.booleanValue()) {
                qFilter.and(new QFilter("entries.account.number", "=", (Object)acctNo));
            } else {
                qFilter.and(new QFilter("entries.account.number", "in", this.getSubAccNumber(acctNo)));
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)cfNo)) {
            qFilter.and(new QFilter("entries.suppcfitem.number", "=", (Object)cfNo));
        }
        if (isnotdeal.booleanValue()) {
            qFilter.and(new QFilter("entries.suppcfitem", "=", (Object)0L));
        }
    }
}

