/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.gl.util.GLUtil;

public class CashFlowEdit
extends AbstractBillPlugIn {
    private static final String OLDNUMBER = "oldnumber";
    private Map<Long, Integer> levelMap = new HashMap<Long, Integer>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit asstype = (BasedataEdit)this.getView().getControl("asstypeid");
        asstype.addBeforeF7SelectListener(select -> {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("assistentry");
            HashSet<Long> ids = new HashSet<Long>();
            for (DynamicObject dyo : entry) {
                if (dyo.get("asstypeid") == null) continue;
                long assisitemid = dyo.getDynamicObject("asstypeid").getLong("id");
                ids.add(assisitemid);
            }
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter("id", "not in", ids));
            Long useOrgId = (Long)this.getModel().getValue("useorg_id");
            list.add(new QFilter("id", "in", (Object)GLUtil.getAssistPKByOrg((Long)useOrgId)));
            showParam.getListFilterParameter().getQFilters().addAll(list);
            showParam.setCustomParam("isCustom", (Object)true);
        });
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map data = e.getSourceData();
        long level = 1L;
        Map parent = (Map)data.get("parent");
        if (parent != null) {
            String parentNumber = (String)parent.get("number");
            Map createorg = (Map)data.get("createorg");
            String orgNumber = (String)createorg.get("number");
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
            if (org == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u6570\u636e\u3002", (String)"CashFlowImportOp_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgNumber));
            }
            QFilter qorg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)org.getLong("id"));
            QFilter qnumber = new QFilter("number", "=", (Object)parentNumber);
            DynamicObject parentCashFlowItem = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,level", (QFilter[])new QFilter[]{qnumber, qorg});
            if (parentCashFlowItem != null) {
                parent.remove("number");
                parent.put("id", parentCashFlowItem.getString("id"));
                level = parentCashFlowItem.getLong("level") + 1L;
                data.put("level", level);
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"CashFlowImportOp_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), parentNumber));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            IDataModel model = this.getModel();
            if (model.getValue("createtime") == null) {
                model.setValue("createtime", (Object)new Date());
            }
            DefaultEntityOperate operate = (DefaultEntityOperate)args.getSource();
            if (this.isVersionOp()) {
                CashflowItemOptionVarManager.setIsVersion((OperateOption)operate.getOption(), (boolean)true);
                this.setUserOrg(operate.getOption());
            }
        }
    }

    private void setUserOrg(OperateOption option) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String useOrgID = (String)view.getFormShowParameter().getCustomParam("useorgId");
        if (useOrgID != null) {
            model.setValue("useorg", (Object)useOrgID);
        }
        if (null == useOrgID && null != model.getValue("useOrg")) {
            useOrgID = ((DynamicObject)model.getValue("useOrg")).getPkValue().toString();
        }
        option.setVariableValue("useOrgID", useOrgID);
    }

    public void afterLoadData(EventObject e) {
        int level;
        boolean isleaf;
        String parentDirection;
        super.afterLoadData(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        view.setEnable(Boolean.valueOf(false), new String[]{"type"});
        DynamicObject parent = (DynamicObject)model.getValue("parent");
        if (parent != null && !"b".equals(parentDirection = parent.getString("direction"))) {
            view.setEnable(Boolean.valueOf(false), new String[]{"direction"});
        }
        if (!(isleaf = ((Boolean)model.getValue("isleaf")).booleanValue())) {
            if (parent == null) {
                if (this.subBizHappened((Long)model.getValue("id"), (String)model.getValue("longnumber"), (Long)model.getValue("createorg_id"))) {
                    view.setEnable(Boolean.valueOf(false), new String[]{"isdealactivity"});
                }
            } else {
                view.setEnable(Boolean.valueOf(false), new String[]{"isdealactivity"});
            }
        }
        if ((level = ((Integer)model.getValue("level")).intValue()) == 1) {
            this.getPageCache().put("oldDealactivity", String.valueOf(model.getValue("isdealactivity")));
        }
        if (this.isVersionOp()) {
            this.getModel().setValue("startdate", (Object)new Date());
        }
        this.getPageCache().put(OLDNUMBER, this.getModel().getValue("number").toString());
    }

    public void afterBindData(EventObject e) {
        boolean enableVersion;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.setEnable(model, view);
        Object value = model.getValue("type");
        if (value != null && "3".equals(value)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"direction", "notice"});
        }
        DynamicObject parent = (DynamicObject)model.getValue("parent");
        long orgId = model.getValue("useorg") == null ? 0L : ((DynamicObject)model.getValue("useorg")).getLong("id");
        boolean isAddFistSubAndExistBiz = false;
        if (orgId != 0L && parent != null) {
            boolean bl = isAddFistSubAndExistBiz = parent.getBoolean("isleaf") && CashflowItemCheckUtil.existsBizOnOrg((long)parent.getLong("masterid"), (long)orgId, null);
        }
        if (!(enableVersion = CashflowItemVersionUtil.isEnableVersion()) || !this.isVersionOp() && !isAddFistSubAndExistBiz) {
            view.setVisible(Boolean.valueOf(false), new String[]{"startdate"});
        }
    }

    private void setEnable(IDataModel model, IFormView view) {
        if (OperationStatus.EDIT.equals((Object)view.getFormShowParameter().getStatus())) {
            view.setEnable(Boolean.valueOf(false), new String[]{"number", "isprefit"});
        }
        if (this.isVersionOp()) {
            view.setEnable(Boolean.valueOf(false), new String[]{"direction"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject parent;
        boolean isAddFistSub;
        Object value;
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        Map map = view.getFormShowParameter().getCustomParams();
        IDataModel m = this.getModel();
        Object pmap = map.get("tree_parent_id");
        if (pmap != null) {
            this.setConsist((AbstractFormDataModel)m, view, ((Map)pmap).get("value"));
        }
        if ((value = m.getValue("type")) != null && "3".equals(value)) {
            m.setValue("direction", (Object)"b");
        }
        boolean bl = isAddFistSub = (parent = (DynamicObject)m.getValue("parent")) != null && parent.getBoolean("isleaf");
        if (this.isVersionOp() || isAddFistSub) {
            this.getModel().setValue("startdate", (Object)CashflowItemVersionUtil.getCurDate());
        }
    }

    private boolean isVersionOp() {
        return this.getView().getFormShowParameter().getCustomParam("isPersonalizeData") != null;
    }

    private void setConsist(AbstractFormDataModel model, IFormView view, Object pid) {
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)pid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
        model.setValue("parent", parent.getPkValue());
        model.setValue("direction", parent.get("direction"));
        model.setValue("isdealactivity", parent.get("isdealactivity"));
        model.setValue("type", parent.get("type"));
        model.setValue("isexchangerate", parent.get("isexchangerate"));
        model.setValue("startdate", parent.get("startdate"));
        model.setValue("notice", parent.get("notice"));
        view.setEnable(Boolean.valueOf(false), new String[]{"isdealactivity", "type"});
        if (!"b".equals(parent.getString("direction"))) {
            view.setEnable(Boolean.valueOf(false), new String[]{"direction"});
        }
        model.setValue("level", (Object)(parent.getInt("level") + 1));
        DynamicObjectCollection parentEntry = parent.getDynamicObjectCollection("assistentry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("asstypeid", new Object[0]);
        vs.addField("isdetail", new Object[0]);
        vs.addField("isrequire", new Object[0]);
        for (DynamicObject entry : parentEntry) {
            if (entry.getDynamicObject("asstypeid") == null) continue;
            vs.addRow(new Object[]{entry.getDynamicObject("asstypeid").getPkValue(), entry.get("isdetail"), entry.get("isrequire")});
        }
        model.batchCreateNewEntryRow("assistentry", vs);
        model.endInit();
        this.getView().updateView("assistentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "type": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue != null && "1".equals(String.valueOf(newValue))) {
                    this.getModel().setValue("isscheduleitem", (Object)false);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"direction", "notice"});
                    break;
                }
                if (newValue != null && "3".equals(String.valueOf(newValue))) {
                    model.setValue("direction", (Object)"b");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"direction", "notice"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"notice"});
                break;
            }
            case "number": {
                if (view.getFormShowParameter().getStatus() != OperationStatus.EDIT) break;
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("save")) {
            List list;
            if (afterDoOperationEventArgs.getOperationResult().isSuccess() && (list = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()).size() > 0) {
                Object id = list.get(0);
                String oldDealactivity = this.getPageCache().get("oldDealactivity");
                String newDealactivity = String.valueOf(this.getModel().getValue("isdealactivity"));
                if (oldDealactivity != null && !newDealactivity.equals(oldDealactivity)) {
                    this.changeAllSubItemDealactivity(id, newDealactivity);
                }
            }
            this.getView().getParentView().setReturnData((Object)"save");
        }
    }

    private void changeAllSubItemDealactivity(Object id, String newDealactivity) {
        ArrayList ids = new ArrayList();
        QFilter qparent = new QFilter("parent", "=", id);
        List SubItemIds = QueryServiceHelper.queryPrimaryKeys((String)"querySubItems", (String)"gl_cashflowitem", (QFilter[])new QFilter[]{qparent}, null, (int)-1);
        while (SubItemIds.size() > 0) {
            ids.addAll(SubItemIds);
            qparent = new QFilter("parent", "in", (Object)SubItemIds);
            SubItemIds = QueryServiceHelper.queryPrimaryKeys((String)"querySubItems", (String)"gl_cashflowitem", (QFilter[])new QFilter[]{qparent}, null, (int)-1);
        }
        if (ids.size() > 0) {
            DynamicObject[] items;
            for (DynamicObject item : items = BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)"id,isdealactivity", (QFilter[])new QFilter("id", "in", ids).toArray())) {
                item.set("isdealactivity", (Object)newDealactivity);
            }
            SaveServiceHelper.save((DynamicObject[])items);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        this.setRealLevel(model);
    }

    private void setRealLevel(IDataModel dataModel) {
        DynamicObject parent = (DynamicObject)dataModel.getValue("parent");
        if (parent == null) {
            long parentId = (Long)dataModel.getValue("parent_id");
            if (parentId != 0L) {
                int plevel = this.levelMap.get(parentId) == null ? 0 : this.levelMap.get(parentId);
                dataModel.setValue("level", (Object)(plevel + 1));
            } else {
                dataModel.setValue("level", (Object)1);
            }
        } else {
            dataModel.setValue("level", (Object)(parent.getInt("level") + 1));
            dataModel.setValue("enable", parent.get("enable"));
        }
        this.levelMap.put(dataModel.getDataEntity().getLong("id"), dataModel.getDataEntity().getInt("level"));
    }

    private boolean subBizHappened(Long id, String longNumber, long curOrgId) {
        List<Long> paramOrg = Collections.singletonList(curOrgId);
        List orgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)true);
        Map subCfid2Masterid = CashflowRelationFactory.get().getAllSubCfIncludeAssign(id, longNumber, orgIds, true);
        ArrayList keys = new ArrayList(subCfid2Masterid.keySet());
        ArrayList values = new ArrayList(subCfid2Masterid.values());
        List bookType = CashflowItemCheckUtil.getBookTypes();
        List existids = CashflowItemCheckUtil.getExistInitCashflowByOrg(keys, (List)bookType, (List)orgIds);
        if (!existids.isEmpty()) {
            return true;
        }
        existids = CashflowItemCheckUtil.getExistSaveVoucherByOrg(keys, (List)orgIds);
        if (!existids.isEmpty()) {
            return true;
        }
        existids = CashflowItemCheckUtil.getExistCashflowByOrg(values, (List)orgIds);
        if (!existids.isEmpty()) {
            return true;
        }
        existids = CashflowItemCheckUtil.getExistCashflowLogByOrg(values, (List)orgIds);
        return !existids.isEmpty();
    }
}

