/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.util.GLUtil;

public class ControlInformationEdit
extends AbstractBillPlugIn {
    private static final String DEBITMUSTRECORD = "debitmustrecord";
    private static final String CREDITMUSTRECORD = "creditmustrecord";
    private static final String DEBITNOTRECORD = "debitnotrecord";
    private static final String CREDITNOTRECORD = "creditnotrecord";
    private static final String DEBITORCREDITMUSTRECORD = "debitorcreditmustrecord";
    private static final String DEBITANDCREDITNOTRECORD = "debitandcreditnotrecord";
    private static final String FBASEDATAID = "fbasedataid";
    private static final String MASTERID = "masterid";
    private static final String NAME = "name";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String ACCOUNTTABLE_ID = "accounttable_id";
    private static final String ORGID_ID = "orgid_id";
    private static final String BD_ACCOUNTVIEW = "bd_accountview";

    public void initialize() {
        BasedataEdit accounttable = (BasedataEdit)this.getControl(ACCOUNTTABLE);
        accounttable.addBeforeF7SelectListener(e -> {
            long orgId = (Long)this.getModel().getValue(ORGID_ID);
            List<Long> accountTables = this.getaccountTable(orgId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", accountTables));
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        });
        MulBasedataEdit debitmustrecord = (MulBasedataEdit)this.getControl(DEBITMUSTRECORD);
        debitmustrecord.addBeforeF7SelectListener(this::addAccountFilter);
        MulBasedataEdit creditmustrecord = (MulBasedataEdit)this.getControl(CREDITMUSTRECORD);
        creditmustrecord.addBeforeF7SelectListener(this::addAccountFilter);
        MulBasedataEdit debitnotrecord = (MulBasedataEdit)this.getControl(DEBITNOTRECORD);
        debitnotrecord.addBeforeF7SelectListener(this::addAccountFilter);
        MulBasedataEdit creditnotrecord = (MulBasedataEdit)this.getControl(CREDITNOTRECORD);
        creditnotrecord.addBeforeF7SelectListener(this::addAccountFilter);
        MulBasedataEdit debitorcreditmustrecord = (MulBasedataEdit)this.getControl(DEBITORCREDITMUSTRECORD);
        debitorcreditmustrecord.addBeforeF7SelectListener(this::addAccountFilter);
        MulBasedataEdit debitandcreditnotrecord = (MulBasedataEdit)this.getControl(DEBITANDCREDITNOTRECORD);
        debitandcreditnotrecord.addBeforeF7SelectListener(this::addAccountFilter);
    }

    private void addAccountFilter(BeforeF7SelectEvent e) {
        long orgId = (Long)this.getModel().getValue(ORGID_ID);
        Object accountTb = this.getModel().getValue(ACCOUNTTABLE_ID);
        long accountTableId = 0L;
        if (accountTb != null) {
            accountTableId = (Long)accountTb;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ACCOUNTTABLE_ID, "=", (Object)accountTableId));
        qFilters.add(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
        qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)BD_ACCOUNTVIEW, (Long)orgId));
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().addAll(qFilters);
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        this.setAccTableHide((Long)model.getValue(ORGID_ID));
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter form = this.getView().getFormShowParameter();
        this.setAccTableHide(Long.parseLong(form.getCustomParam("orgid").toString()));
        model.setValue("vouchertype", form.getCustomParam("vouchertype"));
        model.setValue("orgid", form.getCustomParam("orgid"));
        Object accountTable = form.getCustomParam(ACCOUNTTABLE);
        model.setValue(ACCOUNTTABLE, Objects.isNull(accountTable) ? this.getPageCache().get("defortAccountTable") : accountTable);
        model.setValue(DEBITMUSTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(DEBITMUSTRECORD)));
        model.setValue(CREDITMUSTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(CREDITMUSTRECORD)));
        model.setValue(DEBITNOTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(DEBITNOTRECORD)));
        model.setValue(CREDITNOTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(CREDITNOTRECORD)));
        model.setValue(DEBITORCREDITMUSTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(DEBITORCREDITMUSTRECORD)));
        model.setValue(DEBITANDCREDITNOTRECORD, (Object)this.jsonStringToObjs(form.getCustomParam(DEBITANDCREDITNOTRECORD)));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "accounttable": {
                IDataModel model = this.getModel();
                model.setValue(DEBITMUSTRECORD, null);
                model.setValue(CREDITMUSTRECORD, null);
                model.setValue(DEBITNOTRECORD, null);
                model.setValue(CREDITNOTRECORD, null);
                model.setValue(DEBITORCREDITMUSTRECORD, null);
                model.setValue(DEBITANDCREDITNOTRECORD, null);
                break;
            }
            case "debitmustrecord": 
            case "creditmustrecord": 
            case "debitnotrecord": 
            case "creditnotrecord": 
            case "debitorcreditmustrecord": 
            case "debitandcreditnotrecord": {
                this.checkAccountInput(key, e);
                break;
            }
        }
    }

    private void checkAccountInput(String key, PropertyChangedArgs e) {
        block17: {
            Long id;
            DynamicObject dyAct;
            IDataModel model;
            block21: {
                DynamicObject dyAct2;
                block20: {
                    DynamicObject dyAct3;
                    block19: {
                        DynamicObject dyAct4;
                        block18: {
                            Long id2;
                            DynamicObject dyAct5;
                            block16: {
                                Long id3;
                                DynamicObject dyAct6;
                                model = this.getModel();
                                if (!DEBITMUSTRECORD.equals(key)) break block16;
                                DynamicObjectCollection debitmustrecord = (DynamicObjectCollection)model.getValue(key);
                                DynamicObjectCollection debitnotrecord = (DynamicObjectCollection)model.getValue(DEBITNOTRECORD);
                                DynamicObjectCollection debitandcreditnotrecord = (DynamicObjectCollection)model.getValue(DEBITANDCREDITNOTRECORD);
                                HashSet<Long> set = new HashSet<Long>();
                                for (DynamicObject d : debitmustrecord) {
                                    dyAct6 = d.getDynamicObject(FBASEDATAID);
                                    set.add(dyAct6.getLong(MASTERID));
                                }
                                for (DynamicObject d : debitnotrecord) {
                                    dyAct6 = d.getDynamicObject(FBASEDATAID);
                                    id3 = dyAct6.getLong(MASTERID);
                                    if (!set.contains(id3)) continue;
                                    String name = dyAct6.getString(NAME);
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u65b9\u5fc5\u65e0\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                                    model.setValue(key, null);
                                    return;
                                }
                                for (DynamicObject d : debitandcreditnotrecord) {
                                    dyAct6 = d.getDynamicObject(FBASEDATAID);
                                    id3 = dyAct6.getLong(MASTERID);
                                    if (!set.contains(id3)) continue;
                                    String name = dyAct6.getString(NAME);
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u548c\u8d37\u5fc5\u65e0\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                                    model.setValue(key, null);
                                    return;
                                }
                                break block17;
                            }
                            if (!CREDITMUSTRECORD.equals(key)) break block18;
                            DynamicObjectCollection creditmustrecord = (DynamicObjectCollection)model.getValue(key);
                            DynamicObjectCollection creditnotrecord = (DynamicObjectCollection)model.getValue(CREDITNOTRECORD);
                            DynamicObjectCollection debitandcreditnotrecord = (DynamicObjectCollection)model.getValue(DEBITANDCREDITNOTRECORD);
                            HashSet<Long> set = new HashSet<Long>();
                            for (DynamicObject d : creditmustrecord) {
                                dyAct5 = d.getDynamicObject(FBASEDATAID);
                                set.add(dyAct5.getLong(MASTERID));
                            }
                            for (DynamicObject d : creditnotrecord) {
                                dyAct5 = d.getDynamicObject(FBASEDATAID);
                                id2 = dyAct5.getLong(MASTERID);
                                if (!set.contains(id2)) continue;
                                String name = dyAct5.getString(NAME);
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u8d37\u65b9\u5fc5\u65e0\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                                model.setValue(key, null);
                                return;
                            }
                            for (DynamicObject d : debitandcreditnotrecord) {
                                dyAct5 = d.getDynamicObject(FBASEDATAID);
                                id2 = dyAct5.getLong(MASTERID);
                                if (!set.contains(id2)) continue;
                                String name = dyAct5.getString(NAME);
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u548c\u8d37\u5fc5\u65e0\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                                model.setValue(key, null);
                                return;
                            }
                            break block17;
                        }
                        if (!DEBITNOTRECORD.equals(key)) break block19;
                        DynamicObjectCollection debitnotrecord = (DynamicObjectCollection)model.getValue(key);
                        DynamicObjectCollection debitmustrecord = (DynamicObjectCollection)model.getValue(DEBITMUSTRECORD);
                        HashSet<Long> set = new HashSet<Long>();
                        for (DynamicObject d : debitnotrecord) {
                            dyAct4 = d.getDynamicObject(FBASEDATAID);
                            set.add(dyAct4.getLong(MASTERID));
                        }
                        for (DynamicObject d : debitmustrecord) {
                            dyAct4 = d.getDynamicObject(FBASEDATAID);
                            Long id4 = dyAct4.getLong(MASTERID);
                            if (!set.contains(id4)) continue;
                            String name = dyAct4.getString(NAME);
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u65b9\u5fc5\u6709\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                            model.setValue(key, null);
                            return;
                        }
                        break block17;
                    }
                    if (!CREDITNOTRECORD.equals(key)) break block20;
                    DynamicObjectCollection creditnotrecord = (DynamicObjectCollection)model.getValue(key);
                    DynamicObjectCollection creditmustrecord = (DynamicObjectCollection)model.getValue(CREDITMUSTRECORD);
                    HashSet<Long> set = new HashSet<Long>();
                    for (DynamicObject d : creditnotrecord) {
                        dyAct3 = d.getDynamicObject(FBASEDATAID);
                        set.add(dyAct3.getLong(MASTERID));
                    }
                    for (DynamicObject d : creditmustrecord) {
                        dyAct3 = d.getDynamicObject(FBASEDATAID);
                        Long id5 = dyAct3.getLong(MASTERID);
                        if (!set.contains(id5)) continue;
                        String name = dyAct3.getString(NAME);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u8d37\u65b9\u5fc5\u6709\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                        model.setValue(key, null);
                        return;
                    }
                    break block17;
                }
                if (!DEBITORCREDITMUSTRECORD.equals(key)) break block21;
                DynamicObjectCollection debitorcreditmustrecord = (DynamicObjectCollection)model.getValue(key);
                DynamicObjectCollection debitandcreditnotrecord = (DynamicObjectCollection)model.getValue(DEBITANDCREDITNOTRECORD);
                HashSet<Long> set = new HashSet<Long>();
                for (DynamicObject d : debitorcreditmustrecord) {
                    dyAct2 = d.getDynamicObject(FBASEDATAID);
                    set.add(dyAct2.getLong(MASTERID));
                }
                for (DynamicObject d : debitandcreditnotrecord) {
                    dyAct2 = d.getDynamicObject(FBASEDATAID);
                    Long id6 = dyAct2.getLong(MASTERID);
                    if (!set.contains(id6)) continue;
                    String name = dyAct2.getString(NAME);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u548c\u8d37\u5fc5\u65e0\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                    model.setValue(key, null);
                    return;
                }
                break block17;
            }
            if (!DEBITANDCREDITNOTRECORD.equals(key)) break block17;
            DynamicObjectCollection debitandcreditnotrecord = (DynamicObjectCollection)model.getValue(key);
            DynamicObjectCollection debitorcreditmustrecord = (DynamicObjectCollection)model.getValue(DEBITORCREDITMUSTRECORD);
            DynamicObjectCollection debitmustrecord = (DynamicObjectCollection)model.getValue(DEBITMUSTRECORD);
            DynamicObjectCollection creditmustrecord = (DynamicObjectCollection)model.getValue(CREDITMUSTRECORD);
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject d : debitandcreditnotrecord) {
                dyAct = d.getDynamicObject(FBASEDATAID);
                set.add(dyAct.getLong(MASTERID));
            }
            for (DynamicObject d : creditmustrecord) {
                dyAct = d.getDynamicObject(FBASEDATAID);
                id = dyAct.getLong(MASTERID);
                if (!set.contains(id)) continue;
                String name = dyAct.getString(NAME);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u8d37\u65b9\u5fc5\u6709\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                model.setValue(key, null);
                return;
            }
            for (DynamicObject d : debitmustrecord) {
                dyAct = d.getDynamicObject(FBASEDATAID);
                id = dyAct.getLong(MASTERID);
                if (!set.contains(id)) continue;
                String name = dyAct.getString(NAME);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u65b9\u5fc5\u6709\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                model.setValue(key, null);
                return;
            }
            for (DynamicObject d : debitorcreditmustrecord) {
                dyAct = d.getDynamicObject(FBASEDATAID);
                id = dyAct.getLong(MASTERID);
                if (!set.contains(id)) continue;
                String name = dyAct.getString(NAME);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u5728\u501f\u6216\u8d37\u5fc5\u6709\u7684\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ControlInformationEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), name));
                model.setValue(key, null);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean issuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (issuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ControlInformationEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public Object[] jsonStringToObjs(Object obj) {
        if (obj == null || obj.toString().length() < 3) {
            return new Object[0];
        }
        String str = obj.toString();
        return Arrays.stream(str.substring(1, str.length() - 1).split(",")).map(Long::parseLong).toArray();
    }

    public void setAccTableHide(Long org) {
        List<Long> list = this.getaccountTable(org);
        HashSet<Long> set = new HashSet<Long>(list.size());
        for (Long id : list) {
            set.add(id);
        }
        if (set != null && set.size() == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ACCOUNTTABLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"blankflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ACCOUNTTABLE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"blankflex"});
        }
    }

    public List<Long> getaccountTable(Long orgId) {
        ArrayList<Long> accountTables = new ArrayList<Long>();
        long defortAccountTable = 0L;
        ArrayList<QFilter> orgFilters = new ArrayList<QFilter>(3);
        orgFilters.add(new QFilter("org", "=", (Object)orgId));
        orgFilters.add(new QFilter("view", "=", (Object)10L));
        orgFilters.add(new QFilter("isleaf", "=", (Object)false));
        boolean exists = QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])orgFilters.toArray(new QFilter[0]));
        if (exists) {
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"id", (QFilter[])new QFilter[0]);
            for (DynamicObject dyn : dyns) {
                accountTables.add(dyn.getLong("id"));
            }
        } else {
            List<Long> bookIds = ControlInformationEdit.getAllBookFromAccSys(orgId);
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"isbizunit,accounttable.id,bookstype.accounttype", (QFilter[])new QFilter[]{new QFilter("id", "in", bookIds)}, (String)"bookstype.accounttype");
            for (DynamicObject book : books) {
                accountTables.add(book.getLong("accounttable.id"));
            }
        }
        if (!accountTables.isEmpty()) {
            defortAccountTable = (Long)accountTables.get(0);
        }
        this.getPageCache().put("defortAccountTable", String.valueOf(defortAccountTable));
        return accountTables;
    }

    public static List<Long> getAllBookFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey((Object)orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            QFilter e = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{h, e}, (String)"bookstype.accounttype");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("id"));
            }
            return idList;
        });
    }
}

