/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.STConverter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.common.VchTplExpression;
import kd.fi.gl.util.FinancialKpiGetValueHelp;

public class EnterpriseFinancialKpiEdit
extends AbstractFormPlugin {
    private static final String EXPRESSION_KEY = "expression";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EXPRESSION_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        if (map != null && !map.isEmpty()) {
            this.getModel().setValue("kpitype", map.get("kpitype"));
            this.getModel().setValue("useorg", map.get("org"));
        }
    }

    public void afterBindData(EventObject e) {
        OrmLocaleValue muliexpression = (OrmLocaleValue)this.getModel().getValue("muliexpression");
        this.getModel().setValue(EXPRESSION_KEY, (Object)muliexpression.getLocaleValue());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (EXPRESSION_KEY.equals(key)) {
            this.showExpressionFormula();
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("kpitype", (Object)2);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOp = (FormOperate)args.getSource();
            IDataModel model = this.getModel();
            String operateKey = formOp.getOperateKey();
            model.setValue("status", (Object)"C");
            if ("save".equals(operateKey)) {
                QFilter numberFilter;
                QFilter orgFilter;
                String number = (String)model.getValue("number");
                String name = model.getValue("name").toString();
                Long useorg = (Long)model.getValue("useorg_id");
                String kpitype = (String)model.getValue("kpitype");
                String expression = (String)model.getValue(EXPRESSION_KEY);
                if (number == null || StringUtils.isEmpty((CharSequence)number)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"EnterpriseFinancialKpiEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (name == null || StringUtils.isEmpty((CharSequence)name)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"EnterpriseFinancialKpiEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (useorg == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EnterpriseFinancialKpiEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (kpitype == null || StringUtils.isEmpty((CharSequence)kpitype)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7c7b\u578b\u3002", (String)"EnterpriseFinancialKpiEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (expression == null || StringUtils.isEmpty((CharSequence)expression)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u516c\u5f0f\u3002", (String)"EnterpriseFinancialKpiEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long id = (Long)model.getValue("id");
                QFilter idFilter = new QFilter("id", "!=", (Object)id);
                boolean exists = QueryServiceHelper.exists((String)"gl_business_analskpi", (QFilter[])new QFilter[]{idFilter, orgFilter = new QFilter("useorg", "=", (Object)useorg), numberFilter = new QFilter("number", "=", (Object)number)});
                if (exists) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"EnterpriseFinancialKpiEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private void showExpressionFormula() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gl_rpt_formula");
        parameter.setCustomParam(EXPRESSION_KEY, this.getModel().getValue(EXPRESSION_KEY));
        parameter.setCustomParam("desp", this.getModel().getValue("desp"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPRESSION_KEY));
        parameter.setCustomParam("useorg", this.getModel().getValue("useorg_id"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (EXPRESSION_KEY.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent);
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(EXPRESSION_KEY, (Object)"");
                this.getModel().setValue(EXPRESSION_KEY, (Object)"");
            } else {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)str, VchTplExpression.class);
                String desp = filterObj.getDescription().toString();
                desp = StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim()) ? filterObj.getExprTran() : "";
                String str1 = desp.replaceAll(" ", "");
                this.getModel().setValue("desp", (Object)str1);
                Long orgId = Long.parseLong(this.getModel().getValue("useorg_id") + "");
                desp = FinancialKpiGetValueHelp.translateDesc(desp, orgId);
                desp = desp.replaceAll(" ", "");
                this.getModel().setValue(EXPRESSION_KEY, (Object)desp);
                this.setMutiLang(desp);
            }
        }
    }

    private void setMutiLang(String desc) {
        LocaleString localeString = new LocaleString(desc);
        localeString.setLocaleValue_zh_TW(STConverter.sc2tc((String)desc));
        this.getModel().setValue("muliexpression", (Object)localeString);
    }
}

