/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.exception.ErrorCode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.formplugin.finalprocess.FPAssgrpDescLengthConfig;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.VoucherUtil;

public class FPFormUtil {
    private static final List<String> FINALPROCESS_ENTITYS = new ArrayList<String>(4);
    private static final String[] FINAL_ASSGRP_ENTRY_PROPS;

    public static void queryVcouher(IFormView view) {
        FPFormUtil.queryVcouher(view, Boolean.FALSE, null);
    }

    public static void queryCurPeriodVoucher(IFormView view, List<Object> allVoucher) {
        FPFormUtil.queryVcouher(view, Boolean.TRUE, allVoucher);
    }

    protected static void queryCurPeriodVcouher(IFormView view) {
        FPFormUtil.queryVcouher(view, Boolean.TRUE, null);
    }

    protected static void queryVcouherAfterDoGenVchOp(IFormView view, AfterDoOperationEventArgs e) {
        Object source = e.getSource();
        if (source instanceof DefaultEntityOperate) {
            FPFormUtil.queryVcouherAfterDoGenVchOp(view, ((DefaultEntityOperate)source).getOption());
        }
    }

    protected static void queryVcouherAfterDoGenVchOp(IFormView view, OperateOption option) {
        String voucherListBase64Str;
        if (option.containsVariable("FinalProcessingVouchers") && StringUtils.isNotBlank((CharSequence)(voucherListBase64Str = option.getVariableValue("FinalProcessingVouchers")))) {
            List allVouchers = (List)SerializationUtils.deSerializeFromBase64((String)voucherListBase64Str);
            FPFormUtil.queryVcouher(view, Boolean.FALSE, allVouchers);
        }
    }

    private static void queryVcouher(IFormView view, Boolean isCurPeriod, List<Object> allVouchers) {
        if (allVouchers != null && allVouchers.size() == 1) {
            FPFormUtil.showVoucherForm(allVouchers.get(0), view);
        } else {
            ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>();
            if (view instanceof IBillView) {
                IBillView billView = (IBillView)view;
                String entityName = view.getEntityId();
                DynamicObject dataEntity = billView.getModel().getDataEntity();
                dataEntities.add(dataEntity);
                FPFormUtil.preShowVoucher(dataEntities, entityName, (IFormView)billView, isCurPeriod, allVouchers);
            } else if (view instanceof IListView) {
                IListView listView = (IListView)view;
                String entityName = ((IListView)view).getBillFormId();
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                Collections.addAll(dataEntities, load);
                FPFormUtil.preShowVoucher(dataEntities, entityName, (IFormView)listView, isCurPeriod, allVouchers);
            }
        }
    }

    private static void preShowVoucher(List<DynamicObject> dataEntities, String entityId, IFormView view, Boolean isCurPeriod, List<Object> allVouchers) {
        VoucherRelationTypeEnum type = VoucherRelationTypeEnum.getType((String)entityId);
        if (type == null) {
            return;
        }
        if (dataEntities.size() > 0) {
            String bookTypeFieldKey = FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)entityId);
            if (allVouchers == null) {
                QFilter typeFilter = new QFilter("type", "=", (Object)type.getValue());
                HashMap<Long, List> period2pks = new HashMap<Long, List>(dataEntities.size());
                for (DynamicObject dyn : dataEntities) {
                    long orgId = dyn.getLong(GLField.id_((String)"org"));
                    long bookTypeId = dyn.getLong(GLField.id_((String)bookTypeFieldKey));
                    long curPeriodId = 0L;
                    if (isCurPeriod.booleanValue()) {
                        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
                        curPeriodId = accountBookInfo == null ? 0L : accountBookInfo.getCurPeriodId();
                    }
                    period2pks.compute(curPeriodId, (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<Object>();
                        }
                        v.add(dyn.getPkValue());
                        return v;
                    });
                }
                ArrayList voucherIds = new ArrayList(dataEntities.size());
                period2pks.forEach((k, v) -> {
                    QFilter srcEntityFilter = new QFilter("srcentity", "in", v);
                    if (k > 0L) {
                        srcEntityFilter = srcEntityFilter.and(new QFilter("period", "=", k));
                    }
                    DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{typeFilter, srcEntityFilter});
                    voucherIds.addAll(dynColl.stream().map(x -> x.getLong("targentity")).collect(Collectors.toList()));
                });
                allVouchers = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter("id", "in", voucherIds).toArray(), null, (int)-1);
            }
            if (allVouchers.isEmpty()) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u62e9\u7684\u65b9\u6848\u6ca1\u6709\u751f\u6210\u51ed\u8bc1\u3002", (String)"FPFormUtil_0", (String)"fi-gl-formplugin", (Object[])new Object[0])});
            }
            if (allVouchers.size() == 1) {
                FPFormUtil.showVoucherForm(allVouchers.get(0), view);
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                if (CollectionUtils.isEmpty(allVouchers)) {
                    return;
                }
                HashSet<String> orgIdSet = new HashSet<String>(8);
                HashSet<String> bookTypeIdSet = new HashSet<String>(8);
                for (DynamicObject dyn : dataEntities) {
                    orgIdSet.add(String.valueOf(dyn.getLong(GLField.id_((String)"org"))));
                    bookTypeIdSet.add(String.valueOf(dyn.getLong(GLField.id_((String)bookTypeFieldKey))));
                }
                customParams.put("filter", new QFilter("id", "in", allVouchers).toSerializedString());
                customParams.put("isSetFilter", "true");
                customParams.put("source", "VoucherAmortScheme");
                customParams.put("org", orgIdSet);
                customParams.put("booktype", bookTypeIdSet);
                FPFormUtil.showVoucherList(customParams, view);
            }
        }
    }

    private static void showVoucherForm(Object voucherId, IFormView view) {
        VoucherUtil.hyperVoucher((long)((Long)voucherId), view, (Consumer<BillShowParameter>)((Consumer)param -> FPFormUtil.setCloseBack((FormShowParameter)param, view)));
    }

    private static void showVoucherList(Map<String, Object> customParams, IFormView view) {
        ListShowParameter list = new ListShowParameter();
        list.setBillFormId("gl_voucher");
        list.setFormId("bos_list");
        list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        list.getOpenStyle().setTargetKey("tabap");
        list.setCustomParams(customParams);
        FPFormUtil.setCloseBack((FormShowParameter)list, view);
        view.showForm((FormShowParameter)list);
    }

    private static void setCloseBack(FormShowParameter parameter, IFormView view) {
        List<String> plugins = Arrays.asList("kd.fi.gl.formplugin.VoucherAmortSchemeListPlugin", "kd.fi.gl.formplugin.VoucherAmortSchemeEdit", "kd.fi.gl.formplugin.AdjustExchangeRateList", "kd.fi.gl.formplugin.AutoTransCreateVoucherList", "kd.fi.gl.formplugin.TransPLProgramsList");
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        service.getPlugIns().stream().filter(plugin -> plugins.contains(plugin.getPluginName())).forEach(plugin -> parameter.setCloseCallBack(new CloseCallBack(plugin, "voucherback")));
    }

    public static Boolean checkExistVoucher(IFormView view) {
        String entityName = null;
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>();
        if (view instanceof IBillView) {
            IBillView billView = (IBillView)view;
            entityName = billView.getEntityId();
            DynamicObject dataEntity = billView.getModel().getDataEntity();
            dataEntities.add(dataEntity);
        } else if (view instanceof IListView) {
            IListView listView = (IListView)view;
            entityName = listView.getBillFormId();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            Collections.addAll(dataEntities, load);
        }
        if (StringUtils.isNotBlank(entityName)) {
            String bookTypeFieldKey = FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)entityName);
            VoucherRelationTypeEnum type = VoucherRelationTypeEnum.getType((String)entityName);
            if (bookTypeFieldKey != null && type != null) {
                String relationType = type.getValue();
                for (DynamicObject dyn : dataEntities) {
                    QFilter periodFilter;
                    QFilter typeFilter;
                    long bookTypeId;
                    long orgId = dyn.getLong(GLField.id_((String)"org"));
                    AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = dyn.getLong(GLField.id_((String)bookTypeFieldKey))));
                    if (accountBookInfo == null) continue;
                    long curPeriodId = accountBookInfo.getCurPeriodId();
                    Object pkValue = dyn.getPkValue();
                    QFilter srcEntityFilter = new QFilter("srcentity", "=", pkValue);
                    if (!QueryServiceHelper.exists((String)"gl_voucherrelation", (QFilter[])new QFilter[]{srcEntityFilter, typeFilter = new QFilter("type", "=", (Object)relationType), periodFilter = new QFilter("period", "=", (Object)curPeriodId)})) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Set<Long> getGeneratePeriodByFinalProcessScheme(String entityName, Object[] schemePkValues) {
        if ("gl_voucheramortacheme".equals(entityName)) {
            return FPFormUtil.getGeneratePeriodByVoucherAmortScheme(schemePkValues);
        }
        if (schemePkValues.length < 1) {
            return Collections.emptySet();
        }
        String booksTypeFieldKey = FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)entityName);
        if (StringUtils.isBlank((CharSequence)booksTypeFieldKey)) {
            return Collections.emptySet();
        }
        QFBuilder qfBuilder = new QFBuilder("id", "in", (Object)schemePkValues);
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)("org," + booksTypeFieldKey), (QFilter[])qfBuilder.toArray());
        if (schemes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(schemes.size());
        schemes.values().forEach(x -> {
            List openPeriods;
            long bookTypeId;
            long orgId = x.getLong(GLField.id_((String)"org"));
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = x.getLong(GLField.id_((String)booksTypeFieldKey))));
            if (bookInfo != null && !(openPeriods = GLUtil.getOpenPeriod((long)orgId, (long)bookTypeId)).isEmpty()) {
                result.addAll(openPeriods);
                result.add(bookInfo.getCurPeriodId());
            }
        });
        return result;
    }

    private static Set<Long> getGeneratePeriodByVoucherAmortScheme(Object[] schemePkValues) {
        if (schemePkValues.length < 1) {
            return Collections.emptySet();
        }
        String booksTypeFieldKey = FinalProcessCommonFieldKey.getBooksTypeFieldKeyByEntityName((String)"gl_voucheramortacheme");
        if (StringUtils.isBlank((CharSequence)booksTypeFieldKey)) {
            return Collections.emptySet();
        }
        QFBuilder qfBuilder = new QFBuilder("id", "in", (Object)schemePkValues);
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"gl_voucheramortacheme", (String)("org," + booksTypeFieldKey + "," + "startperiod"), (QFilter[])qfBuilder.toArray());
        if (schemes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(schemes.size());
        schemes.values().forEach(x -> {
            long bookTypeId;
            long orgId = x.getLong(GLField.id_((String)"org"));
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = x.getLong(GLField.id_((String)booksTypeFieldKey))));
            if (bookInfo != null) {
                List openPeriods = GLUtil.getOpenPeriod((long)orgId, (long)bookTypeId);
                long startPeriodId = x.getLong(GLField.id_((String)"startperiod"));
                Set openPeriodSet = openPeriods.stream().filter(v -> v.compareTo(startPeriodId) >= 0).collect(Collectors.toSet());
                if (!openPeriodSet.isEmpty()) {
                    result.addAll(openPeriodSet);
                    result.add(bookInfo.getCurPeriodId());
                }
            }
        });
        return result;
    }

    protected static void showOpenedPeriodListOnFinalProcessView(IFormView view, Set<Long> openedPeriods, CloseCallBack closeCallBack) {
        if (null == view) {
            return;
        }
        if (openedPeriods.isEmpty()) {
            return;
        }
        ListShowParameter periodList = ShowFormHelper.createShowListForm((String)"bd_period", (boolean)Boolean.FALSE);
        periodList.getListFilterParameter().setFilter(new QFilter("id", "in", openedPeriods));
        periodList.setCloseCallBack(closeCallBack);
        periodList.setCaption(ResManager.loadKDString((String)"\u5b58\u5728\u5386\u53f2\u6253\u5f00\u671f\u95f4\uff0c\u8bf7\u9009\u62e9", (String)"FPFormUtil_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        view.showForm((FormShowParameter)periodList);
    }

    protected static void doGenerateVoucherWithSpecifiedPeriodAsync(FormOperate formOperate, Object[] schemePkValues, Long openedPeriod) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("openedperiod", String.valueOf(openedPeriod));
        FPFormUtil.doGenerateVoucherWithOptionAsync(formOperate, schemePkValues, option);
    }

    protected static void doGenerateVoucherWithMergeVoucherAsync(FormOperate formOperate, Object[] schemePkValues) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("MergeVoucherEntries", Boolean.TRUE.toString());
        FPFormUtil.doGenerateVoucherWithOptionAsync(formOperate, schemePkValues, option);
    }

    protected static void doGenerateVoucherWithOptionAsync(FormOperate formOperate, Object[] schemePkValues, OperateOption option) {
        String entityId;
        IFormView view = formOperate.getView();
        String string = entityId = view instanceof IListView ? ((IListView)view).getBillFormId() : view.getEntityId();
        if (!FINALPROCESS_ENTITYS.contains(entityId)) {
            return;
        }
        Map fpOptionVars = option.getVariables();
        if (FPFormUtil.isMutexByThisPage(view)) {
            fpOptionVars.put("isStrict", Boolean.FALSE.toString());
        }
        if (ArrayUtils.isNotEmpty((Object[])schemePkValues)) {
            FormShowParameter parame = new FormShowParameter();
            parame.setFormId("gl_createvoucherprogress");
            parame.getOpenStyle().setShowType(ShowType.Modal);
            parame.setCustomParam("selectIds", (Object)schemePkValues);
            parame.setCustomParam("fp_entity", (Object)entityId);
            parame.setCustomParam("fp_option", (Object)fpOptionVars);
            parame.setCloseCallBack(new CloseCallBack(formOperate.getClass().getName(), "createvoucher"));
            view.showForm(parame);
        }
    }

    protected static void showFinalProcessAssgrpEdit(IFormView view, CloseCallBack closeCallBack, Map<String, Object> customParams) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId("gl_finalprocess_assgrp");
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParams(customParams);
        form.setCloseCallBack(closeCallBack);
        view.showForm(form);
    }

    protected static DynamicObject copyFinalProcessAssgrpDyn(String oldRowId, Long oldOrgId, String newRowId, Long newOrgId) {
        DynamicObject oldExpDyn = FPFormUtil.queryFinalProcessAssgrpDyn(oldRowId, oldOrgId);
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)"gl_finalprocess_assgrp");
        newExpDyn.set(GLField.id_((String)"org"), (Object)newOrgId);
        newExpDyn.set("assgrprow", (Object)newRowId);
        return FPFormUtil.copyFinalProcessAssgrpDyn(oldExpDyn, newExpDyn);
    }

    protected static DynamicObject copyFinalProcessAssgrpDyn(DynamicObject oldExpDyn, DynamicObject newExpDyn) {
        if (oldExpDyn == null || newExpDyn == null) {
            return null;
        }
        FPFormUtil.copyFinalProcessAssgrpDyn(oldExpDyn.getDynamicObjectCollection("entryentity"), newExpDyn.getDynamicObjectCollection("entryentity"));
        return newExpDyn;
    }

    protected static DynamicObjectCollection copyFinalProcessAssgrpDyn(DynamicObjectCollection oldExpEntries, DynamicObjectCollection newExpEntries) {
        newExpEntries.clear();
        for (DynamicObject oldExpEntryRow : oldExpEntries) {
            DynamicObject newExpRow = newExpEntries.addNew();
            for (String prop : FINAL_ASSGRP_ENTRY_PROPS) {
                newExpRow.set(prop, oldExpEntryRow.get(prop));
            }
        }
        return newExpEntries;
    }

    protected static DynamicObject queryFinalProcessAssgrpDyn(String rowId, Long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("assgrprow", "=", (Object)rowId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_finalprocess_assgrp", (QFilter[])filters);
    }

    protected static String getDesc(DynamicObjectCollection entries, FPAssgrpDescLengthConfig config) {
        String substring;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : entries) {
            if (sb.length() > config.getAssgrpLength()) break;
            String name = row.getString("fieldname.name");
            sb.append(name);
            sb.append("\uff1a");
            String value = "";
            String type = row.getString("fieldname.valuetype");
            String dispPropTemp = "";
            String disprops = row.getString("fieldname.disprops");
            if (kd.bos.util.StringUtils.isNotEmpty((String)disprops)) {
                JSONObject jsonObject = JSONObject.parseObject((String)disprops);
                dispPropTemp = jsonObject.getJSONObject("disp").getString("dispprop");
            }
            String dispProp = dispPropTemp;
            if ("3".equals(type)) {
                String txtval = row.getString("txtval");
                if (txtval != null) {
                    value = txtval = txtval.replaceAll(";", "\uff0c");
                }
            } else {
                List ids;
                String entityId = null;
                String nameProp = "name";
                String numProp = "number";
                if ("1".equals(type)) {
                    entityId = row.getString("fieldname.valuesource.id");
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
                    nameProp = entityType.getNameProperty();
                    numProp = entityType.getNumberProperty();
                } else if ("2".equals(type)) {
                    entityId = "bos_assistantdata_detail";
                }
                if (StringUtils.isNotBlank((CharSequence)entityId) && !(ids = row.getDynamicObjectCollection("value").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
                    Map valsFormDb = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)(numProp + "," + nameProp), (QFilter[])new QFilter("id", "in", ids).toArray());
                    String finalNumProp = numProp;
                    String finalNameProp = nameProp;
                    List vals = valsFormDb.values().stream().map(x -> {
                        if ("1".equals(dispProp)) {
                            return x.getString(finalNumProp);
                        }
                        if ("3".equals(dispProp)) {
                            return x.getString(finalNumProp) + "-" + x.getString(finalNameProp);
                        }
                        return x.getString(finalNameProp);
                    }).collect(Collectors.toList());
                    if (!vals.isEmpty()) {
                        value = String.join((CharSequence)"\uff0c", vals);
                    }
                }
            }
            sb.append(value);
            sb.append("\uff1b");
        }
        if ((substring = sb.substring(0, Math.min(sb.length(), config.getAssgrpLength()))).endsWith("\uff1b")) {
            substring = substring.substring(0, substring.length() - 1);
        }
        return substring;
    }

    @Deprecated
    protected static String getDesc(DynamicObjectCollection entries) {
        String substring;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : entries) {
            if (sb.length() > 500) break;
            String name = row.getString("fieldname.name");
            sb.append(name);
            sb.append("\uff1a");
            String value = "";
            String type = row.getString("fieldname.valuetype");
            String dispPropTemp = "";
            String disprops = row.getString("fieldname.disprops");
            if (kd.bos.util.StringUtils.isNotEmpty((String)disprops)) {
                JSONObject jsonObject = JSONObject.parseObject((String)disprops);
                dispPropTemp = jsonObject.getJSONObject("disp").getString("dispprop");
            }
            String dispProp = dispPropTemp;
            if ("3".equals(type)) {
                String txtval = row.getString("txtval");
                if (txtval != null) {
                    value = txtval = txtval.replaceAll(";", "\uff0c");
                }
            } else {
                List ids;
                String entityId = null;
                String nameProp = "name";
                String numProp = "number";
                if ("1".equals(type)) {
                    entityId = row.getString("fieldname.valuesource.id");
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
                    nameProp = entityType.getNameProperty();
                    numProp = entityType.getNumberProperty();
                } else if ("2".equals(type)) {
                    entityId = "bos_assistantdata_detail";
                }
                if (StringUtils.isNotBlank((CharSequence)entityId) && !(ids = row.getDynamicObjectCollection("value").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
                    Map valsFormDb = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)(numProp + "," + nameProp), (QFilter[])new QFilter("id", "in", ids).toArray());
                    String finalNumProp = numProp;
                    String finalNameProp = nameProp;
                    List vals = valsFormDb.values().stream().map(x -> {
                        if ("1".equals(dispProp)) {
                            return x.getString(finalNumProp);
                        }
                        if ("3".equals(dispProp)) {
                            return x.getString(finalNumProp) + "-" + x.getString(finalNameProp);
                        }
                        return x.getString(finalNameProp);
                    }).collect(Collectors.toList());
                    if (!vals.isEmpty()) {
                        value = String.join((CharSequence)"\uff0c", vals);
                    }
                }
            }
            sb.append(value);
            sb.append("\uff1b");
        }
        if ((substring = sb.substring(0, Math.min(sb.length(), 500))).endsWith("\uff1b")) {
            substring = substring.substring(0, substring.length() - 1);
        }
        return substring;
    }

    protected static String getNumberShowStrOnAssistSetupEntry(DynamicObjectCollection entries) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : entries) {
            String assistTypeNumber = row.getString("fieldname.number");
            sb.append(assistTypeNumber).append(":");
            String value = "";
            String type = row.getString("fieldname.valuetype");
            if ("3".equals(type)) {
                String txtval = row.getString("txtval");
                if (txtval != null) {
                    value = txtval = txtval.replaceAll(";", ",");
                }
            } else {
                List ids;
                String entityId = null;
                if ("1".equals(type)) {
                    entityId = row.getString("fieldname.valuesource.id");
                } else if ("2".equals(type)) {
                    entityId = "bos_assistantdata_detail";
                }
                if (StringUtils.isNotBlank((CharSequence)entityId) && !(ids = row.getDynamicObjectCollection("value").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
                    Map valsFormDb = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)"name, number", (QFilter[])new QFilter("id", "in", ids).toArray());
                    value = valsFormDb.values().stream().map(assistValue -> assistValue.getString("number")).collect(Collectors.joining(","));
                }
            }
            sb.append(value).append(";").append("\n");
        }
        return sb.toString();
    }

    protected static void createAssistSetupAfterImport(DynamicObject acctSetEntry) {
        String multiSetup = acctSetEntry.getString("assgrpsetup").trim();
        String[] singleSetupGroup = multiSetup.split(";");
        DynamicObjectCollection assistSetupEntries = acctSetEntry.getDynamicObjectCollection("assgrpentry");
        assistSetupEntries.clear();
        Arrays.stream(singleSetupGroup).forEach(singleSetup -> FPFormUtil.createRowByAssistSetupString(singleSetup, assistSetupEntries));
        acctSetEntry.set("assgrpdesc", (Object)FPFormUtil.getDesc(assistSetupEntries, FPAssgrpDescLengthConfig.fromProperty("gl_adjustexchangerate")));
    }

    protected static void createRowByAssistSetupString(String singleSetup, DynamicObjectCollection assistSetupEntries) {
        if (StringUtils.isEmpty((CharSequence)(singleSetup = singleSetup.trim().replace("\n", "")))) {
            return;
        }
        String[] setupArr = singleSetup.split(":");
        if (setupArr.length != 1 && setupArr.length != 2) {
            throw new GLException(new ErrorCode("fi-gl-endingprocess-import", String.format(ResManager.loadKDString((String)"\u8be5\u884c\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u201c%s\u201d\u7684\u683c\u5f0f\u9519\u8bef\u3002", (String)"FPFormUtil_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), singleSetup)), new Object[0]);
        }
        String assistType = setupArr[0];
        CharSequence[] assistValueArr = setupArr.length == 1 ? new String[]{} : setupArr[1].replace(";", "").trim().split(",");
        DynamicObject assistTypeDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (QFilter[])new QFilter("number", "=", (Object)assistType).toArray());
        if (assistTypeDyo == null) {
            throw new GLException(new ErrorCode("fi-gl-endingprocess-import", String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04\u7c7b\u578b", (String)"FPFormUtil_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), assistType)), new Object[0]);
        }
        String assistValueType = assistTypeDyo.getString("valuetype");
        Collection assistBaseDataValues = null;
        String assistHomeMadeValue = null;
        QFBuilder builder = new QFBuilder();
        if ("3".equals(assistValueType)) {
            assistHomeMadeValue = String.join((CharSequence)";", assistValueArr);
        } else if ("1".equals(assistValueType) || "2".equals(assistValueType)) {
            String assistValueSourceEntity = "1".equals(assistValueType) ? assistTypeDyo.getString("valuesource.number") : "bos_assistantdata_detail";
            builder.add("number", "in", (Object)assistValueArr);
            if ("2".equals(assistValueType)) {
                builder.add("group", "=", (Object)assistTypeDyo.getLong("assistanttype.id"));
            }
            assistBaseDataValues = BusinessDataServiceHelper.loadFromCache((String)assistValueSourceEntity, (String)"", (QFilter[])builder.toArray()).values();
        }
        DynamicObject newAssistValueSetupRow = assistSetupEntries.addNew();
        FPFormUtil.addMultiPropValues(newAssistValueSetupRow, assistBaseDataValues, "value");
        newAssistValueSetupRow.set("fieldname", (Object)assistTypeDyo);
        newAssistValueSetupRow.set("txtval", (Object)assistHomeMadeValue);
    }

    protected static void addMultiPropValues(DynamicObject multiPropParent, Collection<DynamicObject> dyoValues, String multiPropKey) {
        if (CollectionUtils.isEmpty(dyoValues)) {
            return;
        }
        DynamicObjectCollection propDyoCol = multiPropParent.getDynamicObjectCollection(multiPropKey);
        dyoValues.forEach(dyoToSet -> {
            DynamicObject addedValue = propDyoCol.addNew();
            addedValue.set("fbasedataid_id", dyoToSet.getPkValue());
            addedValue.set("fbasedataid", dyoToSet);
        });
    }

    public static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }

    protected static void parseAssistSetupBeforeExport(AfterQueryOfExportEvent e) {
        String parentEntryKey = "accountentry";
        String subAssistEntryKey = "assgrpentry";
        for (DynamicObject queryValue : e.getQueryValues()) {
            queryValue.getDynamicObjectCollection("accountentry").forEach(parentAcctEntry -> {
                DynamicObjectCollection assistValueSetupEntries = parentAcctEntry.getDynamicObjectCollection("assgrpentry");
                String setupShowStr = FPFormUtil.getNumberShowStrOnAssistSetupEntry(assistValueSetupEntries);
                parentAcctEntry.set("assgrpsetup", (Object)setupShowStr);
            });
        }
    }

    private static boolean isMutexByThisPage(IFormView formView) {
        if (formView instanceof IListView) {
            return false;
        }
        IPageCache pageCache = formView.getPageCache();
        String operKey = pageCache.get("MUTEX_OPER_KEY");
        String objId = pageCache.get("MUTEX_OBJ_ID");
        return operKey != null && objId != null;
    }

    static {
        FINALPROCESS_ENTITYS.add("gl_autotrans");
        FINALPROCESS_ENTITYS.add("gl_adjustexchangerate");
        FINALPROCESS_ENTITYS.add("gl_transplprogram");
        FINALPROCESS_ENTITYS.add("gl_voucheramortacheme");
        FINAL_ASSGRP_ENTRY_PROPS = new String[]{"fieldname", "value", "txtval"};
    }
}

