/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.FlexBasedataBeforeF7SelectListener;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class FinalProcessingAssgrpEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String org = "org";
    private static final String assgrpRow = "assgrprow";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_NAME = "fieldname";
    private static final String VALUE = "value";
    private static final String asstEntry = "bd_asstacttype";
    private static final String btnOk = "okbtn";
    private static final String entryKey = "entryentity";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{btnOk});
        BasedataEdit acc = (BasedataEdit)this.getControl(FIELD_NAME);
        acc.addBeforeF7SelectListener(e -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            ArrayList<String> ffList = new ArrayList<String>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject(FIELD_NAME);
                if (fieldname == null) continue;
                String flexfield = fieldname.getString("flexfield");
                ffList.add(flexfield);
            }
            QFilter f = new QFilter("valuetype", "!=", (Object)"3");
            qFilters.add(f);
            f = new QFilter("flexfield", "not in", ffList);
            qFilters.add(f);
            String flexStr = this.getPageCache().get("flexfield");
            if (flexStr != null) {
                Set flexSet = (Set)GLUtil.fromSerializedString((String)flexStr);
                QFilter fflex = new QFilter("flexfield", "in", (Object)flexSet);
                qFilters.add(fflex);
            }
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.setQFilters(qFilters);
        });
        BasedataEdit ass = (BasedataEdit)this.getControl(VALUE);
        ass.addBeforeF7SelectListener((BeforeF7SelectListener)new FlexBasedataBeforeF7SelectListener());
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customValue = formShowParameter.getCustomParams();
        if (customValue == null) {
            return;
        }
        this.cacheAccountFlexField();
        IDataModel model = this.getModel();
        Object orgVal = customValue.get("orgId");
        Object assgrpRowVal = customValue.get("accountRowId");
        model.setValue(org, orgVal);
        model.setValue(assgrpRow, assgrpRowVal);
        if (customValue.get(VALUE) != null) {
            MainEntityType mainEntityType = model.getDataEntityType();
            DynamicObject dynamicObject = GlFormUtil.fromDynamicString((String)customValue.get(VALUE), mainEntityType);
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity");
            if (coll != null && coll.size() > 0) {
                model.getEntryEntity("entryentity").clear();
            }
            this.setEntry(coll);
        } else {
            Object queryParam = customValue.get("donotquery");
            if (queryParam == null || !Boolean.parseBoolean(queryParam.toString())) {
                QFilter filter2 = new QFilter(org, "=", (Object)Long.parseLong(orgVal.toString()));
                QFilter filter3 = new QFilter(assgrpRow, "=", (Object)assgrpRowVal.toString());
                QFilter[] filters = new QFilter[]{filter2, filter3};
                DynamicObject assgrpDyn = BusinessDataServiceHelper.loadSingle((String)formShowParameter.getFormId(), (String)"org,assgrprow,entryentity.fieldname,entryentity.value", (QFilter[])filters);
                if (assgrpDyn != null) {
                    long orgId = assgrpDyn.getLong("org_id");
                    String rowIdVal = assgrpDyn.getString(assgrpRow);
                    model.setValue(org, (Object)orgId);
                    model.setValue(assgrpRow, (Object)rowIdVal);
                    DynamicObjectCollection coll = assgrpDyn.getDynamicObjectCollection("entryentity");
                    if (coll != null && coll.size() > 0) {
                        model.getEntryEntity("entryentity").clear();
                    }
                    this.setEntry(coll);
                }
            }
        }
        this.intialAssist();
        this.initailAssgrpEnable(customValue, model);
    }

    private void initailAssgrpEnable(Map<String, Object> customValue, IDataModel model) {
        JSONArray notIncludeFlexField = (JSONArray)customValue.get("notIncludeFlexField");
        if (notIncludeFlexField != null && !notIncludeFlexField.isEmpty()) {
            DynamicObjectCollection coll = model.getEntryEntity("entryentity");
            for (DynamicObject row : coll) {
                String flexfield;
                DynamicObject fieldname = row.getDynamicObject(FIELD_NAME);
                if (fieldname == null || notIncludeFlexField.contains((Object)(flexfield = fieldname.getString("flexfield")))) continue;
                this.getView().setEnable(Boolean.valueOf(false), row.getInt("seq") - 1, new String[]{VALUE});
            }
        }
    }

    private void intialAssist() {
        String flexStr = this.getPageCache().get("flexfield");
        if (flexStr != null) {
            Object flexfield;
            Set flexSet = (Set)GLUtil.fromSerializedString((String)flexStr);
            IDataModel model = this.getModel();
            HashSet<String> selFlexSet = new HashSet<String>();
            DynamicObjectCollection coll = model.getEntryEntity("entryentity");
            for (DynamicObject row : coll) {
                DynamicObject fieldname = row.getDynamicObject(FIELD_NAME);
                if (fieldname == null) continue;
                flexfield = fieldname.getString("flexfield");
                selFlexSet.add((String)flexfield);
            }
            if (flexSet != null && flexSet.size() > 0) {
                flexSet.removeAll(selFlexSet);
                ArrayList<Long> asstIds = new ArrayList<Long>();
                if (flexSet.size() < 1) {
                    return;
                }
                QFilter f = new QFilter("flexfield", "in", (Object)flexSet);
                DataSet asstSet = QueryServiceHelper.queryDataSet((String)"intialAssist", (String)asstEntry, (String)"id", (QFilter[])new QFilter[]{f}, null);
                flexfield = null;
                try {
                    for (Row row : asstSet) {
                        asstIds.add(row.getLong("id"));
                    }
                }
                catch (Throwable throwable) {
                    flexfield = throwable;
                    throw throwable;
                }
                finally {
                    if (asstSet != null) {
                        if (flexfield != null) {
                            try {
                                asstSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)flexfield).addSuppressed(throwable);
                            }
                        } else {
                            asstSet.close();
                        }
                    }
                }
                if (asstIds.size() > 0) {
                    int idIndex = 0;
                    int[] newEntryRows = model.batchCreateNewEntryRow("entryentity", asstIds.size());
                    for (Object rowIndex : (Object)newEntryRows) {
                        model.setValue(FIELD_NAME, asstIds.get(idIndex), (int)rowIndex);
                        ++idIndex;
                    }
                }
            }
        }
    }

    private void cacheAccountFlexField() {
        Map customValue = this.getView().getFormShowParameter().getCustomParams();
        String accountId = (String)customValue.get("accountId");
        Set<String> flexfieldSet = this.getAssistByAcc(Long.parseLong(accountId));
        this.getPageCache().put("flexfield", GLUtil.toSerializedString(flexfieldSet));
    }

    private Set<String> getAssistByAcc(long accId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        QFilter accFilter = new QFilter("id", "=", (Object)accId);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", (QFilter[])new QFilter[]{accFilter});
        for (DynamicObject col : cols) {
            if ("3".equals(col.getString("valuetype"))) continue;
            result.add(col.getString("flexfield"));
        }
        return result;
    }

    private void setEntry(DynamicObjectCollection collection) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            model.deleteEntryRow("entryentity", i);
        }
        MainEntityType type = model.getDataEntityType();
        if (collection != null && collection.size() > 0) {
            int[] indexs = model.batchCreateNewEntryRow("entryentity", collection.size());
            Iterator iterator = collection.iterator();
            int index = 0;
            int delRows = 0;
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                boolean isNotTxt = this.setVALUEProp(row.getDynamicObject(FIELD_NAME), type);
                if (isNotTxt) {
                    model.setValue(FIELD_NAME, (Object)row.getLong("fieldname_id"), indexs[index]);
                    DynamicObjectCollection collVal = row.getDynamicObjectCollection(VALUE);
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (DynamicObject valDyn : collVal) {
                        long id = valDyn.getLong("fbasedataid_id");
                        ids.add(id);
                    }
                    model.setValue(VALUE, (Object)ids.toArray(new Long[0]), indexs[index++]);
                    continue;
                }
                ++delRows;
            }
            if (delRows > 0) {
                for (int i = 1; i <= delRows; ++i) {
                    model.deleteEntryRow("entryentity", indexs[indexs.length - i]);
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btnOk)) {
            this.returnToData();
        }
    }

    public void returnToData() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        IFormView view = this.getView();
        para.put(VALUE, GlFormUtil.toDynamicObjectJson(this.getModel().getDataEntity(true)));
        para.put("express", this.parseExp());
        String type = (String)view.getFormShowParameter().getCustomParams().get("type");
        String index = (String)view.getFormShowParameter().getCustomParams().get("index");
        para.put(assgrpRow, this.getModel().getValue(assgrpRow));
        para.put("type", type);
        para.put("index", index);
        view.returnDataToParent(para);
        view.close();
    }

    private String parseExp() {
        IDataModel model = this.getModel();
        String expression = "";
        DynamicObjectCollection entryCollection = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryCollection.size(); ++i) {
            DynamicObject rowDyn = (DynamicObject)entryCollection.get(i);
            DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (assisType == null) continue;
            DynamicObject valueSource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            if ("1".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("valuesource");
                entityId = valueSource.getString("id");
            } else if ("2".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            if (valueSource == null) continue;
            String fieldName = rowDyn.getDynamicObject(FIELD_NAME).getLocaleString("name").getLocaleValue();
            expression = expression.isEmpty() ? fieldName + ":" : expression + "\uff1b" + fieldName + ":";
            String valName = " ";
            DynamicObjectCollection collValues = rowDyn.getDynamicObjectCollection(VALUE);
            if (collValues != null && collValues.size() > 0) {
                ArrayList<Long> valIds = new ArrayList<Long>();
                for (DynamicObject value : collValues) {
                    long id = value.getLong("fbasedataid_id");
                    valIds.add(id);
                }
                QFilter fQFilter = new QFilter("id", "in", valIds);
                DynamicObjectCollection coll = QueryServiceHelper.query((String)entityId, (String)"name", (QFilter[])new QFilter[]{fQFilter});
                for (DynamicObject value : coll) {
                    String name = value.getString("name");
                    if (valName.trim().isEmpty()) {
                        valName = name;
                        continue;
                    }
                    valName = valName + "," + name;
                }
            }
            expression = expression + valName;
        }
        return expression;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        int row = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, row);
        this.setVALUEProp(assisType, type);
    }

    private boolean setVALUEProp(DynamicObject assisType, MainEntityType type) {
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(VALUE);
        if (assisType != null) {
            DynamicObject valueSource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            if ("1".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("valuesource");
                entityId = valueSource.getString("id");
            } else if ("2".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            if (valueSource != null) {
                prop.setBaseEntityId(entityId);
                BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                baseProp.setBaseEntityId(entityId);
                baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                return true;
            }
        }
        return false;
    }
}

