/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.FinancialKpiGetValueHelp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class FinancialMainIndex
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FinancialMainIndex.class);
    private static final String GL_FINANCIAL_INDICATORS = "gl_financial_indicators";
    private static final String SELECT_FIELDS = "entryentity.kpiname.name name,entryentity.kpiname.desp desp,entryentity.kpiname.tradestandard tradestandard";
    private static final String GL_BALANCESHEET = "gl_balancesheet";
    private static final String GL_SHOWINCOME = "gl_showincome";
    private static final String GL_CASHFLOWSTAT = "gl_cashflowstat";
    private static final String GL_TAXSHOW = "gl_taxshow";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String EQUAL = "equal";
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String SETBTN = "setbtn";
    private static final String BARAP = "advcontoolbarap";
    private static final String GL_MANAGE_RPTITEM = "gl_manage_rptitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (SETBTN.equals(key)) {
            this.showFinaceKpi();
        }
    }

    private void showFinaceKpi() {
        String orgStr = this.getPageCache().get(ORG);
        String type = this.getPageCache().get(TYPE);
        String orgView = this.getPageCache().get("orgView");
        String bookType = this.getPageCache().get("bookType");
        String accTable = this.getPageCache().get("accTable");
        if (StringUtils.isEmpty((CharSequence)orgStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a\u6216\u591a\u9009\u7ec4\u7ec7\u65f6\uff0c\u4e0d\u80fd\u8bbe\u7f6e", (String)"FinancialMainIndex_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinancialMainIndex_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(GL_FINANCIAL_INDICATORS);
        parameter.setCustomParam(ORG, (Object)orgStr);
        parameter.setCustomParam(TYPE, (Object)type);
        parameter.setCustomParam("orgView", (Object)orgView);
        parameter.setCustomParam("bookType", (Object)bookType);
        parameter.setCustomParam("accTable", (Object)accTable);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SETBTN));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORG, "=", (Object)Long.valueOf(orgStr)));
        qFilters.add(new QFilter(TYPE, "=", (Object)type));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)GL_FINANCIAL_INDICATORS, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dynamicObject != null) {
            parameter.setPkId((Object)dynamicObject.getLong("id"));
        } else {
            qFilters.clear();
            qFilters.add(new QFilter("reporttype", "ftlike", (Object)type));
            qFilters.add(new QFilter("kpitype", "=", (Object)Character.valueOf('1')));
            DynamicObjectCollection kpis = QueryServiceHelper.query((String)"gl_business_analskpi", (String)"id,expression", (QFilter[])qFilters.toArray(new QFilter[0]));
            parameter.setCustomParam("dyn", (Object)GLUtil.toSerializedString((Object)kpis));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SETBTN.equalsIgnoreCase(actionId)) {
            this.setData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setData();
    }

    private void setData() {
        IFormView view = this.getView();
        String tag = (String)this.getView().getFormShowParameter().getCustomParam("tag");
        String orgStr = (String)view.getFormShowParameter().getCustomParam("orgs");
        List orgIds = (List)GLUtil.fromSerializedString((String)orgStr);
        if (orgIds.size() == 1) {
            this.getPageCache().put(ORG, ((Long)orgIds.get(0)).toString());
        }
        this.getPageCache().put(TYPE, (String)view.getFormShowParameter().getCustomParam("tag"));
        Long orgViewId = Long.valueOf((String)view.getFormShowParameter().getCustomParam("orgView"));
        Long bookTypeId = Long.valueOf((String)view.getFormShowParameter().getCustomParam("bookType"));
        Long accTableId = Long.valueOf((String)view.getFormShowParameter().getCustomParam("accTable"));
        this.getPageCache().put("orgView", (String)view.getFormShowParameter().getCustomParam("orgView"));
        this.getPageCache().put("bookType", (String)view.getFormShowParameter().getCustomParam("bookType"));
        this.getPageCache().put("accTable", (String)view.getFormShowParameter().getCustomParam("accTable"));
        Long periodTypeId = Long.valueOf((String)view.getFormShowParameter().getCustomParam("periodType"));
        Long periodId = Long.valueOf((String)view.getFormShowParameter().getCustomParam("period"));
        int amtprecision = Integer.parseInt((String)view.getFormShowParameter().getCustomParam("amtprecision"));
        String childOrgStr = (String)view.getFormShowParameter().getCustomParam("childOrgSet");
        Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgStr);
        List<Map<String, Object>> resultList = this.getKpiResult(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, tag, amtprecision);
        this.setBar(resultList);
    }

    private void setBar(List<Map<String, Object>> resultList) {
        int hidesize;
        int size = resultList.size() > 15 ? 15 : resultList.size();
        for (int j = 1; j <= size; ++j) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexkpi" + j});
        }
        for (int j = hidesize = size + 1; j <= 15; ++j) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexkpi" + j});
        }
        for (int i = 1; i <= size; ++i) {
            Map<String, Object> map = resultList.get(i - 1);
            Label label = (Label)this.getControl("label" + i);
            label.setText(String.valueOf(map.get("name")));
            ProgressBar bar = (ProgressBar)this.getControl("probar" + i);
            BigDecimal result = this.getPerShow(String.valueOf(map.get("percent")));
            int v = result.intValue();
            if (v > 100) {
                v = 100;
            } else if (v == -100) {
                v = 0;
            }
            String title = result.compareTo(new BigDecimal("-100.00")) == 0 ? "N/A" : result.toString() + "%";
            bar.setPercent(v, title);
            if (map.get("tradestandard") != null) {
                Double tradestandard = Double.parseDouble((String)map.get("tradestandard"));
                Double value = Double.parseDouble(map.get("value") + "");
                int retval = value.compareTo(tradestandard);
                if (retval > 0) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{UP + i});
                    this.getView().setVisible(Boolean.FALSE, new String[]{DOWN + i});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EQUAL + i});
                } else if (retval < 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{UP + i});
                    this.getView().setVisible(Boolean.TRUE, new String[]{DOWN + i});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EQUAL + i});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{UP + i});
                    this.getView().setVisible(Boolean.FALSE, new String[]{DOWN + i});
                    this.getView().setVisible(Boolean.TRUE, new String[]{EQUAL + i});
                }
                ((Label)this.getControl("standlabel" + i)).setText(String.format(ResManager.loadKDString((String)"\u884c\u4e1a\u6807\u51c6\u503c:%s", (String)"FinancialMainIndex_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), tradestandard));
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexstand" + i});
        }
    }

    private List<Map<String, Object>> getKpiResult(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, String tag, int amtprecision) {
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection kpis = this.getKpiDyns(orgId, tag);
        ArrayList<String> desps = new ArrayList<String>(kpis.size());
        for (DynamicObject kpi : kpis) {
            desps.add(kpi.getString("desp"));
        }
        Set<String> itemSet = this.getAllItems(desps);
        HashSet<String> items = new HashSet<String>(itemSet.size());
        for (String item : itemSet) {
            items.add(item.substring(0, item.length() - 1));
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)GL_MANAGE_RPTITEM, (String)"id,rptunit", (QFilter[])new QFilter("number", "in", items).toArray());
        HashSet<String> reportTypes = new HashSet<String>();
        for (DynamicObject item : dyns) {
            reportTypes.add(item.getString("rptunit"));
        }
        Map<String, BigDecimal> itemValue = this.getItemValues(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, reportTypes, amtprecision);
        List<Map<String, Object>> resultList = this.getKpiResultByItemValue(itemValue, kpis);
        return resultList;
    }

    private DynamicObjectCollection getKpiDyns(Long orgId, String tag) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORG, "=", (Object)orgId));
        qFilters.add(new QFilter(TYPE, "=", (Object)tag));
        qFilters.add(new QFilter("entryentity.kpiname.name", "is not null", null));
        DynamicObjectCollection kpis = QueryServiceHelper.query((String)GL_FINANCIAL_INDICATORS, (String)SELECT_FIELDS, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (kpis.isEmpty()) {
            qFilters.clear();
            qFilters.add(new QFilter("reporttype", "ftlike", (Object)tag));
            qFilters.add(new QFilter("kpitype", "=", (Object)"1"));
            kpis = QueryServiceHelper.query((String)"gl_business_analskpi", (String)"name,desp,tradestandard", (QFilter[])qFilters.toArray(new QFilter[0]));
        }
        return kpis;
    }

    private List<Map<String, Object>> getKpiResultByItemValue(Map<String, BigDecimal> itemValue, DynamicObjectCollection kpis) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (DynamicObject kpi : kpis) {
            double value;
            HashMap<String, Object> map;
            block8: {
                String desp = kpi.getString("desp");
                desp = this.translateDesc(desp, itemValue);
                map = new HashMap<String, Object>();
                value = 0.0;
                try {
                    String predesc;
                    Double prevalue;
                    int retval;
                    String[] desc;
                    value = Double.parseDouble(FormulaEngine.execExcelFormula((String)desp) + "");
                    if ("Infinity".equals(value + "") && (desc = desp.split("/")) != null && desc.length == 2 && (retval = (prevalue = Double.valueOf(Double.parseDouble(FormulaEngine.execExcelFormula((String)(predesc = desc[1])) + ""))).compareTo(new Double(0.0))) == 0) {
                        value = -1.0;
                    }
                }
                catch (Exception e) {
                    String predesc;
                    Double prevalue;
                    int retval;
                    String[] desc = desp.split("/");
                    if (desc == null || desc.length != 2 || (retval = (prevalue = Double.valueOf(Double.parseDouble(FormulaEngine.execExcelFormula((String)(predesc = desc[1])) + ""))).compareTo(new Double(0.0))) != 0) break block8;
                    value = -1.0;
                }
            }
            if ("Infinity".equals(value + "")) {
                value = 0.0;
            }
            double finalValue = 0.0;
            try {
                finalValue = BigDecimal.valueOf(value * 100.0).setScale(2, 4).doubleValue();
            }
            catch (Exception e) {
                finalValue = 0.0;
            }
            map.put("name", kpi.getString("name"));
            map.put("percent", finalValue);
            BigDecimal tradestandard = kpi.getBigDecimal("tradestandard");
            if (tradestandard.compareTo(BigDecimal.ZERO) != 0) {
                map.put("tradestandard", tradestandard.toString());
            }
            map.put("value", value);
            resultList.add(map);
        }
        return resultList;
    }

    public String translateDesc(String desp, Map<String, BigDecimal> itemValue) {
        if (FinancialKpiGetValueHelp.isDigit(desp).booleanValue() && desp.length() != 7) {
            return "0";
        }
        HashSet<String> desps = new HashSet<String>();
        Pattern p = Pattern.compile("\\d{7}");
        Matcher m = p.matcher(desp);
        while (m.find()) {
            desps.add(m.group());
        }
        for (String des : desps) {
            if (itemValue.get(des) != null) {
                desp = desp.replace(des, itemValue.get(des) + "");
                continue;
            }
            desp = desp.replace(des, "0");
        }
        return desp;
    }

    private Map<String, BigDecimal> getItemValues(final List<Long> orgIds, final Set<Long> childOrgSet, final Long orgViewId, final Long bookTypeId, final Long accTableId, final Long periodTypeId, final Long periodId, Set<String> reportTypes, final int amtprecision) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        ArrayList<Future> taskResultList = new ArrayList<Future>(reportTypes.size());
        for (final String reportType : reportTypes) {
            Future future = ThreadService.submit((Callable)new Callable<Map<String, BigDecimal>>(){

                @Override
                public Map<String, BigDecimal> call() throws Exception {
                    Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                    if (reportType.equals(FinancialMainIndex.GL_BALANCESHEET)) {
                        map = FinancialKpiGetValueHelp.getBalanceValue(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
                    } else if (reportType.equals(FinancialMainIndex.GL_SHOWINCOME)) {
                        map = FinancialKpiGetValueHelp.getIncomeValue(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision, true);
                    } else if (reportType.equals(FinancialMainIndex.GL_CASHFLOWSTAT)) {
                        map = FinancialKpiGetValueHelp.getCashFlowStatValue(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
                    } else if (reportType.equals(FinancialMainIndex.GL_TAXSHOW)) {
                        map = FinancialKpiGetValueHelp.getTaxShowValue(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
                    }
                    return map;
                }
            }, (TaskType)TaskType.GL_FINANCIAL_MAIN_INDEX_COLLECTOR);
            taskResultList.add(future);
        }
        for (Future task : taskResultList) {
            try {
                Map taskResult = (Map)task.get();
                if (CollectionUtils.isEmpty((Map)taskResult)) continue;
                resultMap.putAll(taskResult);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return resultMap;
    }

    private Set<String> getAllItems(List<String> desps) {
        HashSet<String> itemSet = new HashSet<String>();
        for (String desp : desps) {
            Pattern p = Pattern.compile("\\d{7}");
            Matcher m = p.matcher(desp);
            while (m.find()) {
                itemSet.add(m.group());
            }
        }
        return itemSet;
    }

    private BigDecimal getPerShow(String s) {
        BigDecimal value = BigDecimal.valueOf(0L);
        try {
            value = new BigDecimal(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        value = value.setScale(2, 4);
        return value;
    }
}

