/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class GlFlexPropertyConditionPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String FilterGridAp = "filtergridap";
    private static final String[] OUT_IDS = new String[]{CompareTypeEnum.CURRENTUSERINCHARGEDEPT.getId(), CompareTypeEnum.CURRENTUSERINCHARGEDEPTS.getId()};
    private static List<String> OUT_ID_LIST = Arrays.asList(OUT_IDS);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        String filterjson = (String)this.getView().getFormShowParameter().getCustomParam("filterjson");
        FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
        FlexBDValueCondition fc = null;
        if (StringUtils.isNotBlank((CharSequence)filterjson)) {
            fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterjson, FlexBDValueCondition.class);
            filterGrid.SetValue(fc.getFilterCondition());
        }
    }

    public void beforeBindData(EventObject e) {
        this.createFilterGrid();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("baseformid");
            FilterBuilder filterBuilder = this.getFilterBuilder(formId, filterCondition);
            String filter = filterBuilder.getFilterObject().getFilterResult().getFilterGroup()[0];
            FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
            flexPropertyCon.setDescription(new LocaleString(filter));
            flexPropertyCon.setFilterCondition(filterCondition);
            flexPropertyCon.setExpression((String)this.getModel().getValue("expression"));
            String condition = SerializationUtils.toJsonString((Object)flexPropertyCon);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("display", filter.substring(0, filter.length() > 50 ? 50 : filter.length()));
            data.put("value", condition);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private void createFilterGrid() {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String formId = (String)paramter.getCustomParam("baseformid");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.filterGridSetFieldColumns(FilterGridAp, formId, true);
        }
    }

    private List<FilterField> getFilterFields(MainEntityType entityType) {
        IDataEntityProperty fieldProp;
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        Map allFields = entityType.getAllFields();
        Collection allProp = allFields.values();
        for (IDataEntityProperty fieldProp2 : allProp) {
            EntryProp entryProp;
            MulBasedataProp mulBasedataProp;
            String alias;
            String alias2;
            if ((!(fieldProp2 instanceof EntryProp) ? (!(fieldProp2 instanceof MulBasedataProp) ? StringUtils.isBlank((CharSequence)(alias2 = fieldProp2.getAlias())) : StringUtils.isBlank((CharSequence)(alias = (mulBasedataProp = (MulBasedataProp)fieldProp2).getDynamicCollectionItemPropertyType().getAlias()))) : StringUtils.isBlank((CharSequence)(alias = (entryProp = (EntryProp)fieldProp2).getDynamicCollectionItemPropertyType().getAlias()))) || !(fieldProp2 instanceof IFieldHandle)) continue;
            IFieldHandle iFieldHandle = (IFieldHandle)fieldProp2;
            List list = iFieldHandle.createFilterFields(entityType);
            filterFields.addAll(list);
        }
        if ("bos_org".equals(entityType.getName()) && (fieldProp = (IDataEntityProperty)allFields.get("parent")) instanceof IFieldHandle) {
            IFieldHandle iFieldHandle = (IFieldHandle)fieldProp;
            List list = iFieldHandle.createFilterFields(entityType);
            filterFields.addAll(list);
        }
        return filterFields;
    }

    private void filterGridSetFieldColumns(String controlKey, String entityNumber, boolean isAddedBtn) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        filterGrid.setEntityNumber(entityType.getName());
        List<FilterField> filterFields = this.getFilterFields(entityType);
        ArrayList<Map> filterColumns = new ArrayList<Map>(filterFields.size());
        for (FilterField filterField : filterFields) {
            if ("org".equals(filterField.getBaseDataFilterControlType())) {
                CompareType currentAndSubOrgType;
                CompareType currentOrgType = filterField.getCompareType(CompareTypeEnum.CURRENTUSERDEPT.getId());
                if (!Objects.isNull(currentOrgType)) {
                    currentOrgType.setName(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7", (String)"GlFlexPropertyConditionPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                }
                if (Objects.nonNull(currentAndSubOrgType = filterField.getCompareType(CompareTypeEnum.CURRENTUSERDEPTS.getId()))) {
                    currentAndSubOrgType.setName(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7", (String)"GlFlexPropertyConditionPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                }
                filterField.getCompareTypes().removeIf(x -> OUT_ID_LIST.contains(x.getId()));
            }
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
        if (!isAddedBtn) {
            filterGrid.setBtnStatus();
        }
    }

    private FilterBuilder getFilterBuilder(String entityNumber, FilterCondition filterCondition) {
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }
}

