/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.TaxReportFormHelper;
import kd.fi.gl.util.TaxReportUtil;

public class IncomeExpressionEdit
extends AbstractFormPlugin
implements ClickListener {
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "isTotalRow";
    private static final String entryKey = "entryentity";
    private static final String project = "project";
    private static final String sign = "sign";
    private static final String fetchRule = "fetchrule";
    private static final String btnOk = "btnok";
    private static final String addRow = "add";
    private static final String balrowId = "balrowid";
    private static final String rowtag = "rowtag";
    private static final String columnKey = "columnkey";
    private static final String orgID = "org";
    private static final String accTable = "accounttable";
    private static final String orgField = "orgfield";

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btnOk)) {
            this.returnToData();
        }
    }

    public void returnToData() {
        if (this.validate()) {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("value", GlFormUtil.toDynamicObjectJson(this.getModel().getDataEntity(true)));
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    private boolean validate() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        if (collection == null) {
            return true;
        }
        Boolean isTotalRow = Boolean.valueOf(this.getModel().getValue(ISTOTALROW).toString());
        for (DynamicObject dynamicObject : collection) {
            if (isTotalRow.booleanValue()) {
                if (!StringUtils.isBlank((Object)dynamicObject.get(RPTITEM)) && !StringUtils.isBlank((Object)dynamicObject.get(sign))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b2c%s\u884c\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"IncomeExpressionEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), dynamicObject.getInt(1)), Integer.valueOf(3000));
                return false;
            }
            if (!StringUtils.isBlank((Object)dynamicObject.get(project)) && !StringUtils.isBlank((Object)dynamicObject.get(sign)) && !StringUtils.isBlank((Object)dynamicObject.get(fetchRule))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b2c%s\u884c\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"IncomeExpressionEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), dynamicObject.getInt(1)), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btnOk, addRow});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.filterAcct();
    }

    private void filterAcct() {
        BasedataEdit acctTarget = (BasedataEdit)this.getView().getControl(project);
        acctTarget.addBeforeF7SelectListener(e -> {
            long accounttable = (Long)this.getModel().getValue("accounttable_id");
            List filters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(new QFilter(accTable, "=", (Object)accounttable));
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)((Long)this.getModel().getValue(orgID))));
        });
        BasedataEdit itemEdit = (BasedataEdit)this.getView().getControl(RPTITEM);
        itemEdit.addBeforeF7SelectListener(e -> {
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String taxType = (String)formShowParameter.getCustomParam("type");
            long orgId = (Long)this.getModel().getValue(orgID);
            TaxReportFormHelper.filterTaxProject((long)orgId, (ListShowParameter)param, (String)taxType);
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("name", "is not null", null));
            Object projectId = this.getView().getFormShowParameter().getCustomParam(project);
            if (projectId != null) {
                filters.add(new QFilter("id", "!=", projectId));
            }
        });
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map value = formShowParameter.getCustomParams();
        String taxType = (String)value.get("type");
        this.addPLAmount(taxType);
    }

    public void afterCreateNewData(EventObject e) {
        block4: {
            DynamicObjectCollection defaultColl;
            IDataModel model;
            String periodType;
            Map value;
            block6: {
                String taxType;
                FormShowParameter formShowParameter;
                block5: {
                    formShowParameter = this.getView().getFormShowParameter();
                    value = formShowParameter.getCustomParams();
                    if (value == null || !StringUtils.isNotBlank(value.get("periodType"))) break block4;
                    periodType = (String)value.get("periodType");
                    taxType = (String)value.get("type");
                    if (StringUtils.isBlank(value.get("orgId"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeExpressionEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    model = this.getModel();
                    model.setValue(orgID, value.get("orgId"));
                    model.setValue(accTable, value.get("accTableId"));
                    model.setValue("booktype", value.get("booktype"));
                    model.setValue(balrowId, (Object)value.get(balrowId).toString());
                    model.setValue(rowtag, (Object)value.get(rowtag).toString());
                    model.setValue(columnKey, (Object)periodType);
                    model.setValue("type", (Object)taxType);
                    Boolean isTotalRow = Boolean.valueOf(value.get("istotalrow").toString());
                    model.setValue(ISTOTALROW, (Object)isTotalRow);
                    BasedataEdit rptItem = (BasedataEdit)this.getControl(RPTITEM);
                    rptItem.setMustInput(isTotalRow.booleanValue());
                    BasedataEdit projectbEdit = (BasedataEdit)this.getControl(project);
                    projectbEdit.setMustInput(isTotalRow == false);
                    this.getPageCache().put(balrowId, value.get(balrowId).toString());
                    this.getPageCache().put(columnKey, periodType);
                    this.getPageCache().put(orgID, value.get("orgId").toString());
                    if (value.get("value") == null) break block5;
                    MainEntityType mainEntityType = model.getDataEntityType();
                    DynamicObject dynamicObject = GlFormUtil.fromDynamicString((String)value.get("value"), mainEntityType);
                    DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection(entryKey);
                    if (coll != null && coll.size() > 0) {
                        model.getEntryEntity(entryKey).clear();
                    }
                    this.setEntry(coll);
                    break block4;
                }
                QFilter forg = new QFilter(orgID, "=", (Object)Long.valueOf(value.get("orgId").toString()));
                QFilter facctTable = new QFilter(accTable, "=", (Object)Long.valueOf(value.get("accTableId").toString()));
                QFilter bookType = new QFilter("booktype", "=", (Object)Long.valueOf(value.get("booktype").toString()));
                QFilter fbalRowId = new QFilter(balrowId, "=", (Object)value.get(balrowId).toString());
                QFilter fRowTag = new QFilter(rowtag, "=", (Object)value.get(rowtag).toString());
                QFilter fcolumnKey = new QFilter(columnKey, "=", (Object)periodType);
                QFilter ftype = new QFilter("type", "=", (Object)taxType);
                QFilter[] filters = new QFilter[]{forg, facctTable, bookType, fbalRowId, fRowTag, fcolumnKey, ftype};
                String selectFields = "entryentity.project, entryentity.sign, entryentity.fetchrule, entryentity.rptitem rptitem";
                DynamicObjectCollection collection = QueryServiceHelper.query((String)formShowParameter.getFormId(), (String)selectFields, (QFilter[])filters);
                defaultColl = model.getEntryEntity(entryKey);
                if (collection == null || collection.size() <= 0) break block6;
                defaultColl.clear();
                int[] indexs = model.batchCreateNewEntryRow(entryKey, collection.size());
                for (int i = 0; i < collection.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                    model.setValue(project, dynamicObject.get(0), indexs[i]);
                    model.setValue(sign, dynamicObject.get(1), indexs[i]);
                    model.setValue(fetchRule, dynamicObject.get(2), indexs[i]);
                    model.setValue(RPTITEM, dynamicObject.get(RPTITEM), indexs[i]);
                    model.setValue(orgField, value.get("orgId"), indexs[i]);
                }
                break block4;
            }
            if (defaultColl == null || defaultColl.size() <= 0) break block4;
            int count = defaultColl.size();
            for (int i = 0; i < count; ++i) {
                model.setValue(orgField, value.get("orgId"), i);
                model.setValue(fetchRule, (Object)this.fetchRuleByType(periodType), i);
            }
        }
    }

    private void addPLAmount(String type) {
        ComboEdit edit = (ComboEdit)this.getControl(fetchRule);
        List comboItems = TaxReportUtil.getComboItems((String)type);
        edit.setComboItems(comboItems);
    }

    private void setEntry(DynamicObjectCollection collection) {
        IDataModel model = this.getModel();
        if (collection != null && collection.size() > 0) {
            int[] indexs = this.getModel().batchCreateNewEntryRow(entryKey, collection.size());
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                model.setValue(project, dynamicObject.get(project), indexs[i]);
                model.setValue(sign, dynamicObject.get(sign), indexs[i]);
                model.setValue(fetchRule, dynamicObject.get(fetchRule), indexs[i]);
                model.setValue(RPTITEM, dynamicObject.get("rptitem_id"), indexs[i]);
                model.setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(orgID)), indexs[i]);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (addRow.equals(key)) {
            String type = this.getPageCache().get(columnKey);
            String value = "";
            if ("1".equals(type)) {
                value = "3";
            } else if ("2".equals(type)) {
                value = "5";
            }
            int index = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(fetchRule, (Object)value, index);
            this.getModel().setValue(sign, (Object)"+", index);
            this.getModel().setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(orgID)), index);
        }
    }

    private String fetchRuleByType(String type) {
        String value = "1";
        if ("1".equals(type)) {
            value = "3";
        } else if ("2".equals(type)) {
            value = "5";
        }
        return value;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (project.equals(name)) {
            IDataModel model = this.getModel();
            int index = e.getChangeSet()[0].getRowIndex();
            String type = this.fetchRuleByType(this.getPageCache().get(columnKey));
            String ruleIndex = (String)model.getValue(fetchRule, index);
            if (StringUtils.isEmpty((CharSequence)ruleIndex)) {
                model.setValue(fetchRule, (Object)type, index);
            }
            model.setValue(orgField, (Object)Long.parseLong(this.getPageCache().get(orgID)), index);
        }
    }
}

