/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.gl.formplugin.info.NoCloseAccountBookInfo;
import kd.fi.gl.formplugin.info.SeqAccountBookinfo;
import kd.fi.gl.util.GLUtil;

public class PeriodclosemonitorPlugin
extends AbstractFormPlugin
implements ProgresssListener,
ClickListener {
    private static final String GL_CLOSEBOOKTIMEDATA = "gl_closebooktimedata";
    private static final int NODESIZE = 4;
    private static String[] colors = new String[]{"#84a2fb", "#2EC6C8", "#FC8555"};
    private static String[] urls = new String[]{"/FI/GL/10001_0_0oB0pC7y2IunEHQCFh.png", "/FI/GL/10003_0_7QaaSZGxjUv8QZu8k3.png", "/FI/GL/10005_0_7TCruK4c395jQlwjcl.png", "/FI/GL/10002_0_XG29ZqkZyw24wip3Ez.png", "/FI/GL/10004_0_A2JNRSS0gXV736H349.png"};
    private static final String MULORG_PERIODTYPE_CACHE_KEY = "mulorgperiodtype-pagecache-key";
    private DynamicObject currentPeriod = null;

    private static String getHome() {
        String s = ResManager.loadKDString((String)"\u5bb6", (String)"PeriodclosemonitorPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        if ("Home".equalsIgnoreCase(s)) {
            return "";
        }
        return " " + s;
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"asc", "desc", "closetimeset"});
        this.addClickListeners(new String[]{"progressbarap"});
        Chart chart = (Chart)this.getControl("piechartap");
        chart.addClickListener((ClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("periodfield");
        final Object periodTypeId = this.getModel().getValue("periodtype_id");
        periodEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("periodtype", "=", periodTypeId));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        String key = ((Control)evt.getSource()).getKey();
        if ("asc".equals(key)) {
            Object period = model.getValue("periodfield");
            Button button = (Button)this.getControl("asc");
            this.updateButtonStyle(button);
            if (period != null) {
                this.createBookRank(((DynamicObject)period).getString("id"), "asc");
            }
        } else if ("desc".equals(key)) {
            Object period = model.getValue("periodfield");
            Button button = (Button)this.getControl("desc");
            this.updateButtonStyle(button);
            if (period != null) {
                this.createBookRank(((DynamicObject)period).getString("id"), "desc");
            }
        } else if ("closetimeset".equals(key)) {
            FormShowParameter show = new FormShowParameter();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setTime");
            show.setCloseCallBack(closeCallBack);
            show.setFormId("gl_accountbookclosetime");
            show.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(show);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("setTime".equals(closedCallBackEvent.getActionId())) {
            this.cacheMulOrgAccountBookInfo();
            this.setLeftCloseDay();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject period = this.getCorrentPeriod();
        Integer periodnumber = 0;
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f53\u524d\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"PeriodclosemonitorPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        periodnumber = Integer.valueOf(period.get("periodnumber").toString());
        Integer year = this.getYear();
        Label periodLabel = (Label)this.getControl("period");
        periodLabel.setText(periodnumber.toString() + "");
        Label yearLabel = (Label)this.getControl("year");
        yearLabel.setText(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"PeriodclosemonitorPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), year));
        this.cacheMulOrgAccountBookInfo();
        this.setLeftCloseDay();
        String periodId = "0";
        if (period != null) {
            periodId = period.getString("id");
            this.createBookRank(periodId, "asc");
        }
        model.setValue("periodfield", (Object)periodId);
        int progressValue = this.initNoCloseCardInfo();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.setPercent(progressValue);
        bar.start();
        Button button = (Button)this.getControl("asc");
        this.updateButtonStyle(button);
    }

    private void cacheMulOrgAccountBookInfo() {
        IPageCache cache = this.getPageCache();
        cache.remove(MULORG_PERIODTYPE_CACHE_KEY);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)GL_CLOSEBOOKTIMEDATA, (String)"company", null);
        List orgList = orgs.stream().map(x -> x.getLong("company")).collect(Collectors.toList());
        List<Long> permissionOrg = this.getPermissionOrg();
        if (!permissionOrg.isEmpty()) {
            orgList.retainAll(permissionOrg);
        }
        if (!orgList.isEmpty()) {
            QFilter orgFilter = new QFilter("org", "in", orgList);
            DynamicObjectCollection periodtypes = QueryServiceHelper.query((String)"gl_accountbook", (String)"periodtype", (QFilter[])orgFilter.toArray());
            Set periodTypeIds = periodtypes.stream().map(x -> x.getLong("periodtype")).collect(Collectors.toSet());
            cache.put(MULORG_PERIODTYPE_CACHE_KEY, SerializationUtils.toJsonString(periodTypeIds));
        }
        this.setDefaultPeriodType();
    }

    private Set<Long> getPeriodTypesFromCache() {
        IPageCache cache = this.getPageCache();
        String cacheStr = cache.get(MULORG_PERIODTYPE_CACHE_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            Set periodTypeIds = (Set)SerializationUtils.fromJsonString((String)cacheStr, HashSet.class);
            return periodTypeIds;
        }
        return null;
    }

    private void setDefaultPeriodType() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Set<Long> periodTypesFromCache = this.getPeriodTypesFromCache();
        if (periodTypesFromCache != null && !periodTypesFromCache.isEmpty()) {
            BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl("periodtype");
            periodTypeEdit.setQFilter(new QFilter("id", "in", periodTypesFromCache));
            Object defafultPeriodType = model.getValue("periodtype_id");
            if (!periodTypesFromCache.contains(defafultPeriodType)) {
                defafultPeriodType = periodTypesFromCache.iterator().next();
            }
            model.setValue("periodtype", defafultPeriodType);
            if (periodTypesFromCache.size() > 1) {
                view.setVisible(Boolean.TRUE, new String[]{"periodtype"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"periodtype"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"periodtype"});
        }
    }

    private void setLeftCloseDay() {
        DynamicObjectCollection bookEntity = QueryServiceHelper.query((String)GL_CLOSEBOOKTIMEDATA, (String)"closeday", null, (String)"closeday desc", (int)1);
        int days = 0;
        Label dailyclosetime = (Label)this.getControl("dailyclosetime");
        if (!bookEntity.isEmpty() && ((DynamicObject)bookEntity.get(0)).getInt("closeday") != 0) {
            int lastCloseDay = ((DynamicObject)bookEntity.get(0)).getInt("closeday");
            days = this.getLeftDays(lastCloseDay);
            dailyclosetime.setText(String.format(ResManager.loadKDString((String)"\u6bcf\u6708\u7ed3\u8d26\u65e5\u671f\u4e3a%s\u65e5\u3002", (String)"PeriodclosemonitorPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), lastCloseDay));
        } else {
            dailyclosetime.setText(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7ed3\u8d26\u65f6\u95f4\u3002", (String)"PeriodclosemonitorPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        Label dayLabel = (Label)this.getControl("leftdays");
        dayLabel.setText(String.valueOf(days));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String keyName = e.getProperty().getName();
        if ("periodfield".equals(keyName) && model.getValue("periodfield") != null) {
            String periodId = ((DynamicObject)model.getValue("periodfield")).getString("id");
            this.createBookRank(periodId, "asc");
        }
    }

    private int initNoCloseCardInfo() {
        Map<Integer, DynamicObjectCollection> infos = this.getAccountBook();
        DynamicObjectCollection nocloseAccountbook = null;
        int closedAccountBookSize = 0;
        int accountingEntitySize = 0;
        for (Map.Entry<Integer, DynamicObjectCollection> info : infos.entrySet()) {
            nocloseAccountbook = info.getValue();
            closedAccountBookSize = info.getKey();
        }
        int nocloseaAccountbookSize = 0;
        if (null != nocloseAccountbook) {
            nocloseaAccountbookSize = nocloseAccountbook.size();
        }
        int nocloseSize = this.getModel().getEntryEntity("entryentity_noclose").size();
        this.showProgress(nocloseaAccountbookSize, closedAccountBookSize);
        int progressValue = (int)Math.rint((float)closedAccountBookSize / (float)(nocloseaAccountbookSize + closedAccountBookSize) * 100.0f);
        if (nocloseaAccountbookSize == nocloseSize) {
            return progressValue;
        }
        this.nocloseAccountBookDetailShow(nocloseAccountbook);
        this.showChart(closedAccountBookSize, nocloseaAccountbookSize, accountingEntitySize);
        return progressValue;
    }

    public void onProgress(ProgressEvent arg0) {
        int progressValue = this.initNoCloseCardInfo();
        arg0.setProgress(progressValue);
    }

    private void showChart(int closedAccountBookSize, int nocloseaAccountbookSize, int accountingEntitySize) {
        ItemValue[] data = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26", (String)"PeriodclosemonitorPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), (Number)closedAccountBookSize, colors[0]), new ItemValue(ResManager.loadKDString((String)"\u672a\u7ed3\u8d26", (String)"PeriodclosemonitorPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), (Number)nocloseaAccountbookSize, colors[1]), new ItemValue(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"PeriodclosemonitorPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), (Number)accountingEntitySize, colors[2])};
        Chart pieChart = (Chart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setLegendAlign(XAlign.center, YAlign.bottom);
        pieChart.setShowTooltip(true);
        pieChart.setMargin(Position.top, "50");
        pieChart.setLegendAlign(XAlign.right, YAlign.bottom);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u7ed3\u8d26\u8fdb\u5ea6\u7edf\u8ba1", (String)"PeriodclosemonitorPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        series.setData(data);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        series.setRadius("25%", "80%");
        pieChart.bindData(null);
    }

    private void showProgress(int nocloseaAccountbookSize, int closedAccountBookSize) {
        Label nocloseaccounts = (Label)this.getControl("needcloseaccounts");
        nocloseaccounts.setText(nocloseaAccountbookSize + PeriodclosemonitorPlugin.getHome());
        Label accountings = (Label)this.getControl("closedaccounts");
        accountings.setText(closedAccountBookSize + PeriodclosemonitorPlugin.getHome());
    }

    private Map<Integer, DynamicObjectCollection> getAccountBook() {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)"gl_periodclosemonitor", (String)"47150e89000000ac");
        QFilter qf = new QFilter("isbizunit", "=", (Object)"1");
        if (!rs.hasAllOrgPerm()) {
            qf.and(new QFilter("org", "in", (Object)rs.getHasPermOrgs()));
        }
        qf.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        String select = "org,curperiod,curperiod.periodnumber periodnumber,curperiod.periodyear periodyear, bookstype.name name";
        DynamicObjectCollection closeStateInfo = QueryServiceHelper.query((String)"gl_accountbook", (String)select, (QFilter[])qf.toArray());
        Iterator iterator = closeStateInfo.iterator();
        DynamicObject next = null;
        DynamicObject currentPeriod = this.getCorrentPeriod();
        int finish = 0;
        while (iterator.hasNext()) {
            boolean equalsYear;
            next = (DynamicObject)iterator.next();
            boolean largeYear = next.getInt("periodyear") > currentPeriod.getInt("periodyear");
            boolean largeMonth = next.getInt("periodnumber") >= currentPeriod.getInt("periodnumber");
            boolean bl = equalsYear = currentPeriod.getInt("periodyear") == next.getInt("periodyear");
            if (!largeYear && (!largeMonth || !equalsYear)) continue;
            iterator.remove();
            ++finish;
        }
        HashMap<Integer, DynamicObjectCollection> map = new HashMap<Integer, DynamicObjectCollection>();
        map.put(finish, closeStateInfo);
        return map;
    }

    private void nocloseAccountBookDetailShow(DynamicObjectCollection nocloseAccountbook) {
        if (null == nocloseAccountbook || nocloseAccountbook.isEmpty()) {
            Label noclosedNum = (Label)this.getControl("noclosebooknum");
            noclosedNum.setText("0" + PeriodclosemonitorPlugin.getHome());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"noclosedetailsflex"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"nodataflex"});
        ArrayList<NoCloseAccountBookInfo> list = new ArrayList<NoCloseAccountBookInfo>();
        for (DynamicObject nocloseAccountBookEntry : nocloseAccountbook) {
            HashSet<String> orgTypeList = new HashSet<String>();
            orgTypeList.add("10");
            NoCloseAccountBookInfo noCloseAccountBookInfo = new NoCloseAccountBookInfo();
            noCloseAccountBookInfo.setName(nocloseAccountBookEntry.getString("org"));
            noCloseAccountBookInfo.setPeriod(nocloseAccountBookEntry.getString("curperiod"));
            noCloseAccountBookInfo.setOrgTypeList(orgTypeList);
            noCloseAccountBookInfo.setTypeName(nocloseAccountBookEntry.getString("name"));
            list.add(noCloseAccountBookInfo);
        }
        Label noclosedNum = (Label)this.getControl("noclosebooknum");
        noclosedNum.setText(list.size() + PeriodclosemonitorPlugin.getHome());
        AbstractFormDataModel formModel = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = null;
        formModel.deleteEntryData("entryentity_noclose");
        for (NoCloseAccountBookInfo noCloseAccountBookInfo : list) {
            formModel = (AbstractFormDataModel)this.getModel();
            formModel.beginInit();
            vs = this.getTableValues(noCloseAccountBookInfo);
            formModel.batchCreateNewEntryRow("entryentity_noclose", vs);
            formModel.endInit();
        }
        this.getView().updateView("entryentity_noclose");
    }

    private TableValueSetter getTableValues(NoCloseAccountBookInfo noCloseAccountBookInfo) {
        int j;
        int i;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int subSysSize = noCloseAccountBookInfo.getOrgTypeList().size();
        vs.addField("accountname", new Object[]{noCloseAccountBookInfo.getName()});
        vs.addField("periodname", new Object[]{noCloseAccountBookInfo.getPeriod()});
        vs.addField("booktype", new Object[]{noCloseAccountBookInfo.getTypeName()});
        for (i = 1; i <= subSysSize; ++i) {
            vs.addField("circle" + i, new Object[]{urls[4]});
        }
        for (j = 1; j < subSysSize; ++j) {
            vs.addField("line" + j, new Object[]{urls[3]});
        }
        if (4 - subSysSize > 0) {
            for (i = subSysSize + 1; i <= 4; ++i) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"piccardflex"});
            }
            for (j = subSysSize; j <= 3; ++j) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"piccardflex"});
            }
        }
        return vs;
    }

    private void createBookRank(String periodId, String seq) {
        block24: {
            ArrayList<SeqAccountBookinfo> bookList;
            IDataModel model;
            block23: {
                AbstractFormDataModel model1 = (AbstractFormDataModel)this.getModel();
                model1.deleteEntryData("entryentity");
                model = this.getModel();
                DynamicObject periodD = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodyear,periodnumber", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(periodId)).toArray());
                QFilter periodYear = new QFilter("period.periodyear", "=", periodD.get("periodyear"));
                QFilter periodNumber = new QFilter("period.periodnumber", "=", periodD.get("periodnumber"));
                QFilter subSysFilter = new QFilter("subsysformnum", "in", (Object)new String[]{"gl_accountbook", "bd_accountbooks"});
                QFilter closeStateFilter = new QFilter("closestate", "=", (Object)"1");
                List<Long> permissionOrg = this.getPermissionOrg();
                if (!permissionOrg.isEmpty()) {
                    closeStateFilter.and(new QFilter("company", "in", this.getPermissionOrg()));
                }
                DynamicObjectCollection bookOksbyDate = QueryServiceHelper.query((String)"gl_closestate", (String)"company, period, closedate, accountbooks, closeuser", (QFilter[])new QFilter[]{periodYear, periodNumber, subSysFilter, closeStateFilter});
                bookList = new ArrayList<SeqAccountBookinfo>();
                for (DynamicObject bookEntry : bookOksbyDate) {
                    DynamicObject day;
                    String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
                    DynamicObject period1 = QueryServiceHelper.queryOne((String)"bd_period", (String)selector, (QFilter[])new QFilter("id", "=", bookEntry.get("period")).toArray());
                    DynamicObject period2 = null;
                    if (period1 != null) {
                        period2 = GLUtil.getPreviousPeriod((Object)period1.get("id"));
                    }
                    if ((day = QueryServiceHelper.queryOne((String)GL_CLOSEBOOKTIMEDATA, (String)"closeday", (QFilter[])new QFilter("company", "=", bookEntry.get("company")).toArray())) == null) continue;
                    if (day.getInt("closeday") == 0) {
                        bookList.add(this.addDefaultSeqAccountBookInfo(bookEntry));
                        continue;
                    }
                    QFilter companyFilter = new QFilter("company", "=", bookEntry.get("company"));
                    QFilter periodf1 = new QFilter("period", "=", period1.get("id"));
                    Object periodid = null;
                    if (period2 != null) {
                        periodid = period2.get("id");
                    }
                    QFilter periodf2 = new QFilter("period", "=", periodid);
                    DynamicObject bookOksbyperiod1 = QueryServiceHelper.queryOne((String)"gl_closestate", (String)"closedate,period.periodyear year,period.periodnumber month", (QFilter[])new QFilter[]{companyFilter, periodf1, subSysFilter});
                    DynamicObject bookOksbyperiod2 = QueryServiceHelper.queryOne((String)"gl_closestate", (String)"closedate,period.periodyear year,period.periodnumber month", (QFilter[])new QFilter[]{companyFilter, periodf2, subSysFilter});
                    DynamicObject[] datas = new DynamicObject[]{bookOksbyperiod1, bookOksbyperiod2};
                    Map<String, int[]> closeTime = this.getCloseTime(day.getInt("closeday"), datas);
                    int[] hours = closeTime.get("hours");
                    int[] days = closeTime.get("days");
                    int[] minites = closeTime.get("minites");
                    double range = 0.0;
                    if (days[0] != 0 && days[1] != 0) {
                        range = Math.rint((float)(days[1] - days[0]) / (float)days[1] * 100.0f);
                    }
                    SeqAccountBookinfo seqAccountBookinfo = new SeqAccountBookinfo();
                    seqAccountBookinfo.setCompany(bookEntry.get("company").toString());
                    if (days[0] != 0 && hours[0] != 0) {
                        seqAccountBookinfo.setThisclosetime(String.format(ResManager.loadKDString((String)"%s\u5929", (String)"PeriodclosemonitorPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(days[0])) + String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"PeriodclosemonitorPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(hours[0])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[0])));
                    } else if (days[0] == 0 && hours[0] != 0) {
                        seqAccountBookinfo.setThisclosetime(String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"PeriodclosemonitorPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(hours[0])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[0])));
                    } else if (hours[0] == 0 && days[0] != 0) {
                        seqAccountBookinfo.setThisclosetime(String.format(ResManager.loadKDString((String)"%s\u5929", (String)"PeriodclosemonitorPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(days[0])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[0])));
                    }
                    if (days[1] != 0 && hours[1] != 0) {
                        seqAccountBookinfo.setLastclosetime(String.format(ResManager.loadKDString((String)"%s\u5929", (String)"PeriodclosemonitorPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(days[1])) + String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"PeriodclosemonitorPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(hours[1])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[1])));
                    } else if (days[1] == 0 && hours[1] != 0) {
                        seqAccountBookinfo.setLastclosetime(String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"PeriodclosemonitorPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(hours[1])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[1])));
                    } else if (hours[1] == 0 && days[1] != 0) {
                        seqAccountBookinfo.setLastclosetime(String.format(ResManager.loadKDString((String)"%s\u5929", (String)"PeriodclosemonitorPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(days[1])) + String.format(ResManager.loadKDString((String)"%s\u5206\u949f", (String)"PeriodclosemonitorPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.valueOf(minites[1])));
                    }
                    seqAccountBookinfo.setRange(range);
                    seqAccountBookinfo.setClosedate(bookEntry.getString("closedate"));
                    seqAccountBookinfo.setBooktype(bookEntry.getLong("accountbooks"));
                    seqAccountBookinfo.setCloseUserId(bookEntry.getLong("closeuser"));
                    bookList.add(seqAccountBookinfo);
                }
                Collections.sort(bookList, new Comparator<SeqAccountBookinfo>(){

                    @Override
                    public int compare(SeqAccountBookinfo book1, SeqAccountBookinfo book2) {
                        if (book1.getRange() == book2.getRange()) {
                            return 0;
                        }
                        if (book1.getRange() > book2.getRange()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                int n = bookList.size();
                if (n == 0) {
                    return;
                }
                if (!"asc".equals(seq)) break block23;
                for (int i = 0; i < n; ++i) {
                    int rowKey = model.createNewEntryRow("entryentity");
                    model.setValue("company", (Object)((SeqAccountBookinfo)bookList.get(i)).getCompany(), rowKey);
                    model.setValue("thisclosetime", (Object)((SeqAccountBookinfo)bookList.get(i)).getThisclosetime(), rowKey);
                    model.setValue("lastclosetime", (Object)((SeqAccountBookinfo)bookList.get(i)).getLastclosetime(), rowKey);
                    if (((SeqAccountBookinfo)bookList.get(i)).getThisclosetime() == null && ((SeqAccountBookinfo)bookList.get(i)).getRange() == 0.0) {
                        model.setValue("range", null, rowKey);
                    } else {
                        model.setValue("range", (Object)(((SeqAccountBookinfo)bookList.get(i)).getRange() + "%"), rowKey);
                    }
                    model.setValue("closedate", (Object)((SeqAccountBookinfo)bookList.get(i)).getClosedate(), rowKey);
                    model.setValue("accountbooks", (Object)((SeqAccountBookinfo)bookList.get(i)).getBooktype(), rowKey);
                    model.setValue("closeuser", (Object)((SeqAccountBookinfo)bookList.get(i)).getCloseUserId(), rowKey);
                }
                break block24;
            }
            if (!"desc".equals(seq)) break block24;
            for (int x = n - 1; x >= 0; --x) {
                int rowKey = model.createNewEntryRow("entryentity");
                model.setValue("company", (Object)((SeqAccountBookinfo)bookList.get(x)).getCompany(), rowKey);
                model.setValue("thisclosetime", (Object)((SeqAccountBookinfo)bookList.get(x)).getThisclosetime(), rowKey);
                model.setValue("lastclosetime", (Object)((SeqAccountBookinfo)bookList.get(x)).getLastclosetime(), rowKey);
                if (((SeqAccountBookinfo)bookList.get(x)).getThisclosetime() == null && ((SeqAccountBookinfo)bookList.get(x)).getRange() == 0.0) {
                    model.setValue("range", null, rowKey);
                } else {
                    model.setValue("range", (Object)(((SeqAccountBookinfo)bookList.get(x)).getRange() + "%"), rowKey);
                }
                model.setValue("closedate", (Object)((SeqAccountBookinfo)bookList.get(x)).getClosedate(), rowKey);
                model.setValue("accountbooks", (Object)((SeqAccountBookinfo)bookList.get(x)).getBooktype(), rowKey);
                model.setValue("closeuser", (Object)((SeqAccountBookinfo)bookList.get(x)).getCloseUserId(), rowKey);
            }
        }
    }

    private SeqAccountBookinfo addDefaultSeqAccountBookInfo(DynamicObject bookEntry) {
        SeqAccountBookinfo seqAccountBookinfo = new SeqAccountBookinfo();
        seqAccountBookinfo.setCompany(bookEntry.get("company").toString());
        seqAccountBookinfo.setClosedate(bookEntry.getString("closedate"));
        seqAccountBookinfo.setBooktype(bookEntry.getLong("accountbooks"));
        seqAccountBookinfo.setCloseUserId(bookEntry.getLong("closeuser"));
        return seqAccountBookinfo;
    }

    private Map<String, int[]> getCloseTime(int day, DynamicObject[] datas) {
        HashMap<String, int[]> closetime = new HashMap<String, int[]>();
        int[] days = new int[]{0, 0};
        int[] hours = new int[]{0, 0};
        int[] minites = new int[]{0, 0};
        Date d = null;
        Calendar closeCal = null;
        Calendar c = null;
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject data = datas[i];
            if (data == null) continue;
            d = data.getDate("closedate");
            closeCal = Calendar.getInstance();
            closeCal.setTime(d);
            c = Calendar.getInstance();
            if (day > 15) {
                c.set(data.getInt("year"), data.getInt("month") - 1, day);
            } else if (data.getInt("month") < 12) {
                c.set(data.getInt("year"), data.getInt("month"), day);
            } else {
                c.set(data.getInt("year") + 1, 0, day);
            }
            if (closeCal.get(1) == c.get(1)) {
                days[i] = closeCal.get(6) - c.get(6);
            } else if (closeCal.get(1) > c.get(1)) {
                Calendar endPeriod = Calendar.getInstance();
                endPeriod.set(c.get(1), 11, 31);
                int residue = endPeriod.get(6) - c.get(6);
                days[i] = residue + closeCal.get(6);
            }
            hours[i] = closeCal.get(11);
            if (hours[i] > 8) {
                int n = i;
                hours[n] = hours[n] - 8;
            } else {
                hours[i] = 0;
            }
            minites[i] = closeCal.get(12);
        }
        closetime.put("days", days);
        closetime.put("hours", hours);
        closetime.put("minites", minites);
        return closetime;
    }

    private DynamicObject getCorrentPeriod() {
        if (this.currentPeriod == null) {
            Date datetime = new Date();
            QFilter periodf1 = new QFilter("begindate", "<=", (Object)datetime);
            QFilter periodf2 = new QFilter("enddate", ">=", (Object)datetime);
            QFilter[] filter = new QFilter[]{periodf1, periodf2};
            this.currentPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])filter);
        }
        return this.currentPeriod;
    }

    private void updateButtonStyle(Button ct) {
        String userId = RequestContext.get().getUserId();
        long lUserId1 = Long.parseLong(userId);
        Map themeMap = UserServiceHelper.getUserThemeNumAndVer((Long)lUserId1);
        String[] color = new String[]{(String)themeMap.get("color"), "#ffffff"};
        ButtonAp btn1 = new ButtonAp();
        btn1.setForeColor(color[1]);
        btn1.setBackColor(color[0]);
        btn1.setHeight(new LocaleString("22px"));
        Style style1 = new Style();
        Border border1 = new Border();
        String borderStyle1 = "0px_solid";
        border1.setBottom(borderStyle1);
        border1.setTop(borderStyle1);
        border1.setLeft(borderStyle1);
        border1.setRight(borderStyle1);
        style1.setBorder(border1);
        Margin margin = new Margin();
        margin.setTop("0px");
        margin.setLeft("0px");
        margin.setRight("0px");
        margin.setBottom("0px");
        style1.setMargin(margin);
        btn1.setStyle(style1);
        ButtonAp btn2 = new ButtonAp();
        btn2.setForeColor(color[0]);
        btn2.setBackColor(color[1]);
        btn2.setHeight(new LocaleString("22px"));
        Style style2 = new Style();
        Border border2 = new Border();
        String borderStyle2 = "1px_solid_" + color[0];
        border2.setBottom(borderStyle2);
        border2.setTop(borderStyle2);
        border2.setLeft(borderStyle2);
        border2.setRight(borderStyle2);
        style2.setBorder(border2);
        style2.setMargin(margin);
        btn2.setStyle(style2);
        if ("asc".equals(ct.getKey())) {
            LocaleString name1 = new LocaleString(ResManager.loadKDString((String)"\u5347\u5e8f", (String)"PeriodclosemonitorPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btn1.setName(name1);
            btn1.setKey(ct.getKey());
            LocaleString name2 = new LocaleString(ResManager.loadKDString((String)"\u964d\u5e8f", (String)"PeriodclosemonitorPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btn2.setName(name2);
            btn2.setKey("desc");
            this.getView().updateControlMetadata(ct.getKey(), btn1.createControl());
            this.getView().updateControlMetadata("desc", btn2.createControl());
        } else if ("desc".equals(ct.getKey())) {
            LocaleString name1 = new LocaleString(ResManager.loadKDString((String)"\u964d\u5e8f", (String)"PeriodclosemonitorPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btn1.setName(name1);
            btn1.setKey(ct.getKey());
            LocaleString name2 = new LocaleString(ResManager.loadKDString((String)"\u5347\u5e8f", (String)"PeriodclosemonitorPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            btn2.setName(name2);
            btn2.setKey("asc");
            this.getView().updateControlMetadata(ct.getKey(), btn1.createControl());
            this.getView().updateControlMetadata("asc", btn2.createControl());
        }
    }

    private int getLeftDays(int lastCloseDay) {
        int leftDays = 0;
        Calendar cal1 = Calendar.getInstance();
        int nowDay = cal1.get(5);
        int maxDays = cal1.getActualMaximum(5);
        cal1.add(2, 1);
        int nextMonthMaxDays = cal1.getActualMaximum(5);
        leftDays = lastCloseDay > maxDays ? maxDays - nowDay : (lastCloseDay >= nowDay ? lastCloseDay - nowDay : (lastCloseDay >= nextMonthMaxDays ? nextMonthMaxDays + (maxDays - nowDay) : lastCloseDay + (maxDays - nowDay)));
        return leftDays;
    }

    private int getYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public List<Long> getPermissionOrg() {
        String useId = RequestContext.get().getUserId();
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult glBook = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(useId), (String)appId, (String)"gl_accountbook", (String)"47150e89000000ac");
        List orgIds = new ArrayList();
        if (!glBook.hasAllOrgPerm()) {
            orgIds = glBook.getHasPermOrgs();
        }
        appId = AppMetadataCache.getAppInfo((String)"fibd").getId();
        HasPermOrgResult oldPerm = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(useId), (String)appId, (String)"gl_accountbook", (String)"47150e89000000ac");
        if (!oldPerm.hasAllOrgPerm()) {
            if (orgIds != null) {
                orgIds.addAll(oldPerm.getHasPermOrgs());
            } else {
                orgIds = oldPerm.getHasPermOrgs();
            }
        }
        return orgIds;
    }
}

