/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.GroupEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.AccountRelation;
import kd.fi.gl.formplugin.PresetCashFlowItem;

public class PresetAccountEdit
extends AbstractBillPlugIn {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private Map<String, Long> tableMap = new HashMap<String, Long>();
    private Map<String, Map<String, Map<String, Long>>> acctMap = new HashMap<String, Map<String, Map<String, Long>>>();
    private Map<String, Map<String, Long>> itemMap = new HashMap<String, Map<String, Long>>();
    private Map<String, Map<String, Map<String, PresetCashFlowItem>>> presetItemMap = new HashMap<String, Map<String, Map<String, PresetCashFlowItem>>>();

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (!customParams.isEmpty()) {
            Object parentId;
            Long itemid = (Long)customParams.get("group");
            DynamicObject item = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,name,number,type", (QFilter[])new QFilter("id", "=", (Object)itemid).toArray());
            if (item != null) {
                String name = item.getString("name");
                String number = item.getString("number");
                model.setValue("group", (Object)itemid);
                model.setValue("name", (Object)name);
                model.setValue("number", (Object)number);
                Object accTableObj = customParams.get("accTableId");
                long accTableId = accTableObj == null ? 0L : Long.parseLong(accTableObj.toString());
                model.setValue("accounttable", (Object)accTableId);
                Object orgId = customParams.get("useorg");
                model.setValue("createorg", orgId);
            }
            if ((parentId = customParams.get("parent")) != null) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle(parentId, (String)"gl_presetcashflowitem", (String)"entryentity.account, entryentity.dc, entryentity.assgrp");
                DynamicObjectCollection coll = parent.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection entry = model.getEntryEntity("entryentity");
                entry.clear();
                for (DynamicObject row : coll) {
                    DynamicObject newRow = entry.addNew();
                    newRow.set("account", row.get("account"));
                    newRow.set("dc", row.get("dc"));
                    newRow.set("assgrp", row.get("assgrp"));
                }
            }
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (!customParams.isEmpty()) {
            DynamicObject group = (DynamicObject)model.getValue("group");
            if (customParams.get("group") != null) {
                long itemid = Long.parseLong(String.valueOf(customParams.get("group")));
                if (group.getLong("id") != itemid) {
                    model.setValue("group", (Object)itemid);
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit acct = (BasedataEdit)this.getView().getControl("account");
        acct.addBeforeF7SelectListener(select -> {
            DynamicObject m = this.getModel().getDataEntity();
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            QFilter qids = AccountUtils.getAccountDataFilter((long)((Long)this.getModel().getValue(AccountRelation.getDyo_id((String)"createorg"))), (long)((Long)m.getDynamicObject("accounttable").getPkValue()));
            list.add(qids);
            list.add(new QFilter("accounttable", "=", m.getDynamicObject("accounttable").getPkValue()));
            list.add(new QFilter("iscash", "=", (Object)"0"));
            list.add(new QFilter("isbank", "=", (Object)"0"));
            list.add(new QFilter("iscashequivalent", "=", (Object)"0"));
            list.add(AccountType.buildNonBudgetFilter());
            showParam.getListFilterParameter().getQFilters().addAll(list);
        });
        GroupEdit group = (GroupEdit)this.getView().getControl("group");
        group.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            long orgId = this.getModel().getDataEntity().getLong(AccountRelation.getDyo_id((String)"createorg"));
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter qisleaf = new QFilter("isleaf", "=", (Object)"1");
            QFilter directionFilter = new QFilter("type", "!=", (Object)"1").or("direction", "!=", (Object)"b");
            showParam.getListFilterParameter().getQFilters().add(qids);
            showParam.getListFilterParameter().getQFilters().add(qisleaf);
            showParam.getListFilterParameter().getQFilters().add(directionFilter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("group".equals(key)) {
            DynamicObject newgroup = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldgroup = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newgroup == null || oldgroup == null || !newgroup.getString("type").equals(oldgroup.getString("type"))) {
                IDataModel model = this.getModel();
                model.beginInit();
                model.setValue("debitacct", null);
                model.setValue("creditacct", null);
                model.endInit();
                this.getView().updateView();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(key)) {
            IFormView view = this.getView();
            view.getParentView().updateView("billlistap");
            view.sendFormAction(view.getParentView());
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map data = e.getSourceData();
        this.prepareDataCache(data);
        this.getDataIdByNum();
        this.resetImportData(data);
    }

    private void prepareDataCache(Map<String, Object> data) {
        Map createorg = (Map)data.get("createorg");
        Map group = (Map)data.get("group");
        Map accounttable = (Map)data.get("accounttable");
        if (createorg == null || accounttable == null || group == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u5fc5\u987b\u5305\u542b\u521b\u5efa\u7ec4\u7ec7\u3001\u79d1\u76ee\u8868\u3001\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"PresetAccountEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (!(accounttable.containsKey("number") && createorg.containsKey("number") && group.containsKey("number"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f\u5bfc\u5165\u3002", (String)"PresetAccountEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        String orgNumber = (String)createorg.get("number");
        this.orgMap.put(orgNumber, 0L);
        String tablenumber = (String)accounttable.get("number");
        this.tableMap.put(tablenumber, 0L);
        Map tableMapOfOrg = this.acctMap.computeIfAbsent(orgNumber, k -> new HashMap());
        Map acctMapOfTable = tableMapOfOrg.computeIfAbsent(tablenumber, k -> new HashMap());
        JSONArray entry = (JSONArray)data.get("entryentity");
        String acctkey = "account";
        for (Object row : entry) {
            JSONObject rowData = (JSONObject)row;
            Map mulacctMap = (Map)rowData.get((Object)acctkey);
            if (mulacctMap == null) continue;
            String accts = String.valueOf(mulacctMap.get("number"));
            acctMapOfTable.put(accts, 0L);
        }
        String groupNum = (String)group.get("number");
        Map itemMapOfOrg = this.itemMap.computeIfAbsent(orgNumber, k -> new HashMap());
        itemMapOfOrg.put(groupNum, 0L);
        Map tableItemMapOfOrg = this.presetItemMap.computeIfAbsent(orgNumber, k -> new HashMap());
        Map presetItemMapOfTable = tableItemMapOfOrg.computeIfAbsent(tablenumber, k -> new HashMap());
        presetItemMapOfTable.put(groupNum, new PresetCashFlowItem());
    }

    private void getDataIdByNum() {
        Row row;
        try (DataSet tableDataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountList.table", (String)"bd_accounttable", (String)"id,number", (QFilter[])new QFilter("number", "in", this.tableMap.keySet()).toArray(), null);){
            while (tableDataSet.hasNext()) {
                row = tableDataSet.next();
                String tableNumber = row.getString("number");
                long tableId = row.getLong("id");
                this.tableMap.put(tableNumber, tableId);
            }
        }
        var2_2 = null;
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountList.org", (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", this.orgMap.keySet())}, null);){
            while (orgDataSet.hasNext()) {
                row = orgDataSet.next();
                String orgNumber = row.getString("number");
                long orgId = row.getLong("id");
                this.orgMap.put(orgNumber, orgId);
                Map<String, Map<String, Long>> tableMapOfOrg = this.acctMap.get(orgNumber);
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                for (Map.Entry<String, Map<String, Long>> entry : tableMapOfOrg.entrySet()) {
                    String tableNum = entry.getKey();
                    Map<String, Long> map = tableMapOfOrg.get(tableNum);
                    filters.clear();
                    filters.add(new QFilter("number", "in", map.keySet()));
                    DataSet acctDataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)this.tableMap.get(tableNum), (String)"id,number", filters);
                    Throwable throwable = null;
                    try {
                        while (acctDataSet.hasNext()) {
                            Row acctRow = acctDataSet.next();
                            String acctNum = acctRow.getString("number");
                            long id = acctRow.getLong("id");
                            map.put(acctNum, id);
                        }
                    }
                    catch (Throwable acctRow) {
                        throwable = acctRow;
                        throw acctRow;
                    }
                    finally {
                        if (acctDataSet == null) continue;
                        if (throwable != null) {
                            try {
                                acctDataSet.close();
                            }
                            catch (Throwable acctRow) {
                                throwable.addSuppressed(acctRow);
                            }
                            continue;
                        }
                        acctDataSet.close();
                    }
                }
                QFilter qitemids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
                Map<String, Long> itemMapOfTable = this.itemMap.get(orgNumber);
                DataSet itemDataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountList.cashflowitem", (String)"gl_cashflowitem", (String)"id,number", (QFilter[])new QFilter[]{qitemids, new QFilter("number", "in", itemMapOfTable.keySet())}, null);
                Object object = null;
                try {
                    while (itemDataSet.hasNext()) {
                        Row row2 = itemDataSet.next();
                        String itemNum = row2.getString("number");
                        long id = row2.getLong("id");
                        itemMapOfTable.put(itemNum, id);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (itemDataSet != null) {
                        if (object != null) {
                            try {
                                itemDataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            itemDataSet.close();
                        }
                    }
                }
                Map<String, Map<String, PresetCashFlowItem>> tableItemMapOfOrg = this.presetItemMap.get(orgNumber);
                for (Map.Entry entry : tableItemMapOfOrg.entrySet()) {
                    String tableNum = (String)entry.getKey();
                    Map<String, PresetCashFlowItem> presetItemMapOfTable = tableItemMapOfOrg.get(tableNum);
                    DataSet presetItemDataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountList.presetitem", (String)"gl_presetcashflowitem", (String)"id,group.number", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)orgId), new QFilter("accounttable", "=", (Object)this.tableMap.get(tableNum)), new QFilter("group.number", "in", presetItemMapOfTable.keySet())}, null);
                    Throwable throwable = null;
                    try {
                        while (presetItemDataSet.hasNext()) {
                            Row presetitemRow = presetItemDataSet.next();
                            String cashflowItemNum = presetitemRow.getString("group.number");
                            PresetCashFlowItem item = presetItemMapOfTable.get(cashflowItemNum);
                            if (item == null) {
                                item = new PresetCashFlowItem();
                                presetItemMapOfTable.put(cashflowItemNum, item);
                            }
                            if (item.getId() != 0L) continue;
                            item.setId(presetitemRow.getLong("id"));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (presetItemDataSet == null) continue;
                        if (throwable != null) {
                            try {
                                presetItemDataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        presetItemDataSet.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private void resetImportData(Map<String, Object> data) {
        PresetCashFlowItem item;
        Map<String, PresetCashFlowItem> presetItemMapOfTable;
        Map<String, Map<String, PresetCashFlowItem>> tableItemMapOfOrg;
        Map<String, Long> acctMapOfTable;
        Map<String, Map<String, Long>> acctMapOfOrg;
        long groupid;
        Map<String, Long> itemMapOfTable;
        Map createorg = (Map)data.get("createorg");
        Map group = (Map)data.get("group");
        Map accounttable = (Map)data.get("accounttable");
        String orgNum = (String)createorg.get("number");
        String tableNum = (String)accounttable.get("number");
        String groupNum = (String)group.get("number");
        if (this.orgMap.get(orgNum) != null) {
            createorg.put("id", this.orgMap.get(orgNum));
        }
        if (this.tableMap.get(tableNum) != null) {
            accounttable.put("id", this.tableMap.get(tableNum));
        }
        if ((itemMapOfTable = this.itemMap.get(orgNum)) != null && itemMapOfTable.get(groupNum) != null && (groupid = itemMapOfTable.get(groupNum).longValue()) != 0L) {
            group.put("id", groupid);
        }
        if ((acctMapOfOrg = this.acctMap.get(orgNum)) != null && (acctMapOfTable = acctMapOfOrg.get(tableNum)) != null) {
            JSONArray entry = (JSONArray)data.get("entryentity");
            String acctkey = "account";
            for (Object row : entry) {
                JSONObject rowData = (JSONObject)row;
                Map mulacctMap = (Map)rowData.get((Object)acctkey);
                if (mulacctMap == null) continue;
                String acctNum = String.valueOf(mulacctMap.get("number"));
                if (acctMapOfTable.get(acctNum) == null || acctMapOfTable.get(acctNum) <= 0L) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u79d1\u76ee\u672a\u627e\u5230\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u7ef4\u62a4\u3002", (String)"PresetAccountEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), acctNum));
                }
                long acctId = acctMapOfTable.get(acctNum);
                mulacctMap.put("id", acctId);
            }
        }
        if ((tableItemMapOfOrg = this.presetItemMap.get(orgNum)) != null && (presetItemMapOfTable = tableItemMapOfOrg.get(tableNum)) != null && presetItemMapOfTable.get(groupNum) != null && (item = presetItemMapOfTable.get(groupNum)) != null && item.getId() != 0L) {
            data.put("id", item.getId());
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
    }
}

