/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.CashflowItemUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.PresetCashItemUtilOfNoCache;

public class PresetAccountList
extends AbstractTreeListPlugin
implements BeforeFilterF7SelectListener {
    private static final String ACCOUNTTABLEID = "accounttableid";
    private static final String ROOTKEY = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String[] ACCTKEYS = new String[]{"debitacct", "creditacct"};
    private String selectedorg;
    private static final String ACCOUNTTABLE_ID = "accounttable.id";
    private static final String ACCOUNTTABLE_NUMBER = "accounttable.number";
    private static final String CREATEORG_ID = "createorg.id";

    public void initialize() {
        super.initialize();
        ((TreeListModel)this.getTreeListView().getTreeModel()).getQueryParas().put("order", "number");
    }

    public void initTreeToolbar(EventObject e) {
        GroupProp prop = this.getTreeListView().getTreeModel().getGroupProp();
        if (!(prop instanceof ParentBasedataProp)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"iscontainlower", "btnnew", "btnedit", "btndel"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String defaultAccTableId = null;
        FilterColumn accounttable = null;
        FilterColumn useorg = null;
        for (FilterColumn filterColumn : columnList) {
            if ("accounttable.name".equals(filterColumn.getFieldName())) {
                accounttable = filterColumn;
            }
            if (!"createorg.name".equals(filterColumn.getFieldName())) continue;
            useorg = filterColumn;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp() && accounttable != null) {
            String orgId;
            String entityType = listShowParameter.getBillFormId();
            IPageCache pageCache = this.getPageCache();
            String colString = pageCache.get("alluseorgs");
            List<Object> col = new ArrayList();
            if (colString == null) {
                col = this.getAllUseOrg(entityType);
                colString = SerializationUtils.toJsonString(col);
                pageCache.put("alluseorgs", colString);
            } else {
                col = SerializationUtils.fromJsonStringToList((String)colString, col.getClass());
            }
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.size());
            for (List list : col) {
                if (list == null) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(String.valueOf(list.get(1))));
                item.setValue(String.valueOf(list.get(0)));
                combos.add(item);
            }
            String defaultOrg = this.getDefaultUseOrg(col);
            long l = AccSysUtil.getDefaultOrgId((String)((ListView)this.getView()).getBillFormId(), (boolean)true, (PermissonType)PermissonType.VIEW);
            if (AccSysUtil.getAllOrgIdByComboItems(combos).contains(l)) {
                defaultOrg = String.valueOf(l);
            }
            if (StringUtils.isNotEmpty((String)(orgId = (String)listShowParameter.getCustomParam("imicdimension_bos_org")))) {
                defaultOrg = orgId;
            }
            if (useorg == null) {
                return;
            }
            ((CommonFilterColumn)useorg).setComboItems(combos);
            String createOrg = this.getPageCache().get("createOrg");
            if (StringUtils.isEmpty((String)createOrg)) {
                ((CommonFilterColumn)useorg).setDefaultValue(defaultOrg);
            } else {
                ((CommonFilterColumn)useorg).setDefaultValue(createOrg);
            }
            List orgids = useorg.getDefaultValues();
            if (!orgids.isEmpty()) {
                this.selectedorg = String.valueOf(orgids.get(0));
                this.getPageCache().put("createOrg", this.selectedorg);
                List<ComboItem> comboItems = this.getAccountTableComboItems(Long.parseLong(this.selectedorg));
                String lastTableid = this.getPageCache().get(ACCOUNTTABLEID);
                if (!comboItems.isEmpty()) {
                    CommonFilterColumn tableColumn = (CommonFilterColumn)accounttable;
                    tableColumn.setComboItems(comboItems);
                    String v = comboItems.get(0).getValue();
                    if (v != null) {
                        if (defaultAccTableId == null) {
                            String finalAccountTableId = lastTableid;
                            long count = comboItems.stream().filter(comboItem -> comboItem.getValue().equals(finalAccountTableId)).count();
                            defaultAccTableId = count > 0L ? finalAccountTableId : v;
                        }
                        tableColumn.setDefaultValue(defaultAccTableId);
                        this.getPageCache().put(ACCOUNTTABLEID, defaultAccTableId);
                    }
                }
                FilterContainer fgv = (FilterContainer)this.getControl("filtercontainerap");
                FilterKeyValueCollections fast = fgv.getCachedFilterValues().getFastFilterValues();
                if (lastTableid == null && (fast == null || fast != null && fast.getFilterValueCollection().isEmpty())) {
                    this.setTreeListFilter(orgids.get(0));
                }
            }
        }
    }

    private List<List<Object>> getAllUseOrg(String entityType) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = "gl";
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entity, (String)"47150e89000000ac");
        ArrayList<List<Object>> viewOrgIds = new ArrayList<List<Object>>();
        if (result == null) {
            return viewOrgIds;
        }
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        String orgFuncPro = "org.fisaccounting";
        QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)"1");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)"gl_cashflowitem");
        String view = null;
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)"1");
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, orgFuncFilter} : new QFilter[]{idsFilter, f2, f3, orgFuncFilter};
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])qfilters, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                ArrayList<Object> par = new ArrayList<Object>(2);
                par.add(row.getLong("org.id"));
                par.add(row.getString("org.name"));
                viewOrgIds.add(par);
            }
        }
        return viewOrgIds;
    }

    private String getDefaultUseOrg(List<List<Object>> col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(col.get(0).get(0));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (List<Object> obj : col) {
            if (longinOrg != Long.parseLong(String.valueOf(obj.get(0)))) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "createorg.id": {
                IPageCache pageCache = this.getPageCache();
                String colString = pageCache.get("alluseorgs");
                List<Object> col = new ArrayList();
                if (colString == null) {
                    ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                    String entityType = listShowParameter.getBillFormId();
                    col = this.getAllUseOrg(entityType);
                    colString = SerializationUtils.toJsonString(col);
                    pageCache.put("alluseorgs", colString);
                } else {
                    col = SerializationUtils.fromJsonStringToList((String)colString, col.getClass());
                }
                ArrayList<Long> viewOrgIds = new ArrayList<Long>(col.size());
                for (List list : col) {
                    if (list == null || list.get(0) == null) continue;
                    viewOrgIds.add(Long.valueOf(list.get(0).toString()));
                }
                if (viewOrgIds.isEmpty()) {
                    return;
                }
                QFilter idsFilter = new QFilter("id", "in", viewOrgIds);
                args.getQfilters().add(idsFilter);
                break;
            }
            case "accounttable.id": 
            case "accounttable.number": {
                Long l = Long.parseLong(this.getContainer().get("useorg").toString());
                List<ComboItem> tables = this.getAccountTableComboItems(l);
                ArrayList<Long> tableIds = new ArrayList<Long>(tables.size());
                for (ComboItem table : tables) {
                    tableIds.add(Long.valueOf(table.getValue()));
                }
                args.getQfilters().add(new QFilter("id", "in", tableIds));
                break;
            }
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Map<String, Object> selectedValues = this.getContainer();
        if (selectedValues.get("useorg") != null) {
            String orgid = String.valueOf(selectedValues.get("useorg"));
            this.getPageCache().put("createOrg", orgid);
            if (!this.selectedorg.equals(orgid)) {
                this.setTreeListFilter(orgid);
            }
        }
        if (selectedValues.get("accTableId") != null) {
            String accTableId = String.valueOf(selectedValues.get("accTableId"));
            this.getPageCache().put(ACCOUNTTABLEID, accTableId);
        }
    }

    private void setTreeListFilter(Object orgid) {
        ListView listView = (ListView)this.getView();
        TreeListView treeListView = (TreeListView)listView.getTreeListView();
        TreeListModel listModel = (TreeListModel)treeListView.getTreeModel();
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)Long.parseLong(String.valueOf(orgid)));
        QFilter qisPrefit = new QFilter("isprefit", "=", (Object)false);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(filter);
        qFilters.add(qisPrefit);
        listModel.setTreeFilter(qFilters);
        listModel.setCurrentNodeId((Object)ROOTKEY);
        treeListView.refreshTreeView();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qfs = e.getQFilters();
        ITreeModel treemodel = this.getTreeListView().getTreeModel();
        Object curNode = treemodel.getCurrentNodeId();
        ArrayList<Long> ids = new ArrayList<Long>();
        Map<String, Object> filtercontainerap = this.getContainer();
        Object curOrg = filtercontainerap.get("useorg");
        if (curOrg != null) {
            List<Long> porgids = PresetCashItemUtilOfNoCache.getAllSuperiorOrgIds(curOrg, true);
            HashMap info = new HashMap();
            List<Object> itemids = PresetCashItemUtilOfNoCache.getLeafNodes(curNode, porgids, curOrg);
            if (!itemids.isEmpty()) {
                for (int i = qfs.size(); i > 0; --i) {
                    QFilter qFilter = (QFilter)qfs.get(i - 1);
                    if (!"group".equals(qFilter.getProperty())) continue;
                    qfs.remove(i - 1);
                }
                qfs.add(new QFilter("group", "in", itemids));
                QFilter qorg = new QFilter("createorg", "in", porgids);
                String accTableIdStr = filtercontainerap.get("accTableId") == null ? "0" : filtercontainerap.get("accTableId").toString();
                QFilter qtable = new QFilter("accounttable", "=", (Object)Long.valueOf(accTableIdStr));
                QFilter qids = new QFilter("group", "in", itemids);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PersetAccountList", (String)"gl_presetcashflowitem", (String)"id,createorg,group.longnumber,group.id", (QFilter[])new QFilter[]{qorg, qtable, qids}, null);
                Object object = null;
                try {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        long id = row.getLong("id");
                        long orgId = row.getLong("createorg");
                        String longnumber = row.getString("group.longnumber");
                        long groupId = row.getLong("group.id");
                        ArrayList curOrgItemInfoList = (ArrayList)info.get(orgId);
                        if (curOrgItemInfoList == null) {
                            curOrgItemInfoList = new ArrayList();
                        }
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.put("id", id);
                        m.put("longnumber", longnumber);
                        m.put("groupId", groupId);
                        curOrgItemInfoList.add(m);
                        info.put(orgId, curOrgItemInfoList);
                        ids.add(id);
                    }
                }
                catch (Throwable row) {
                    object = row;
                    throw row;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)object).addSuppressed(row);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            HashSet<String> usedNumber = new HashSet<String>();
            ArrayList<Long> removeIds = new ArrayList<Long>();
            for (int i = porgids.size() - 1; i >= 0; --i) {
                Long orgid = porgids.get(i);
                List curOrgItemInfoList = (List)info.get(orgid);
                if (curOrgItemInfoList == null) continue;
                for (Map map : curOrgItemInfoList) {
                    String longnumber = String.valueOf(map.get("longnumber"));
                    if (usedNumber.contains(longnumber)) {
                        long id = (Long)map.get("id");
                        removeIds.add(id);
                        continue;
                    }
                    usedNumber.add(longnumber);
                }
            }
            ids.removeAll(removeIds);
            qfs.add(new QFilter("id", "in", ids));
        }
        for (int i = qfs.size(); i > 0; --i) {
            QFilter qFilter = (QFilter)qfs.get(i - 1);
            if (!CREATEORG_ID.equals(qFilter.getProperty())) continue;
            qfs.remove(i - 1);
        }
        e.setOrderBy("group.number,entryentity.account.number");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        Map<String, Object> selectedValues = this.getContainer();
        List filters = this.getTreeModel().getTreeFilter();
        filters.clear();
        if (selectedValues.get("useorg") != null) {
            String orgid = String.valueOf(selectedValues.get("useorg"));
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)Long.parseLong(orgid)));
            filters.add(new QFilter("enable", "=", (Object)"1"));
        } else if (this.selectedorg != null) {
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)Long.parseLong(this.selectedorg)));
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        TreeListModel treeListModel = (TreeListModel)e.getSource();
        TreeNode root = treeListModel.getRoot();
        TreeNode curNode = root.getTreeNode(String.valueOf(e.getNodeId()), 20);
        filters.add(new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate()));
        List<TreeNode> childNodes = CashflowItemUtil.getChildNodes(filters, curNode.getLongNumber(), curNode.getId());
        e.setChildNodes(childNodes);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        if (!"bos_org".equals(event.getRefEntityId())) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        event.setRefEntityId("bos_org");
        String entityType = listShowParameter.getBillFormId();
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)"gl_cashflowitem");
        Map map = EntityMetadataCache.getDataEntityType((String)entityType).getAllFields();
        OrgProp pro = (OrgProp)map.get("createorg");
        if (pro == null) {
            return;
        }
        if (ctrlview != null) {
            pro.setOrgFunc(ctrlview.getString("treetype"));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        Map map = parameter.getCustomParams();
        map.putAll(this.getContainer());
        parameter.setCustomParams(map);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("group_number".equals(fieldName)) {
            Object id = ((IListView)this.getView()).getFocusRowPkId();
            DynamicObject presetItem = QueryServiceHelper.queryOne((String)"gl_presetcashflowitem", (String)"group.masterid", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(id.toString())).toArray());
            Map<String, Object> container = this.getContainer();
            QFilterBuilder qFilterBuilder = new QFilterBuilder().add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)Long.parseLong(String.valueOf(container.get("useorg"))))).addEqual("masterid", (Object)presetItem.getLong("group.masterid")).addEqual("enddate", (Object)GLUtil.getEndDate());
            DynamicObject item = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,number,longnumber", (QFilter[])qFilterBuilder.toArray(new QFilter[0]));
            this.showPresetCashflowItemView(item);
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("delete".equals(keyName)) {
            operateInfo.getOption().setVariableValue("useorg", this.getPageCache().get("createOrg"));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObject[] presetitems;
                DynamicObjectCollection dyos = super.getData(start, limit);
                if (!dyos.isEmpty()) {
                    DataEntityPropertyCollection properties = ((DynamicObject)dyos.get(0)).getDynamicObjectType().getProperties();
                    properties.add((Object)new DynamicSimpleProperty("debitacctview", String.class, null));
                    properties.add((Object)new DynamicSimpleProperty("creditacctview", String.class, null));
                }
                HashMap<Long, DynamicObject> presetitemMap = new HashMap<Long, DynamicObject>();
                for (DynamicObject dyo : dyos) {
                    presetitemMap.put(dyo.getLong("id"), dyo);
                }
                for (DynamicObject item : presetitems = BusinessDataServiceHelper.load((String)"gl_presetcashflowitem", (String)"id,debitacct,creditacct", (QFilter[])new QFilter[]{new QFilter("id", "in", presetitemMap.keySet())}, (String)"id")) {
                    for (String key : ACCTKEYS) {
                        DynamicObjectCollection debitaccts = item.getDynamicObjectCollection(key);
                        StringBuilder str = new StringBuilder();
                        for (int i = 0; i < debitaccts.size(); ++i) {
                            DynamicObject mulacct = (DynamicObject)debitaccts.get(i);
                            DynamicObject acct = mulacct.getDynamicObject("fbasedataid");
                            String number = acct.getString("number");
                            String name = acct.getString("name");
                            if (i != 0) {
                                str.append(";");
                            }
                            str.append(number).append(" ").append(name);
                        }
                        long id = item.getLong("id");
                        ((DynamicObject)presetitemMap.get(id)).set(key + "view", (Object)str.toString());
                    }
                }
                return dyos;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private Map<String, Object> getContainer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ControlFilters filters = ((IListView)this.getView()).getControlFilters();
        if (filters != null) {
            List accTableIds;
            Object useorgId = null;
            Object accTableId = null;
            List useorgIds = filters.getFilter(CREATEORG_ID);
            if (useorgIds != null && !useorgIds.isEmpty()) {
                useorgId = useorgIds.get(0);
            }
            if (useorgId != null) {
                map.put("useorg", Long.valueOf(useorgId + ""));
            }
            if ((accTableIds = filters.getFilter(ACCOUNTTABLE_ID)) != null && !accTableIds.isEmpty()) {
                accTableId = accTableIds.get(0);
            }
            if (accTableId != null) {
                map.put("accTableId", Long.valueOf(accTableId + ""));
            }
        }
        return map;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "preset": {
                IFormView view = this.getView();
                HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"gl", (String)"gl_presetcashflowitem", (String)PermissonType.NEW.getPermId());
                if (!permOrgRs.hasAllOrgPerm() && !permOrgRs.getHasPermOrgs().contains(Long.parseLong(String.valueOf(this.getContainer().get("useorg"))))) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PresetAccountList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeView treeview = (TreeView)view.getControl("treeview");
                List itemids = treeview.getTreeState().getSelectedNodeId();
                if (itemids.isEmpty() || ROOTKEY.equals(itemids.get(0))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u8fdb\u884c\u9884\u8bbe\u3002", (String)"PresetAccountList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject item = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,number,isleaf,longnumber,direction,type", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf((String)itemids.get(0))).toArray());
                if (item == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PresetAccountList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!item.getBoolean("isleaf")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u8fdb\u884c\u9884\u8bbe\u3002", (String)"PresetAccountList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("1".equals(item.getString("type")) && "b".equals(item.getString("direction"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u65b9\u5411\u4e3a\u201c\u6d41\u5165\u6d41\u51fa\u201d\uff0c\u8bf7\u9009\u62e9\u5355\u65b9\u5411\u9879\u76ee\u3002", (String)"PresetAccountList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showPresetCashflowItemView(item);
                break;
            }
        }
    }

    private void showPresetCashflowItemView(DynamicObject item) {
        BaseShowParameter parame = new BaseShowParameter();
        parame.setFormId("gl_presetcashflowitem");
        Map<String, Object> container = this.getContainer();
        Long orgId = Long.parseLong(container.get("useorg").toString());
        Long accountTableId = Long.parseLong(container.get("accTableId").toString());
        QFilter qorg = new QFilter("createorg", "=", (Object)orgId);
        QFilter qtable = new QFilter("accounttable", "=", (Object)accountTableId);
        QFilter qgroup = new QFilter("group.number", "=", (Object)item.getString("number"));
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_presetcashflowitem", (QFilter[])new QFilter[]{qorg, qtable, qgroup}, null, (int)-1);
        String parentId = null;
        if (!ids.isEmpty()) {
            parame.setPkId(ids.get(0));
        } else {
            List<Object> parentIds = PresetCashItemUtilOfNoCache.getUsedPresetIds(orgId, accountTableId, item.getString("longnumber"));
            parentId = parentIds.isEmpty() ? null : parentIds.get(0).toString();
        }
        parame.getOpenStyle().setShowType(ShowType.Modal);
        parame.setCustomParam("group", (Object)item.getLong("id"));
        parame.setCustomParam("parent", (Object)parentId);
        Map map = parame.getCustomParams();
        map.putAll(container);
        this.getView().showForm((FormShowParameter)parame);
    }

    private List<ComboItem> getAccountTableComboItems(long orgId) {
        IPageCache cache = this.getPageCache();
        String value = cache.get(this.getTableComboItemKey(orgId));
        ArrayList<ComboItem> coms = new ArrayList();
        if (value == null) {
            List orgIds = BDUtil.getAllSuperiorOrgIds((Object)orgId, (boolean)true);
            if (!orgIds.isEmpty()) {
                QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
                QFilter enableFilter = new QFilter("enable", "=", (Object)true);
                try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter[]{orgFilter, enableFilter}, null);){
                    while (tableSet.hasNext()) {
                        Row row = tableSet.next();
                        ComboItem com = new ComboItem(new LocaleString(row.getString("name")), String.valueOf(row.getLong("id")));
                        coms.add(com);
                    }
                }
            }
            cache.put(this.getTableComboItemKey(orgId), SerializationUtils.serializeToBase64(coms));
        } else {
            coms = (List)SerializationUtils.deSerializeFromBase64((String)value);
        }
        return coms;
    }

    private String getTableComboItemKey(long orgId) {
        return String.format("TableComboItem+%d", orgId);
    }
}

