/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.ControlFilterUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class ReciprocalSchemeListPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final String ORG = "org";

    public void filterContainerInit(FilterContainerInitArgs args) {
        Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"useorg.id");
        List listFilterColumns = args.getCommonFilterColumns();
        block8: for (FilterColumn filterColumn : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "useorg.id": {
                    List comboItems = commFilter.getComboItems();
                    if (comboItems == null || comboItems.isEmpty()) break;
                    long bussOrg = AccSysUtil.getDefaultOrgId((String)((ListView)this.getView()).getBillFormId(), (boolean)true, (PermissonType)PermissonType.VIEW);
                    if (orgId != null) continue block8;
                    int i = 0;
                    for (ComboItem com : comboItems) {
                        if (Long.parseLong(com.getValue()) != bussOrg) continue;
                        ++i;
                        orgId = Long.parseLong(com.getValue());
                        break;
                    }
                    if (i == 0) {
                        orgId = Long.valueOf(((ComboItem)comboItems.get(0)).getValue());
                    }
                    commFilter.setDefaultValue(orgId + "");
                    this.getPageCache().put(ORG, orgId + "");
                    AccSysUtil.dealCacheOrgCustomFilter((FilterColumn)commFilter, (IPageCache)this.getPageCache());
                    break;
                }
                case "accounttable.number": {
                    List value;
                    Tuple<List<String>, List<ComboItem>> tupleComboItems;
                    String selectedOrg;
                    String deforgId = this.getPageCache().get(ORG);
                    String string = selectedOrg = orgId == null ? deforgId : String.valueOf(orgId);
                    if (!StringUtils.isNotEmpty((String)selectedOrg) || (tupleComboItems = this.getAccountTableComboItems(Long.parseLong(selectedOrg))) == null || ((List)tupleComboItems.item2).isEmpty()) break;
                    CommonFilterColumn tableColumn = (CommonFilterColumn)filterColumn;
                    tableColumn.setComboItems((List)tupleComboItems.item2);
                    ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
                    if (Objects.nonNull(controlFilters) && Objects.nonNull(controlFilters.getFilters().get("accounttable.id")) && Objects.nonNull(value = ((ControlFilter)controlFilters.getFilters().get("accounttable.id")).getValue()) && value.size() > 0 && ((List)tupleComboItems.item1).contains((String)value.get(0))) {
                        commFilter.setDefaultValue((String)value.get(0));
                        break;
                    }
                    commFilter.setDefaultValue(((ComboItem)((List)tupleComboItems.item2).get(0)).getValue());
                }
            }
        }
    }

    private Tuple<List<String>, List<ComboItem>> getAccountTableComboItems(long orgId) {
        IPageCache cache = this.getPageCache();
        String value = cache.get(ReciprocalSchemeListPlugin.getTableComboItemKey(orgId));
        Tuple coms = null;
        if (value == null) {
            List orgIds = GLUtil.getAllSuperiorOrgIdsOrderByLevel((long)orgId);
            if (!orgIds.isEmpty()) {
                try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter(ORG, "in", (Object)orgIds).toArray(), null);){
                    while (tableSet.hasNext()) {
                        Row row = tableSet.next();
                        String acctTableIdStr = String.valueOf(row.getLong("id"));
                        ComboItem com = new ComboItem(new LocaleString(row.getString("name")), acctTableIdStr);
                        if (coms == null) {
                            ArrayList<String> acctTableIds = new ArrayList<String>(16);
                            acctTableIds.add(acctTableIdStr);
                            ArrayList<ComboItem> acctTableValues = new ArrayList<ComboItem>(16);
                            acctTableValues.add(com);
                            coms = Tuple.create(acctTableIds, acctTableValues);
                            continue;
                        }
                        ((List)coms.item1).add(acctTableIdStr);
                        ((List)coms.item2).add(com);
                    }
                }
            }
            cache.put(ReciprocalSchemeListPlugin.getTableComboItemKey(orgId), SerializationUtils.serializeToBase64((Object)coms));
        } else {
            coms = (Tuple)SerializationUtils.deSerializeFromBase64((String)value);
        }
        return coms;
    }

    private static String getTableComboItemKey(long orgId) {
        return String.format("TableComboItem+%d", orgId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus()) {
            Object tableId;
            BillShowParameter showParam = e.getParameter();
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            FilterContainer fgv = (FilterContainer)this.getControl("filtercontainerap");
            Map selectedValues = fgv.getSelectedValues();
            String orgid = this.getPageCache().get(ORG);
            if (orgid == null) {
                Long defOrgId = GLUtil.getFilterInitDefOrgId((IPageCache)this.getPageCache(), (String)"gl_reciprocal_scheme");
                if (defOrgId != null && !defOrgId.equals(0L)) {
                    orgid = defOrgId + "";
                } else {
                    List orgList = AccSysUtil.getAcctOrgPkList((String)"gl_reciprocal_scheme", (boolean)Boolean.TRUE, (PermissonType)PermissonType.VIEW);
                    if (orgList == null || orgList.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"ReciprocalSchemeListPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                    Long orgId = RequestContext.get().getOrgId();
                    orgid = orgList.contains(orgId) ? orgId + "" : orgList.get(0) + "";
                }
            }
            if ((tableId = selectedValues.get("accounttable.id")) == null) {
                tableId = ControlFilterUtil.getCustomFilterId("accounttable.id", (FilterContainer)this.getControl("filtercontainerap"));
            }
            if (tableId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"ReciprocalSchemeListPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            showParam.setCustomParam("accounttable", tableId);
            showParam.setCustomParam(ORG, (Object)orgid);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String orgid = args.getFilterValue("useorg.id") + "";
        if (orgid != null && !"null".equals(orgid)) {
            this.getPageCache().put(ORG, orgid + "");
        }
    }
}

