/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.enums.GLBillParamEnum;

public class ReperiodclosepopupPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BTN_CANCLE = "canclebtn";
    private static final String BTN_OK = "okbtn";
    private static final int DESC = 2;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CANCLE, BTN_OK});
        super.registerListener(e);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map map = parameter.getCustomParams();
        Object bizapp = map.get("appid");
        if ("gl".equalsIgnoreCase(bizapp.toString()) && GLBillParamEnum.OPEN_PERIOD.getBooleanValue()) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("ismul", Boolean.TRUE);
            this.getView().updateControlMetadata("billlistap", params);
            BillList list = (BillList)this.getControl("billlistap");
            list.setMulti(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map map = parameter.getCustomParams();
        Object periodtype = map.get("periodtype");
        List orglist = (List)SerializationUtils.fromJsonString((String)(map.get("orglist") + ""), List.class);
        QFilter orgQ = new QFilter("org", "in", (Object)orglist);
        QFilter f = new QFilter("periodtype", "=", periodtype);
        if (map.get("booktypefield") != null && !StringUtils.isBlank((String)(map.get("booktypefield") + ""))) {
            orgQ.and(new QFilter(map.get("booktypefield") + "", "=", (Object)Long.parseLong(map.get("booktype").toString())));
        }
        Object bizapp = map.get("appid");
        DynamicObjectCollection books = QueryServiceHelper.query((String)(map.get("entityname") + ""), (String)this.getSelect(bizapp + ""), (QFilter[])new QFilter[]{orgQ, f});
        ArrayList<Long> periodid = new ArrayList<Long>();
        for (DynamicObject book : books) {
            periodid.add(book.getLong("curperiod"));
            if (!this.isFaOrGL(bizapp)) continue;
            periodid.add(book.getLong("startperiod"));
        }
        Collections.sort(periodid);
        if (bizapp != null && !"gl".equalsIgnoreCase(bizapp.toString())) {
            f.and(new QFilter("isadjustperiod", "=", (Object)"0"));
        }
        if (periodid.isEmpty()) {
            f.and(new QFilter("1", "!=", (Object)"1", true));
        } else {
            if (this.isFaOrGL(bizapp)) {
                f.and(new QFilter("id", ">=", periodid.get(0)));
            }
            f.and(new QFilter("id", "<", periodid.get(periodid.size() - 1)));
        }
        BillList list = (BillList)this.getControl("billlistap");
        FilterParameter filter = new FilterParameter();
        filter.setFilter(f);
        list.setFilterParameter(filter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        if (btn.getKey().equals(BTN_OK)) {
            BillList billList = (BillList)this.getControl("billlistap");
            int[] selectRows = billList.getEntryState().getSelectedRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53cd\u7ed3\u8d26\u7684\u671f\u95f4\u3002", (String)"ReperiodclosepopupPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] periodIds = billList.getSelectedRows().getPrimaryKeyValues();
            HashMap<String, List> retrunData = new HashMap<String, List>();
            retrunData.put("periodIds", Stream.of(periodIds).collect(Collectors.toList()));
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map map = parameter.getCustomParams();
            List rowIndxs = (List)SerializationUtils.fromJsonString((String)(map.get("rowIndxs") + ""), List.class);
            retrunData.put("rowIndxs", rowIndxs);
            this.getView().returnDataToParent(retrunData);
            this.getView().close();
        }
    }

    private String getSelect(String appId) {
        String select = "curperiod";
        switch (appId) {
            case "gl": 
            case "fa": {
                return select + "," + "startperiod";
            }
        }
        return select;
    }

    private boolean isFaOrGL(Object appId) {
        return "fa".equals(appId) || "gl".equals(appId);
    }
}

