/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OCR;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.OCREvent;
import kd.bos.form.control.events.OCRListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryCollection;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.util.GenVoucherFromInvoiceUtils;

public class ScanAndOCRPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(ScanAndOCRPlugin.class);
    private static String GIFURL = "/images/pc/other/ying_xiang_GIF.gif";
    private static String PNGURL = "/images/pc/other/ying_xiang.png";
    private static final String CARDENTRY = "entryentity";
    private static final String VOUCHERENTRY = "subentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vdescription"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String Key2 = control.getKey();
        if ("vdescription".equals(Key2)) {
            FormShowParameter parameEdit = new FormShowParameter();
            parameEdit.setCustomParam("orgid", this.getModel().getValue("org_id"));
            this.showForm("gl_voucherabstract_list", ShowType.Modal, parameEdit, new CloseCallBack((IFormPlugin)this, "voucherabstract"));
        }
    }

    private void showForm(String formKey, ShowType t, FormShowParameter param, CloseCallBack back) {
        param.setFormId(formKey);
        param.getOpenStyle().setShowType(t);
        param.setCloseCallBack(back);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object result = closedCallBackEvent.getReturnData();
        if (result == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "voucherabstract": {
                if (!(result instanceof Long)) break;
                Long id = (Long)result;
                DynamicObject vabstract = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gl_voucherabstract", (String)"abstract");
                int curIndex = this.getModel().getEntryCurrentRowIndex(VOUCHERENTRY);
                this.getModel().setValue("vdescription", (Object)vabstract.getString("abstract"), curIndex);
                break;
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        final EntryGrid grid = (EntryGrid)this.getView().getControl(CARDENTRY);
        grid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                int[] indexlist = grid.getEntryState().getSelectedRows();
                if (indexlist.length <= 0) {
                    return;
                }
                ScanAndOCRPlugin.this.showPicture(indexlist[0]);
            }
        });
        OCR cor = (OCR)this.getControl("ocr");
        cor.addOCRListener(new OCRListener(){

            public void processOCR(OCREvent evt) {
                Map data = evt.getData();
                int index = ScanAndOCRPlugin.this.genList(data, evt.getPicKey());
                log.info("evt.getPicKey():" + evt.getPicKey());
                if (index == -1) {
                    log.info("\u751f\u6210\u5de6\u4fa7\u5361\u7968\u5217\u8868\u5931\u8d25");
                    return;
                }
                ScanAndOCRPlugin.this.genVoucher(data, index);
                ScanAndOCRPlugin.this.defaultShow();
                ScanAndOCRPlugin.this.scanNumShow(true);
            }

            public void notifyMsg(int status, String msg) {
            }

            public void finishOCR() {
                log.info("\u5df2\u63a5\u6536\u5230finishOCR");
                ScanAndOCRPlugin.this.gifProcessing(PNGURL);
            }
        });
    }

    protected void genVoucher(Map<String, String> data, int parentIndex) {
        FormShowParameter formshow = this.getView().getFormShowParameter();
        if (formshow.getCustomParam("templateId") == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6a21\u5f0f\u51ed\u8bc1\u4e3a\u7a7a\u3002", (String)"ScanAndOCRPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        long id = (Long)formshow.getCustomParam("templateId");
        GenVoucherFromInvoiceUtils utils = new GenVoucherFromInvoiceUtils();
        VoucherInfo vou = utils.buildVoucher(data, id);
        IDataModel m = this.getModel();
        m.setValue("description", (Object)vou.getDesc(), parentIndex);
        VoucherEntryCollection entries = vou.getEntries();
        int i = 0;
        m.setEntryCurrentRowIndex(CARDENTRY, parentIndex);
        m.deleteEntryData(VOUCHERENTRY);
        for (VoucherEntryInfo entry : entries) {
            m.createNewEntryRow(VOUCHERENTRY);
            m.setValue("vdescription", (Object)entry.getDesc(), i, parentIndex);
            m.setValue("account", (Object)entry.getAccount(), i, parentIndex);
            m.setValue("assgrp", (Object)entry.getAssgrp(), i, parentIndex);
            m.setValue("debitlocal", (Object)entry.getDebLoc(), i, parentIndex);
            m.setValue("creditlocal", (Object)entry.getCreLoc(), i, parentIndex);
            ++i;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"ocrflex"});
        FormShowParameter formshow = this.getView().getFormShowParameter();
        if (formshow.getCustomParam("templateId") != null) {
            long bookstype;
            IDataModel model = this.getModel();
            long id = Long.parseLong(formshow.getCustomParam("templateId").toString());
            long orgId = Long.parseLong(formshow.getCustomParam("orgId").toString());
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookstype = Long.parseLong(formshow.getCustomParam("bookstype").toString())));
            if (book != null) {
                long currency = book.getBaseCurrencyId();
                model.setValue("currency", (Object)currency);
            }
            model.setValue("vouchertemplate", (Object)id);
            model.setValue("org", (Object)orgId);
            model.setValue("booktype", (Object)bookstype);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        ScanAndOCRPlugin.cleanOCRNumber(this.getPageCache());
        this.gifProcessing(GIFURL);
        OCR cor = (OCR)this.getControl("ocr");
        cor.scanAndOCR();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        ScanAndOCRPlugin.subOCRNumber(this.getPageCache());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(VOUCHERENTRY);
        model.createNewEntryRow(VOUCHERENTRY);
        model.createNewEntryRow(VOUCHERENTRY);
        this.defaultShow();
        this.scanNumShow(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btnocr")) {
            this.getPageCache().remove("index");
            this.scanNumShow(false);
            ScanAndOCRPlugin.cleanOCRNumber(this.getPageCache());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CARDENTRY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ocrflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultleft"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultright"});
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(CARDENTRY);
            model.deleteEntryData(VOUCHERENTRY);
            this.gifProcessing(GIFURL);
            OCR cor = (OCR)this.getControl("ocr");
            cor.scanAndOCR();
        } else if ("save".equals(itemKey)) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(VOUCHERENTRY);
            if (count <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u6570\u636e\u3002", (String)"ScanAndOCRPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.hasSetCoderule("A")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u51ed\u8bc1\u6682\u5b58\u72b6\u6001\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u5148\u7ef4\u62a4\u7f16\u7801\u89c4\u5219\u3002", (String)"ScanAndOCRPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveVoucher(model);
        }
    }

    private boolean hasSetCoderule(String billStatus) {
        QFilter fenable = new QFilter("enable", "=", (Object)"1");
        QFilter fbizobjectid = new QFilter("bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro = new QFilter("conditionentry.property.bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro1 = new QFilter("conditionentry.property.number", "=", (Object)"billstatus");
        QFilter fvalue = new QFilter("conditionentry.propertyvalue.value", "=", (Object)billStatus);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_coderule", (String)"id", (QFilter[])new QFilter[]{fenable, fbizobjectid, fpro, fpro1, fvalue});
        return col != null && !col.isEmpty();
    }

    private void saveVoucher(IDataModel model) {
        DynamicObjectCollection entries = model.getEntryEntity(CARDENTRY);
        FormShowParameter formshow = this.getView().getFormShowParameter();
        long templateId = Long.parseLong(formshow.getCustomParam("templateId").toString());
        GenVoucherFromInvoiceUtils util = new GenVoucherFromInvoiceUtils();
        DynamicObject templateObj = util.getVoucherTemplate(templateId);
        DynamicObject vou = null;
        int count = entries.size();
        DynamicObject[] objs = new DynamicObject[count];
        long[] ids = DBServiceHelper.genLongIds((String)"t_gl_voucher", (int)count);
        for (int i = 0; i < count; ++i) {
            long vouid = (Long)model.getValue("vouid", i);
            if (vouid != 0L) {
                vou = BusinessDataServiceHelper.loadSingle((Object)vouid, (String)"gl_voucher");
            } else {
                vou = util.buildVoucher(templateObj).toDynamicObject();
                vou.set("id", (Object)ids[i]);
                vou.set("description", model.getValue("description", i));
            }
            model.setEntryCurrentRowIndex(CARDENTRY, i);
            DynamicObjectCollection vouEntry = vou.getDynamicObjectCollection("entries");
            int subEntrySize = model.getEntryRowCount(VOUCHERENTRY);
            for (int j = 0; j < subEntrySize; ++j) {
                ((DynamicObject)vouEntry.get(j)).set("edescription", model.getValue("vdescription", j));
                ((DynamicObject)vouEntry.get(j)).set("assgrp", model.getValue("assgrp", j));
                ((DynamicObject)vouEntry.get(j)).set("account", model.getValue("account", j));
                ((DynamicObject)vouEntry.get(j)).set("debitlocal", model.getValue("debitlocal", j));
                ((DynamicObject)vouEntry.get(j)).set("creditlocal", model.getValue("creditlocal", j));
                ((DynamicObject)vouEntry.get(j)).set("debitori", model.getValue("debitlocal", j));
                ((DynamicObject)vouEntry.get(j)).set("creditori", model.getValue("creditlocal", j));
            }
            objs[i] = vou;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (DynamicObject[])objs, (OperateOption)OperateOption.create());
        List list = operationResult.getSuccessPkIds();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            Object id = objs[i].get("id");
            if (!list.contains(id)) continue;
            model.setValue("vouid", (Object)objs[i].getLong("id"), i);
        }
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ScanAndOCRPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private int genList(Map<String, String> data, String picKey) {
        try {
            if (new BigDecimal(data.get(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"ScanAndOCRPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]))).compareTo(BigDecimal.ZERO) == 0) {
                return -1;
            }
        }
        catch (NumberFormatException e) {
            log.error("\u4ef7\u7a0e\u5408\u8ba1\u683c\u5f0f\u5316\u9519\u8bef\u3002\u4ef7\u7a0e\u5408\u8ba1:" + data.get("\u4ef7\u7a0e\u5408\u8ba1"));
            return -1;
        }
        catch (Exception e) {
            log.error("\u4ef7\u7a0e\u5408\u8ba1\u683c\u5f0f\u5316\u9519\u8bef\u3002\u4ef7\u7a0e\u5408\u8ba1:" + data.get("\u4ef7\u7a0e\u5408\u8ba1"));
            return -1;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowIndex = model.createNewEntryRow(CARDENTRY);
        model.setValue("card_invoicenumber", (Object)data.get(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"ScanAndOCRPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0])), rowIndex);
        model.setValue("card_companysale", (Object)data.get(ResManager.loadKDString((String)"\u9500\u65b9\u4f01\u4e1a\u540d\u79f0", (String)"ScanAndOCRPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0])), rowIndex);
        model.setValue("card_amounttax", (Object)("\uffe5" + data.get(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"ScanAndOCRPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]))), rowIndex);
        model.setValue("card_invoicecode", (Object)data.get(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"ScanAndOCRPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0])), rowIndex);
        model.setValue("card_picurl", (Object)picKey, rowIndex);
        log.info("put-pic:" + picKey + "  rowIndex:" + rowIndex);
        int rowcount = ScanAndOCRPlugin.addOCRNumber(this.getPageCache());
        return rowcount - 1;
    }

    private void showPicture(int index) {
        String picurl = (String)this.getModel().getValue("card_picurl", index);
        OCR cor = (OCR)this.getControl("ocr");
        cor.loadPicture(picurl);
    }

    private void gifProcessing(String url) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("scangif", "setBackgroundImg", new Object[]{url});
    }

    private void defaultShow() {
        int rowcount = ScanAndOCRPlugin.getOCRNumber(this.getPageCache());
        if (rowcount > 0) {
            this.showPicture(rowcount - 1);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CARDENTRY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ocrflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultleft"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultright"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CARDENTRY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ocrflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultleft"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultright"});
        }
    }

    private void scanNumShow(boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"scannumflex"});
        Label statusLab = (Label)this.getControl("scannum");
        int rowcount = ScanAndOCRPlugin.getOCRNumber(this.getPageCache());
        statusLab.setText(String.valueOf(rowcount));
    }

    private static synchronized int addOCRNumber(IPageCache pageCache) {
        String OCRNumber = pageCache.get("OCRNumber");
        if (OCRNumber == null) {
            pageCache.put("OCRNumber", "1");
            return 1;
        }
        int num = Integer.parseInt(OCRNumber) + 1;
        pageCache.put("OCRNumber", String.valueOf(num));
        return num;
    }

    private static synchronized int subOCRNumber(IPageCache pageCache) {
        String OCRNumber = pageCache.get("OCRNumber");
        if (OCRNumber == null) {
            return 0;
        }
        int num = Integer.parseInt(OCRNumber) - 1;
        pageCache.put("OCRNumber", String.valueOf(num));
        return num;
    }

    private static synchronized int getOCRNumber(IPageCache pageCache) {
        String OCRNumber = pageCache.get("OCRNumber");
        if (OCRNumber == null) {
            return 0;
        }
        return Integer.parseInt(OCRNumber);
    }

    private static synchronized void cleanOCRNumber(IPageCache pageCache) {
        pageCache.remove("OCRNumber");
    }
}

