/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.basedata.AssistantDataDetailConstant;
import kd.fi.gl.constant.basedata.AsstactTypeConstant;
import kd.fi.gl.constant.basedata.BaseDataConstant;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.enums.PlanType;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.finalprocess.constant.VoucherAmortConstant;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntity;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocess.service.impl.VchAmortService;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.formplugin.finalprocess.FPAssgrpDescLengthConfig;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLFabulousOperation;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.TaxReportFormHelper;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public class VoucherAmortSchemeEdit
extends AbstractBillPlugIn
implements ClickListener {
    private boolean isDataChanged = true;
    private BigDecimal oneHundred = new BigDecimal(100);
    private static final Log logger = LogFactory.getLog(VoucherAmortSchemeEdit.class);
    private static final String DEST_ASSIST_SUFFIX = "dest";

    public void initialize() {
        super.initialize();
        this.setPeriodFilter();
        this.setControlFilter();
        this.putDestTypeCash(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"thumbimg", "addpolicie", "targetassgrp", "destassgrp"});
        BasedataEdit book = (BasedataEdit)this.getControl("accountbooks");
        book.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            long orgId = (Long)this.getModel().getValue("org_id");
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
            ArrayList<Object> booktypeIds = new ArrayList<Object>();
            for (DynamicObject b : books) {
                booktypeIds.add(b.get("bookstype"));
            }
            showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", booktypeIds));
        });
        BasedataEdit vtEdit = (BasedataEdit)this.getView().getControl("vouchertype");
        vtEdit.addBeforeF7SelectListener(evt -> {
            long orgId = (Long)this.getModel().getValue("org_id");
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            QFilter vtFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId);
            showParam.getListFilterParameter().getQFilters().add(vtFilter);
        });
        BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("startperiod");
        this.filterPeriod(periodEdit);
        this.accountFilter("targetaccount");
        this.accountFilter("destaccount");
        this.currencyFilter("destcurrency", "destaccount");
        this.currencyFilter("targetcurrency", "targetaccount");
        BasedataEdit cperiod = (BasedataEdit)this.getView().getControl("cperiod");
        this.filterPeriod(cperiod);
    }

    private void filterPeriod(BasedataEdit periodEdit) {
        periodEdit.addBeforeF7SelectListener(evt -> {
            long orgId = (Long)this.getModel().getValue("org_id");
            long bookTypeId = (Long)this.getModel().getValue("accountbooks_id");
            if (orgId == 0L || bookTypeId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u548c\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"VoucherAmortSchemeEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
            long curPeriodId = bookInfo.getCurPeriodId();
            long periodTypeId = bookInfo.getPeriodTypeId();
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            QFilter curFilter = new QFilter("id", ">=", (Object)curPeriodId);
            QFilter typeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(curFilter);
            list.add(typeFilter);
            showParam.getListFilterParameter().getQFilters().addAll(list);
        });
    }

    private void currencyFilter(String currency, String account) {
        BasedataEdit destCurEdit = (BasedataEdit)this.getControl(currency);
        destCurEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue(account, evt.getRow());
            if (accoutDyn != null) {
                ArrayList<Long> ids = new ArrayList<Long>();
                if ("descurrency".equals(accoutDyn.get("acctcurrency"))) {
                    DynamicObjectCollection coll = (DynamicObjectCollection)accoutDyn.get("currencyentry");
                    for (DynamicObject dyn : coll) {
                        Long acctCur = dyn.getLong("currency_id");
                        ids.add(acctCur);
                    }
                    QFilter filter = new QFilter("id", "in", ids);
                    List list = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
                    list.add(filter);
                }
            }
        });
    }

    private void accountFilter(String accKey) {
        BasedataEdit accountEdit = (BasedataEdit)this.getControl(accKey);
        accountEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject orgDb = (DynamicObject)this.getModel().getValue("org");
            DynamicObject bookDb = (DynamicObject)this.getModel().getValue("accountbooks");
            this.checkOrg(orgDb);
            this.checkBook(bookDb);
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)((Long)orgDb.getPkValue()), (long)((Long)bookDb.getPkValue()));
            long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)((Long)orgDb.getPkValue()), (long)((Long)bookDb.getPkValue()), (long)bookInfo.getCurPeriodId());
            QFilter qFilter = new QFilter("accounttableid", "=", (Object)accountTableId);
            qFilter.and(new QFilter("accounttype", "in", (Object)AccountType.FINANCIAL_ACCOUNT));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".accountFilter"), (String)"bd_accounttype", (String)"id", (QFilter[])qFilter.toArray(), null);
            ArrayList<Object> accountTypeIds = new ArrayList<Object>();
            for (Row row : dataSet) {
                accountTypeIds.add(row.get("id"));
            }
            QFilter filter = new QFilter("accounttype", "in", accountTypeIds);
            List list = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            list.add(filter);
        });
    }

    private void checkOrg(DynamicObject orgDb) {
        if (orgDb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TransPLProgramsEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkBook(DynamicObject bookDb) {
        if (bookDb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TransPLProgramsEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("plantype".equals(actionId) && evt.getReturnData() != null) {
            ListSelectedRowCollection lstRow = (ListSelectedRowCollection)evt.getReturnData();
            List vchIds = lstRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            EntryGrid grid = (EntryGrid)this.getView().getControl("targetaccounts");
            int[] rowIndex = grid.getSelectRows();
            this.removeDetailEntry(rowIndex[0]);
            if (rowIndex.length > 0) {
                DynamicObject accDyn = (DynamicObject)this.getModel().getValue("targetaccount", rowIndex[0]);
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add("entries.account.masterid", "=", (Object)accDyn.getLong("masterid")).add("id", "in", vchIds);
                GlFormUtil.getAssgrpsByRowid((String)this.getModel().getValue("targetrowid", rowIndex[0]), this.getPageCache()).ifPresent(assgrpIds -> qfBuilder.add("entries.assgrp.id", "in", assgrpIds));
                qfBuilder.add("entries.currency.id", "=", this.getModel().getValue("targetcurrency_id", rowIndex[0]));
                StringBuilder selectFields = new StringBuilder("entries.account.dc, entries.account.id,entries.debitlocal,entries.creditlocal,entries.debitori,entries.creditori,entries.assgrp");
                long comAssistCount = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(k -> k.startsWith("detailcomassist")).count();
                int i = 1;
                while ((long)i <= comAssistCount) {
                    selectFields.append(",entries.").append(CommonAssistUtil.getComassistField((int)i)).append(".id");
                    ++i;
                }
                DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_voucher", (String)selectFields.toString(), (QFilter[])qfBuilder.toArray());
                BigDecimal debitOriSum = BigDecimal.ZERO;
                BigDecimal debitLocSum = BigDecimal.ZERO;
                String plandirection = this.getModel().getValue("plandirection").toString();
                for (DynamicObject row : query) {
                    BigDecimal debitOri = row.getBigDecimal(String.join((CharSequence)".", "entries", "debitori")).subtract(row.getBigDecimal(String.join((CharSequence)".", "entries", "creditori")));
                    BigDecimal debitLoc = row.getBigDecimal(String.join((CharSequence)".", "entries", "debitlocal")).subtract(row.getBigDecimal(String.join((CharSequence)".", "entries", "creditlocal")));
                    if ("1".equals(plandirection)) {
                        debitOri = debitOri.negate();
                        debitLoc = debitLoc.negate();
                    }
                    HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
                    int i2 = 1;
                    while ((long)i2 <= comAssistCount) {
                        comAssistMap.put(i2, row.getLong("entries.comassist" + i2 + ".id"));
                        ++i2;
                    }
                    this.createDetailEntry(rowIndex[0], row.getLong("entries.account.id"), row.getLong("entries.assgrp"), debitOri, debitLoc, comAssistMap);
                    debitOriSum = debitOriSum.add(debitOri);
                    debitLocSum = debitLocSum.add(debitLoc);
                }
                this.getModel().setValue("planamount", (Object)debitOriSum, rowIndex[0]);
                this.getModel().setValue("targetlocal", (Object)debitLocSum, rowIndex[0]);
                if (debitOriSum.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue("rate", (Object)debitLocSum.divide(debitOriSum, 4, RoundingMode.HALF_UP), rowIndex[0]);
                }
            }
            return;
        }
        if (evt.getReturnData() != null) {
            Map resultMap = (Map)evt.getReturnData();
            if (resultMap.get("value") != null) {
                String expression = (String)resultMap.get("express");
                String strObj = (String)resultMap.get("value");
                String type = (String)resultMap.get("type");
                String indexStr = (String)resultMap.get("index");
                int index = 0;
                if (StringUtils.isBlank((CharSequence)indexStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u8868\u8fbe\u5f0f\u3002", (String)"VoucherAmortSchemeEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                index = Integer.parseInt(indexStr);
                String columnKey = (String)resultMap.get("assgrprow");
                if (expression.length() > 100) {
                    expression = expression.substring(0, 100) + "...";
                }
                this.getPageCache().remove(columnKey);
                this.getPageCache().put(columnKey, strObj);
                this.getModel().setValue(type.replace("accounts", "assgrp"), (Object)expression, index);
            }
        } else if ("voucherback".equals(actionId)) {
            this.updateModel();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isDataChanged) {
            return;
        }
        super.propertyChanged(e);
        IDataModel m = this.getModel();
        ChangeData changData = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        int rowIndex = changData.getRowIndex();
        String amortStyleVal = (String)this.getModel().getValue("amortstyle");
        boolean isCustomAmortStyle = AmortStyle.isCustome((String)amortStyleVal);
        switch (key) {
            case "org": {
                DynamicObject newValue = (DynamicObject)changData.getNewValue();
                if (newValue == null) break;
                long orgId = newValue.getLong("id");
                this.setDefaultValue(orgId);
                break;
            }
            case "planamount": {
                logger.info("TARGET_ORI in: ");
                BigDecimal newVal = (BigDecimal)changData.getNewValue();
                BigDecimal oldVal = (BigDecimal)changData.getOldValue();
                BigDecimal oldLocAmt = (BigDecimal)m.getValue("targetlocal", rowIndex);
                BigDecimal rate = (BigDecimal)m.getValue("rate", rowIndex);
                BigDecimal newLocAmt = newVal.multiply(rate).setScale(oldLocAmt.scale(), RoundingMode.HALF_UP);
                m.beginInit();
                m.setValue("targetlocal", (Object)newLocAmt, rowIndex);
                m.endInit();
                if (!this.checkTargetAmountValidity(isCustomAmortStyle)) {
                    this.initModelValue("targetlocal", oldLocAmt, rowIndex);
                    this.initModelValue("planamount", oldVal, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u644a\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u644a\u9500\u91d1\u989d\u3002", (String)"VoucherAmortSchemeEdit_37", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    break;
                }
                m.beginInit();
                m.setValue("targetlocal", (Object)oldLocAmt, rowIndex);
                m.endInit();
                this.changeTargetLocalByTargetAmount(newVal, rowIndex);
                break;
            }
            case "targetcurrency": {
                DynamicObject newVal = (DynamicObject)changData.getNewValue();
                DynamicObject oldVal = (DynamicObject)changData.getOldValue();
                if (newVal == null) {
                    this.rollBackValue("targetcurrency", oldVal, rowIndex, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5f85\u644a\u79d1\u76ee\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherAmortSchemeEdit_84", (String)"fi-gl-formplugin", (Object[])new Object[0]), rowIndex + 1));
                    return;
                }
                long newId = newVal.getLong("id");
                long oldId = oldVal == null ? 0L : oldVal.getLong("id");
                this.setRate(rowIndex);
                this.changeTargetAmountByTargetCurrency(oldId, newId, rowIndex);
                this.plantype(rowIndex, true);
                this.setCCurrency();
                this.updateCustomPoliciesView();
                break;
            }
            case "destcurrency": {
                this.changeDestAmountByCurrencyOrRaio(rowIndex);
                break;
            }
            case "targetlocal": {
                BigDecimal newVal = (BigDecimal)changData.getNewValue();
                BigDecimal oldVal = (BigDecimal)changData.getOldValue();
                newVal = newVal == null ? BigDecimal.ZERO : newVal;
                oldVal = oldVal == null ? BigDecimal.ZERO : oldVal;
                IDataModel model = this.getModel();
                BigDecimal total = (BigDecimal)model.getValue("totalamount");
                total = total == null ? BigDecimal.ZERO : total;
                model.setValue("totalamount", (Object)newVal.subtract(oldVal).add(total));
                break;
            }
            case "destratio": {
                this.policiesRatioChange(changData, "destratio", "destaccounts");
                this.changeDestAmountByCurrencyOrRaio(rowIndex);
                break;
            }
            case "totalamount": {
                this.changePeriodAmortAmount();
                this.setCurAmortAmount();
                this.averPoliciesRatio();
                break;
            }
            case "planperiod": {
                BigDecimal newVal = (BigDecimal)changData.getNewValue();
                if (newVal == null) break;
                int intValue = newVal.intValue();
                BigDecimal intNewVal = new BigDecimal(intValue);
                if ("3".equals(amortStyleVal) || newVal.compareTo(intNewVal) == 0) {
                    this.changePeriodAmortAmount();
                    this.setCurAmortAmount();
                } else {
                    this.getModel().setValue("planperiod", (Object)intValue);
                }
                if (!AmortStyle.isCustome((String)amortStyleVal)) break;
                this.customAmortHandle();
                return;
            }
            case "periodamortamount": {
                this.putDestTypeCash(null);
                this.changeDestAmountByPeriodAmount();
                IDataModel model = this.getModel();
                if (!"2".equals(amortStyleVal)) break;
                BigDecimal total = (BigDecimal)model.getValue("totalamount");
                total = total != null ? total : BigDecimal.ZERO;
                BigDecimal amortAmountVal = (BigDecimal)model.getValue("amortamount");
                amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
                BigDecimal unAmortAmountVal = total.subtract(amortAmountVal);
                BigDecimal newVal = (BigDecimal)changData.getNewValue();
                if (BigDecimal.ZERO.compareTo(newVal) == 0 || (unAmortAmountVal.compareTo(BigDecimal.ZERO) <= 0 || unAmortAmountVal.compareTo(newVal) >= 0) && (unAmortAmountVal.compareTo(BigDecimal.ZERO) >= 0 || unAmortAmountVal.compareTo(newVal) <= 0)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u671f\u644a\u9500\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u5269\u4f59\u644a\u9500\u91d1\u989d\u3002", (String)"VoucherAmortSchemeEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
                model.setValue("periodamortamount", (Object)BigDecimal.ZERO);
                break;
            }
            case "targetaccount": {
                this.setRowIdByChangAccount("targetaccounts");
                DynamicObject newValue = (DynamicObject)changData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changData.getNewValue();
                if (newValue == null) {
                    this.visibleAssgrp("targetaccounts");
                    return;
                }
                long acctId = newValue.getLong("id");
                if (this.isContainAcct(acctId, rowIndex, "targetaccounts", "targetaccount")) {
                    this.getModel().setValue("targetaccount", (Object)oldValue, rowIndex);
                    return;
                }
                this.visibleAssgrp("targetaccounts");
                this.initCurrency(e, "targetaccounts");
                this.changedAcctClearAssist(rowIndex, "targetassgrp", "targetrowid");
                this.getModel().setValue("plantype", (Object)"0", rowIndex);
                break;
            }
            case "destaccount": {
                this.setRowIdByChangAccount("destaccounts");
                DynamicObject newValue = (DynamicObject)changData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changData.getNewValue();
                if (newValue == null) {
                    return;
                }
                long acctId = newValue.getLong("id");
                if (this.isContainAcct(acctId, rowIndex, "destaccounts", "destaccount")) {
                    this.getModel().setValue("destaccount", (Object)oldValue, rowIndex);
                    return;
                }
                this.visibleAssgrp("destaccounts");
                this.initCurrency(e, "destaccounts");
                this.changedAcctClearAssist(rowIndex, "destassgrp", "destrowid");
                break;
            }
            case "destamount": {
                this.destAmountChange(changData);
                break;
            }
            case "amortstyle": {
                int intValue;
                BigDecimal intNewVal;
                String newVal = changData.getNewValue().toString();
                String oldVal = changData.getOldValue().toString();
                if (AmortStyle.CUSTOME.getValue().equals(newVal)) {
                    this.customAmortHandle();
                } else if (AmortStyle.CUSTOME.getValue().equals(oldVal)) {
                    m.deleteEntryData("custompolicies");
                }
                String status = (String)this.getModel().getValue("status");
                if (AmortStyle.DATE.getValue().equals(oldVal) && AmortStyle.FIXED.getValue().equals(status)) {
                    this.rollBackValue("amortstyle", oldVal, ResManager.loadKDString((String)"\u6309\u65e5\u671f\u644a\u9500\uff0c\u5b8c\u5168\u644a\u9500\u4e4b\u524d\u4e0d\u5141\u8bb8\u4fee\u6539\u644a\u9500\u65b9\u5f0f\u3002", (String)"VoucherAmortSchemeEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (AmortStyle.DATE.getValue().equals(newVal)) {
                    this.setDateRangeFilter(true);
                    this.dateRangeChangeEvent(AmortStyle.DATE.getValue(), changData);
                    this.changePeriodAmortAmount();
                    this.setCurAmortAmount();
                    break;
                }
                BigDecimal periodDecimalVal = (BigDecimal)this.getModel().getValue("planperiod");
                if (periodDecimalVal.compareTo(intNewVal = new BigDecimal(intValue = periodDecimalVal.intValue())) == 0) {
                    this.changePeriodAmortAmount();
                    break;
                }
                this.getModel().setValue("planperiod", (Object)intNewVal);
                break;
            }
            case "startperiod": {
                this.setDateRangeFilter(true);
                if (!AmortStyle.isCustome((String)amortStyleVal)) break;
                this.amendCustomAmort();
                return;
            }
            case "begindate": {
                this.dateRangeChangeEvent("begindate", changData);
                break;
            }
            case "enddate": {
                this.dateRangeChangeEvent("enddate", changData);
                break;
            }
            case "curamortamount": {
                this.changeDestAmountByCurPeriodAmount();
                break;
            }
            case "plantype": {
                this.plantype(rowIndex, true);
                break;
            }
            case "rate": {
                if (!PlanType.FIXED.getValue().equals(m.getValue("plantype", rowIndex))) {
                    return;
                }
                IDataModel model = this.getModel();
                BigDecimal newRate = (BigDecimal)changData.getNewValue();
                BigDecimal oldRate = (BigDecimal)changData.getOldValue();
                BigDecimal oldLocAmt = (BigDecimal)model.getValue("targetlocal", rowIndex);
                model.beginInit();
                BigDecimal targetAmountVal = (BigDecimal)model.getValue("planamount", rowIndex);
                model.setValue("targetlocal", (Object)targetAmountVal.multiply(newRate), rowIndex);
                boolean isCorrectAmt = this.checkTargetAmountValidity(isCustomAmortStyle);
                if (!isCorrectAmt) {
                    model.setValue("rate", (Object)oldRate, rowIndex);
                    model.setValue("targetlocal", (Object)oldLocAmt, rowIndex);
                    model.endInit();
                    this.getView().updateView("rate", rowIndex);
                    this.getView().updateView("targetlocal", rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u671f\u644a\u9500\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u5269\u4f59\u644a\u9500\u91d1\u989d\u3002", (String)"VoucherAmortSchemeEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
                    break;
                }
                model.setValue("targetlocal", (Object)oldLocAmt, rowIndex);
                model.endInit();
                model.setValue("targetlocal", (Object)targetAmountVal.multiply(newRate), rowIndex);
                break;
            }
            case "plandirection": {
                logger.info("PLAN_DIRECTION in:");
                this.updateWithoutPropertyChanged(() -> IntStream.range(0, this.getModel().getEntryEntity("targetaccounts").size()).forEach(index -> this.getModel().setValue("plandirection", changData.getNewValue(), index)));
                IntStream.range(0, this.getModel().getEntryEntity("targetaccounts").size()).forEach(index -> this.getModel().setValue("planamount", (Object)((BigDecimal)this.getModel().getValue("planamount", index)).negate(), index));
                this.enableTargetOriAndRate();
                this.getView().updateView("targetaccounts");
                this.getView().updateView("detailentry");
                break;
            }
            case "destdirection": {
                BigDecimal destamount = (BigDecimal)this.getModel().getValue("destamount", rowIndex);
                BigDecimal destlocal = (BigDecimal)this.getModel().getValue("destlocal", rowIndex);
                destamount = destamount.multiply(new BigDecimal(-1));
                destlocal = destlocal.multiply(new BigDecimal(-1));
                this.getModel().setValue("destamount", (Object)destamount, rowIndex);
                this.getModel().setValue("destlocal", (Object)destlocal, rowIndex);
                DynamicObjectCollection destColl = this.getModel().getEntryEntity("destaccounts");
                for (int i = 0; i < destColl.size(); ++i) {
                    if (i == rowIndex || this.getModel().getValue("destaccounts", i).equals(changData.getNewValue())) continue;
                    this.getModel().setValue("destdirection", changData.getNewValue(), i);
                }
                break;
            }
            case "destassgrp": {
                if (!changData.getNewValue().equals("")) break;
                this.deleteAssgrp("destaccounts", new int[]{rowIndex});
                break;
            }
            case "targetassgrp": {
                if (changData.getNewValue().equals("")) {
                    this.deleteAssgrp("targetaccounts", new int[]{rowIndex});
                }
                this.plantype(rowIndex, this.getPlanType(rowIndex) != PlanType.FIXED);
            }
        }
    }

    private void enableTargetOriAndRate() {
        for (int i = 0; i < this.getModel().getEntryEntity("targetaccounts").size(); ++i) {
            PlanType value = this.getPlanType(i);
            boolean isEnable = false;
            switch (value) {
                case FIXED: {
                    isEnable = true;
                    break;
                }
                case ENDLOCAL: 
                case VOUCHER: {
                    break;
                }
            }
            this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"rate"});
            this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"planamount"});
        }
    }

    private boolean checkTargetAmountValidity(boolean isCustomStyle) {
        BigDecimal oriAmtAmortDone = BigDecimal.ZERO;
        BigDecimal localAmtAmortDone = BigDecimal.ZERO;
        BigDecimal amortInTotal = BigDecimal.ZERO;
        localAmtAmortDone = (BigDecimal)this.getModel().getValue("amortamount");
        if (isCustomStyle) {
            oriAmtAmortDone = this.getModel().getEntryEntity("custompolicies").stream().map(row -> "1".equals(row.getString("isgenvoucher")) ? row.getBigDecimal("camount") : BigDecimal.ZERO).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        String fieldToCompare = isCustomStyle ? "planamount" : "targetlocal";
        amortInTotal = this.getModel().getEntryEntity("targetaccounts").stream().map(row -> row.getBigDecimal(fieldToCompare)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (oriAmtAmortDone.intValue() == 0 || localAmtAmortDone.intValue() == 0) {
            return true;
        }
        return isCustomStyle ? oriAmtAmortDone.compareTo(BigDecimal.ZERO) > 0 && oriAmtAmortDone.compareTo(amortInTotal) <= 0 || oriAmtAmortDone.compareTo(BigDecimal.ZERO) < 0 && oriAmtAmortDone.compareTo(amortInTotal) >= 0 : localAmtAmortDone.compareTo(BigDecimal.ZERO) > 0 && localAmtAmortDone.compareTo(amortInTotal) <= 0 || localAmtAmortDone.compareTo(BigDecimal.ZERO) < 0 && localAmtAmortDone.compareTo(amortInTotal) >= 0;
    }

    private void customAmortHandle() {
        this.customAmortPreHandle();
        IDataModel model = this.getModel();
        int periodNumberOngoing = ((BigDecimal)model.getValue("planperiod")).intValue();
        int periodNumberDone = ((BigDecimal)model.getValue("amortperiod")).intValue();
        int periodNumberInTotal = periodNumberOngoing + periodNumberDone;
        int curPeriodNumber = model.getEntryRowCount("custompolicies");
        Long startperiod = (Long)model.getValue("startperiod_id");
        Long orgId = (Long)model.getValue("org_id");
        Long bookTypeId = (Long)model.getValue("accountbooks_id");
        QFBuilder qfBuilder = new QFBuilder();
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        qfBuilder.add("periodtype", "=", (Object)accountBookInfo.getPeriodTypeId()).add("id", ">=", (Object)startperiod).add("isadjustperiod", "=", (Object)"0");
        DynamicObjectCollection periodColl = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qfBuilder.toArray(), (String)"id", (int)periodNumberInTotal);
        if (periodColl.size() < periodNumberInTotal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u644a\u671f\u95f4\u6570\u5c0f\u4e8e\u5f53\u671f\u4e4b\u540e\u53ef\u7528\u7684\u671f\u95f4\u6570\uff0c\u8bf7\u7ef4\u62a4\u8db3\u591f\u7684\u671f\u95f4\u3002", (String)"VoucherAmortSchemeEdit_38", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        model.beginInit();
        IntStream.range(curPeriodNumber, periodNumberInTotal).forEach(indexToInsert -> {
            model.insertEntryRow("custompolicies", indexToInsert);
            model.setValue("cperiod", (Object)((DynamicObject)periodColl.get(indexToInsert)).getLong("id"), indexToInsert);
        });
        int[] rowIndexToRemove = IntStream.range(periodNumberInTotal, curPeriodNumber).toArray();
        model.deleteEntryRows("custompolicies", rowIndexToRemove);
        model.endInit();
        this.getView().updateView("custompolicies");
    }

    private void customAmortPreHandle() {
        IDataModel model = this.getModel();
        DynamicObjectCollection destaccounts = model.getEntryEntity("destaccounts");
        destaccounts.forEach(v -> {
            if ("2".equals(v.getString("desttype"))) {
                return;
            }
            v.set("destamount", (Object)BigDecimal.ZERO);
            v.set("destlocal", (Object)BigDecimal.ZERO);
            v.set("desttype", (Object)1);
        });
        this.getView().updateView("destaccounts");
        model.setValue("periodamortamount", (Object)BigDecimal.ZERO);
        this.getView().updateView("periodamortamount");
        model.setValue("curamortamount", (Object)BigDecimal.ZERO);
        this.getView().updateView("curamortamount");
    }

    private void destAmountChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        boolean isCustomAmortStyle = AmortStyle.isCustome((String)((String)this.getModel().getValue("amortstyle")));
        IDataModel model = this.getModel();
        DynamicObjectCollection destEntryEntry = model.getEntryEntity("destaccounts");
        if (rowIndex + 1 == model.getEntryRowCount("destaccounts")) {
            this.putDestTypeCash(null);
        }
        if (VoucherAmortConstant.DestType.RATIO.getValue().equals(model.getValue("desttype", rowIndex)) || "true".equals(this.getDestTypeCash())) {
            return;
        }
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal amortAmtOnCurPeriod = this.getAmortAmtOnCurPeriod(isCustomAmortStyle);
        BigDecimal changedRowExchangeRatio = this.getRatio(rowIndex);
        if (null == changedRowExchangeRatio) {
            changedRowExchangeRatio = BigDecimal.ONE;
        }
        BigDecimal changedRowOriAmt = newValue;
        BigDecimal changedRowLocalAmt = changedRowOriAmt.multiply(changedRowExchangeRatio).setScale(4, RoundingMode.HALF_UP);
        BigDecimal changedRowRatio = amortAmtOnCurPeriod.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : changedRowLocalAmt.divide(amortAmtOnCurPeriod, 4, RoundingMode.HALF_UP).multiply(this.oneHundred).multiply(this.getCof());
        DynamicObject changedRow = (DynamicObject)destEntryEntry.get(rowIndex);
        BigDecimal transInAmountInTotal = destEntryEntry.stream().map(transInRow -> changedRow == transInRow ? changedRowLocalAmt : transInRow.getBigDecimal("destlocal")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        model.beginInit();
        model.setValue("destratio", (Object)changedRowRatio, rowIndex);
        model.setValue("destlocal", (Object)changedRowLocalAmt, rowIndex);
        model.endInit();
        this.getView().updateView("destratio", rowIndex);
        this.getView().updateView("destlocal", rowIndex);
    }

    private BigDecimal getAmortAmtOnCurPeriod(boolean isCustomAmortStyle) {
        if (!isCustomAmortStyle) {
            return (BigDecimal)this.getModel().getValue("periodamortamount");
        }
        for (DynamicObject row : this.getModel().getEntryEntity("custompolicies")) {
            if (!row.getString("isgenvoucher").equals("0")) continue;
            return row.getBigDecimal("camount");
        }
        return BigDecimal.ZERO;
    }

    private void plantype(int index, boolean clearAmt) {
        if (clearAmt) {
            this.getModel().setValue("planamount", (Object)BigDecimal.ZERO, index);
        }
        boolean isEnable = false;
        PlanType value = this.getPlanType(index);
        switch (value) {
            case FIXED: {
                isEnable = true;
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"rate"});
                break;
            }
            case ENDLOCAL: {
                this.getBalanceAmount(index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"rate"});
                break;
            }
            case VOUCHER: {
                Object account = this.getModel().getValue("targetaccount", index);
                if (null != account) {
                    this.showVoucherList(index);
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"rate"});
                break;
            }
        }
        this.targetAmountEnable(isEnable, index);
    }

    private void targetAmountEnable(boolean value, int index) {
        this.getView().setEnable(Boolean.valueOf(value), index, new String[]{"planamount"});
    }

    private void getBalanceAmount(int index) {
        this.removeDetailEntry(index);
        IDataModel model = this.getModel();
        DynamicObject dyAccount = (DynamicObject)model.getValue("targetaccount", index);
        if (dyAccount == null) {
            return;
        }
        List comAssistFieldKeyList = this.getComAssistFieldKeys().stream().filter(key -> !key.endsWith(DEST_ASSIST_SUFFIX)).collect(Collectors.toList());
        HashMap<String, String> fieldKeyToFilterPropertyMap = new HashMap<String, String>(8);
        for (String fieldKey : comAssistFieldKeyList) {
            fieldKeyToFilterPropertyMap.put(fieldKey, this.getComAssistKeyByFieldKey(fieldKey));
        }
        List<QFilter> comAssistFilters = this.getComAssistFilters(fieldKeyToFilterPropertyMap, index);
        QueryParam param = this.getQueryParam(dyAccount.getLong("id"), (Long)this.getModel().getValue("targetcurrency_id", index));
        GlFormUtil.getAssgrpsByRowid((String)model.getValue("targetrowid", index), this.getPageCache()).ifPresent(arg_0 -> ((QueryParam)param).setAssGrpIds(arg_0));
        param.getCustomFilter().addAll(comAssistFilters);
        Long orgIds = (Long)model.getValue("org_id");
        Long bookTypeId = (Long)model.getValue("accountbooks_id");
        long accountTableId = this.getAccountTableId(orgIds, bookTypeId);
        long beginPeriodId = TaxReportFormHelper.getCurPeriod((long)orgIds, (long)bookTypeId);
        Long endPeriodId = beginPeriodId;
        String plandirection = model.getValue("plandirection", index).toString();
        StringBuilder selector = new StringBuilder("account,assgrp,endfor,endlocal");
        long comAssistCount = model.getDataEntityType().getAllFields().keySet().stream().filter(k -> k.startsWith("detailcomassist")).count();
        int i = 1;
        while ((long)i <= comAssistCount) {
            selector.append(",").append(CommonAssistUtil.getComassistField((int)i));
            ++i;
        }
        try (DataSet dt = BalanceQueryExecutor.getInstance().getBalance(selector.toString(), new Long[]{orgIds}, bookTypeId.longValue(), accountTableId, beginPeriodId, endPeriodId.longValue(), param);){
            Iterator irow = dt.iterator();
            BigDecimal totalOri = BigDecimal.ZERO;
            BigDecimal totalLoc = BigDecimal.ZERO;
            if (irow.hasNext()) {
                while (irow.hasNext()) {
                    Row next = (Row)irow.next();
                    BigDecimal endfor = next.getBigDecimal("endfor");
                    BigDecimal endlocal = next.getBigDecimal("endlocal");
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)plandirection)) {
                        endfor = endfor.negate();
                        endlocal = endlocal.negate();
                    }
                    HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
                    int i2 = 1;
                    while ((long)i2 <= comAssistCount) {
                        comAssistMap.put(i2, next.getLong(CommonAssistUtil.getComassistField((int)i2)));
                        ++i2;
                    }
                    this.createDetailEntry(index, next.getLong("account"), next.getLong("assgrp"), endfor, endlocal, comAssistMap);
                    totalOri = totalOri.add(endfor);
                    totalLoc = totalLoc.add(endlocal);
                }
                model.setValue("planamount", (Object)totalOri, index);
                model.setValue("targetlocal", (Object)totalLoc, index);
                BigDecimal rate = totalOri.compareTo(BigDecimal.ZERO) == 0 ? null : totalLoc.divide(totalOri, 4, RoundingMode.HALF_UP);
                model.setValue("rate", (Object)rate, index);
            } else {
                Object showTip = ThreadCache.get((Object)"getBalanceAmount_showTip");
                if (null == showTip) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u6ca1\u6709\u671f\u672b\u4f59\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"VoucherAmortSchemeEdit_72", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    ThreadCache.put((Object)"getBalanceAmount_showTip", (Object)"true");
                }
                model.setValue("planamount", (Object)BigDecimal.ZERO, index);
                model.setValue("targetlocal", (Object)BigDecimal.ZERO, index);
            }
        }
    }

    private long getAccountTableId(long orgId, long bookTypeId) {
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        long accounttableId = 0L;
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"BalanceService", (String)"gl_accountbook", (String)"accounttable.id accounttableId", (QFilter[])new QFilter[]{orgFilter, bookFilter}, null);){
            Iterator it = set.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                accounttableId = row.getLong("accounttableId");
            }
        }
        return accounttableId;
    }

    private void showVoucherList(int index) {
        DynamicObject dyObj = (DynamicObject)this.getModel().getValue("targetaccount", index);
        Long masterId = dyObj.getLong("masterid");
        ListShowParameter list = ShowFormHelper.createShowListForm((String)"gl_voucherlistf7", (boolean)true, (int)2, (boolean)true);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("entries.account.masterid", "=", (Object)masterId).add("org", "=", this.getModel().getValue("org_id")).add("booktype", "=", this.getModel().getValue("accountbooks_id")).add("billstatus", "not in", Arrays.asList("A", "D"));
        GlFormUtil.getAssgrpsByRowid((String)this.getModel().getValue("targetrowid", index), this.getPageCache()).ifPresent(ids -> qfBuilder.add("entries.assgrp.id", "in", ids));
        List comAssistFieldKeyList = this.getComAssistFieldKeys().stream().filter(key -> !key.endsWith(DEST_ASSIST_SUFFIX)).collect(Collectors.toList());
        HashMap<String, String> fieldKeyToFilterPropertyMap = new HashMap<String, String>(8);
        for (String fieldKey : comAssistFieldKeyList) {
            fieldKeyToFilterPropertyMap.put(fieldKey, "entries." + this.getComAssistKeyByFieldKey(fieldKey));
        }
        List<QFilter> comAssistFilters = this.getComAssistFilters(fieldKeyToFilterPropertyMap, index);
        list.getListFilterParameter().getQFilters().addAll(comAssistFilters);
        list.getListFilterParameter().getQFilters().addAll(qfBuilder.toList());
        list.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "plantype"));
        this.getView().showForm((FormShowParameter)list);
    }

    private void dateRangeChangeEvent(String fieldKey, ChangeData changeData) {
        Long endPeriodId;
        Date dateBegin = (Date)this.getModel().getValue("begindate");
        Date dateEnd = (Date)this.getModel().getValue("enddate");
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (dateBegin == null || dateEnd == null || bookInfo == null) {
            return;
        }
        Object amortStatus = this.getModel().getValue("status");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        if (startPeriod == null) {
            this.rollBackValue("begindate", null, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"VoucherAmortSchemeEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection policies = this.getModel().getDataEntity(true).getDynamicObjectCollection("policies");
        Date lastEndDate = null;
        if (CollectionUtils.isNotEmpty((Collection)policies)) {
            String row = PeriodUtil.getFuturePeriod((Object)startPeriod.getLong("id"), (int)policies.size(), (boolean)false);
            if (row == null) {
                this.rollBackValue(fieldKey, changeData.getOldValue(), ResManager.loadKDString((String)"\u671f\u95f4\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherAmortSchemeEdit_83", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            lastEndDate = row.getDate("enddate");
        }
        switch (fieldKey) {
            case "begindate": {
                Date newValue = (Date)changeData.getNewValue();
                Date maxDate = startPeriod.getDate("enddate");
                if (newValue != null && maxDate != null && newValue.compareTo(maxDate) > 0) {
                    this.rollBackValue(fieldKey, changeData.getOldValue(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u8be5\u2264\u5f00\u59cb\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"VoucherAmortSchemeEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!"2".equals(amortStatus)) break;
                this.rollBackValue(fieldKey, changeData.getOldValue(), ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\u7684\u65b9\u6848\u4e0d\u5141\u8bb8\u4fee\u6539\u5f00\u59cb\u65e5\u671f\u3002", (String)"VoucherAmortSchemeEdit_81", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            case "enddate": {
                Date newDate;
                if (!"2".equals(amortStatus) || (newDate = (Date)changeData.getNewValue()) == null || lastEndDate == null || newDate.compareTo(lastEndDate) > 0) break;
                this.rollBackValue(fieldKey, changeData.getOldValue(), ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5df2\u644a\u9500\u6700\u5927\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"VoucherAmortSchemeEdit_82", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        DynamicObject endPeriod = GLUtil.getPeriodByDate((Date)dateEnd, (long)bookInfo.getPeriodTypeId());
        if (endPeriod == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u5b9a\u4e49%s\u5e74\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"VoucherAmortSchemeEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), format.format(dateEnd)));
            return;
        }
        Long startPeriodId = startPeriod.getLong("id");
        if (startPeriodId.equals(endPeriodId = Long.valueOf(endPeriod.getLong("id")))) {
            long totalDays = this.diffDays(startPeriod.getDate("begindate"), startPeriod.getDate("enddate"));
            long rangeDays = this.diffDays(dateBegin, dateEnd);
            Double totalPeriod = totalDays == 0L ? 0.0 : Double.parseDouble(String.valueOf(rangeDays)) / Double.parseDouble(String.valueOf(totalDays));
            this.getModel().setValue("planperiod", (Object)totalPeriod);
        } else {
            List periodIds = VoucherAmortSchemeUtils.getPeriodIds((Long)startPeriodId, (Long)endPeriodId);
            long beginTotalDays = this.diffDays(startPeriod.getDate("begindate"), startPeriod.getDate("enddate"));
            long beginRangeDays = this.diffDays(dateBegin, startPeriod.getDate("enddate"));
            Double beginTotalPeriod = beginTotalDays == 0L ? 0.0 : Double.parseDouble(String.valueOf(beginRangeDays)) / Double.parseDouble(String.valueOf(beginTotalDays));
            long endTotalDays = this.diffDays(endPeriod.getDate("begindate"), endPeriod.getDate("enddate"));
            long endRangeDays = this.diffDays(endPeriod.getDate("begindate"), dateEnd);
            Double endTotalPeriod = endTotalDays == 0L ? 0.0 : Double.parseDouble(String.valueOf(endRangeDays)) / Double.parseDouble(String.valueOf(endTotalDays));
            BigDecimal result = BigDecimal.valueOf(beginTotalPeriod + endTotalPeriod + (double)(periodIds.size() - 2)).subtract((BigDecimal)this.getModel().getValue("amortperiod"));
            this.getModel().setValue("planperiod", (Object)result);
        }
    }

    private long diffDays(Date dtBegin, Date dtEnd) {
        return (dtEnd.getTime() - dtBegin.getTime()) / 1000L / 3600L / 24L + 1L;
    }

    private void rollBackValue(String key, Object value, String message) {
        this.getView().showTipNotification(message);
        this.isDataChanged = false;
        this.getModel().setValue(key, value);
        this.isDataChanged = true;
    }

    private void rollBackValue(String key, Object value, int row, String message) {
        this.getView().showTipNotification(message);
        this.isDataChanged = false;
        this.getModel().setValue(key, value, row);
        this.isDataChanged = true;
    }

    private void initModelValue(String key, Object value, int index) {
        this.getModel().beginInit();
        this.getModel().setValue(key, value, index);
        this.getModel().endInit();
        this.getView().updateView(key, index);
    }

    private void setDateRangeFilter(boolean isPropertyChanged) {
        IDataModel model = this.getModel();
        DynamicObject dyStartPeriod = (DynamicObject)model.getValue("startperiod");
        String style = (String)model.getValue("amortstyle");
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl("daterange");
        if ("3".equals(style)) {
            if (dyStartPeriod != null) {
                Date dateBegin = dyStartPeriod.getDate("begindate");
                Date dateEnd = dyStartPeriod.getDate("enddate");
                dateRangeEdit.setMinDate(dateBegin);
                if (isPropertyChanged) {
                    model.setValue("begindate", (Object)dateBegin);
                    model.setValue("enddate", (Object)dateEnd);
                }
            }
            dateRangeEdit.setMustInput(true);
        } else {
            dateRangeEdit.setMustInput(false);
        }
    }

    private void changedAcctClearAssist(int index, String assgrpKey, String rowIdKey) {
        IDataModel model = this.getModel();
        model.setValue(assgrpKey, (Object)"", index);
        String rowIdVal = (String)model.getValue(rowIdKey, index);
        QFilter forg = new QFilter("org", "=", model.getValue("org_id"));
        this.getPageCache().remove(rowIdVal);
        QFilter fassgrpRow = new QFilter("assgrprow", "=", (Object)rowIdVal);
        DeleteServiceHelper.delete((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{forg, fassgrpRow});
    }

    private void setRowIdByChangAccount(String entryKey) {
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = model.getEntryEntity(entryKey);
        String rowIdKey = "targetaccounts".equals(entryKey) ? "targetrowid" : "destrowid";
        int i = 0;
        for (DynamicObject row : coll) {
            String rowId = row.getString(rowIdKey);
            if (StringUtils.isBlank((CharSequence)rowId)) {
                model.setValue(rowIdKey, (Object)this.genRowId(), i);
            }
            ++i;
        }
    }

    private void initCurrency(PropertyChangedArgs e, String typeEntry) {
        IDataModel m = this.getModel();
        String currencyKey = "targetaccounts".equals(typeEntry) ? "targetcurrency" : "destcurrency";
        if (e.getChangeSet().length > 0) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject accoutDyn = (DynamicObject)changeData.getNewValue();
            if (null == accoutDyn) {
                return;
            }
            long curId = (Long)m.getValue("currency_id");
            int index = e.getChangeSet()[0].getRowIndex();
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"targetcurrency"});
            if ("descurrency".equals(accoutDyn.get("acctcurrency"))) {
                DynamicObjectCollection coll = (DynamicObjectCollection)accoutDyn.get("currencyentry");
                if (coll.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5df2\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u4f46\u5e01\u79cd\u5206\u5f55\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u79d1\u76ee\u6570\u636e\u3002", (String)"VoucherAmortSchemeEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject dyn : coll) {
                    Long acctCur = dyn.getLong("currency_id");
                    ids.add(acctCur);
                }
                if (ids.contains(curId)) {
                    m.setValue(currencyKey, (Object)curId, index);
                } else {
                    m.setValue(currencyKey, ids.get(0), index);
                }
            } else {
                m.setValue(currencyKey, (Object)curId, index);
            }
        }
    }

    private boolean isContainAcct(long acctId, int rowIndex, String entryKey, String acctKey) {
        if (acctId == 0L) {
            return false;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection acctColl = model.getEntryEntity(entryKey);
        HashSet<Long> selectedAcctIds = new HashSet<Long>();
        for (int i = 0; i < acctColl.size(); ++i) {
            long id;
            if (i == rowIndex || (id = ((DynamicObject)acctColl.get(i)).getLong(acctKey + "_id")) == 0L) continue;
            selectedAcctIds.add(id);
        }
        HashSet selectedLeafAcctIds = new HashSet();
        GLUtil.getLeafIds(selectedAcctIds, selectedLeafAcctIds, (boolean)false);
        if (selectedLeafAcctIds.contains(acctId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u79d1\u76ee\u5df2\u5b58\u5728\u7236\u79d1\u76ee\u3002", (String)"VoucherAmortSchemeEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return true;
        }
        HashSet<Long> currentAcctIds = new HashSet<Long>();
        currentAcctIds.add(acctId);
        HashSet currentLeafIds = new HashSet();
        GLUtil.getLeafIds(currentAcctIds, currentLeafIds, (boolean)false);
        for (Long id : selectedAcctIds) {
            if (!currentLeafIds.contains(id)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5df2\u5b58\u5728\u5b50\u79d1\u76ee\u3002", (String)"VoucherAmortSchemeEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void policiesRatioChange(ChangeData changeData, String key, String entryKey) {
        BigDecimal newRatio = (BigDecimal)changeData.getNewValue();
        BigDecimal oldRatio = (BigDecimal)changeData.getOldValue();
        IDataModel model = this.getModel();
        int curIndex = changeData.getRowIndex();
        if (curIndex + 1 == model.getEntryRowCount("destaccounts")) {
            this.putDestTypeCash(null);
        }
        if (VoucherAmortConstant.DestType.AMOUNT.getValue().equals(this.getModel().getValue("desttype", curIndex)) && !"true".equals(this.getDestTypeCash())) {
            return;
        }
        String amountKey = "";
        if (!key.equals("destratio")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u6bd4\u4f8b\u3002", (String)"VoucherAmortSchemeEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        amountKey = "destamount";
        this.policiesRatioDeal(curIndex, newRatio, oldRatio, key, amountKey, entryKey);
        int policiesIndex = model.getEntryCurrentRowIndex("policies");
        BigDecimal total = (BigDecimal)this.getModel().getValue("amount", policiesIndex);
        total = total != null ? total : BigDecimal.ZERO;
        model.setValue("destamount", (Object)total.multiply(newRatio.setScale(4, 4).divide(this.oneHundred, RoundingMode.HALF_UP)), curIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (args.getSource() != null && (args.getSource() instanceof Save || args.getSource() instanceof Submit)) {
            String[] entrys;
            IDataModel model = this.getModel();
            ArrayList<DynamicObject> assgrpDynList = new ArrayList<DynamicObject>();
            ArrayList<String> cacheRowIdList = new ArrayList<String>();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gl_finalprocess_assgrp");
            for (String entry : entrys = new String[]{"targetaccounts", "destaccounts"}) {
                String rowIdKey = entry.replace("accounts", "rowid");
                DynamicObjectCollection destColl = model.getEntryEntity(entry);
                for (DynamicObject row : destColl) {
                    String rowIdVal = row.getString(rowIdKey);
                    String strObj = this.getPageCache().get(rowIdVal);
                    if (StringUtils.isBlank((CharSequence)strObj)) continue;
                    DynamicObject oldAssgrpDyn = GlFormUtil.fromDynamicString(strObj, entityType);
                    DynamicObject newExpDyn = this.newExpDyn(oldAssgrpDyn);
                    assgrpDynList.add(newExpDyn);
                    cacheRowIdList.add(rowIdVal);
                }
            }
            if (!cacheRowIdList.isEmpty()) {
                QFilter forg = new QFilter("org", "=", model.getValue("org_id"));
                QFilter fassgrpRow = new QFilter("assgrprow", "in", cacheRowIdList);
                DeleteServiceHelper.delete((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{forg, fassgrpRow});
            }
            if (!assgrpDynList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)entityType, (Object[])assgrpDynList.toArray(new DynamicObject[0]));
            }
            if (!"yes".equalsIgnoreCase(this.getPageCache().get("save")) && "2".equals(this.getModel().getValue("status").toString())) {
                long orgId = (Long)this.getModel().getValue("org_id");
                long bookTypeId = (Long)this.getModel().getValue("accountbooks_id");
                if (orgId != 0L && bookTypeId != 0L) {
                    AccountBookInfo bookDyn = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
                    long curPeriodId = bookDyn.getCurPeriodId();
                    boolean showCheck = false;
                    DynamicObjectCollection policies = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("policies");
                    for (DynamicObject dyn : policies) {
                        long period = dyn.getLong("period.id");
                        if (curPeriodId != period) continue;
                        showCheck = true;
                        break;
                    }
                    if (showCheck) {
                        this.getPageCache().put("save", "yes");
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u672c\u671f\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u786e\u5b9a\u7ee7\u7eed\u4fdd\u5b58\u65b9\u6848\uff1f", (String)"VoucherAmortSchemeEdit_71", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save"));
                        args.setCancel(true);
                    } else {
                        this.checkForSave(args);
                        this.getPageCache().put("save", "no");
                    }
                }
            } else {
                this.checkForSave(args);
                this.getPageCache().put("save", "no");
            }
        } else if ("glcreatevoucher".equals(operate.getOperateKey())) {
            if (AmortStyle.isCustome((String)this.getModel().getValue("amortstyle").toString())) {
                AccountBookInfo bookInfo = this.getBookByOrg();
                Optional<DynamicObject> first = this.getModel().getEntryEntity("custompolicies").stream().filter(v -> v.getLong("cperiod_id") == bookInfo.getCurPeriodId()).findFirst();
                if (!first.isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u671f\u95f4\u4e0d\u5305\u542b\u4f1a\u8ba1\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"VoucherAmortSchemeEdit_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if ("autofill".equals(operate.getOperateKey())) {
            IDataModel model = this.getModel();
            DynamicObjectCollection coll = model.getEntryEntity("destaccounts");
            int count = coll.size();
            BigDecimal ave = this.oneHundred.divide(new BigDecimal(count + ""), 2, 3);
            int i = 0;
            for (DynamicObject row : coll) {
                String rowId = row.getString("destrowid");
                if (StringUtils.isBlank((CharSequence)rowId)) {
                    model.setValue("destrowid", (Object)this.genRowId(), i);
                }
                if (i == count - 1) {
                    BigDecimal lastAve = this.oneHundred.subtract(ave.multiply(new BigDecimal(count - 1)));
                    model.setValue("destratio", (Object)lastAve, i);
                } else {
                    model.setValue("destratio", (Object)ave, i);
                }
                ++i;
            }
        }
    }

    private boolean customAmortCheck(BeforeDoOperationEventArgs args) {
        BigDecimal periodNumberDone;
        IDataModel model = this.getModel();
        this.customAmortPreHandle();
        if (!this.checkCurrency(args).booleanValue()) {
            return false;
        }
        DynamicObjectCollection custompolicies = model.getEntryEntity("custompolicies");
        if (custompolicies.stream().filter(v -> v.getBigDecimal("camount").compareTo(BigDecimal.ZERO) == 0).count() > 0L) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u644a\u91d1\u989d\u662f\u5426\u4e3a\u7a7a\u3002", (String)"VoucherAmortSchemeEdit_20", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal periodNumberOngoing = (BigDecimal)model.getValue("planperiod");
        BigDecimal periodNumberInTotal = periodNumberOngoing.add(periodNumberDone = (BigDecimal)model.getValue("amortperiod"));
        if (periodNumberInTotal.compareTo(new BigDecimal(String.valueOf(custompolicies.size()))) != 0) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u671f\u6570\u4e0e\u5f85\u644a\u9500\u671f\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VoucherAmortSchemeEdit_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal totalAmort = BigDecimal.ZERO;
        BigDecimal totalPlanAmount = BigDecimal.ZERO;
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject dyn : custompolicies) {
            long periodId = dyn.getLong("cperiod_id");
            if (list.contains(periodId)) {
                this.setCancelInfo(args, ResManager.loadKDString((String)"\u644a\u9500\u671f\u95f4\u4e0d\u80fd\u91cd\u590d", (String)"VoucherAmortSchemeEdit_22", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            list.add(periodId);
            totalAmort = totalAmort.add(dyn.getBigDecimal("camount"));
        }
        DynamicObjectCollection targetaccounts = model.getEntryEntity("targetaccounts");
        for (DynamicObject dyn : targetaccounts) {
            totalPlanAmount = totalPlanAmount.add(dyn.getBigDecimal("planamount"));
        }
        if (totalAmort.compareTo(totalPlanAmount) != 0) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5f85\u644a\u9500\u603b\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VoucherAmortSchemeEdit_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Boolean checkCurrency(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        DynamicObjectCollection targetaccounts = model.getEntryEntity("targetaccounts");
        DynamicObjectCollection destaccounts = model.getEntryEntity("destaccounts");
        Set<Long> targetAccountIds = targetaccounts.stream().map(v -> v.getLong("targetcurrency.id")).collect(Collectors.toSet());
        if (targetAccountIds.size() > 1) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u201c\u5f85\u644a\u79d1\u76ee\u201d\u7684\u5e01\u79cd\u5fc5\u987b\u76f8\u540c\u3002", (String)"VoucherAmortSchemeEdit_24", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set<Long> destAccountIds = destaccounts.stream().map(v -> v.getLong("destcurrency.id")).collect(Collectors.toSet());
        if (destAccountIds.size() > 1) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u201c\u8f6c\u5165\u79d1\u76ee\u201d\u7684\u5e01\u79cd\u5fc5\u987b\u76f8\u540c\u3002", (String)"VoucherAmortSchemeEdit_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (targetAccountIds.size() == 1 && destAccountIds.size() == 1 && !targetAccountIds.toArray(new Long[0])[0].equals(destAccountIds.toArray(new Long[0])[0])) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u201c\u5f85\u644a\u79d1\u76ee\u201d\u7684\u5e01\u79cd\u548c\u201c\u8f6c\u5165\u79d1\u76ee\u201d\u7684\u5e01\u79cd\u5fc5\u987b\u4e00\u81f4\u3002", (String)"VoucherAmortSchemeEdit_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean noCustomAmortCheck(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<Long> list = new ArrayList<Long>();
        DynamicObjectCollection collection = model.getEntryEntity("policies");
        for (DynamicObject dyn : collection) {
            long periodId = dyn.getLong("period_id");
            if (list.contains(periodId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u644a\u9500\u671f\u95f4\u4e0d\u80fd\u91cd\u590d", (String)"VoucherAmortSchemeEdit_22", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            list.add(periodId);
            BigDecimal val = dyn.getBigDecimal("policiesratio");
            if (val == null) continue;
            total = total.add(val);
        }
        if (total.compareTo(this.oneHundred) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u644a\u9500\u671f\u95f4\u6bd4\u4f8b\u4e0d\u5f97\u8d85\u8fc7100%\u3002", (String)"VoucherAmortSchemeEdit_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (AmortStyle.DATE.getValue().equals(model.getValue("amortstyle").toString()) && "2".equals(model.getValue("status"))) {
            DynamicObject perid;
            Date lastEndDate;
            Date dateEnd = (Date)model.getValue("enddate");
            DynamicObjectCollection policies = this.getModel().getDataEntity(true).getDynamicObjectCollection("policies");
            if (policies.size() > 0 && dateEnd.before(lastEndDate = (perid = (DynamicObject)policies.get(0)).getDynamicObject("period").getDate("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\u7684\u65b9\u6848\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5df2\u644a\u9500\u671f\u95f4\u6700\u540e\u4e00\u5929\u3002", (String)"VoucherAmortSchemeEdit_68", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
        }
        return true;
    }

    private boolean compareEntry(DynamicObject entry1, DynamicObject entry2, String accountField, String currencyField, String rowidField) {
        String rowid2;
        String rowid1;
        Long currency2;
        Long currency1;
        Long account2;
        Long account1;
        int seq2;
        boolean result = false;
        int seq1 = entry1.getInt("seq");
        if (seq1 != (seq2 = entry2.getInt("seq")) && (account1 = Long.valueOf(entry1.getLong(accountField))).equals(account2 = Long.valueOf(entry2.getLong(accountField))) && (currency1 = Long.valueOf(entry1.getLong(currencyField))).equals(currency2 = Long.valueOf(entry2.getLong(currencyField))) && this.compareAssgrp(rowid1 = entry1.getString(rowidField), rowid2 = entry2.getString(rowidField))) {
            result = true;
        }
        return result;
    }

    private boolean compareAssgrp(String rowid1, String rowid2) {
        Map<String, Set<Object>> entries1 = this.getAssgrpValue(rowid1);
        Map<String, Set<Object>> entries2 = this.getAssgrpValue(rowid2);
        if (entries1 != null && entries2 != null && entries1.size() == entries2.size()) {
            for (Map.Entry<String, Set<Object>> entry1 : entries1.entrySet()) {
                Set<Object> vals1 = entry1.getValue();
                Set<Object> vals2 = entries2.get(entry1.getKey());
                if (vals2 == null || vals1.size() != vals2.size()) {
                    return false;
                }
                for (Object val1 : vals1) {
                    if (vals2.contains(val1)) continue;
                    return false;
                }
            }
        } else {
            if (entries1 == null && entries2 == null) {
                return false;
            }
            return false;
        }
        return true;
    }

    private Map<String, Set<Object>> getAssgrpValue(String cachekey) {
        FinalProcessAssgrp finalProcessAssgrp;
        QFilter fassgrpRow;
        IDataModel model;
        QFilter forg;
        Map loadFromCache;
        IPageCache cache = this.getPageCache();
        String cacheStr = cache.get(cachekey);
        DynamicObject expDyn = null;
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gl_finalprocess_assgrp");
            expDyn = GlFormUtil.fromDynamicString(cacheStr, entityType);
        }
        if (expDyn == null && !(loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{forg = new QFilter("org", "=", (model = this.getModel()).getValue("org_id")), fassgrpRow = new QFilter("assgrprow", "=", (Object)cachekey)})).isEmpty()) {
            expDyn = (DynamicObject)loadFromCache.values().iterator().next();
        }
        if (expDyn != null && (finalProcessAssgrp = FinalProcessAssgrp.create((DynamicObjectCollection)expDyn.getDynamicObjectCollection("entryentity"))) != null) {
            return finalProcessAssgrp.getFlex2values().entrySet().stream().filter(x -> x.getValue() != null).collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((FinalProcessAssgrp.AssgrpValues)x.getValue()).getValues()));
        }
        return null;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void changeTargetLocalByTargetAmount(BigDecimal newVal, int rowIndex) {
        IDataModel model = this.getModel();
        PlanType value = this.getPlanType(rowIndex);
        if (PlanType.ENDLOCAL == value) {
            this.getBalanceAmount(rowIndex);
        } else {
            BigDecimal rate = (BigDecimal)model.getValue("rate", rowIndex);
            model.setValue("targetlocal", (Object)newVal.multiply(rate), rowIndex);
        }
    }

    private void changeTargetAmountByTargetCurrency(long oldId, long newId, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal targetAmountVal = (BigDecimal)model.getValue("planamount", rowIndex);
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return;
        }
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        Date newDate = new Date();
        BigDecimal newRate = BigDecimal.ONE;
        if (newId == 0L && oldId != 0L) {
            model.setValue("targetcurrency", (Object)oldId);
        } else if (newId != baseCurrencyId) {
            newRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)newId, (Long)baseCurrencyId, (Date)newDate);
        }
        BigDecimal targetLoc = null;
        if (newRate != null) {
            targetLoc = targetAmountVal.multiply(newRate);
        }
        model.setValue("targetlocal", (Object)targetLoc, rowIndex);
    }

    private void changePeriodAmortAmount() {
        IDataModel model = this.getModel();
        String amortTypeVal = (String)model.getValue("amortstyle");
        if ("1".equals(amortTypeVal) || "3".equals(amortTypeVal)) {
            BigDecimal total = (BigDecimal)model.getValue("totalamount");
            total = total != null ? total : BigDecimal.ZERO;
            BigDecimal amortAmountVal = (BigDecimal)model.getValue("amortamount");
            amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
            BigDecimal periodCount = (BigDecimal)model.getValue("planperiod");
            if (periodCount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal periodAmount = total.subtract(amortAmountVal).divide(periodCount, amortAmountVal.scale(), RoundingMode.HALF_UP);
                model.setValue("periodamortamount", (Object)periodAmount);
            } else {
                model.setValue("periodamortamount", (Object)total);
            }
        }
    }

    private void setCurAmortAmount() {
        Long endPeriodId;
        IDataModel model = this.getModel();
        String amortTypeVal = (String)model.getValue("amortstyle");
        if (!"3".equals(amortTypeVal)) {
            return;
        }
        long orgId = (Long)model.getValue("org_id");
        long bookTypeId = (Long)model.getValue("accountbooks_id");
        Date dateBegin = (Date)this.getModel().getValue("begindate");
        Date dateEnd = (Date)this.getModel().getValue("enddate");
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null || dateEnd == null || dateBegin == null) {
            return;
        }
        DynamicObject endPeriod = GLUtil.getPeriodByDate((Date)dateEnd, (long)bookInfo.getPeriodTypeId());
        if ("startperiod" == null || endPeriod == null) {
            return;
        }
        Long curPeriodId = bookInfo.getCurPeriodId();
        if (curPeriodId.equals(endPeriodId = Long.valueOf(endPeriod.getLong("id")))) {
            String status = (String)this.getModel().getValue("status");
            if ("3".equals(status)) {
                DynamicObjectCollection policys = this.getModel().getEntryEntity("policies");
                for (DynamicObject policy : policys) {
                    Long periodId;
                    DynamicObject period = policy.getDynamicObject("period");
                    if (period == null || !(periodId = Long.valueOf(period.getLong("id"))).equals(curPeriodId)) continue;
                    model.setValue("curamortamount", (Object)policy.getBigDecimal("amount"));
                    break;
                }
            } else {
                BigDecimal total = (BigDecimal)model.getValue("totalamount");
                total = total != null ? total : BigDecimal.ZERO;
                BigDecimal amortAmountVal = (BigDecimal)model.getValue("amortamount");
                amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
                BigDecimal unAmortAmountVal = total.subtract(amortAmountVal);
                model.setValue("curamortamount", (Object)unAmortAmountVal);
            }
        } else {
            BigDecimal periodAmt = (BigDecimal)model.getValue("periodamortamount");
            BigDecimal curAmortPeriod = VoucherAmortSchemeUtils.queryCurPeriodAmortPeriod((Long)orgId, (Long)bookTypeId, (Date)dateBegin, (Date)dateEnd, (BigDecimal)((BigDecimal)this.getModel().getValue("planperiod")));
            model.setValue("curamortamount", (Object)periodAmt.multiply(curAmortPeriod));
        }
    }

    private void changeDestAmountByCurrencyOrRaio(int rowIndex) {
        String amortTypeVal;
        BigDecimal periodAmountVal;
        IDataModel model = this.getModel();
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return;
        }
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        Date newDate = new Date();
        BigDecimal newRate = BigDecimal.ONE;
        long currencyId = (Long)model.getValue("destcurrency_id", rowIndex);
        if (currencyId == 0L) {
            return;
        }
        if (currencyId != baseCurrencyId) {
            newRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)newDate);
        }
        BigDecimal bigDecimal = periodAmountVal = "3".equals(amortTypeVal = (String)model.getValue("amortstyle")) ? (BigDecimal)model.getValue("curamortamount") : (BigDecimal)model.getValue("periodamortamount");
        if (newRate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u6c47\u7387\uff0c\u8bf7\u4fee\u6539\u5e01\u79cd\u3002", (String)"VoucherAmortSchemeEdit_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            model.setValue("destcurrency", null, rowIndex);
            periodAmountVal = BigDecimal.ZERO;
            newRate = BigDecimal.ONE;
        }
        if (this.isDirectionConsistent()) {
            periodAmountVal = periodAmountVal.multiply(new BigDecimal(-1));
        }
        int entryCount = model.getEntryRowCount("destaccounts");
        BigDecimal destAmountVal = BigDecimal.ZERO;
        BigDecimal destLocalVal = BigDecimal.ZERO;
        if (rowIndex + 1 == entryCount) {
            DynamicObjectCollection coll = model.getEntryEntity("destaccounts");
            BigDecimal ratioCount = BigDecimal.ZERO;
            BigDecimal destLocalCount = BigDecimal.ZERO;
            int index = 0;
            for (DynamicObject row : coll) {
                BigDecimal ratio = row.getBigDecimal("destratio");
                ratioCount = ratioCount.add(ratio);
                if (index == rowIndex) continue;
                BigDecimal localVal = row.getBigDecimal("destlocal");
                destLocalCount = destLocalCount.add(localVal);
                ++index;
            }
            if (this.oneHundred.compareTo(ratioCount) == 0) {
                destLocalVal = periodAmountVal.subtract(destLocalCount);
                destAmountVal = destLocalVal.divide(newRate, 4, RoundingMode.HALF_UP);
            } else {
                BigDecimal ratio = (BigDecimal)model.getValue("destratio", rowIndex);
                destLocalVal = periodAmountVal.multiply(ratio.divide(this.oneHundred));
                destAmountVal = destLocalVal.divide(newRate, 4, RoundingMode.HALF_UP);
            }
        } else {
            BigDecimal ratio = (BigDecimal)model.getValue("destratio", rowIndex);
            destLocalVal = periodAmountVal.multiply(ratio.divide(this.oneHundred));
            destAmountVal = destLocalVal.divide(newRate, 4, RoundingMode.HALF_UP);
        }
        this.changeRatioOrAmount(rowIndex, destAmountVal, destLocalVal);
    }

    private void changeDestAmountByPeriodAmount() {
        IDataModel model = this.getModel();
        String amortTypeVal = (String)model.getValue("amortstyle");
        if ("3".equals(amortTypeVal)) {
            return;
        }
        BigDecimal periodAmount = (BigDecimal)model.getValue("periodamortamount");
        if (this.isDirectionConsistent()) {
            periodAmount = periodAmount.multiply(new BigDecimal(-1));
        }
        DynamicObjectCollection destColl = model.getEntryEntity("destaccounts");
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return;
        }
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        Date newDate = new Date();
        BigDecimal localCount = BigDecimal.ZERO;
        int entrySize = destColl.size();
        BigDecimal destAmountVal = BigDecimal.ZERO;
        BigDecimal destLocalVal = BigDecimal.ZERO;
        BigDecimal destRatioVal = BigDecimal.ZERO;
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject rowDyn = (DynamicObject)destColl.get(i);
            DynamicObject currencyDyn = rowDyn.getDynamicObject("destcurrency");
            if (currencyDyn == null) continue;
            long currencyId = currencyDyn.getLong("id");
            int amtPrecision = currencyDyn.getInt("amtprecision");
            BigDecimal ratio = rowDyn.getBigDecimal("destratio") == null ? BigDecimal.ZERO : rowDyn.getBigDecimal("destratio").divide(this.oneHundred);
            BigDecimal rateVal = BigDecimal.ONE;
            if (baseCurrencyId != currencyId) {
                rateVal = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)baseCurrencyId, (Long)currencyId, (Date)newDate);
            }
            if (rateVal == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u6c47\u7387\uff0c\u8bf7\u4fee\u6539\u5e01\u79cd\u3002", (String)"VoucherAmortSchemeEdit_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                model.setValue("targetcurrency", (Object)0L);
                periodAmount = BigDecimal.ZERO;
                rateVal = BigDecimal.ZERO;
            }
            destRatioVal = destRatioVal.add(ratio);
            if (i + 1 == entrySize && destRatioVal.compareTo(BigDecimal.ONE) == 0) {
                destLocalVal = periodAmount.subtract(localCount);
                destAmountVal = destLocalVal.multiply(rateVal);
            } else {
                destLocalVal = periodAmount.multiply(ratio).setScale(amtPrecision, RoundingMode.HALF_UP);
                destAmountVal = destLocalVal.multiply(rateVal).setScale(amtPrecision, RoundingMode.HALF_UP);
                localCount = localCount.add(destLocalVal);
            }
            this.changeRatioOrAmount(i, destAmountVal, destLocalVal);
        }
    }

    private BigDecimal getRatio(int curIndex) {
        BigDecimal rateVal = BigDecimal.ONE;
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return rateVal;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection destColl = model.getEntryEntity("destaccounts");
        DynamicObject rowDyn = (DynamicObject)destColl.get(curIndex);
        DynamicObject currencyDyn = rowDyn.getDynamicObject("destcurrency");
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        long currencyId = currencyDyn.getLong("id");
        Date newDate = new Date();
        if (baseCurrencyId != currencyId) {
            rateVal = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)newDate);
        }
        if (rateVal == null) {
            rateVal = BigDecimal.ONE;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u6c47\u7387\uff0c\u8bf7\u4fee\u6539\u5e01\u79cd\u3002", (String)"VoucherAmortSchemeEdit_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            model.setValue("destcurrency", (Object)0L, curIndex);
        }
        return rateVal;
    }

    private void changeDestAmountByCurPeriodAmount() {
        IDataModel model = this.getModel();
        String amortTypeVal = (String)model.getValue("amortstyle");
        if (!"3".equals(amortTypeVal)) {
            return;
        }
        BigDecimal periodAmount = (BigDecimal)model.getValue("curamortamount");
        DynamicObjectCollection destColl = model.getEntryEntity("destaccounts");
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return;
        }
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        Date newDate = new Date();
        BigDecimal localCount = BigDecimal.ZERO;
        int entrySize = destColl.size();
        BigDecimal destAmountVal = BigDecimal.ZERO;
        BigDecimal destLocalVal = BigDecimal.ZERO;
        BigDecimal destRatioVal = BigDecimal.ZERO;
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject rowDyn = (DynamicObject)destColl.get(i);
            DynamicObject currencyDyn = rowDyn.getDynamicObject("destcurrency");
            if (currencyDyn == null) continue;
            long currencyId = currencyDyn.getLong("id");
            int amtPrecision = currencyDyn.getInt("amtprecision");
            BigDecimal ratio = rowDyn.getBigDecimal("destratio") == null ? BigDecimal.ZERO : rowDyn.getBigDecimal("destratio").divide(this.oneHundred);
            BigDecimal rateVal = BigDecimal.ONE;
            if (baseCurrencyId != currencyId) {
                rateVal = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)baseCurrencyId, (Long)currencyId, (Date)newDate);
            }
            if (rateVal == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u6c47\u7387\uff0c\u8bf7\u4fee\u6539\u5e01\u79cd\u3002", (String)"VoucherAmortSchemeEdit_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                model.setValue("targetcurrency", (Object)0L);
                periodAmount = BigDecimal.ZERO;
                rateVal = BigDecimal.ZERO;
            }
            destRatioVal = destRatioVal.add(ratio);
            if (i + 1 == entrySize && destRatioVal.compareTo(BigDecimal.ONE) == 0) {
                destLocalVal = periodAmount.subtract(localCount);
                destAmountVal = destLocalVal.multiply(rateVal);
            } else {
                destLocalVal = periodAmount.multiply(ratio).setScale(amtPrecision, RoundingMode.HALF_UP);
                destAmountVal = destLocalVal.multiply(rateVal).setScale(amtPrecision, RoundingMode.HALF_UP);
                localCount = localCount.add(destLocalVal);
            }
            model.setValue("destamount", (Object)destAmountVal, i);
            model.setValue("destlocal", (Object)destLocalVal, i);
            this.changeRatioOrAmount(i, destAmountVal, destLocalVal);
        }
    }

    private void changeRatioOrAmount(int rowIndex, BigDecimal destAmountVal, BigDecimal destLocalVal) {
        IDataModel model = this.getModel();
        BigDecimal periodAmount = (BigDecimal)model.getValue("periodamortamount");
        if (VoucherAmortConstant.DestType.RATIO.getValue().equals(this.getModel().getValue("desttype", rowIndex)) || "true".equals(this.getDestTypeCash())) {
            model.setValue("destamount", (Object)destAmountVal, rowIndex);
            model.setValue("destlocal", (Object)destLocalVal, rowIndex);
        } else {
            periodAmount = periodAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : periodAmount;
            periodAmount = this.isDirectionConsistent() ? periodAmount.negate() : periodAmount;
            BigDecimal destRatioChangeVal = ((BigDecimal)model.getValue("destlocal", rowIndex)).divide(periodAmount, 4, RoundingMode.HALF_UP).multiply(this.oneHundred);
            model.setValue("destratio", (Object)destRatioChangeVal, rowIndex);
        }
    }

    private void setControlFilter() {
        BasedataEdit acctTarget = (BasedataEdit)this.getView().getControl("targetaccount");
        acctTarget.addBeforeF7SelectListener(e -> this.setAccountFilter(e));
        BasedataEdit acctDest = (BasedataEdit)this.getView().getControl("destaccount");
        acctDest.addBeforeF7SelectListener(e -> this.setAccountFilter(e));
    }

    private void setAccountFilter(BeforeF7SelectEvent e) {
        AccountBookInfo bookDyn = this.getBookByOrg();
        if (bookDyn != null) {
            QFBuilder acctFilterInVersioning = new VchAmortService(new VchAmortScheme(this.getModel().getDataEntity(true))).getAccountFilterInVersion(null);
            List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.removeIf(GLUtil::isLastVersionFilter);
            qFilters.addAll(acctFilterInVersioning.toList());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u201d\u548c\u201c\u8d26\u7c3f\u7c7b\u578b\u201d\u3002", (String)"VoucherAmortSchemeEdit_29", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private AccountBookInfo getBookByOrg() {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        long bookTypeId = (Long)model.getValue("accountbooks_id");
        if (orgId != 0L && bookTypeId != 0L) {
            return AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        }
        return null;
    }

    private void setDefaultValue(long orgId) {
        IDataModel model = this.getModel();
        String exchangeBook = this.getPageCache().get("exchangeBook");
        if (exchangeBook == null) {
            Map<String, Object> book = this.getAllBookByOrg(orgId);
            if (book != null) {
                if ("false".equals(book.get("ismultiplebook"))) {
                    model.setValue("ismultiplebook", (Object)"false");
                    model.setValue("currency", book.get("currency"));
                    model.setValue("vouchertype", book.get("vouchertype"));
                    model.setValue("accountbooks", book.get("accountbooks"));
                } else if ("true".equals(book.get("ismultiplebook"))) {
                    model.setValue("ismultiplebook", (Object)"true");
                    model.setValue("currency", book.get("currency"));
                    model.setValue("vouchertype", book.get("vouchertype"));
                    model.setValue("accountbooks", book.get("accountbooks"));
                }
            }
        } else {
            DynamicObject curOrg = (DynamicObject)this.getModel().getContextVariable("org");
            model.setValue("org", (Object)curOrg);
            this.getModel().setValue("ismultiplebook", (Object)"true");
            this.getPageCache().remove("exchangeBook");
        }
    }

    private Map<String, Object> getAllBookByOrg(Long orgId) {
        HashMap<String, Object> bookInfoMap = new HashMap<String, Object>();
        List bookIdList = AccSysUtil.getAllBookFromAccSys((long)orgId);
        if (bookIdList.isEmpty()) {
            bookInfoMap.put("ismultiplebook", "true");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8d26\u7c3f\u3002", (String)"VoucherAmortSchemeEdit_30", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else {
            bookInfoMap.put("ismultiplebook", bookIdList.size() > 1 ? "true" : "false");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object booktypeId = customParams.get("accountbooks");
            Map books = BusinessDataServiceHelper.loadFromCache((Object[])bookIdList.toArray(), (String)"gl_accountbook");
            DynamicObject book = null;
            if (booktypeId != null) {
                for (Long id : bookIdList) {
                    long btypeid = ((DynamicObject)books.get(id)).getLong("bookstype_id");
                    if (btypeid != Long.parseLong(booktypeId.toString())) continue;
                    book = (DynamicObject)books.get(id);
                    break;
                }
                if (book == null) {
                    book = (DynamicObject)books.get(bookIdList.get(0));
                }
            } else {
                book = (DynamicObject)books.get(bookIdList.get(0));
            }
            bookInfoMap.put("currency", book.getLong("basecurrency.id"));
            bookInfoMap.put("period", book.getLong("curperiod.id"));
            bookInfoMap.put("vouchertype", book.getLong("defaultvouchertype.id"));
            bookInfoMap.put("accountbooks", book.getLong("bookstype.id"));
            bookInfoMap.put("accounttable", book.getLong("accounttable.id"));
        }
        return bookInfoMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("thumbimg".equals(key)) {
            this.doFabulous();
        } else if ("addpolicie".equals(key)) {
            IDataModel dataModel = this.getModel();
            Object value = dataModel.getValue("accountbooks_id");
            if ("0".equals(value.toString())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d26\u7c3f", (String)"VoucherAmortSchemeEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        } else if ("targetassgrp".equals(key)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("targetaccounts");
            this.showAssgrpValue(index, "targetrowid");
        } else if ("destassgrp".equals(key)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("destaccounts");
            this.showAssgrpValue(index, "destrowid");
        }
    }

    public void doFabulous() {
        Long creator = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
        if (GLFabulousOperation.isCanThumbUp((long)creator, (String)"gl_voucheramortacheme")) {
            GLFabulousOperation.createFabulous((long)creator, (String)"gl_voucheramortacheme");
            this.setDefaultHeart();
        }
    }

    public void setDefaultHeart() {
        Long creator = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
        Label heart = (Label)this.getControl("heart");
        if (creator != 0L) {
            int heartQu = GLFabulousOperation.getFabulousOne((Long)creator, (String)"gl_voucheramortacheme", (boolean)false, (boolean)true);
            heart.setText(String.valueOf(heartQu));
        } else {
            heart.setText(String.valueOf(0));
        }
        if (!GLFabulousOperation.isThumbUp((long)creator, (String)"gl_voucheramortacheme")) {
            ((Image)this.getControl("thumbimg")).setUrl("/icons/pc/state/praised.png");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.putDestTypeCash("true");
        String entryName = e.getEntryProp().getName();
        RowDataEntity currow = e.getRowDataEntities()[0];
        IDataModel model = this.getModel();
        int curIndex = currow.getRowIndex();
        if ("destaccounts".equals(entryName)) {
            model.setValue("destrowid", (Object)this.genRowId(), curIndex);
            model.setValue("destratio", (Object)BigDecimal.ZERO, curIndex);
            DynamicObjectCollection coll = model.getEntryEntity("destaccounts");
            if (coll.size() > 1) {
                if (curIndex == 0) {
                    model.setValue("destdirection", ((DynamicObject)coll.get(1)).get("destdirection"), curIndex);
                } else {
                    model.setValue("destdirection", ((DynamicObject)coll.get(0)).get("destdirection"), curIndex);
                }
            }
        } else if ("targetaccounts".equals(entryName)) {
            DynamicObjectCollection coll = model.getEntryEntity("targetaccounts");
            int i = 0;
            for (DynamicObject row : coll) {
                String rowId = row.getString("targetrowid");
                if (StringUtils.isBlank((CharSequence)rowId)) {
                    model.setValue("targetrowid", (Object)this.genRowId(), i);
                }
                ++i;
            }
            if (coll.size() > 1) {
                if (curIndex == 0) {
                    model.setValue("plandirection", ((DynamicObject)coll.get(1)).get("plandirection"), curIndex);
                } else {
                    this.getModel().beginInit();
                    this.getModel().setValue("plandirection", ((DynamicObject)coll.get(0)).get("plandirection"), curIndex);
                    this.getModel().endInit();
                    this.getView().updateView("plandirection", curIndex);
                }
            }
        }
    }

    private void averPoliciesRatio() {
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = model.getEntryEntity("policies");
        if (coll == null || coll.size() == 0) {
            return;
        }
        BigDecimal totalAmountVal = (BigDecimal)model.getValue("totalamount");
        if (totalAmountVal.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal ratio = amount.multiply(this.oneHundred).divide(totalAmountVal, 2, RoundingMode.HALF_UP);
            model.setValue("policiesratio", (Object)ratio, i);
        }
    }

    private void policiesRatioDeal(int curIndex, BigDecimal curRatio, BigDecimal oldRatio, String fieldKey, String amountKey, String entryKey) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryKey);
        if (count == 1) {
            return;
        }
        DynamicObjectCollection coll = model.getEntryEntity(entryKey);
        BigDecimal upTotal = BigDecimal.ZERO;
        for (int i = 0; i < curIndex; ++i) {
            BigDecimal ratioVal = ((DynamicObject)coll.get(i)).getBigDecimal(fieldKey);
            upTotal = upTotal.add(ratioVal);
        }
        BigDecimal overVal = this.oneHundred.subtract(upTotal).subtract(curRatio);
        if (overVal.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue(fieldKey, (Object)oldRatio, curIndex);
            this.getView().showTipNotification(this.ratioNoEqualHundred());
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection policies = (DynamicObjectCollection)this.getModel().getValue("policies");
        DynamicObjectCollection custompolicies = (DynamicObjectCollection)this.getModel().getValue("custompolicies");
        custompolicies.stream().forEach(c -> c.set("isgenvoucher", (Object)(policies.stream().filter(p -> p.get("period_id").equals(c.get("cperiod_id"))).count() > 0L ? "1" : "0")));
        this.getView().updateView("custompolicies");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultHeart();
        DynamicObject book = (DynamicObject)this.getModel().getValue("accountbooks");
        if (book != null) {
            String bookId = book.getString("id");
            this.getPageCache().put("oldBookId", bookId);
        }
        this.setDestAmount();
        this.visibleAssgrp("targetaccounts");
        this.visibleAssgrp("destaccounts");
        this.setDateRangeFilter(false);
        this.setCurAmortAmount();
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rate"});
        }
        this.customeIsGenVoucher();
        this.enableTargetOriAndRate();
        this.getModel().setDataChanged(false);
    }

    private void customeIsGenVoucher() {
        if (AmortStyle.isCustome((String)this.getModel().getValue("amortstyle").toString())) {
            DynamicObjectCollection custompolicies = this.getModel().getEntryEntity("custompolicies");
            Optional<DynamicObject> isgenvoucher = custompolicies.stream().filter(v -> v.getBoolean("isgenvoucher")).findFirst();
            if (isgenvoucher.isPresent()) {
                this.getPageCache().put("isgenvoucher", "true");
            } else {
                this.getPageCache().put("isgenvoucher", "false");
            }
        }
    }

    private void setDestAmount() {
        IDataModel model = this.getModel();
        BigDecimal periodAmount = (BigDecimal)model.getValue("periodamortamount");
        DynamicObjectCollection coll = model.getEntryEntity("destaccounts");
        for (DynamicObject dyn : coll) {
            BigDecimal ratio = (BigDecimal)dyn.get("destratio");
            BigDecimal destAmountVal = dyn.getBigDecimal("destamount");
            if (destAmountVal != null && destAmountVal.compareTo(BigDecimal.ZERO) != 0) continue;
            dyn.set("destamount", (Object)periodAmount.multiply(ratio).divide(this.oneHundred));
        }
        this.getView().updateView("destaccounts");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equalsIgnoreCase("save")) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                this.getPageCache().put("save", "yes");
                this.getView().invokeOperation("save");
            } else {
                this.getPageCache().put("save", "no");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        model.setValue("status", (Object)"1");
        model.setValue("amortamount", (Object)BigDecimal.ZERO);
        model.getEntryEntity("policies").clear();
        this.afterCopyEntryData("targetaccounts", "targetrowid", "targetassgrp");
        this.afterCopyEntryData("destaccounts", "destrowid", "destassgrp");
        this.visibleAssgrp("targetaccounts");
        this.visibleAssgrp("destaccounts");
        model.setValue("planperiod", (Object)((BigDecimal)model.getValue("planperiod")).add((BigDecimal)model.getValue("amortperiod")));
        model.setValue("amortperiod", (Object)BigDecimal.ZERO);
        long curPeriodId = Objects.requireNonNull(this.getBookByOrg()).getCurPeriodId();
        long startPeriodId = (Long)model.getValue("startperiod_id");
        if (curPeriodId > startPeriodId) {
            model.setValue("startperiod", (Object)curPeriodId);
            if (AmortStyle.isCustome((String)((String)model.getValue("amortstyle")))) {
                this.amendCustomAmort();
            }
        }
        this.changePeriodAmortAmount();
        this.setCCurrency();
    }

    private void afterCopyEntryData(String entryKey, String rowIdKey, String assgrpKey) {
        HashMap<String, String> rowIdMap = new HashMap<String, String>(8);
        IDataModel model = this.getModel();
        Long orgId = (Long)model.getValue("org_id");
        IPageCache cache = this.getPageCache();
        int targetCount = model.getEntryRowCount(entryKey);
        for (int i = 0; i < targetCount; ++i) {
            String oldRowId = model.getValue(rowIdKey, i).toString();
            String newRowId = this.genRowId();
            rowIdMap.put(oldRowId, newRowId);
            DynamicObject newAssgrpDyn = FPFormUtil.copyFinalProcessAssgrpDyn(oldRowId, orgId, newRowId, orgId);
            if (newAssgrpDyn != null) {
                cache.put(newRowId, FPFormUtil.toDynamicObjectJson(newAssgrpDyn));
                model.setValue(assgrpKey, (Object)FPFormUtil.getDesc(newAssgrpDyn.getDynamicObjectCollection("entryentity"), FPAssgrpDescLengthConfig.fromProperty("gl_voucheramortacheme")), i);
            }
            model.setValue(rowIdKey, (Object)newRowId, i);
        }
        model.getEntryEntity("detailentry").forEach(detailRow -> {
            String originRowId = detailRow.getString("detailrowid");
            detailRow.set("detailrowid", (Object)rowIdMap.getOrDefault(originRowId, originRowId));
        });
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entry = e.getEntryProp();
        int[] rowIndexs = e.getRowIndexs();
        if ("policies".equals(entry.toString()) || "targetaccounts".equals(entry.toString())) {
            IDataModel model;
            if ("policies".equals(entry.toString())) {
                model = this.getModel();
                int count = model.getEntryRowCount("policies");
                for (int index : rowIndexs) {
                    if (count > index) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5220\u9664\u884c", (String)"VoucherAmortSchemeEdit_32", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
            if ("targetaccounts".equals(entry.toString())) {
                model = this.getModel();
                BigDecimal total = (BigDecimal)model.getValue("totalamount");
                for (int index : rowIndexs) {
                    BigDecimal amount = (BigDecimal)model.getValue("targetlocal", index);
                    if (amount == null) continue;
                    total = total.subtract(amount);
                }
                model.setValue("totalamount", (Object)total);
            }
            this.deleteAssgrp(entry.toString(), rowIndexs);
            Arrays.stream(rowIndexs).forEach(this::removeDetailEntry);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("amortabstract", (Object)ResManager.loadKDString((String)"\u51ed\u8bc1\u644a\u9500", (String)"VoucherAmortSchemeEdit_33", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        model.setValue("status", (Object)"1");
        this.setPeriodFilter();
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        if (creator != null) {
            Long creatorId = creator.getLong("id");
            Map<String, Object> dpt = GlFormUtil.getDptNameByUserId(creatorId);
            model.setValue("dptnames", dpt.get("dpt"));
        }
        this.setOrgFilter();
        long orgId = (Long)model.getValue("org_id");
        this.setDefaultValue(orgId);
        List orgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (orgIds == null || orgIds.size() == 0) {
            IFormView view = this.getView();
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"VoucherAmortSchemeEdit_34", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            view.setEnable(Boolean.valueOf(false), new String[]{"titlepanelflex", "contentpanelflex"});
            return;
        }
        if (!orgIds.contains(orgId)) {
            model.setValue("org", null);
        }
        this.visibleAssgrp("targetaccounts");
        this.visibleAssgrp("destaccounts");
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(false), new String[]{"org"});
        DynamicObjectCollection targetColl = this.getModel().getEntryEntity("targetaccounts");
        for (Object row : targetColl) {
            String rowId = row.getString("targetrowid");
            DynamicObject assgrpDyn = FPFormUtil.queryFinalProcessAssgrpDyn(rowId, (Long)this.getModel().getValue("org_id"));
            if (assgrpDyn != null) {
                String desc = FPFormUtil.getDesc(assgrpDyn.getDynamicObjectCollection("entryentity"), FPAssgrpDescLengthConfig.fromProperty("gl_voucheramortacheme"));
                row.set("targetassgrp", (Object)desc);
                continue;
            }
            row.set("targetassgrp", (Object)"");
        }
        DynamicObjectCollection destColl = this.getModel().getEntryEntity("destaccounts");
        for (DynamicObject row : destColl) {
            String rowId = row.getString("destrowid");
            DynamicObject assgrpDyn = FPFormUtil.queryFinalProcessAssgrpDyn(rowId, (Long)this.getModel().getValue("org_id"));
            if (assgrpDyn != null) {
                String desc = FPFormUtil.getDesc(assgrpDyn.getDynamicObjectCollection("entryentity"), FPAssgrpDescLengthConfig.fromProperty("gl_voucheramortacheme"));
                row.set("destassgrp", (Object)desc);
                continue;
            }
            row.set("destassgrp", (Object)"");
        }
        String status = (String)model.getValue("status");
        if ("2".equals(status)) {
            int targetCount = model.getEntryRowCount("targetaccounts");
            IntStream.range(0, targetCount).peek(i -> view.setEnable(Boolean.valueOf(false), i, new String[]{"targetaccount"})).filter(i -> !model.getValue("plantype", i).equals(PlanType.FIXED.getValue())).forEach(i -> view.setEnable(Boolean.valueOf(false), i, new String[]{"planamount"}));
            DynamicObjectCollection collection = model.getEntryEntity("policies");
            int index = 0;
            for (DynamicObject dyn : collection) {
                if (dyn.getBoolean("isvouchered")) {
                    view.setEnable(Boolean.valueOf(false), index, new String[]{"policies"});
                }
                ++index;
            }
        }
        this.averPoliciesRatio();
        this.setCCurrency();
        if (AmortStyle.DATE.getValue().equals(model.getValue("amortstyle"))) {
            if ("2".equals(status)) {
                view.setEnable(Boolean.valueOf(false), new String[]{"begindate"});
                view.setEnable(Boolean.valueOf(true), new String[]{"enddate"});
            } else if ("3".equals(status)) {
                view.setEnable(Boolean.valueOf(false), new String[]{"begindate"});
                view.setEnable(Boolean.valueOf(false), new String[]{"enddate"});
            }
        }
    }

    private void setPeriodFilter() {
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener(e -> {
            IDataModel model = this.getModel();
            long orgId = (Long)model.getValue("org_id");
            long bookTypeId = (Long)model.getValue("accountbooks_id");
            if (orgId != 0L && bookTypeId != 0L) {
                AccountBookInfo bookDyn = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
                long curPeriodId = bookDyn.getCurPeriodId();
                long periodType = bookDyn.getPeriodTypeId();
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                QFilter curfilter = new QFilter("id", ">=", (Object)curPeriodId);
                QFilter typefilter = new QFilter("periodtype", "=", (Object)periodType);
                list.add(curfilter);
                list.add(typefilter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(list);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a", (String)"VoucherAmortSchemeEdit_35", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
            }
        });
    }

    private void setOrgFilter() {
        BasedataEdit orgBd = (BasedataEdit)this.getControl("org");
        if (orgBd != null) {
            List orgList = AccSysUtil.getAcctOrgPkList((String)"gl_voucheramortacheme", (boolean)false, (PermissonType)PermissonType.VIEW);
            QFilter orgf = new QFilter("id", "in", (Object)orgList);
            orgBd.setQFilter(orgf);
            long orgId = (Long)this.getModel().getValue("org_id");
            if (!orgList.isEmpty() && !orgList.contains(orgId)) {
                this.getModel().setValue("org", orgList.get(0));
            }
        }
    }

    private String genRowId() {
        return UUID.randomUUID().toString();
    }

    public void showAssgrpValue(int index, String rowKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gl_finalprocess_assgrp");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        String accountRowId = (String)model.getValue(rowKey, index);
        String type = "targetaccounts";
        String accountKey = "targetaccount";
        if ("destrowid".equals(rowKey)) {
            type = "destaccounts";
            accountKey = "destaccount";
        }
        long bookstypeId = (Long)model.getValue("accountbooks_id");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        map.put("index", index + "");
        map.put("orgId", orgId);
        map.put("bookstypeId", bookstypeId);
        map.put("accountId", model.getValue(accountKey + "_id") + "");
        map.put("accountRowId", accountRowId);
        String strObj = this.getPageCache().get(accountRowId);
        map.put("value", strObj);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, accountRowId));
        this.getView().showForm(parameter);
    }

    private void visibleAssgrp(String entry) {
        IDataModel model = this.getModel();
        String assgrpKey = "";
        String accountKey = "";
        if ("targetaccounts".equals(entry)) {
            assgrpKey = "targetassgrp";
            accountKey = "targetaccount";
        } else if ("destaccounts".equals(entry)) {
            assgrpKey = "destassgrp";
            accountKey = "destaccount";
        }
        IFormView view = this.getView();
        DynamicObjectCollection coll = model.getEntryEntity(entry);
        boolean flag = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject accountDyn = row.getDynamicObject(accountKey);
            if (accountDyn == null || !accountDyn.getBoolean("isassist")) continue;
            flag = true;
        }
        view.setVisible(Boolean.valueOf(flag), new String[]{assgrpKey});
    }

    private void deleteAssgrp(String entry, int[] index) {
        String rowIdKey = "";
        if ("targetaccounts".equals(entry)) {
            rowIdKey = "targetrowid";
        } else if ("destaccounts".equals(entry)) {
            rowIdKey = "destrowid";
        }
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        ArrayList<String> rowIdlist = new ArrayList<String>();
        for (int i : index) {
            String rowIdVal = (String)model.getValue(rowIdKey, i);
            if (StringUtils.isBlank((CharSequence)rowIdVal)) continue;
            this.getPageCache().remove(rowIdVal);
            rowIdlist.add(rowIdVal);
        }
        Object pkId = model.getDataEntity().getPkValue();
        if (pkId != null) {
            QFilter fassgrpRow = new QFilter("assgrprow", "in", rowIdlist);
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            DeleteServiceHelper.delete((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{forg, fassgrpRow});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs op) {
        super.afterDoOperation(op);
        String operateKey = op.getOperateKey();
        if ("deletevoucher".equalsIgnoreCase(operateKey) && op.getOperationResult().isSuccess()) {
            this.updateModel();
        } else if ("queryvoucher".equalsIgnoreCase(operateKey) && op.getOperationResult().isSuccess()) {
            FPFormUtil.queryVcouher(this.getView());
        }
        this.customeIsGenVoucher();
    }

    private void updateModel() {
        IBillView view = (IBillView)this.getView();
        view.load(this.getModel().getDataEntity().getPkValue());
    }

    private DynamicObject newExpDyn(DynamicObject oldAssgrpDyn) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)"gl_finalprocess_assgrp");
        newExpDyn.set("org", (Object)oldAssgrpDyn.getLong("org_id"));
        newExpDyn.set("assgrprow", (Object)oldAssgrpDyn.getString("assgrprow"));
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection coll = oldAssgrpDyn.getDynamicObjectCollection("entryentity");
        newColl.clear();
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set("fieldname", row.get("fieldname_id"));
            DynamicObjectCollection mulBaseColl = row.getDynamicObjectCollection("value");
            DynamicObjectCollection newMulBaseColl = newRow.getDynamicObjectCollection("value");
            for (DynamicObject mulRow : mulBaseColl) {
                long id = mulRow.getLong("fbasedataid_id");
                DynamicObject mulBaseRow = new DynamicObject(mulBaseColl.getDynamicObjectType());
                mulBaseRow.set("fbasedataid_id", (Object)id);
                newMulBaseColl.add((Object)mulBaseRow);
            }
            newRow.set("value", (Object)newMulBaseColl);
            newRow.set("txtval", row.get("txtval"));
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }

    private void putDestTypeCash(String value) {
        this.getPageCache().put("destTypeCash", value);
    }

    private String getDestTypeCash() {
        return this.getPageCache().get("destTypeCash");
    }

    private void setCCurrency() {
        this.getModel().setValue("ccurrency", this.getModel().getValue("targetcurrency", 0));
    }

    private void updateCustomPoliciesView() {
        for (int i = 0; i < this.getModel().getEntryEntity("custompolicies").size(); ++i) {
            this.getModel().setValue("camount", null, i);
        }
        this.getView().updateView("custompolicies");
    }

    public String ratioNoEqualHundred() {
        return ResManager.loadKDString((String)"\u8f6c\u5165\u79d1\u76ee\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"VoucherAmortSchemeEdit_36", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map map = e.getSourceData();
        ArrayList<DynamicObject> assistList = new ArrayList<DynamicObject>();
        Map startPeriod = (Map)map.get("startperiod");
        Map org = (Map)map.get("org");
        Map bookType = (Map)map.get("accountbooks");
        String amortstyle = map.get("amortstyle").toString();
        String billNo = (String)map.get("number");
        if (!this.isNumberMatches((String)map.get("planperiod"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u5f85\u644a\u671f\u95f4\u6570\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_59", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        if (map.get("planperiod").equals("0")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u5f85\u644a\u671f\u95f4\u6570\u4e0d\u80fd\u4e3a0\u3002", (String)"VoucherAmortSchemeEdit_65", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        if (!AmortStyle.AVERAGE.getValue().equals(amortstyle) && !AmortStyle.CUSTOME.getValue().equals(amortstyle)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u644a\u9500\u65b9\u5f0f\u4e0d\u652f\u6301\u3002", (String)"VoucherAmortSchemeEdit_41", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        QFilter orgFilter = new QFilter("number", "=", org.get("number"));
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])orgFilter.toArray());
        if (orgDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_48", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        Long orgId = orgDyn.getLong("id");
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", bookType.get("number"))});
        if (bookTypeDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"VoucherAmortSchemeEdit_64", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        Long bookTypeId = bookTypeDyn.getLong("id");
        DynamicObject accountBookDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"periodtype,exratetable,basecurrency,basecurrency.amtprecision amtprecision,accounttable,curperiod,isbizunit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bookstype", "=", (Object)bookTypeId)});
        if (accountBookDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_47", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        if (!accountBookDyn.getBoolean("isbizunit")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_66", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        Long exrateTableId = accountBookDyn.getLong("exratetable");
        Long baseCurrencyId = accountBookDyn.getLong("basecurrency");
        Long accountTable = accountBookDyn.getLong("accounttable");
        Long curperiod = accountBookDyn.getLong("curperiod");
        int amtprecision = accountBookDyn.getInt("amtprecision");
        HashMap<String, Long> currency = new HashMap<String, Long>(3);
        currency.put("id", baseCurrencyId);
        map.put("currency", currency);
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", accountBookDyn.get("periodtype")), new QFilter("number", "=", startPeriod.get("number"))});
        if (periodDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u5f00\u59cb\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"VoucherAmortSchemeEdit_46", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        if (periodDyn.getLong("id") < curperiod) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u5f00\u59cb\u671f\u95f4\u65e9\u4e8e\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_49", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
        }
        startPeriod.put("id", periodDyn.getLong("id"));
        BigDecimal totalamount = BigDecimal.ZERO;
        List targetaccounts = (List)map.get("targetaccounts");
        Map<String, Currency> currencyNumber2Dyn = this.getCurrencyNumber2Dyn(targetaccounts, "targetcurrency");
        Map<String, DynamicObject> acctnum2Dyn = this.getAcctnum2Dyn(targetaccounts, orgId, accountTable, "targetaccount");
        int index = 0;
        for (Map targetaccount : targetaccounts) {
            List<Long> assists;
            Map<String, Object> result;
            DynamicObject value;
            ++index;
            String number = ((Map)targetaccount.get("targetaccount")).get("number").toString();
            Object accId = null;
            DynamicObject accountDyn = acctnum2Dyn.get(number);
            if (accountDyn != null) {
                accId = accountDyn.getLong("id");
                this.checkIsFinancialAcc(accountDyn, billNo, index);
            }
            if (accId == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u79d1\u76ee\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_43", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
            }
            ((Map)targetaccount.get("targetaccount")).put("id", accId);
            Currency currencyDyn = currencyNumber2Dyn.get(((Map)targetaccount.get("targetcurrency")).get("number"));
            if (currencyDyn == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"VoucherAmortSchemeEdit_61", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
            }
            BigDecimal newRate = BigDecimal.ONE;
            Long currencyId = currencyDyn.getId();
            int targetAmtprecision = currencyDyn.getAmtprecision();
            ((Map)targetaccount.get("targetcurrency")).put("id", currencyId);
            String plantype = targetaccount.get("plantype").toString();
            if (PlanType.VOUCHER.getValue().equals(plantype)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u6682\u4e0d\u652f\u6301\u6309\u51ed\u8bc1\u53f7\u7684\u53d6\u503c\u6765\u6e90\u3002", (String)"VoucherAmortSchemeEdit_40", (String)"fi-gl-formplugin", (Object[])new Object[0]), number));
            }
            if (!this.checkCurrency(accountDyn, currencyId, baseCurrencyId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u5f85\u644a\u79d1\u76ee\u5e01\u79cd\u4e0d\u8fdb\u884c\u6838\u7b97\u3002", (String)"VoucherAmortSchemeEdit_53", (String)"fi-gl-formplugin", (Object[])new Object[0]), number, index));
            }
            if (plantype.equals(PlanType.VOUCHER.getValue())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f%2$s\u6761\u5206\u5f55\u6682\u4e0d\u652f\u6301\u6309\u51ed\u8bc1\u53f7\u53d6\u503c\u3002", (String)"VoucherAmortSchemeEdit_45", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
            }
            if (PlanType.FIXED.getValue().equals(plantype)) {
                if (!targetaccount.containsKey("planamount")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7684%2$s\u6761\u5206\u5f55\u79d1\u76ee\u5f85\u644a\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"VoucherAmortSchemeEdit_51", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, number));
                }
                if (!this.isNumberMatches((String)targetaccount.get("planamount"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u5f85\u644a\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_62", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
                }
            }
            if (currencyId.compareTo(baseCurrencyId) != 0 && (newRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)new Date())) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7684%2$s\u6761\u5206\u5f55\u79d1\u76ee\u5e01\u79cd\u672a\u8bbe\u7f6e\u6c47\u7387\u3002", (String)"VoucherAmortSchemeEdit_58", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, number));
            }
            targetaccount.put("rate", newRate);
            String rowId = this.genRowId();
            targetaccount.put("targetrowid", rowId);
            String targetassgrp = (String)targetaccount.get("targetassgrp");
            QueryParam param = this.getQueryParam((Long)accId, currencyId);
            if (!StringUtils.isEmpty((CharSequence)targetassgrp) && (value = (DynamicObject)(result = this.newAmortassgrp(targetassgrp, assists = VoucherAmortSchemeEdit.queryAccountAssist((Long)accId), orgId, rowId, billNo, index)).get("dyn")) != null) {
                DynamicObjectCollection entryEntity = value.getDynamicObjectCollection("entryentity");
                Set assGrpIds = FinalProcessAssgrp.create((DynamicObjectCollection)entryEntity).getHgIds();
                param.setAssGrpIds(assGrpIds);
                assistList.add(value);
                targetaccount.put("targetassgrp", result.get("msg"));
            }
            BigDecimal targetLocal = BigDecimal.ZERO;
            if (plantype.equals(PlanType.ENDLOCAL.getValue())) {
                Tuple<BigDecimal, BigDecimal> endfor = this.getBalanceAmountForImport(orgId, bookTypeId, accountTable, "account,assgrp,endfor,endlocal", param);
                if (((BigDecimal)endfor.item1).compareTo(BigDecimal.ZERO) == 0 || ((BigDecimal)endfor.item2).compareTo(BigDecimal.ZERO) == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7684%2$s\u6761\u5206\u5f55\u79d1\u76ee\u671f\u672b\u4f59\u989d\u4e3a0\u3002", (String)"VoucherAmortSchemeEdit_44", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
                }
                targetaccount.put("planamount", ((BigDecimal)endfor.item1).setScale(targetAmtprecision, RoundingMode.HALF_UP));
                int scale = RateServiceHelper.getRatePrecision((Long)currencyId, (Long)baseCurrencyId, (Long)exrateTableId, (Date)new Date());
                targetLocal = ((BigDecimal)endfor.item2).setScale(amtprecision, RoundingMode.HALF_UP);
                newRate = ((BigDecimal)endfor.item2).divide((BigDecimal)endfor.item1, Math.min(scale, 4), RoundingMode.HALF_UP);
                targetaccount.put("rate", newRate);
            } else {
                targetLocal = new BigDecimal(targetaccount.get("planamount").toString()).multiply(newRate).setScale(amtprecision, RoundingMode.HALF_UP);
            }
            targetaccount.put("targetlocal", targetLocal);
            totalamount = totalamount.add(targetLocal);
        }
        map.put("totalamount", totalamount.setScale(amtprecision, RoundingMode.HALF_UP));
        BigDecimal periodamortamount = totalamount.divide(new BigDecimal(map.get("planperiod").toString()), totalamount.scale(), RoundingMode.HALF_UP);
        map.put("periodamortamount", periodamortamount);
        if (AmortStyle.CUSTOME.getValue().equals(amortstyle)) {
            if (!map.containsKey("custompolicies")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f,\u6ca1\u6709\u81ea\u5b9a\u4e49\u644a\u9500\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u644a\u9500\u65b9\u5f0f\u3002", (String)"VoucherAmortSchemeEdit_55", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
            }
            List custompolicies = (List)map.get("custompolicies");
            int index2 = 1;
            for (Map custompolicie : custompolicies) {
                ++index2;
                Map cperiod = (Map)custompolicie.get("cperiod");
                DynamicObject customPeriodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", accountBookDyn.get("periodtype")), new QFilter("number", "=", cperiod.get("number"))});
                if (customPeriodDyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f,\u7b2c%2$s\u6761\u5206\u5f55\u81ea\u5b9a\u4e49\u644a\u9500\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5728\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_42", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index2));
                }
                if (customPeriodDyn.getLong("id") < curperiod) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f,\u7b2c%2$s\u6761\u5206\u5f55\u81ea\u5b9a\u4e49\u644a\u9500\u4f1a\u8ba1\u671f\u95f4\u65e9\u4e8e\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_50", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index2));
                }
                if (!this.isNumberMatches((String)custompolicie.get("camount"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f,\u7b2c%2$s\u6761\u5206\u5f55\u81ea\u5b9a\u4e49\u644a\u9500\u5f85\u644a\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_63", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index2));
                }
                cperiod.put("id", customPeriodDyn.get("id"));
            }
        }
        List destaccounts = (List)map.get("destaccounts");
        int index1 = 0;
        boolean destTypeFix = false;
        boolean destTypeRatio = false;
        BigDecimal destRatio = BigDecimal.ZERO;
        BigDecimal destAmount = BigDecimal.ZERO;
        acctnum2Dyn = this.getAcctnum2Dyn(destaccounts, orgId, accountTable, "destaccount");
        currencyNumber2Dyn = this.getCurrencyNumber2Dyn(destaccounts, "destcurrency");
        for (Map destaccount : destaccounts) {
            List<Long> assists;
            Map<String, Object> result;
            Object value;
            ++index1;
            String number = ((Map)destaccount.get("destaccount")).get("number").toString();
            Long accId = null;
            DynamicObject accountDyn = acctnum2Dyn.get(number);
            if (accountDyn != null) {
                accId = accountDyn.getLong("id");
                this.checkIsFinancialAcc(accountDyn, billNo, index1);
            }
            if (accId == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u79d1\u76ee\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_43", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
            }
            Currency currencyDyn = currencyNumber2Dyn.get(((Map)destaccount.get("destcurrency")).get("number"));
            if (currencyDyn == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"VoucherAmortSchemeEdit_61", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
            }
            BigDecimal newRate = BigDecimal.ONE;
            Long currencyId = currencyDyn.getId();
            int destAmtprecision = currencyDyn.getAmtprecision();
            ((Map)destaccount.get("destcurrency")).put("id", currencyId);
            if (!this.checkCurrency(accountDyn, currencyId, baseCurrencyId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8f6c\u5165\u79d1\u76ee\u5e01\u79cd\u4e0d\u8fdb\u884c\u6838\u7b97\u3002", (String)"VoucherAmortSchemeEdit_54", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
            }
            if (currencyId.compareTo(baseCurrencyId) != 0 && (newRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)new Date())) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8f6c\u5165\u79d1\u76ee\u5e01\u79cd\u672a\u8bbe\u7f6e\u6c47\u7387\u3002", (String)"VoucherAmortSchemeEdit_57", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
            }
            ((Map)destaccount.get("destaccount")).put("id", accId);
            if ("2".equals(destaccount.get("desttype"))) {
                destTypeFix = true;
            } else {
                destTypeRatio = true;
            }
            if (AmortStyle.AVERAGE.getValue().equals(amortstyle)) {
                BigDecimal destAmountRow = BigDecimal.ZERO;
                BigDecimal destLocalRow = BigDecimal.ZERO;
                BigDecimal destRatioRow = BigDecimal.ZERO;
                switch ((String)destaccount.get("desttype")) {
                    case "1": {
                        String rowDestRatio = (String)destaccount.get("destratio");
                        if (!this.isNumberMatches(rowDestRatio)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u6bd4\u4f8b\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_60", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
                        }
                        destRatioRow = new BigDecimal(rowDestRatio);
                        if (destRatioRow.compareTo(BigDecimal.ZERO) == 0) break;
                        destLocalRow = periodamortamount.multiply(destRatioRow).divide(this.oneHundred, amtprecision, RoundingMode.HALF_UP);
                        destAmountRow = destLocalRow.divide(newRate, destAmtprecision, RoundingMode.HALF_UP);
                        break;
                    }
                    case "2": {
                        if (destaccount.get("destlocal") == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8f6c\u5165\u79d1\u76ee\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\u91d1\u989d\u3002", (String)"VoucherAmortSchemeEdit_78", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
                        }
                        if (destaccount.get("destamount") == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8f6c\u5165\u79d1\u76ee\u672a\u8bbe\u7f6e\u539f\u5e01\u91d1\u989d\u3002", (String)"VoucherAmortSchemeEdit_79", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
                        }
                        destLocalRow = new BigDecimal(String.valueOf(destaccount.get("destlocal")));
                        destAmountRow = currencyId.compareTo(baseCurrencyId) == 0 ? destLocalRow : new BigDecimal(String.valueOf(destaccount.get("destamount")));
                        destRatioRow = destLocalRow.divide(periodamortamount, 4, RoundingMode.HALF_UP).multiply(this.oneHundred).setScale(2, RoundingMode.HALF_UP);
                        break;
                    }
                }
                destaccount.put("destamount", destAmountRow);
                destaccount.put("destlocal", destLocalRow);
                destaccount.put("destratio", destRatioRow);
                destAmount = destAmount.add(destLocalRow);
                destRatio = destRatio.add(destRatioRow);
            } else {
                String rowDestRatio = (String)destaccount.get("destratio");
                if (!this.isNumberMatches(rowDestRatio)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u6bd4\u4f8b\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_60", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index1));
                }
                if ("2".equals(destaccount.get("desttype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f,\u4e0d\u652f\u6301\u6309\u56fa\u5b9a\u503c\u65b9\u5f0f\u3002", (String)"VoucherAmortSchemeEdit_52", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
                }
            }
            String rowId = this.genRowId();
            destaccount.put("destrowid", rowId);
            String targetassgrp = (String)destaccount.get("destassgrp");
            if (StringUtils.isEmpty((CharSequence)targetassgrp) || (value = (result = this.newAmortassgrp(targetassgrp, assists = VoucherAmortSchemeEdit.queryAccountAssist(accId), orgId, rowId, billNo, index1)).get("dyn")) == null) continue;
            assistList.add((DynamicObject)value);
            destaccount.put("destassgrp", result.get("msg"));
        }
        if (AmortStyle.AVERAGE.getValue().equals(amortstyle)) {
            if (destTypeFix && destTypeRatio) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u8f6c\u5165\u79d1\u76ee\u53d6\u503c\u65b9\u5f0f\u53ea\u652f\u6301\u5168\u4e3a\u6309\u6bd4\u4f8b\u6216\u8005\u5168\u4e3a\u6309\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u8f6c\u5165\u79d1\u76ee\u5206\u5f55\u4e2d\u53d6\u503c\u65b9\u5f0f\u3002", (String)"VoucherAmortSchemeEdit_75", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
            }
            if (destTypeFix && destAmount.compareTo(periodamortamount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\uff0c\u6bcf\u671f\u644a\u9500\u91d1\u989d\u548c\u8f6c\u5165\u79d1\u76ee\u672c\u4f4d\u5e01\u91d1\u989d\u4e4b\u548c\u4e0d\u5e73\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_76", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
            }
            if (destTypeRatio && destRatio.compareTo(this.oneHundred) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6a21\u677f\u7684\u8f6c\u5165\u79d1\u76ee\u5206\u5f55\u4e2d\u6bd4\u4f8b\u76f8\u52a0\u4e0d\u7b49\u4e8e100\uff0c\u8bf7\u68c0\u67e5\u8f6c\u5165\u79d1\u76ee\u5206\u5f55\u3002", (String)"VoucherAmortSchemeEdit_77", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo));
            }
        }
        map.put("status", "1");
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_finalprocess_assgrp"), (Object[])assistList.toArray(new DynamicObject[0]));
    }

    private void checkIsFinancialAcc(DynamicObject dyn, String billNo, int index) {
        if (AccountType.isBudGetType((String)dyn.getString("accounttype.accounttype"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u5f85\u644a / \u8f6c\u5165\u79d1\u76ee\u4e0d\u80fd\u4e3a\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"VoucherAmortSchemeEdit_80", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
        }
    }

    private Map<String, DynamicObject> getAcctnum2Dyn(List<Map<String, Object>> targetaccounts, Long orgId, Long accountTable, String field) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(targetaccounts.size());
        ArrayList<String> acctNumbers = new ArrayList<String>(targetaccounts.size());
        for (Map<String, Object> targetaccount : targetaccounts) {
            acctNumbers.add(((Map)targetaccount.get(field)).get("number").toString());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("accounttable", "=", (Object)accountTable));
        QFilter qids = AccountUtils.getAccountDataFilter((long)orgId, (long)accountTable);
        filters.add(qids);
        filters.add(new QFilter("number", "in", acctNumbers));
        filters.add(new QFilter("enddate", "=", (Object)this.getEndDate()));
        Map dynmap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id,number,acctcurrency,currencyentry.currency,accounttype.accounttype", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject dyn : dynmap.values()) {
            map.put(dyn.getString("number"), dyn);
        }
        return map;
    }

    private Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException("date parse error");
        }
    }

    private Map<String, Currency> getCurrencyNumber2Dyn(List<Map<String, Object>> targetaccounts, String field) {
        ArrayList<String> currencyNumbers = new ArrayList<String>(targetaccounts.size());
        HashMap<String, Currency> map = new HashMap<String, Currency>(targetaccounts.size());
        for (Map<String, Object> targetaccount : targetaccounts) {
            currencyNumbers.add(((Map)targetaccount.get(field)).get("number").toString());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#getCurrencyNumber2Dyn"), (String)"bd_currency", (String)"id,amtprecision,number", (QFilter[])new QFilter("number", "in", currencyNumbers).toArray(), null);){
            for (Row row : ds) {
                Currency currency = new Currency();
                currency.setId(row.getLong("id"));
                currency.setAmtprecision(row.getInteger("amtprecision"));
                map.put(row.getString("number"), currency);
            }
        }
        return map;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.checkForSave(null);
    }

    private Map<String, Object> newAmortassgrp(String assgrp, List<Long> assists, Long org, String autorowid, String number, int index) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String[] assgrpArray = assgrp.split(";");
        HashMap<String, String[]> map = new HashMap<String, String[]>(assgrpArray.length);
        ArrayList<String> assgrpName = new ArrayList<String>(assgrpArray.length);
        for (int i = 0; i < assgrpArray.length; ++i) {
            String[] keyValue = assgrpArray[i].split(":");
            if (keyValue.length > 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u6838\u7b97\u7ef4\u5ea6\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"VoucherAmortSchemeEdit_39", (String)"fi-gl-formplugin", (Object[])new Object[0]), number, index));
            }
            if (keyValue.length == 1) {
                map.put(keyValue[0], new String[0]);
            } else {
                String[] values = keyValue[1].split(",");
                map.put(keyValue[0], values);
            }
            assgrpName.add(keyValue[0]);
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        list.add(new QFilter("id", "in", assists));
        list.add(new QFilter("name", "in", assgrpName));
        List asstactTypeEntityList = new AsstactTypeConstant().loadEntity(list, new PropertyKey[]{AsstactTypeConstant.Entity_ID, AsstactTypeConstant.Entity_Name, AsstactTypeConstant.Entity_Number, AsstactTypeConstant.Entity_BaseDataType, AsstactTypeConstant.Entity_AssistantType, AsstactTypeConstant.Entity_ValueType});
        if (!asstactTypeEntityList.isEmpty()) {
            int count = 0;
            MainEntityType autoExpEntityType = EntityMetadataCache.getDataEntityType((String)"gl_finalprocess_assgrp");
            DynamicObject assgrpEntity = (DynamicObject)autoExpEntityType.createInstance();
            assgrpEntity.set("org", (Object)org);
            assgrpEntity.set("assgrprow", (Object)autorowid);
            block7: for (DynamicEntity asstactTypeEntity : asstactTypeEntityList) {
                String asstactTypeName = asstactTypeEntity.getLocalString(AsstactTypeConstant.Entity_Name);
                CharSequence[] asstactValueNumber = (String[])map.get(asstactTypeName);
                QFilter numberFilter = AssistantDataDetailConstant.Entity_Number.getFilter("in", (Object)asstactValueNumber);
                String valueSource = asstactTypeEntity.getInnerString(new PropertyKey[]{AsstactTypeConstant.Entity_BaseDataType, BaseDataConstant.Entity_Number});
                String valueType = asstactTypeEntity.getString(AsstactTypeConstant.Entity_ValueType);
                switch (AssistValueType.getTypeEnum((String)valueType)) {
                    case baseData: {
                        Optional<QFilter> baseDataF = Optional.ofNullable(BaseDataServiceHelper.getBaseDataFilter((String)valueSource, (Long)org));
                        baseDataF.ifPresent(arg_0 -> ((QFilter)numberFilter).and(arg_0));
                        break;
                    }
                    case assistData: {
                        valueSource = "bos_assistantdata_detail";
                        numberFilter.and(AssistantDataDetailConstant.Entity_Group.getFilter("=", (Object)asstactTypeEntity.getLong(AsstactTypeConstant.Entity_AssistantType)));
                        break;
                    }
                    case manualTxt: {
                        break;
                    }
                    case none: {
                        continue block7;
                    }
                }
                DynamicObjectCollection entrys = assgrpEntity.getDynamicObjectCollection("entryentity");
                DynamicObject row = entrys.addNew();
                row.set("fieldname_id", (Object)asstactTypeEntity.getLong(AsstactTypeConstant.Entity_ID));
                BusinessDataServiceHelper.loadRefence((Object[])new Object[]{row}, (IDataEntityType)row.getDataEntityType());
                if (AssistValueType.isManualTxt((String)valueType)) {
                    row.set("txtval", (Object)String.join((CharSequence)";", asstactValueNumber));
                    ++count;
                    continue;
                }
                DynamicObjectCollection multiBaseDataValueEntry = row.getDynamicObjectCollection("value");
                DynamicObjectCollection assistItemValueDOC = QueryServiceHelper.query((String)valueSource, (String)"id,name,number", (QFilter[])new QFilter[]{numberFilter});
                for (DynamicObject assistItemValue : assistItemValueDOC) {
                    assgrp = assgrp.replace(assistItemValue.getString("number"), assistItemValue.getString("name"));
                    DynamicObject mulBaseRow = new DynamicObject(multiBaseDataValueEntry.getDynamicObjectType());
                    mulBaseRow.set("fbasedataid", assistItemValue.get("id"));
                    mulBaseRow.set("fbasedataid_id", assistItemValue.get("id"));
                    multiBaseDataValueEntry.add((Object)mulBaseRow);
                }
                ++count;
            }
            if (count > 0) {
                result.put("dyn", assgrpEntity);
                result.put("msg", assgrp);
            }
        }
        return result;
    }

    private static List<Long> queryAccountAssist(Long accountId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem asstactitem", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
        for (DynamicObject dyn : dyns) {
            idList.add(dyn.getLong("asstactitem"));
        }
        idList.remove(0L);
        return idList;
    }

    private Tuple<BigDecimal, BigDecimal> getBalanceAmountForImport(Long orgId, Long bookTypeId, Long accountTableId, String selector, QueryParam queryParam) {
        Tuple res;
        Long beginPeriodId;
        Long endPeriodId = beginPeriodId = Long.valueOf(TaxReportFormHelper.getCurPeriod((long)orgId, (long)bookTypeId));
        try (DataSet dt = BalanceQueryExecutor.getInstance().getBalance(selector, new Long[]{orgId}, bookTypeId.longValue(), accountTableId.longValue(), beginPeriodId.longValue(), endPeriodId.longValue(), queryParam);){
            Iterator irow = dt.iterator();
            BigDecimal totalOri = BigDecimal.ZERO;
            BigDecimal totalLoc = BigDecimal.ZERO;
            if (irow.hasNext()) {
                while (irow.hasNext()) {
                    Row next = (Row)irow.next();
                    totalOri = totalOri.add(next.getBigDecimal("endfor"));
                    totalLoc = totalLoc.add(next.getBigDecimal("endlocal"));
                }
                res = new Tuple((Object)totalOri, (Object)totalLoc);
            } else {
                res = new Tuple((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
            }
        }
        return res;
    }

    private QueryParam getQueryParam(Long accId, Long currencyId) {
        QueryParam param = new QueryParam();
        param.setAccountFilter(new QFilter("id", "=", (Object)accId));
        param.setCurrencyIds(new Long[]{currencyId});
        param.setOnlyLeafAcctBal(true);
        param.setZeroBalNoDisplay(true);
        return param;
    }

    private boolean checkForSave(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        if (AmortStyle.isCustome((String)model.getValue("amortstyle").toString()) ? !this.customAmortCheck(args) : !this.noCustomAmortCheck(args)) {
            return false;
        }
        DynamicObjectCollection destColl = model.getEntryEntity("destaccounts");
        int destdirction = 0;
        for (DynamicObject dyn : destColl) {
            int dirction = dyn.getInt("destdirection");
            if (destdirction == 0) {
                destdirction = dirction;
                continue;
            }
            if (destdirction == dirction) continue;
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8f6c\u5165\u79d1\u76ee\u7684\u751f\u6210\u65b9\u5411\uff0c\u8f6c\u5165\u7684\u751f\u6210\u65b9\u5411\u5fc5\u987b\u4e00\u81f4\u3002", (String)"VoucherAmortSchemeEdit_69", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (((BigDecimal)model.getValue("totalamount")).compareTo(BigDecimal.ZERO) == 0) {
            this.setCancelInfo(args, ResManager.loadKDString((String)"\u5f85\u644a\u79d1\u76ee\u91d1\u989d\u76f8\u52a0\u4e3a0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u51ed\u8bc1\uff0c\u8bf7\u91cd\u65b0\u5efa\u7acb\u51ed\u8bc1\u644a\u9500\u65b9\u6848\u3002", (String)"VoucherAmortSchemeEdit_56", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection targetColl = model.getEntryEntity("targetaccounts");
        DynamicObjectCollection targetCollCopy = (DynamicObjectCollection)targetColl.clone();
        Iterator targeIterator = targetCollCopy.iterator();
        int plandirection = 0;
        while (targeIterator.hasNext()) {
            DynamicObject entry1 = (DynamicObject)targeIterator.next();
            if (BigDecimal.ZERO.compareTo(entry1.getBigDecimal("planamount")) == 0) {
                this.setCancelInfo(args, ResManager.loadKDString((String)"\u5f85\u644a\u91d1\u989d\u53d6\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u3002", (String)"VoucherAmortSchemeEdit_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            int dirction = entry1.getInt("plandirection");
            if (plandirection == 0) {
                plandirection = dirction;
            } else if (plandirection != dirction) {
                this.setCancelInfo(args, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5f85\u644a\u79d1\u76ee\u751f\u6210\u65b9\u5411\uff0c\u5f85\u644a\u79d1\u76ee\u751f\u6210\u65b9\u5411\u9700\u4e00\u81f4\u3002", (String)"VoucherAmortSchemeEdit_70", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            targeIterator.remove();
            while (targeIterator.hasNext()) {
                DynamicObject entry2 = (DynamicObject)targeIterator.next();
                if (!this.compareEntry(entry1, entry2, "targetaccount_id", "targetcurrency_id", "targetrowid")) continue;
                this.setCancelInfo(args, String.format(ResManager.loadKDString((String)"\u5f85\u644a\u79d1\u76ee\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u79d1\u76ee\u5e01\u79cd\u53ca\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"VoucherAmortSchemeEdit_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry1.getString("seq"), entry2.getString("seq")));
                return false;
            }
            targeIterator = targetCollCopy.iterator();
        }
        DynamicObjectCollection destCollCopy = (DynamicObjectCollection)destColl.clone();
        Iterator destIterator = destCollCopy.iterator();
        while (destIterator.hasNext()) {
            DynamicObject entry1 = (DynamicObject)destIterator.next();
            destIterator.remove();
            while (destIterator.hasNext()) {
                DynamicObject entry2 = (DynamicObject)destIterator.next();
                if (!this.compareEntry(entry1, entry2, "destaccount_id", "destcurrency_id", "destrowid")) continue;
                this.setCancelInfo(args, String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u79d1\u76ee\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u79d1\u76ee\u5e01\u79cd\u53ca\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"VoucherAmortSchemeEdit_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry1.getString("seq"), entry2.getString("seq")));
                return false;
            }
            destIterator = destCollCopy.iterator();
        }
        return true;
    }

    private void setCancelInfo(BeforeDoOperationEventArgs args, String info) {
        if (args == null) {
            throw new KDBizException(info);
        }
        this.getView().showTipNotification(info);
        args.setCancel(true);
    }

    private boolean checkCurrency(DynamicObject accountview, Long currencyId, Long baseCurrency) {
        if (accountview != null) {
            HashSet<Long> currencySet = new HashSet<Long>();
            String acctCurrency = accountview.getString("acctcurrency");
            if ("allcurrency".equals(acctCurrency)) {
                return true;
            }
            if ("descurrency".equals(acctCurrency)) {
                DynamicObjectCollection currencyentry = accountview.getDynamicObjectCollection("currencyentry");
                for (DynamicObject currencyRow : currencyentry) {
                    DynamicObject currency = (DynamicObject)currencyRow.get("currency");
                    if (currency == null) continue;
                    long cuId = currency.getLong("id");
                    currencySet.add(cuId);
                }
            } else if ("nocurrency".equals(acctCurrency)) {
                currencySet.add(baseCurrency);
            }
            if (!currencySet.contains(currencyId)) {
                return false;
            }
        }
        return true;
    }

    private void setRate(int rowIndex) {
        IDataModel model = this.getModel();
        Long currencyId = (Long)model.getValue("targetcurrency_id", rowIndex);
        AccountBookInfo bookInfo = this.getBookByOrg();
        if (bookInfo == null) {
            return;
        }
        long exrateTableId = bookInfo.getExrateTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        BigDecimal rate = BigDecimal.ONE;
        Date newDate = new Date();
        if (currencyId == 0L && baseCurrencyId != 0L) {
            model.setValue("targetcurrency", (Object)baseCurrencyId);
        } else if (currencyId != baseCurrencyId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rate"});
            rate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)currencyId, (Long)baseCurrencyId, (Date)newDate);
            if (rate == null) {
                this.checkRateNullAndShowTipsWhenPlanTypeFixed(rowIndex);
            }
        }
        model.setValue("rate", (Object)rate, rowIndex);
    }

    private void checkRateNullAndShowTipsWhenPlanTypeFixed(int rowIndex) {
        PlanType value = this.getPlanType(rowIndex);
        if (PlanType.FIXED == value) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6c47\u7387\uff0c\u8bf7\u5f55\u5165\u3002", (String)"VoucherAmortSchemeEdit_74", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNumberMatches(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        return pattern.matcher(str).matches();
    }

    private void amendCustomAmort() {
        DynamicObjectCollection custompolicies = this.getModel().getEntryEntity("custompolicies");
        custompolicies.sort(Comparator.comparingLong(row -> row.getLong("cperiod_id")));
        List toReplace = VoucherAmortSchemeUtils.getPeriods((long)((Long)this.getModel().getValue("startperiod_id")), (int)((BigDecimal)this.getModel().getValue("planperiod")).intValue()).stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        if (custompolicies.size() < toReplace.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u5206\u5f55\u884c\u5c11\u4e8e\u644a\u9500\u671f\u95f4\u6570\uff0c\u8bf7\u70b9\u51fb\u201c\u65b0\u589e\u201d\u8865\u5145\u5206\u5f55\u884c\u3002", (String)"VoucherAmortSchemeEdit_73", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < toReplace.size(); ++i) {
            ((DynamicObject)custompolicies.get(i)).set("cperiod", (Object)BusinessDataServiceHelper.loadSingleFromCache(toReplace.get(i), (String)"bd_period"));
        }
        this.getView().updateView("custompolicies");
    }

    private void createDetailEntry(int index, Long accountId, Long assgrpid, BigDecimal ori, BigDecimal local, Map<Integer, Long> comAssistMap) {
        IDataModel model = this.getModel();
        String targetRowid = (String)model.getValue("targetrowid", index);
        model.insertEntryRow("detailentry", 0);
        model.setValue("detailrowid", (Object)targetRowid, 0);
        model.setValue("detailaccount", (Object)accountId, 0);
        model.setValue("detailassgrp", (Object)assgrpid, 0);
        model.setValue("detailoritotal", (Object)ori, 0);
        model.setValue("detailloctotal", (Object)local, 0);
        for (Map.Entry<Integer, Long> comAssistEntry : comAssistMap.entrySet()) {
            model.setValue("detailcomassist" + comAssistEntry.getKey(), (Object)comAssistEntry.getValue(), 0);
        }
        model.updateCache();
    }

    private void removeDetailEntry(int index) {
        IDataModel model = this.getModel();
        String targetRowid = (String)model.getValue("targetrowid", index);
        int[] remove = this.getModel().getEntryEntity("detailentry").stream().filter(row -> row.getString("detailrowid").equals(targetRowid)).map(x -> x.getInt("seq") - 1).mapToInt(Integer::valueOf).toArray();
        model.deleteEntryRows("detailentry", remove);
    }

    private void updateWithoutPropertyChanged(Runnable runnable) {
        this.getModel().beginInit();
        runnable.run();
        this.getModel().endInit();
    }

    private boolean isDirectionConsistent() {
        IDataModel model = this.getModel();
        Object planDirection = model.getValue("plandirection");
        return Objects.nonNull(planDirection) && planDirection.equals(model.getValue("destdirection"));
    }

    private BigDecimal getCof() {
        return this.isDirectionConsistent() ? new BigDecimal("-1") : new BigDecimal("1");
    }

    private List<String> getComAssistFieldKeys() {
        return this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(key -> key.startsWith("comassist")).collect(Collectors.toList());
    }

    private String getComAssistKeyByFieldKey(String comAssistFieldKey) {
        return comAssistFieldKey.substring(0, "comassist".length() + 1);
    }

    private List<QFilter> getComAssistFilters(Map<String, String> fieldKeyToFilterPropertyMap, int index) {
        ArrayList<QFilter> comAssistFilters = new ArrayList<QFilter>(8);
        for (Map.Entry<String, String> fieldKeyToFilterPropertyEntry : fieldKeyToFilterPropertyMap.entrySet()) {
            Object comAssistValues = this.getModel().getValue(fieldKeyToFilterPropertyEntry.getKey(), index);
            if (comAssistValues instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)comAssistValues))) {
                comAssistFilters.add(new QFilter(fieldKeyToFilterPropertyEntry.getValue(), "in", ((Collection)comAssistValues).stream().map(comAssist -> comAssist.getLong("fbasedataid_id")).collect(Collectors.toSet())));
                continue;
            }
            if (!(comAssistValues instanceof DynamicObject)) continue;
            comAssistFilters.add(new QFilter(fieldKeyToFilterPropertyEntry.getValue(), "=", ((DynamicObject)comAssistValues).getPkValue()));
        }
        return comAssistFilters;
    }

    private PlanType getPlanType(int rowIndex) {
        return PlanType.getType((String)this.getModel().getValue("plantype", rowIndex).toString());
    }

    private static class Currency {
        private Long id;
        private int amtprecision;

        private Currency() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public int getAmtprecision() {
            return this.amtprecision;
        }

        public void setAmtprecision(int amtprecision) {
            this.amtprecision = amtprecision;
        }
    }
}

