/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VoucherBreakPointManualPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String VOUCHERNO = "voucherno";
    private static final String NEWVOUCHERNO = "newvoucherno";
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateView();
    }

    private void updateView() {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        FormShowParameter parame = this.getView().getFormShowParameter();
        Map map = parame.getCustomParams();
        if (map != null && map.size() != 0) {
            String orgCol = String.valueOf(map.get("orgCol"));
            String periodCol = String.valueOf(map.get("periodCol"));
            if (StringUtils.isNotEmpty((String)orgCol)) {
                String[] orgs = orgCol.split(",");
                String[] periods = periodCol.split(",");
                for (int i = 0; i < orgs.length; ++i) {
                    Object[] voucherIds;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("orgId", orgs[i]);
                    m.put("booktype", map.get("booktype"));
                    m.put("period", periods[i]);
                    CodeRuleInfo coderule = BreakPointCommonUtil.getCodeRuleInfo((String)orgs[i]);
                    m.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)coderule));
                    DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)coderule);
                    List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
                    DynamicObject[] voucherList = new DynamicObject[]{};
                    JSONArray jarrayVoucherIds = (JSONArray)map.get("voucherids");
                    if (jarrayVoucherIds != null && (voucherIds = jarrayVoucherIds.toArray()).length != 0) {
                        QFilter qf = new QFilter("id", "in", (Object)voucherIds);
                        voucherList = GLBreakPointUtil.queryVoucher(m, (List)codeRuleEntryAttributes, (QFilter)qf);
                    }
                    if (voucherList.length == 0) continue;
                    List issortitemvouchers = GLBreakPointUtil.getIssortitemvouchers((List)codeRuleEntryAttributes, (DynamicObject[])voucherList);
                    model.beginInit();
                    for (List vos : issortitemvouchers) {
                        for (DynamicObject vo : vos) {
                            int rowKey = model.createNewEntryRow(ENTRYENTITY);
                            model.setValue("org", vo.get("org"), rowKey);
                            model.setValue("vouchertype", vo.get("vouchertype"), rowKey);
                            model.setValue(VOUCHERNO, vo.get("billno"), rowKey);
                            model.setValue(NEWVOUCHERNO, (Object)"", rowKey);
                            model.setValue("voucherid", vo.get("id"), rowKey);
                            model.setValue("bizdate", vo.get("bizdate"), rowKey);
                            model.setValue("bookeddate", vo.get("bookeddate"), rowKey);
                        }
                    }
                    model.endInit();
                }
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("close".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
        } else if ("execute".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.execute();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("save_btn".equals(key) && this.validate()) {
            this.execute();
        }
    }

    private DynamicObjectCollection getEntries() {
        return this.getModel().getEntryEntity(ENTRYENTITY);
    }

    private boolean validate() {
        String newVoucherNo;
        DynamicObject entry;
        String voucherNo;
        UnchangedNumbers unchangedNumbers = new UnchangedNumbers();
        DynamicObjectCollection entries = this.getEntries();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext() && (!unchangedNumbers.isUnchanged(voucherNo = (entry = (DynamicObject)iterator.next()).getString(VOUCHERNO), newVoucherNo = entry.getString(NEWVOUCHERNO)) || unchangedNumbers.add(voucherNo))) {
        }
        if (CollectionUtils.isNotEmpty(unchangedNumbers.getNumbers())) {
            this.getView().showConfirm(unchangedNumbers.isExceeded() ? ResManager.loadKDString((String)"\u8981\u8c03\u6574\u7684\u7f16\u7801\u201c%1$s\u201d\u7b49\u5b58\u5728\u548c\u539f\u7f16\u7801\u76f8\u540c\u7684\u60c5\u51b5\uff0c\u662f\u5426\u7ee7\u7eed\u8c03\u6574\uff1f", (String)"VoucherBreakPointManualPlugin_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{String.join((CharSequence)"\u3001", unchangedNumbers.getNumbers())}) : ResManager.loadKDString((String)"\u8981\u8c03\u6574\u7684\u7f16\u7801\uff1a\u201c%1$s\u201d\u5b58\u5728\u548c\u539f\u7f16\u7801\u76f8\u540c\u7684\u60c5\u51b5\uff0c\u662f\u5426\u7ee7\u7eed\u8c03\u6574\uff1f", (String)"VoucherBreakPointManualPlugin_9", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{String.join((CharSequence)"\u3001", unchangedNumbers.getNumbers())}), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("execute", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private void execute() {
        Object m;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        boolean skipcheck = (Boolean)model.getValue("skipcheck");
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
        if (entryentity.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> voMap = this.getVoMap(entryentity);
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>(entryentity.size());
        ArrayList<String> notMacthList = new ArrayList<String>();
        HashMap<String, List> newnumListMap = new HashMap<String, List>();
        HashMap<String, List> onlynewnumListMap = new HashMap<String, List>();
        HashMap<String, List> repiteListMap = new HashMap<String, List>();
        long orgId = Long.parseLong(((DynamicObject)entryentity.get(0)).getDynamicObject("org").getString("id"));
        CodeRuleInfo coderule = VoucherNumberUtils.getCodeRuleInfo((Long)orgId, (String)"B");
        DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)coderule);
        List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
        List issortitemFields = GLBreakPointUtil.getIssortitemFields((List)codeRuleEntryAttributes, (boolean)false);
        List issortitemTrueFields = GLBreakPointUtil.getIssortitemFields((List)codeRuleEntryAttributes, (boolean)true);
        AdjustmentCollector collector = new AdjustmentCollector(orgId);
        HashMap<String, DynamicObject> sortitemVoucherMap = new HashMap<String, DynamicObject>();
        HashMap<String, List<String>> sortitemOldNoMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> sortitemNewNoMap = new HashMap<String, List<String>>();
        UnchangedNumbers unchangedNumbers = new UnchangedNumbers();
        for (DynamicObject dynamicObject : entryentity) {
            String newvoucherno;
            String voucherno = dynamicObject.getString(VOUCHERNO);
            if (StringUtils.isEmpty((String)voucherno) || unchangedNumbers.isUnchanged(voucherno, newvoucherno = dynamicObject.getString(NEWVOUCHERNO))) continue;
            m = new HashMap<String, Object>();
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("org");
            DynamicObject vouchertype = dynamicObject.getDynamicObject("vouchertype");
            m.put("org", dynamicObject2);
            m.put("vouchertype", vouchertype);
            m.put(VOUCHERNO, voucherno);
            m.put(NEWVOUCHERNO, newvoucherno);
            if (StringUtils.isNotEmpty((String)newvoucherno) && newvoucherno.length() > 30) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u8981\u8c03\u6574\u7684\u7f16\u7801\u201c%s\u201d\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e30\u5b57\u7b26\u3002", (String)"VoucherBreakPointManualPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), newvoucherno));
                return;
            }
            DynamicObject voucher = voMap.get(dynamicObject.getLong("voucherid"));
            m.put("voucher", voucher);
            Map voucherInfo = GLBreakPointUtil.getVoucherInfo((DynamicObject)voucher, (List)issortitemTrueFields);
            Map numbermap = GLBreakPointUtil.resetBreakNumber((String)coderule.getId(), (String)"1", (Map)voucherInfo);
            String templateNumber = (String)numbermap.get("resetNumber");
            int[] SerialNumber = new int[]{Integer.parseInt((String)numbermap.get("indexOfSerial")), Integer.parseInt((String)numbermap.get("lengthOfSerial"))};
            boolean isOldNumMatch = GLBreakPointUtil.isMatchCodeRule((String)voucherno, (String)templateNumber, (int)SerialNumber[0], (int)SerialNumber[1]);
            StringBuilder issortitemkey = new StringBuilder();
            for (Map fieldmap : issortitemFields) {
                if (issortitemkey.length() != 0) {
                    issortitemkey.append("_split_");
                }
                issortitemkey.append(GLBreakPointUtil.getOneSortItemString((Map)fieldmap, (Map)voucherInfo));
            }
            Basis basis = new Basis(issortitemkey.toString(), GLBreakPointUtil.getVoucherPropValue((DynamicObject)voucher, (List)issortitemTrueFields));
            List newnumList = newnumListMap.computeIfAbsent(basis.getBasis(), f -> new ArrayList());
            List repiteList = repiteListMap.computeIfAbsent(basis.getBasis(), f -> new ArrayList());
            if (StringUtils.isNotEmpty((String)newvoucherno)) {
                if (newnumList.contains(newvoucherno)) {
                    repiteList.add(newvoucherno);
                } else {
                    newnumList.add(newvoucherno);
                }
                List onlynewnumList = onlynewnumListMap.computeIfAbsent(basis.getBasis(), f -> new ArrayList());
                onlynewnumList.add(newvoucherno);
                boolean isNewNumMatch = GLBreakPointUtil.isMatchCodeRule((String)newvoucherno, (String)templateNumber, (int)SerialNumber[0], (int)SerialNumber[1]);
                m.put("templateNumber", templateNumber);
                m.put("isMatch", new boolean[]{isNewNumMatch, isOldNumMatch});
                if (isNewNumMatch) {
                    collector.collect(basis, null, newvoucherno);
                }
                if (isOldNumMatch) {
                    collector.collect(basis, voucherno, null);
                }
                if (!isNewNumMatch) {
                    notMacthList.add(newvoucherno);
                } else {
                    sortitemVoucherMap.computeIfAbsent(basis.getBasis(), f -> voucher);
                    if (isOldNumMatch) {
                        List<String> oldNoList = this.getNoList(sortitemOldNoMap, basis.getBasis(), voucherno);
                        sortitemOldNoMap.put(basis.getBasis(), oldNoList);
                        List<String> newNoList = this.getNoList(sortitemNewNoMap, basis.getBasis(), newvoucherno);
                        sortitemNewNoMap.put(basis.getBasis(), newNoList);
                    }
                }
            } else if (newnumList.contains(voucherno)) {
                repiteList.add(voucherno);
            } else {
                newnumList.add(voucherno);
            }
            l.add((Map<String, Object>)m);
        }
        if (onlynewnumListMap.isEmpty()) {
            view.showMessage(ResManager.loadKDString((String)"\u8981\u8c03\u6574\u7684\u51ed\u8bc1\u53f7\u4e3a\u7a7a\u3002", (String)"VoucherBreakPointManualPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!notMacthList.isEmpty()) {
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u5217\u60f3\u8981\u4fee\u6539\u7684\u51ed\u8bc1\u53f7\u4e0d\u6ee1\u8db3\u7f16\u7801\u89c4\u5219", (String)"VoucherBreakPointManualPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), ((Object)notMacthList).toString(), MessageTypes.Default);
            return;
        }
        for (Map.Entry entry : repiteListMap.entrySet()) {
            List values = (List)entry.getValue();
            if (values.isEmpty() || skipcheck) continue;
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u5217\u60f3\u8981\u4fee\u6539\u7684\u51ed\u8bc1\u53f7\u4e0e\u5217\u8868\u91cc\u7684\u51ed\u8bc1\u53f7\u6709\u91cd\u53f7\u3002", (String)"VoucherBreakPointManualPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), values.toString(), MessageTypes.Default);
            return;
        }
        HashMap<String, Object> voumap = new HashMap<String, Object>();
        DynamicObject dynamicObject = (DynamicObject)((Map)l.get(0)).get("voucher");
        voumap.put("orgId", dynamicObject.get(Voucher.id_((String)"org")));
        voumap.put("booktype", dynamicObject.get(Voucher.id_((String)"booktype")));
        voumap.put("period", dynamicObject.get(Voucher.id_((String)"period")));
        voumap.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)coderule));
        QFilter qids = new QFilter("id", "not in", voMap.keySet());
        DataSet dt = GLBreakPointUtil.queryVoucherDataset(voumap, (List)codeRuleEntryAttributes, (QFilter)qids, (int)1, (int)1, (int)0);
        m = null;
        try {
            while (dt.hasNext()) {
                Object fieldmap22;
                Row row = dt.next();
                HashMap<String, Object> hashMap = new HashMap<String, Object>(issortitemTrueFields.size());
                for (Object fieldmap22 : issortitemTrueFields) {
                    String field = (String)fieldmap22.get("valueatribute");
                    hashMap.put(field, row.get(field));
                }
                StringBuilder issortitemkey = new StringBuilder();
                fieldmap22 = issortitemFields.iterator();
                while (fieldmap22.hasNext()) {
                    Map fieldmap3 = (Map)fieldmap22.next();
                    if (issortitemkey.length() != 0) {
                        issortitemkey.append("_split_");
                    }
                    issortitemkey.append(GLBreakPointUtil.getOneSortItemString((Map)fieldmap3, hashMap));
                }
                String issortitemkeyStr = issortitemkey.toString();
                List onlynewnumList = (List)onlynewnumListMap.get(issortitemkeyStr);
                String dbnumber = row.getString("billno");
                if (onlynewnumList == null || !onlynewnumList.contains(dbnumber) || skipcheck) continue;
                view.showMessage(ResManager.loadKDString((String)"\u4e0b\u5217\u51ed\u8bc1\u53f7\u5728\u5f53\u671f\u5b58\u5728\u91cd\u53f7\u3002", (String)"VoucherBreakPointManualPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), dbnumber, MessageTypes.Default);
                return;
            }
        }
        catch (Throwable throwable) {
            m = throwable;
            throw throwable;
        }
        finally {
            if (dt != null) {
                if (m != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)m).addSuppressed(throwable);
                    }
                } else {
                    dt.close();
                }
            }
        }
        List<String> cancelNumbers = this.getCancelNumbers(l, orgId);
        if (!cancelNumbers.isEmpty()) {
            view.showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"VoucherBreakPointManualPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), cancelNumbers.toString(), MessageTypes.Default);
            return;
        }
        for (Map map : l) {
            if (map.get(NEWVOUCHERNO) == null || "".equals(map.get(NEWVOUCHERNO))) continue;
            ((DynamicObject)map.get("voucher")).set("billno", map.get(NEWVOUCHERNO));
        }
        List<DynamicObject> vobkList = this.buildVoucherBreakPointData(entryentity, unchangedNumbers);
        int n = vobkList.size();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(n);
        for (DynamicObject vobk : vobkList) {
            Object[] params = new Object[]{vobk.getString(NEWVOUCHERNO), vobk.getLong("voucherid")};
            paramList.add(params);
        }
        GLBreakPointUtil.saveVouchers(paramList, (DynamicObject[])vobkList.toArray(new DynamicObject[0]), (String)"gl_manualbreakpoint");
        this.deleteNos(collector);
        this.recycleNos(sortitemVoucherMap, sortitemOldNoMap, sortitemNewNoMap);
        this.getPageCache().put("manualflag", "true");
        this.updateView();
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"VoucherBreakPointManualPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private List<String> getCancelNumbers(List<Map<String, Object>> l, long orgId) {
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<String> cancelNumbers = new ArrayList<String>();
        for (Map<String, Object> m : l) {
            String newVoucherNo = StringUtils.getStringValue((Object)m.get(NEWVOUCHERNO));
            if (!StringUtils.isNotEmpty((String)newVoucherNo)) continue;
            numbers.add(newVoucherNo);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Long bookTypeId = Long.parseLong(String.valueOf(map.get("booktype")));
        qFilters.add(new QFilter("org.id", "=", (Object)orgId));
        qFilters.add(new QFilter("booktype.id", "=", (Object)bookTypeId));
        qFilters.add(new QFilter("period.id", "=", (Object)this.getPeriodId()));
        qFilters.add(new QFilter("billno", "in", numbers));
        qFilters.add(new QFilter("billstatus", "=", (Object)"D"));
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)"billno", (QFilter[])qFilters.toArray(new QFilter[3]), null, (int)-1);){
            for (Row row : ds) {
                cancelNumbers.add(row.getString("billno"));
            }
        }
        return cancelNumbers;
    }

    private long getPeriodId() {
        Object periodParam = this.getView().getFormShowParameter().getCustomParam("periodCol");
        if (periodParam == null) {
            return 0L;
        }
        String periodStr = periodParam.toString().split(",")[0];
        if (StringUtils.isEmpty((String)periodStr)) {
            return 0L;
        }
        return Long.parseLong(periodStr);
    }

    private List<DynamicObject> buildVoucherBreakPointData(DynamicObjectCollection entryentity, UnchangedNumbers unchangedNumbers) {
        ArrayList<DynamicObject> voucherBreakPointList = new ArrayList<DynamicObject>(entryentity.size());
        MainEntityType voucherBreakPointType = EntityMetadataCache.getDataEntityType((String)"gl_voucherbreakpoint");
        Date curtime = new Date();
        Map<Long, DynamicObject> voMap = this.getVoMap(entryentity);
        for (DynamicObject entry : entryentity) {
            String newvoucherno;
            String voucherno = entry.getString(VOUCHERNO);
            if (StringUtils.isEmpty((String)voucherno) || unchangedNumbers.isUnchanged(voucherno, newvoucherno = entry.getString(NEWVOUCHERNO))) continue;
            long voucherid = entry.getLong("voucherid");
            if (!StringUtils.isNotEmpty((String)newvoucherno)) continue;
            DynamicObject voucher = voMap.get(voucherid);
            DynamicObject voucherBreakPoint = BreakPointCommonUtil.buildVoucherBreakPoint((DynamicObject)voucher, (MainEntityType)voucherBreakPointType);
            voucherBreakPoint.set("adjuster", (Object)RequestContext.get().getCurrUserId());
            voucherBreakPoint.set("adjustdate", (Object)curtime);
            voucherBreakPoint.set("curvoucherno", (Object)newvoucherno);
            voucherBreakPoint.set(NEWVOUCHERNO, (Object)newvoucherno);
            voucherBreakPointList.add(voucherBreakPoint);
        }
        return voucherBreakPointList;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("manualflag"))) {
            this.getView().returnDataToParent((Object)"manualflag");
        }
    }

    private Map<Long, DynamicObject> getVoMap(DynamicObjectCollection entryentity) {
        ArrayList<Long> voids = new ArrayList<Long>();
        for (DynamicObject en : entryentity) {
            voids.add(en.getLong("voucherid"));
        }
        return BreakPointCommonUtil.getVoucherMap(voids);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save_btn"});
        this.addClickListeners(new String[]{"close_btn"});
    }

    private List<String> getNoList(Map<String, List<String>> map, String issortitemkeyStr, String no) {
        List<String> oldNoList = map.get(issortitemkeyStr);
        if (oldNoList == null) {
            oldNoList = new ArrayList<String>();
        }
        if (!oldNoList.contains(no)) {
            oldNoList.add(no);
        }
        return oldNoList;
    }

    private void deleteNos(AdjustmentCollector collector) {
        Map<Basis, Set<String>> afterAdjustment = collector.getAfterAdjustment();
        afterAdjustment.forEach((basis, afterNumbers) -> {
            Set beforeNumbers = collector.getBeforeAdjustment().getOrDefault(basis, Collections.emptySet());
            HashSet deleteNumbers = new HashSet(afterNumbers);
            deleteNumbers.removeAll(beforeNumbers);
            if (CollectionUtils.isNotEmpty(deleteNumbers)) {
                Map<String, Object> segmentValueMap = basis.getVoucherPropValue();
                segmentValueMap.put("billstatus", "B");
                CodeRuleServiceHelper.deleteBreakNumbers((String)"gl_voucher", segmentValueMap, (long)collector.getOrgId(), new ArrayList(deleteNumbers));
            }
        });
    }

    private void recycleNos(Map<String, DynamicObject> sortitemVoucherMap, Map<String, List<String>> sortitemOldNoMap, Map<String, List<String>> sortitemNewNoMap) {
        for (Map.Entry<String, DynamicObject> entry : sortitemVoucherMap.entrySet()) {
            String issortitemkeyStr = entry.getKey();
            DynamicObject voucher = entry.getValue();
            List<String> oldNoList = sortitemOldNoMap.get(issortitemkeyStr);
            List<String> newNoList = sortitemNewNoMap.get(issortitemkeyStr);
            if (oldNoList == null || newNoList == null) continue;
            oldNoList.removeAll(newNoList);
            for (String no : oldNoList) {
                voucher.set("billstatus", (Object)"B");
                CodeRuleServiceHelper.recycleNumber((String)"gl_voucher", (DynamicObject)voucher, (String)String.valueOf(voucher.get("org_id")), (String)no);
            }
        }
    }

    private static class Basis {
        private final String basis;
        private final Map<String, Object> voucherPropValue;

        private Basis(String basis, Map<String, Object> voucherPropValue) {
            this.basis = basis;
            this.voucherPropValue = voucherPropValue;
        }

        public String getBasis() {
            return this.basis;
        }

        public Map<String, Object> getVoucherPropValue() {
            return this.voucherPropValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Basis that = (Basis)o;
            return Objects.equals(this.basis, that.basis);
        }

        public int hashCode() {
            return Objects.hash(this.basis);
        }
    }

    private static class AdjustmentCollector {
        private final long orgId;
        private final Map<Basis, Set<String>> beforeAdjustment;
        private final Map<Basis, Set<String>> afterAdjustment;

        private AdjustmentCollector(long orgId) {
            this.orgId = orgId;
            this.beforeAdjustment = new HashMap<Basis, Set<String>>(4);
            this.afterAdjustment = new HashMap<Basis, Set<String>>(4);
        }

        public long getOrgId() {
            return this.orgId;
        }

        public Map<Basis, Set<String>> getBeforeAdjustment() {
            return this.beforeAdjustment;
        }

        public Map<Basis, Set<String>> getAfterAdjustment() {
            return this.afterAdjustment;
        }

        private void collect(Basis basis, String before, String after) {
            if (before != null) {
                this.beforeAdjustment.computeIfAbsent(basis, k -> new HashSet(8)).add(before);
            }
            if (after != null) {
                this.afterAdjustment.computeIfAbsent(basis, k -> new HashSet(8)).add(after);
            }
        }
    }

    protected static class UnchangedNumbers {
        private final List<String> numbers = new ArrayList<String>(10);
        private boolean exceeded = false;

        protected UnchangedNumbers() {
        }

        public boolean isUnchanged(String oldNumber, String newNumber) {
            return StringUtils.isNotEmpty((String)oldNumber) && StringUtils.isNotEmpty((String)newNumber) && oldNumber.equals(newNumber);
        }

        public boolean add(String unchangedNumber) {
            boolean bl = this.exceeded = this.numbers.size() >= 10;
            if (this.exceeded) {
                return false;
            }
            this.numbers.add(unchangedNumber);
            return true;
        }

        public List<String> getNumbers() {
            return this.numbers;
        }

        public boolean isExceeded() {
            return this.exceeded;
        }
    }
}

